/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.coredefine.module.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.qlangtech.tis.aiagent.plan.DescribableImpl;
import com.qlangtech.tis.coredefine.module.action.PluginAction;
import com.qlangtech.tis.extension.PluginWrapper;
import com.qlangtech.tis.extension.model.UpdateSite;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.IPluginTaggable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PluginFilter {
    final Set<IPluginTaggable.PluginTag> tags;
    final Predicate<UpdateSite.Plugin> endTypeMatcher;
    final List<String> extendpoint;
    final String[] queries;

    public static PluginFilter create(PluginAction pluginAction) {
        return new PluginFilter(pluginAction.getExtendpointParam(), StringUtils.split((String)pluginAction.getString("query"), (String)" "), pluginAction.getStringArray("tag"), PluginFilter.getEndTypeMatcher(pluginAction));
    }

    public static PluginFilter create(String endType, Collection<DescribableImpl> extendpoint) {
        if (StringUtils.isEmpty((CharSequence)endType)) {
            throw new IllegalArgumentException("param endType can not be null");
        }
        return new PluginFilter(extendpoint.stream().map(ep -> ep.getExtendPoint().getName()).collect(Collectors.toList()), new String[0], new String[0], PluginFilter.getEndTypeMatcher(endType));
    }

    private PluginFilter(List<String> extendpoint, String[] queries, String[] filterTags, Predicate<UpdateSite.Plugin> endTypeMatcher) {
        this.extendpoint = extendpoint;
        if (filterTags != null && filterTags.length > 0) {
            this.tags = Sets.newHashSet();
            for (String tag : filterTags) {
                this.tags.add(IPluginTaggable.PluginTag.parse((String)tag));
            }
        } else {
            this.tags = null;
        }
        this.queries = queries;
        this.endTypeMatcher = endTypeMatcher;
    }

    private static Predicate<UpdateSite.Plugin> getEndTypeMatcher(PluginAction pluginAction) {
        String endType = pluginAction.getString(IEndTypeGetter.EndType.KEY_END_TYPE);
        return PluginFilter.getEndTypeMatcher(endType);
    }

    public static Predicate<UpdateSite.Plugin> getEndTypeMatcher(@Nullable String endType) {
        if (StringUtils.isEmpty((CharSequence)endType)) {
            return plugin -> true;
        }
        IEndTypeGetter.EndType targetEndType = IEndTypeGetter.EndType.parse((String)endType);
        return plugin -> targetEndType.containIn(plugin.endTypes);
    }

    public boolean filter(Optional<PluginWrapper> plugin, UpdateSite.Plugin info) {
        if (this.tags != null && !CollectionUtils.containsAny((Collection)info.pluginTags, this.tags)) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(this.extendpoint) && !CollectionUtils.containsAny(info.extendPoints.keySet(), this.extendpoint)) {
            return true;
        }
        boolean collect = this.endTypeMatcher.test(info);
        if (!collect) {
            return true;
        }
        return this.filterPlugin(plugin.isPresent() ? plugin.get().getDisplayName() : info.title, info != null ? info.excerpt : null);
    }

    private boolean filterPlugin(String title, String excerpt) {
        List<String> queries = this.getQueryPluginParam();
        if (CollectionUtils.isEmpty(queries)) {
            return false;
        }
        boolean collect = false;
        for (String searchQ : queries) {
            if (StringUtils.indexOfIgnoreCase((CharSequence)title, (CharSequence)searchQ) <= -1 && (!StringUtils.isNotBlank((CharSequence)excerpt) || StringUtils.indexOfIgnoreCase((CharSequence)excerpt, (CharSequence)searchQ) <= -1)) continue;
            collect = true;
            break;
        }
        return !collect;
    }

    private List<String> getQueryPluginParam() {
        if (this.queries == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])this.queries);
    }
}

