/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.coredefine.module.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.datax.job.DataXJobWorker;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.util.DescriptorsJSON;
import com.qlangtech.tis.util.DescriptorsJSONResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PluginDescMeta<T extends Describable<T>> {
    protected final DescriptorsJSON pluginDesc;
    private final Map<DataXJobWorker.K8SWorkerCptType, List<T>> plugins = Maps.newHashMap();

    public PluginDescMeta(Collection<Descriptor<T>> descList) {
        this.pluginDesc = new DescriptorsJSON(descList);
    }

    public void addTypedPlugins(DataXJobWorker.K8SWorkerCptType type, List<T> p) {
        ArrayList plugins = this.plugins.get(type);
        if (plugins == null) {
            plugins = Lists.newArrayList();
            this.plugins.put(type, plugins);
        }
        plugins.addAll(p);
    }

    public Map<String, Integer> getTypedPluginCount() {
        return this.plugins.entrySet().stream().collect(Collectors.toMap(e -> ((DataXJobWorker.K8SWorkerCptType)e.getKey()).token, e -> ((List)e.getValue()).size()));
    }

    public DescriptorsJSONResult getPluginDesc() {
        return this.pluginDesc.getDescriptorsJSON();
    }
}

