/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.coredefine.module.action;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.coredefine.module.action.ResName;
import com.qlangtech.tis.coredefine.module.action.TISK8sDelegate;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.job.DefaultSSERunnable;
import com.qlangtech.tis.datax.job.ILaunchingOrchestrate;
import com.qlangtech.tis.datax.job.JobOrchestrateException;
import com.qlangtech.tis.datax.job.SSERunnable;
import com.qlangtech.tis.datax.job.ServerLaunchToken;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import java.util.Iterator;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class LaunchIncrSyncChannel {
    private final DataXName appName;
    private final IControlMsgHandler module;
    private final Context context;
    private final ServerLaunchToken incrLaunchToken;
    private final TISK8sDelegate k8sClient;
    private final boolean isRelaunch;

    public LaunchIncrSyncChannel(DataXName appName, IControlMsgHandler module, Context context, ServerLaunchToken incrLaunchToken) {
        this(appName, module, context, incrLaunchToken, false);
    }

    public LaunchIncrSyncChannel(DataXName appName, IControlMsgHandler module, Context context, ServerLaunchToken incrLaunchToken, boolean isRelaunch) {
        appName.assetCheckDataAppType();
        this.appName = appName;
        this.module = module;
        this.context = context;
        this.incrLaunchToken = incrLaunchToken;
        this.k8sClient = TISK8sDelegate.getK8SDelegate(appName);
        this.isRelaunch = isRelaunch;
    }

    protected abstract ILaunchingOrchestrate<FlinkJobDeployDTO> getFlinkJobWorkingOrchestrate(TISK8sDelegate var1);

    public void executeLaunch() {
        ILaunchingOrchestrate<FlinkJobDeployDTO> orchestrate = this.getFlinkJobWorkingOrchestrate(this.k8sClient);
        ILaunchingOrchestrate.ExecuteSteps executeSteps = orchestrate.createExecuteSteps((Object)this);
        DefaultSSERunnable launchProcess = new DefaultSSERunnable(this.module, executeSteps, () -> {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }){

            public void afterLaunched() {
                LaunchIncrSyncChannel.this.module.addActionMessage(LaunchIncrSyncChannel.this.context, "\u5df2\u7ecf\u6210\u529f\u542f\u52a8Flink\u589e\u91cf\u5b9e\u4f8b");
            }
        };
        SSERunnable sse = SSERunnable.getLocal();
        try {
            DefaultSSERunnable.execute((DefaultSSERunnable)launchProcess, (boolean)false, (ServerLaunchToken)this.incrLaunchToken, () -> {
                this.incrLaunchToken.writeLaunchToken(this.isRelaunch, () -> {
                    for (ILaunchingOrchestrate.ExecuteStep execStep : executeSteps.getExecuteSteps()) {
                        execStep.getSubJob().execSubJob((Object)new FlinkJobDeployDTO(this.context, this.k8sClient));
                    }
                    return Optional.empty();
                });
                launchProcess.afterLaunched();
            });
        }
        catch (Exception e) {
            Iterator iterator;
            if (ExceptionUtils.indexOfThrowable((Throwable)e, JobOrchestrateException.class) < 0 && (iterator = executeSteps.getExecuteSteps().iterator()).hasNext()) {
                ILaunchingOrchestrate.ExecuteStep execStep = (ILaunchingOrchestrate.ExecuteStep)iterator.next();
                sse.writeComplete((ResName)execStep.getSubJob(), false);
            }
            throw e;
        }
    }

    class FlinkJobDeployDTO {
        final Context context;
        final TISK8sDelegate k8sClient;
        private final StringBuffer logger;

        public FlinkJobDeployDTO(Context context, TISK8sDelegate k8sClient) {
            this.logger = new StringBuffer("flink sync app:" + LaunchIncrSyncChannel.this.appName);
            this.context = context;
            this.k8sClient = k8sClient;
        }

        public boolean hasErrors() {
            return this.context.hasErrors();
        }

        public void appendLog(String loggerMsg) {
            this.logger.append(loggerMsg);
        }
    }
}

