/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.coredefine.module.action;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qlangtech.tis.config.k8s.HorizontalpodAutoscaler;
import com.qlangtech.tis.config.k8s.ReplicasSpec;
import com.qlangtech.tis.coredefine.module.action.Specification;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.runtime.module.misc.IMessageHandler;
import com.qlangtech.tis.utils.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class IncrUtils {
    static final String fieldPods = "pods";
    static final String fieldCuprequest = "cuprequest";
    static final String fieldCuprequestUnit = "cuprequestunit";
    static final String KEY_CPU_UNIT_CORES = "cores";
    static final String filedCpuLimit = "cuplimit";
    static final String KEY_CPU_LIMIT_UNIT = "cuplimitunit";
    static final String fieldMemoryRequest = "memoryrequest";
    static final String KEY_MEMORY_REQUEST_UNIT = "memoryrequestunit";
    static final String fieldMemorylimit = "memorylimit";
    static final String field_Memorylimit_UNIT = "memorylimitunit";
    static final String KEY_MIN_HPA_POD = "minHpaPod";
    static final String KEY_MAX_HPA_POD = "maxHpaPod";
    static final String KEY_CPU_AVERAGE_UTILIZATION = "cpuAverageUtilization";
    static final String KEY_SUPPORT_HPA = "supportHpa";
    public static final Pattern PATTERN_NUMBER = Pattern.compile("[1-9]\\d*");

    private IncrUtils() {
    }

    public static boolean isNumber(String val) {
        Matcher m = PATTERN_NUMBER.matcher(val);
        return m.matches();
    }

    public static JSONObject serializeSpec(IncrSpecResult s) {
        JSONObject result = new JSONObject();
        ReplicasSpec spec = s.getSpec();
        HorizontalpodAutoscaler hpa = s.hpa;
        result.put(KEY_SUPPORT_HPA, (Object)(hpa != null ? 1 : 0));
        hpa = hpa != null ? hpa : HorizontalpodAutoscaler.getDft();
        result.put(KEY_MIN_HPA_POD, (Object)hpa.getMinPod());
        result.put(KEY_MAX_HPA_POD, (Object)hpa.getMaxPod());
        result.put(KEY_CPU_AVERAGE_UTILIZATION, (Object)hpa.getCpuAverageUtilization());
        result.put(fieldPods, (Object)spec.getReplicaCount());
        Specification cpuRequest = spec.getCpuRequest();
        result.put(fieldCuprequest, (Object)Float.valueOf(cpuRequest.getVal()));
        result.put(fieldCuprequestUnit, (Object)cpuRequest.getUnit());
        Specification cpuLimit = spec.getCpuLimit();
        result.put(filedCpuLimit, (Object)Float.valueOf(cpuLimit.getVal()));
        result.put(KEY_CPU_LIMIT_UNIT, (Object)cpuLimit.getUnit());
        Specification memoryRequest = spec.getMemoryRequest();
        result.put(fieldMemoryRequest, (Object)Float.valueOf(memoryRequest.getVal()));
        result.put(KEY_MEMORY_REQUEST_UNIT, (Object)memoryRequest.getUnit());
        Specification memoryLimit = spec.getMemoryLimit();
        result.put(fieldMemorylimit, (Object)Float.valueOf(memoryLimit.getVal()));
        result.put(field_Memorylimit_UNIT, (Object)memoryLimit.getUnit());
        return result;
    }

    public static IncrSpecResult parseIncrSpec(Context context, JSONObject form, IControlMsgHandler msg) {
        boolean supportHpa;
        ReplicasSpec spec = new ReplicasSpec();
        IncrSpecResult result = new IncrSpecResult(spec, context, (IMessageHandler)msg);
        result.success = false;
        int replicCount = form.getIntValue(fieldPods);
        if (replicCount < 1) {
            msg.addFieldError(context, fieldPods, "\u8bf7\u8bbe\u7f6ePods\uff0c\u4e0d\u80fd\u5c0f\u4e8e1", new Object[0]);
        } else if (replicCount > 20) {
            msg.addFieldError(context, fieldPods, "\u4e0d\u80fd\u5927\u4e8e20", new Object[0]);
        }
        spec.setReplicaCount(replicCount);
        Specification s = null;
        String cpurequest = StringUtils.trimToEmpty((String)form.getString(fieldCuprequest));
        String cpuRequestUnit = form.getString(fieldCuprequestUnit);
        if (StringUtils.isEmpty((CharSequence)cpuRequestUnit)) {
            msg.addFieldError(context, fieldCuprequest, "\u8bf7\u586b\u5199CPU\u8bf7\u6c42\u5355\u4f4d", new Object[0]);
        }
        String string = cpuRequestUnit = KEY_CPU_UNIT_CORES.equals(cpuRequestUnit) ? "" : cpuRequestUnit;
        if (StringUtils.isEmpty((CharSequence)cpurequest)) {
            msg.addFieldError(context, fieldCuprequest, "\u8bf7\u586b\u5199", new Object[0]);
        } else if (!IncrUtils.isNumber(cpurequest)) {
            msg.addFieldError(context, fieldCuprequest, "\u5fc5\u987b\u662f\u975e\u8d1f\u6574\u6570", new Object[0]);
        } else {
            s = new Specification();
            s.setVal((float)Integer.parseInt(cpurequest));
            s.setUnit(cpuRequestUnit);
            if (s.normalizeCPU() > 4096) {
                msg.addFieldError(context, fieldCuprequest, "\u8bf7\u68c0\u67e5CPU\u8bf7\u6c42\u8d44\u6e90\uff0c\u4e0d\u80fd\u5927\u4e8e4cores", new Object[0]);
            }
            spec.setCpuRequest(s);
        }
        String cupLimit = StringUtils.trimToEmpty((String)form.getString(filedCpuLimit));
        String cupLimitUnit = form.getString(KEY_CPU_LIMIT_UNIT);
        if (StringUtils.isEmpty((CharSequence)cupLimitUnit)) {
            msg.addFieldError(context, filedCpuLimit, "\u8bf7\u586b\u5199CPU\u6700\u5927\u8bf7\u6c42\u5355\u4f4d", new Object[0]);
        }
        String string2 = cupLimitUnit = KEY_CPU_UNIT_CORES.equals(cupLimitUnit) ? "" : cupLimitUnit;
        if (StringUtils.isEmpty((CharSequence)cupLimit)) {
            msg.addFieldError(context, filedCpuLimit, "\u8bf7\u586b\u5199", new Object[0]);
        } else if (!IncrUtils.isNumber(cupLimit)) {
            msg.addFieldError(context, filedCpuLimit, "\u5fc5\u987b\u662f\u975e\u8d1f\u6574\u6570", new Object[0]);
        } else {
            s = new Specification();
            s.setVal((float)Integer.parseInt(cupLimit));
            s.setUnit(cupLimitUnit);
            if (s.normalizeCPU() > 8192) {
                msg.addFieldError(context, filedCpuLimit, "\u8bf7\u68c0\u67e5CPU\u6700\u5927\u7533\u8bf7\u8d44\u6e90\uff0c\u4e0d\u80fd\u5927\u4e8e8cores", new Object[0]);
            }
            spec.setCpuLimit(s);
        }
        if (spec.getCpuRequest() != null && spec.getCpuLimit() != null && spec.getCpuRequest().cpuBigThan(spec.getCpuLimit())) {
            msg.addFieldError(context, fieldCuprequest, "\u8bf7\u68c0\u67e5CPU`\u7533\u8bf7\u8d44\u6e90`\uff0c\u4e0d\u80fd\u5927\u4e8e`\u6700\u5927\u7533\u8bf7\u8d44\u6e90`", new Object[0]);
            msg.addFieldError(context, filedCpuLimit, "\u8bf7\u68c0\u67e5CPU`\u6700\u5927\u7533\u8bf7\u8d44\u6e90`\uff0c\u4e0d\u80fd\u5c0f\u4e8e`\u7533\u8bf7\u8d44\u6e90`", new Object[0]);
        }
        String memoryRequest = form.getString(fieldMemoryRequest);
        String memoryRequestUnit = form.getString(KEY_MEMORY_REQUEST_UNIT);
        if (StringUtils.isEmpty((CharSequence)memoryRequest)) {
            msg.addFieldError(context, fieldMemoryRequest, "\u8bf7\u586b\u5199", new Object[0]);
        } else if (!IncrUtils.isNumber(memoryRequest)) {
            msg.addFieldError(context, fieldMemoryRequest, "\u5fc5\u987b\u662f\u975e\u8d1f\u6574\u6570", new Object[0]);
        } else {
            s = new Specification();
            s.setVal((float)Integer.parseInt(memoryRequest));
            s.setUnit(memoryRequestUnit);
            int maxMemoryRequest = 4;
            if (s.normalizeMemory() > maxMemoryRequest * 1024) {
                msg.addFieldError(context, fieldMemoryRequest, "\u8bf7\u68c0\u67e5\u5185\u5b58\u7533\u8bf7\u8d44\u6e90\uff0c\u4e0d\u80fd\u5927\u4e8e" + maxMemoryRequest + "G", new Object[0]);
            }
            spec.setMemoryRequest(s);
        }
        if (StringUtils.isEmpty((CharSequence)memoryRequestUnit)) {
            msg.addFieldError(context, fieldMemoryRequest, "\u8bf7\u586b\u5199\u5185\u5b58\u8bf7\u6c42\u5355\u4f4d", new Object[0]);
        }
        String memoryLimit = form.getString(fieldMemorylimit);
        String memoryLimitUnit = form.getString(field_Memorylimit_UNIT);
        if (StringUtils.isEmpty((CharSequence)memoryLimit)) {
            msg.addFieldError(context, fieldMemorylimit, "\u8bf7\u586b\u5199", new Object[0]);
        } else if (!IncrUtils.isNumber(memoryLimit)) {
            msg.addFieldError(context, fieldMemorylimit, "\u5fc5\u987b\u4e3a\u975e\u8d1f\u6574\u6570", new Object[0]);
        } else {
            int maxMemorylimit = 8;
            s = new Specification();
            s.setVal((float)Integer.parseInt(memoryLimit));
            s.setUnit(memoryLimitUnit);
            if (s.normalizeMemory() > maxMemorylimit * 1024) {
                msg.addFieldError(context, fieldMemorylimit, "\u8bf7\u68c0\u67e5\u5185\u5b58\u6700\u5927\u7533\u8bf7\u8d44\u6e90\uff0c\u4e0d\u80fd\u5927\u4e8e" + maxMemorylimit + "G", new Object[0]);
            }
            spec.setMemoryLimit(s);
        }
        if (StringUtils.isEmpty((CharSequence)memoryLimitUnit)) {
            msg.addFieldError(context, fieldMemorylimit, "\u8bf7\u586b\u5199\u5185\u5b58\u4e0a\u9650\u5355\u4f4d", new Object[0]);
        }
        if (spec.getMemoryRequest() != null && spec.getMemoryLimit() != null && spec.getMemoryRequest().memoryBigThan(spec.getMemoryLimit())) {
            msg.addFieldError(context, fieldMemoryRequest, "\u8bf7\u68c0\u67e5\u5185\u5b58`\u7533\u8bf7\u8d44\u6e90`\uff0c\u4e0d\u80fd\u5927\u4e8e`\u6700\u5927\u7533\u8bf7\u8d44\u6e90`", new Object[0]);
            msg.addFieldError(context, fieldMemorylimit, "\u8bf7\u68c0\u67e5\u5185\u5b58`\u6700\u5927\u7533\u8bf7\u8d44\u6e90`\uff0c\u4e0d\u80fd\u5c0f\u4e8e`\u7533\u8bf7\u8d44\u6e90`", new Object[0]);
        }
        if (supportHpa = form.getBooleanValue(KEY_SUPPORT_HPA)) {
            Integer cpuAverageUtilization;
            Integer maxHpaPod = form.getInteger(KEY_MAX_HPA_POD);
            Integer minHpaPod = form.getInteger(KEY_MIN_HPA_POD);
            if (minHpaPod == null) {
                msg.addFieldError(context, KEY_MIN_HPA_POD, "\u8bf7\u586b\u5199'\u6700\u5c0fPods'", new Object[0]);
            }
            if (maxHpaPod == null) {
                msg.addFieldError(context, KEY_MAX_HPA_POD, "\u8bf7\u586b\u5199'\u6700\u5927Pods'", new Object[0]);
            }
            if ((cpuAverageUtilization = form.getInteger(KEY_CPU_AVERAGE_UTILIZATION)) == null) {
                msg.addFieldError(context, KEY_CPU_AVERAGE_UTILIZATION, "\u8bf7\u586b\u5199'CPU\u5e73\u5747\u5229\u7528\u7387'", new Object[0]);
            }
            if (context.hasErrors()) {
                result.success = false;
                return result;
            }
            boolean hasErr = false;
            if (cpuAverageUtilization < 1 || cpuAverageUtilization >= 100) {
                msg.addFieldError(context, KEY_CPU_AVERAGE_UTILIZATION, "\u5fc5\u987b\u5927\u4e8e0\u4e14\u5c0f\u4e8e100", new Object[0]);
                hasErr = true;
            }
            if (minHpaPod < 1) {
                msg.addFieldError(context, KEY_MIN_HPA_POD, "\u6700\u5c0f\u5f39\u6027Pod\u6570\u5fc5\u987b\u5927\u4e8e0", new Object[0]);
                hasErr = true;
            }
            if (maxHpaPod <= minHpaPod) {
                msg.addFieldError(context, KEY_MAX_HPA_POD, "\u5fc5\u987b\u5927\u4e8e\u6700\u5c0f\u5f39\u6027Pod\u6570", new Object[0]);
                msg.addFieldError(context, KEY_MIN_HPA_POD, "\u5fc5\u987b\u5c0f\u4e8e\u6700\u5927\u5f39\u6027Pod\u6570", new Object[0]);
                hasErr = true;
            }
            if (hasErr) {
                return result;
            }
            HorizontalpodAutoscaler hpa = new HorizontalpodAutoscaler();
            hpa.setMaxPod(maxHpaPod);
            hpa.setMinPod(minHpaPod);
            hpa.setCpuAverageUtilization(cpuAverageUtilization);
            if (hpa.getMinPod() > spec.getReplicaCount()) {
                msg.addFieldError(context, KEY_MIN_HPA_POD, "\u4e0d\u80fd\u5927\u4e8e'Pods'\u6570", new Object[0]);
                msg.addFieldError(context, fieldPods, "\u4e0d\u80fd\u5c0f\u4e8e'\u5f39\u6027\u6269\u5bb9\u6700\u5c0fPods\u6570'", new Object[0]);
                return result;
            }
            result.hpa = hpa;
        }
        result.success = !context.hasErrors();
        return result;
    }

    public static void main(String[] args) throws Exception {
        Specification s = Specification.parse((String)"300");
        System.out.println(s.getUnit() + "," + s.getVal());
        ReplicasSpec spec = new ReplicasSpec();
        spec = IncrUtils.readIncrSpec("search4totalpay");
    }

    public static void saveIncrSpec(String indexName, ReplicasSpec spec) throws IOException {
        File f = IncrUtils.getIncrSpecFile(indexName);
        FileUtils.write((File)f, (CharSequence)JSON.toJSONString((Object)spec, (boolean)true), (Charset)Charset.forName("utf8"), (boolean)false);
    }

    public static ReplicasSpec readIncrSpec(String indexName) {
        File f = IncrUtils.getIncrSpecFile(indexName);
        if (!f.exists()) {
            return null;
        }
        try {
            return (ReplicasSpec)JSON.parseObject((String)FileUtils.readFileToString((File)f, (Charset)Charset.forName("utf8")), ReplicasSpec.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeploymentStatus appendDeploymentRecord(String indexName, Status status, int version, int replica, boolean shallSeralize, int preLatestVersionNumber) {
        Class<IncrUtils> clazz = IncrUtils.class;
        synchronized (IncrUtils.class) {
            DeploymentStatus s = new DeploymentStatus(indexName);
            s.setStatus(status);
            s.setVersion(version);
            s.setPreVersion(preLatestVersionNumber);
            s.setReplica(replica);
            if (shallSeralize) {
                File f = IncrUtils.getDeploymentHistoryFile(indexName);
                String line = version + "," + preLatestVersionNumber + "," + status.val + "," + replica + "\n";
                IncrUtils.appendLine(f, line);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendIndeterminacyDeploymentRecord(String indexName, int preLatestVersionNumber) {
        Class<IncrUtils> clazz = IncrUtils.class;
        synchronized (IncrUtils.class) {
            IncrUtils.appendDeploymentRecord(indexName, Status.CREATED, -1, -1, true, preLatestVersionNumber);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeploymentStatus readLastDeploymentRecord(String indexName) {
        Class<IncrUtils> clazz = IncrUtils.class;
        synchronized (IncrUtils.class) {
            final DeploymentStatus s = new DeploymentStatus(indexName);
            s.setStatus(Status.NONE);
            File f = IncrUtils.getDeploymentHistoryFile(indexName);
            Utils.readLastNLine((File)f, (int)1, (Utils.IProcessLine)new Utils.IProcessLine(){

                public void print(String line) {
                    String[] ary = StringUtils.split((String)line, (String)",");
                    s.setVersion(Integer.parseInt(ary[0]));
                    s.setPreVersion(Integer.parseInt(ary[1]));
                    s.setStatus(Status.parse(ary[2]));
                    s.setReplica(Integer.parseInt(ary[3]));
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rollbackIncrDeploy(final String indexName) {
        Class<IncrUtils> clazz = IncrUtils.class;
        synchronized (IncrUtils.class) {
            final ArrayList history = Lists.newArrayList();
            File f = IncrUtils.getDeploymentHistoryFile(indexName);
            Utils.readLastNLine((File)f, (int)2, (Utils.IProcessLine)new Utils.IProcessLine(){

                public void print(String line) {
                    DeploymentStatus s = new DeploymentStatus(indexName);
                    String[] ary = StringUtils.split((String)line, (String)",");
                    s.setVersion(Integer.parseInt(ary[0]));
                    s.setPreVersion(Integer.parseInt(ary[1]));
                    s.setStatus(Status.parse(ary[2]));
                    s.setReplica(Integer.parseInt(ary[3]));
                    history.add(s);
                }
            });
            if (history.size() == 1) {
                IncrUtils.appendDeploymentRecord(indexName, Status.NONE, -1, -1, true, -1);
            } else if (history.size() == 2) {
                DeploymentStatus s = (DeploymentStatus)history.get(0);
                IncrUtils.appendDeploymentRecord(indexName, s.getStatus(), s.getVersion(), s.getReplica(), true, s.getPreVersion());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void appendLine(File f, String line) {
        try (FileOutputStream out = FileUtils.openOutputStream((File)f, (boolean)true);){
            out.write(line.getBytes());
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File getIncrBuildFile(String indexName) {
        String dataDir = System.getProperty("data.dir", ".");
        if (StringUtils.isEmpty((CharSequence)dataDir)) {
            throw new IllegalArgumentException("system dir 'data.dir' can not be empty");
        }
        File f = new File(dataDir, "/" + indexName + "/incr-build/history.log");
        return f;
    }

    private static File getDeploymentHistoryFile(String indexName) {
        String dataDir = System.getProperty("data.dir", ".");
        if (StringUtils.isEmpty((CharSequence)dataDir)) {
            throw new IllegalArgumentException("system dir 'data.dir' can not be empty");
        }
        return new File(dataDir, "/" + indexName + "/incr-deployment/history.log");
    }

    private static File getIncrSpecFile(String indexName) {
        String dataDir = System.getProperty("data.dir", ".");
        if (StringUtils.isEmpty((CharSequence)dataDir)) {
            throw new IllegalArgumentException("system dir 'data.dir' can not be empty");
        }
        if (StringUtils.isEmpty((CharSequence)indexName)) {
            throw new IllegalArgumentException("indexName can not be empty");
        }
        return new File(dataDir, "/incr-spec/" + indexName + ".text");
    }

    public static enum Status {
        CREATED("created"),
        SUCCESS("success"),
        FAILD("faild"),
        NONE("none"),
        CANCELLED("cancelled");

        private String val;

        private Status(String val) {
            this.val = val;
        }

        public String getVal() {
            return this.val;
        }

        public static Status parse(String val) {
            if (Status.CREATED.val.equals(val)) {
                return CREATED;
            }
            if (Status.SUCCESS.val.equals(val)) {
                return SUCCESS;
            }
            if (Status.FAILD.val.equals(val)) {
                return FAILD;
            }
            if (Status.NONE.val.equals(val)) {
                return NONE;
            }
            if (Status.CANCELLED.val.equals(val)) {
                return CANCELLED;
            }
            throw new IllegalStateException("illegal val:" + val);
        }
    }

    public static class DeploymentStatus {
        private final String collection;
        private final String type = "deploy";
        private int version;
        private int preVersion;
        private Status status;
        private int replica;

        public String getType() {
            return "deploy";
        }

        public String getReplicationControllerName() {
            return this.collection + "-" + this.version;
        }

        public int getPreVersion() {
            return this.preVersion;
        }

        public void setPreVersion(int preVersion) {
            this.preVersion = preVersion;
        }

        public int getReplica() {
            return this.replica;
        }

        public void setReplica(int replica) {
            this.replica = replica;
        }

        public boolean isIndeterminacy() {
            return this.version < 0;
        }

        public DeploymentStatus(String deploymentName) {
            this.collection = deploymentName;
        }

        public String getCollection() {
            return this.collection;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public String getStatusLiterial() {
            switch (this.status) {
                case CREATED: {
                    return "\u90e8\u7f72\u4e2d";
                }
                case SUCCESS: {
                    return "\u8fd0\u884c\u4e2d";
                }
                case FAILD: {
                    return "\u90e8\u7f72\u5931\u8d25";
                }
            }
            return "\u5c1a\u672a\u90e8\u7f72";
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }
    }

    private static interface IMetricsGetter {
        public int get(Specification var1);
    }

    public static class IncrSpecResult {
        public HorizontalpodAutoscaler hpa;
        private final ReplicasSpec spec;
        private boolean success;
        private final Context context;
        private final IMessageHandler msgHandler;

        public static IncrSpecResult create(ReplicasSpec spec, HorizontalpodAutoscaler hpa) {
            IncrSpecResult result = new IncrSpecResult(spec, null, null);
            result.hpa = hpa;
            return result;
        }

        public ReplicasSpec getSpec() {
            return this.spec;
        }

        public boolean isSuccess() {
            if (!this.success) {
                return false;
            }
            if (!this.validRequestAndLimit(this.spec.getMemoryRequest(), this.spec.getMemoryLimit(), r -> r.normalizeMemory(), "Memory")) {
                return false;
            }
            return this.validRequestAndLimit(this.spec.getCpuRequest(), this.spec.getCpuLimit(), r -> r.normalizeCPU(), "CPU");
        }

        private boolean validRequestAndLimit(Specification request, Specification limit, IMetricsGetter getter, String resourceLiteria) {
            int r = getter.get(request);
            if (r < 1) {
                this.msgHandler.addErrorMessage(this.context, resourceLiteria + " Request Is inValid " + request);
                return false;
            }
            int l = getter.get(limit);
            if (l < 1) {
                this.msgHandler.addErrorMessage(this.context, resourceLiteria + " Limit Is InValid " + limit);
                return false;
            }
            if (r > l) {
                this.msgHandler.addErrorMessage(this.context, resourceLiteria + " Request(" + request + ") can not bigger than Limit(" + limit + ") ");
                return false;
            }
            return true;
        }

        IncrSpecResult(ReplicasSpec spec, Context context, IMessageHandler msgHandler) {
            this.spec = spec;
            this.context = context;
            this.msgHandler = msgHandler;
        }
    }
}

