/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.coredefine.module.action;

import com.alibaba.fastjson.annotation.JSONField;
import com.qlangtech.tis.assemble.ExecResult;
import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.assemble.TriggerType;
import com.qlangtech.tis.workflow.pojo.WorkFlowBuildHistory;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ExtendWorkFlowBuildHistory {
    private final WorkFlowBuildHistory delegate;
    private ExecResult execResult;

    public ExtendWorkFlowBuildHistory(WorkFlowBuildHistory delegate) {
        this(delegate, ExecResult.parse((int)delegate.getState().byteValue()));
    }

    public ExtendWorkFlowBuildHistory(WorkFlowBuildHistory delegate, ExecResult execResult) {
        this.delegate = delegate;
        this.execResult = execResult;
    }

    public String getConsuming() {
        Date endTime = this.execResult.isComplete() && this.getEndTime() != null ? this.getEndTime() : new Date();
        int consuming = (int)((endTime.getTime() - this.getStartTime().getTime()) / 1000L);
        if (consuming < 60) {
            return consuming + "\u79d2";
        }
        return consuming / 60 + "\u5206\u949f";
    }

    public Integer getId() {
        return this.delegate.getId();
    }

    public Date getStartTime() {
        return this.delegate.getStartTime();
    }

    @JSONField(serialize=false)
    public WorkFlowBuildHistory getDelegate() {
        return this.delegate;
    }

    public static void main(String[] args) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        long t1 = 1599460480838L;
        long t2 = 1599450043000L;
        System.out.println(f.format(new Date(t1)));
        System.out.println(f.format(new Date(t2)));
        long diff = t1 - t2;
        System.out.println(diff / 3600000L + "\u5c0f\u65f6");
        System.out.println(diff / 1000L % 60L + "\u79d2");
        System.out.println(diff / 60000L % 60L + "\u5206");
        Calendar gmt = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        System.out.println(gmt.getTimeInMillis());
        gmt = Calendar.getInstance();
        System.out.println(gmt.getTimeInMillis());
    }

    public Date getEndTime() {
        return this.delegate.getEndTime();
    }

    public String getStateClass() {
        switch (this.execResult) {
            case DOING: 
            case ASYN_DOING: {
                return "loading";
            }
            case SUCCESS: {
                return "check";
            }
            case FAILD: {
                return "close";
            }
            case CANCEL: {
                return "stop";
            }
        }
        throw new IllegalStateException("result:" + this.execResult + " status is illegal");
    }

    public String getStateColor() {
        switch (this.execResult) {
            case DOING: 
            case ASYN_DOING: {
                return "blue";
            }
            case SUCCESS: {
                return "green";
            }
            case FAILD: {
                return "red";
            }
            case CANCEL: {
                return "red";
            }
        }
        throw new IllegalStateException("result:" + this.execResult + " status is illegal");
    }

    public int getState() {
        return this.delegate.getState().byteValue();
    }

    public String getLiteralState() {
        return this.execResult.getLiteral();
    }

    public String getTriggerType() {
        return TriggerType.parse((int)this.delegate.getTriggerType()).getLiteral();
    }

    public Integer getOpUserId() {
        return this.delegate.getOpUserId();
    }

    public String getOpUserName() {
        return this.delegate.getOpUserName();
    }

    public Integer getAppId() {
        return this.delegate.getAppId();
    }

    public String getAppName() {
        return this.delegate.getAppName();
    }

    public String getStartPhase() {
        return FullbuildPhase.parse((int)this.delegate.getStartPhase()).getLiteral();
    }

    public int getStartPhaseNum() {
        return this.delegate.getStartPhase();
    }

    public int getEndPhaseNum() {
        return this.delegate.getEndPhase();
    }

    public String getEndPhase() {
        return FullbuildPhase.parse((int)this.delegate.getEndPhase()).getLiteral();
    }

    public Integer getHistoryId() {
        return this.delegate.getHistoryId();
    }

    public Integer getWorkFlowId() {
        return this.delegate.getWorkFlowId();
    }

    public long getCreateTime() {
        return this.delegate.getCreateTime().getTime();
    }

    public Date getOpTime() {
        return this.delegate.getOpTime();
    }
}

