/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.coredefine.module.action;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.datax.common.element.DataXResultPreviewOrderByCols;
import com.alibaba.datax.common.element.QueryCriteria;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.koubei.web.tag.pager.Pager;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.assemble.ExecResult;
import com.qlangtech.tis.coredefine.module.action.CoreAction;
import com.qlangtech.tis.coredefine.module.action.DataXJobWorkerStatus;
import com.qlangtech.tis.coredefine.module.action.IFlinkIncrJobStatus;
import com.qlangtech.tis.coredefine.module.action.IncrUtils;
import com.qlangtech.tis.coredefine.module.action.IndexIncrStatus;
import com.qlangtech.tis.coredefine.module.action.PluginDescMeta;
import com.qlangtech.tis.coredefine.module.action.ProcessModel;
import com.qlangtech.tis.coredefine.module.action.RcHpaStatus;
import com.qlangtech.tis.coredefine.module.action.TargetResName;
import com.qlangtech.tis.coredefine.module.action.ValdateReaderAndWriter;
import com.qlangtech.tis.datax.DataXCfgFile;
import com.qlangtech.tis.datax.DataXJobSubmit;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.IDataXPowerJobSubmit;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.IDataxReader;
import com.qlangtech.tis.datax.IDataxReaderContext;
import com.qlangtech.tis.datax.IDataxWriter;
import com.qlangtech.tis.datax.ISearchEngineTypeTransfer;
import com.qlangtech.tis.datax.SourceColMetaGetter;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.TableAlias;
import com.qlangtech.tis.datax.TableAliasMapper;
import com.qlangtech.tis.datax.impl.DataXBasicProcessMeta;
import com.qlangtech.tis.datax.impl.DataXCfgGenerator;
import com.qlangtech.tis.datax.impl.DataxProcessor;
import com.qlangtech.tis.datax.impl.DataxReader;
import com.qlangtech.tis.datax.impl.DataxWriter;
import com.qlangtech.tis.datax.impl.ESTableAlias;
import com.qlangtech.tis.datax.job.DataXJobWorker;
import com.qlangtech.tis.datax.job.DefaultSSERunnable;
import com.qlangtech.tis.datax.job.ILaunchingOrchestrate;
import com.qlangtech.tis.datax.job.JobResName;
import com.qlangtech.tis.datax.job.SSEEventWriter;
import com.qlangtech.tis.datax.job.SSERunnable;
import com.qlangtech.tis.datax.job.ServerLaunchToken;
import com.qlangtech.tis.datax.job.SubJobResName;
import com.qlangtech.tis.datax.preview.PreviewHeaderCol;
import com.qlangtech.tis.datax.preview.PreviewRowsData;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.DescriptorExtensionList;
import com.qlangtech.tis.extension.SubFormFilter;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.manage.IAppSource;
import com.qlangtech.tis.manage.biz.dal.pojo.Application;
import com.qlangtech.tis.manage.biz.dal.pojo.ApplicationCriteria;
import com.qlangtech.tis.manage.common.AppDomainInfo;
import com.qlangtech.tis.manage.common.ManageUtils;
import com.qlangtech.tis.manage.common.MockContext;
import com.qlangtech.tis.manage.common.Option;
import com.qlangtech.tis.manage.common.RunContext;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.manage.common.apps.IDepartmentGetter;
import com.qlangtech.tis.manage.common.incr.StreamContextConstant;
import com.qlangtech.tis.manage.common.valve.AjaxValve;
import com.qlangtech.tis.manage.servlet.BasicServlet;
import com.qlangtech.tis.manage.spring.aop.Func;
import com.qlangtech.tis.plugin.IPluginTaggable;
import com.qlangtech.tis.plugin.KeyedPluginStore;
import com.qlangtech.tis.plugin.annotation.IFieldValidator;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.datax.SelectedTabExtend;
import com.qlangtech.tis.plugin.datax.common.AutoCreateTable;
import com.qlangtech.tis.plugin.ds.CMeta;
import com.qlangtech.tis.plugin.ds.ColumnMetaData;
import com.qlangtech.tis.plugin.ds.DataTypeMeta;
import com.qlangtech.tis.plugin.ds.DefaultTab;
import com.qlangtech.tis.plugin.ds.IInitWriterTableExecutor;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.plugin.ds.IdlistElementCreatorFactory;
import com.qlangtech.tis.plugin.trigger.JobTrigger;
import com.qlangtech.tis.realtime.yarn.rpc.SynResTarget;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import com.qlangtech.tis.runtime.module.action.CreateIndexConfirmModel;
import com.qlangtech.tis.runtime.module.action.SchemaAction;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.runtime.module.misc.IFieldErrorHandler;
import com.qlangtech.tis.runtime.module.misc.impl.DelegateControl4JsonPostMsgHandler;
import com.qlangtech.tis.solrdao.ISchema;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.util.DescribableJSON;
import com.qlangtech.tis.util.DescriptorsJSON;
import com.qlangtech.tis.util.DescriptorsJSONResult;
import com.qlangtech.tis.util.HeteroEnum;
import com.qlangtech.tis.util.HeteroList;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.Selectable;
import com.qlangtech.tis.util.UploadPluginMeta;
import com.qlangtech.tis.workflow.pojo.WorkFlowBuildHistory;
import com.qlangtech.tis.workflow.pojo.WorkFlowBuildHistoryCriteria;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterceptorRefs(value={@InterceptorRef(value="tisStack")})
public class DataxAction
extends BasicModule {
    private static final Logger logger = LoggerFactory.getLogger(DataxAction.class);
    private static final String PARAM_KEY_DATAX_NAME = "dataxName";
    public static final String KEY_USING_POWERJOB_USE_EXIST_CLUSTER = "usingPowderJobUseExistCluster";
    private static List<Option> deps;
    private static final Pattern PatternEdittingDirSuffix;

    @Func(value="dataX_manage")
    public void doDeletePowerJobWorkflow(Context context) throws Exception {
        Long pjWorkflowId = this.getLong("id");
        Optional powerJobSubmit = DataXJobSubmit.getPowerJobSubmit();
        IDataXPowerJobSubmit jobSubmit = (IDataXPowerJobSubmit)powerJobSubmit.orElseThrow(() -> new IllegalStateException("dataXJobSubmit must be present"));
        jobSubmit.deleteWorkflow((IControlMsgHandler)this, context, pjWorkflowId);
    }

    @Func(value="dataX_manage")
    public void doGetAllPowerjobWorkflowRecord(Context context) throws Exception {
        Optional powerJobSubmit = DataXJobSubmit.getPowerJobSubmit();
        IDataXPowerJobSubmit jobSubmit = (IDataXPowerJobSubmit)powerJobSubmit.orElseThrow(() -> new IllegalStateException("dataXJobSubmit must be present"));
        HashMap criteria = Maps.newHashMap();
        Pager pager = this.createPager();
        Pair workflows = jobSubmit.fetchAllInstance((Map)criteria, pager.getCurPage(), pager.getRowsPerPage());
        pager.setTotalCount((Integer)workflows.getKey());
        this.setBizResult(context, new BasicModule.PaginationResult(pager, (List)workflows.getRight(), new Object[0]));
    }

    @Func(value="dataX_manage")
    public void doTriggerFullbuildTask(Context context) throws Exception {
        Optional<Long> powerJobWorkflowInstanceId = Optional.ofNullable(this.getLong("powerJobWorkflowInstanceId", null));
        DataXJobSubmit.InstanceType triggerType = Optional.ofNullable(this.getString("triggertype")).map(type -> DataXJobSubmit.InstanceType.parse((String)type)).orElseGet(() -> DataXJobSubmit.getDataXTriggerType());
        DataXName dataX = this.getCollectionName();
        IDataxProcessor dataXProcessor = DataxProcessor.load(null, (StoreResourceType)dataX.getType(), (String)dataX.getPipelineName());
        if (!dataXProcessor.isSupportBatch((IPluginContext)this)) {
            this.addErrorMessage(context, "\u8be5\u6570\u636e\u901a\u9053\u4e0d\u652f\u6301\u6279\u91cf\u6570\u636e\u540c\u6b65\uff0c\u8bf7\u4f7f\u7528\u5b9e\u65f6\u540c\u6b65");
            return;
        }
        WorkFlowBuildHistory latestWorkflowHistory = this.getDaoContext().getLatestSuccessWorkflowHistory(SynResTarget.pipeline((String)dataXProcessor.identityValue()));
        Optional partialTrigger = JobTrigger.getPartialTriggerFromContext((Context)context);
        DataXCfgGenerator.GenerateCfgs cfgFileNames = dataXProcessor.getDataxCfgFileNames(null, partialTrigger);
        if (!triggerType.validate((IControlMsgHandler)this, context, cfgFileNames.getDataXCfgFiles())) {
            return;
        }
        Optional dataXJobSubmit = DataXJobSubmit.getDataXJobSubmit((boolean)false, (DataXJobSubmit.InstanceType)triggerType);
        if (!dataXJobSubmit.isPresent()) {
            this.setBizResult(context, Collections.singletonMap("installLocal", true));
            this.addErrorMessage(context, "\u8fd8\u6ca1\u6709\u5b89\u88c5\u672c\u5730\u89e6\u53d1\u7c7b\u578b\u7684\u6267\u884c\u5668:" + triggerType + ",\u8bf7\u5148\u5b89\u88c5");
            return;
        }
        DataXJobSubmit jobSubmit = (DataXJobSubmit)dataXJobSubmit.get();
        logger.info("jobSubmit " + jobSubmit.getType() + " the submit instance type of :" + jobSubmit.getClass().getName());
        this.setBizResult(context, jobSubmit.triggerJob((IControlMsgHandler)this, context, this.getCollectionName(), powerJobWorkflowInstanceId, Optional.ofNullable(latestWorkflowHistory)));
    }

    @Func(value="dataX_manage")
    public void doSaveTableCreateDdl(Context context) throws Exception {
        JSONObject post = this.parseJsonPost();
        String dataXName = post.getString(PARAM_KEY_DATAX_NAME);
        String createTableDDL = post.getString("content");
        if (StringUtils.isEmpty((String)createTableDDL)) {
            throw new IllegalArgumentException("create table ddl can not be null");
        }
        if (StringUtils.isEmpty((String)dataXName)) {
            throw new IllegalArgumentException("param dataXName can not be null");
        }
        ProcessModel pmodel = ProcessModel.parse((String)this.getString("processModel"));
        IDataxProcessor dataxProcessor = (IDataxProcessor)pmodel.loadDataXProcessor((IPluginContext)this, dataXName);
        String createFileName = post.getString("fileName");
        dataxProcessor.saveCreateTableDDL((IPluginContext)this, new StringBuffer(createTableDDL), createFileName, true);
        this.addActionMessage(context, "\u5df2\u7ecf\u6210\u529f\u66f4\u65b0\u5efa\u8868DDL\u811a\u672c " + createFileName);
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doDataxProcessorDesc(Context context) throws Exception {
        ProcessModel pmodel = ProcessModel.parse((String)this.getString("processModel"));
        UploadPluginMeta pluginMeta = UploadPluginMeta.parse((String)HeteroEnum.APP_SOURCE.identity);
        HeteroList hlist = new HeteroList(pluginMeta);
        hlist.setDescriptors(Collections.singletonList(pmodel.getPluginDescMeta()));
        hlist.setExtensionPoint(IAppSource.class);
        hlist.setSelectable(Selectable.Single);
        hlist.setCaption("");
        String dataxName = this.getString(PARAM_KEY_DATAX_NAME);
        if (StringUtils.isNotEmpty((String)dataxName)) {
            hlist.setItems(Collections.singletonList(pmodel.loadDataXProcessor((IPluginContext)this, dataxName)));
        }
        this.setBizResult(context, hlist.toJSON());
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doGetWriterPluginInfo(Context context) throws Exception {
        String dataxName = this.getString(PARAM_KEY_DATAX_NAME);
        ProcessModel pmodel = ProcessModel.parse((String)this.getString("processModel"));
        JSONObject writerDesc = this.parseJsonPost();
        if (StringUtils.isEmpty((String)dataxName)) {
            throw new IllegalStateException("param dataxName can not be null");
        }
        pmodel.getDataXReader((IPluginContext)this, dataxName);
        String requestDescId = writerDesc.getString("impl");
        DataxWriter writer = pmodel.loadWriter((IPluginContext)this, writerDesc, dataxName);
        HashMap pluginInfo = Maps.newHashMap();
        DescriptorsJSONResult writeDesc = null;
        if (writer != null) {
            pluginInfo.put("item", new DescribableJSON((Describable)writer).getItemJson());
            writeDesc = DescriptorsJSON.desc((Descriptor)writer.getDescriptor());
        } else {
            writeDesc = DescriptorsJSON.desc((String)requestDescId);
        }
        pluginInfo.put("desc", writeDesc);
        this.setBizResult(context, pluginInfo);
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doGetReaderPluginInfo(Context context) throws Exception {
        String dataxName = this.getString(PARAM_KEY_DATAX_NAME);
        JSONObject readerDesc = this.parseJsonPost();
        if (StringUtils.isEmpty((String)dataxName)) {
            throw new IllegalStateException("param dataxName can not be null");
        }
        String requestDescId = readerDesc.getString("impl");
        KeyedPluginStore readerStore = DataxReader.getPluginStore((IPluginContext)this, (String)dataxName);
        DataxReader reader = (DataxReader)readerStore.getPlugin();
        HashMap pluginInfo = Maps.newHashMap();
        if (reader != null && StringUtils.equals((String)reader.getDescriptor().getId(), (String)requestDescId)) {
            pluginInfo.put("item", new DescribableJSON((Describable)reader).getItemJson());
        }
        pluginInfo.put("desc", DescriptorsJSON.desc((String)requestDescId));
        this.setBizResult(context, pluginInfo);
    }

    @Func(value="dataX_manage")
    public void doTestLaunchDataxWorker(Context context) throws IOException {
        SSEEventWriter printWriter = this.getEventStreamWriter();
        int timeout = 40000;
        long start = System.currentTimeMillis();
        long end = System.currentTimeMillis();
        printWriter.writeSSEEvent(SSERunnable.SSEEventType.TASK_LOG, "xxxxxxxxxxxxxxxxx");
        System.out.println("Exiting handleSSE()-suscribe" + Thread.currentThread().getName());
    }

    @Func(value="dataX_manage")
    public void doApplyPodNumber(Context context) throws Exception {
        SSEEventWriter writer = this.getEventStreamWriter();
        Integer podNum = this.getInt("podNumber");
        TargetResName cptType = new TargetResName(this.getString("cptType"));
        DataXJobWorker dataxJobWorker = DataXJobWorker.getJobWorker((TargetResName)this.getK8SJobWorkerTargetName());
        ILaunchingOrchestrate.ExecuteStep execStep = new ILaunchingOrchestrate.ExecuteStep((JobResName)SubJobResName.createSubJob((String)"scalaPods", dto -> {
            throw new UnsupportedOperationException();
        }), null);
        List<ILaunchingOrchestrate.ExecuteStep> executeSteps = Collections.singletonList(execStep);
        DefaultSSERunnable launchProcess = new DefaultSSERunnable(writer, new ILaunchingOrchestrate.ExecuteSteps("\u8c03\u6574Pod\u6570\u91cf", (Object)dataxJobWorker, executeSteps), () -> {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        ServerLaunchToken launchToken = dataxJobWorker.getProcessTokenFile(cptType, true, DataXJobWorker.K8SWorkerCptType.K8SPods);
        launchToken.deleteLaunchToken();
        DefaultSSERunnable.execute((DefaultSSERunnable)launchProcess, (boolean)false, (ServerLaunchToken)launchToken, () -> dataxJobWorker.updatePodNumber((SSERunnable)launchProcess, cptType, podNum));
    }

    @Func(value="dataX_manage")
    public void doRelaunchDataxWorker(Context context) throws Exception {
        DataXJobWorker.K8SWorkerCptType cptType = this.getPowerJobCptType();
        this.relaunchK8SCluster(context, cptType);
    }

    private DataXJobWorker.K8SWorkerCptType getPowerJobCptType() {
        return this.getBoolean(KEY_USING_POWERJOB_USE_EXIST_CLUSTER) ? DataXJobWorker.K8SWorkerCptType.UsingExistCluster : DataXJobWorker.K8SWorkerCptType.Server;
    }

    public void relaunchK8SCluster(Context context, DataXJobWorker.K8SWorkerCptType cptType) throws Exception {
        SSEEventWriter writer = this.getEventStreamWriter();
        DataXJobWorker dataxJobWorker = this.getDataXJobWorker(cptType);
        dataxJobWorker.remove();
        Thread.sleep(3000L);
        this.launchDataxWorker(context, writer, dataxJobWorker, DataXJobWorker.getOrchestrate((DataXJobWorker)dataxJobWorker));
    }

    @Func(value="dataX_manage")
    public void doRelaunchFlinkCluster(Context context) throws Exception {
        this.relaunchK8SCluster(context, DataXJobWorker.K8SWorkerCptType.FlinkCluster);
    }

    public void doGetDataxWorkerConfig(Context context) throws Exception {
        Optional launchToken = DataXJobWorker.getLaunchToken((TargetResName)this.getK8SJobWorkerTargetName());
        ServerLaunchToken lt = (ServerLaunchToken)launchToken.orElseThrow(() -> new IllegalStateException("launchToken must be present"));
        JSONObject dataXWorker = new JSONObject();
        dataXWorker.put(KEY_USING_POWERJOB_USE_EXIST_CLUSTER, (Object)(lt.workerCptType == DataXJobWorker.K8SWorkerCptType.UsingExistCluster ? 1 : 0));
        if (lt.workerCptType == DataXJobWorker.K8SWorkerCptType.Server) {
            DataXJobWorker pjServer = DataXJobWorker.getJobWorker((TargetResName)TargetResName.K8S_DATAX_INSTANCE_NAME, Optional.of(DataXJobWorker.K8SWorkerCptType.Server));
            DataXJobWorker pjWorker = DataXJobWorker.getJobWorker((TargetResName)TargetResName.K8S_DATAX_INSTANCE_NAME, Optional.of(DataXJobWorker.K8SWorkerCptType.Worker));
            dataXWorker.put("powderJobServerRCSpec", (Object)IncrUtils.serializeSpec(IncrUtils.IncrSpecResult.create(pjServer.getReplicasSpec(), pjServer.getHpa())));
            dataXWorker.put("powderJobWorkerRCSpec", (Object)IncrUtils.serializeSpec(IncrUtils.IncrSpecResult.create(pjWorker.getReplicasSpec(), pjWorker.getHpa())));
        }
        this.setBizResult(context, dataXWorker);
    }

    @Func(value="dataX_manage")
    public void doLaunchDataxWorker(Context context) throws Exception {
        DataXJobWorker.K8SWorkerCptType cptType = this.getPowerJobCptType();
        this.launchK8SCluster(context, cptType);
    }

    @Func(value="dataX_manage")
    public void doLaunchFlinkCluster(Context context) throws Exception {
        this.launchK8SCluster(context, DataXJobWorker.K8SWorkerCptType.FlinkCluster);
    }

    public void launchK8SCluster(Context context, DataXJobWorker.K8SWorkerCptType cptType) throws Exception {
        DataXJobWorker dataxJobWorker = this.getDataXJobWorker(cptType);
        boolean orchestrate = DataXJobWorker.isOrchestrate((DataXJobWorker)dataxJobWorker);
        if (!orchestrate) {
            throw new NotImplementedException("to do for " + DataXJobWorker.K8SWorkerCptType.UsingExistCluster + ",worker:" + dataxJobWorker.getClass().getName());
        }
        SSEEventWriter httpResponseWriter = this.getEventStreamWriter();
        this.launchDataxWorker(context, httpResponseWriter, dataxJobWorker, DataXJobWorker.getOrchestrate((DataXJobWorker)dataxJobWorker));
    }

    private void launchDataxWorker(final Context context, SSEEventWriter httpResponseWriter, DataXJobWorker dataxJobWorker, ILaunchingOrchestrate orchestrate) throws Exception {
        DefaultSSERunnable launchProcess = new DefaultSSERunnable(httpResponseWriter, orchestrate.createExecuteSteps((Object)dataxJobWorker), () -> {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }){

            public void afterLaunched() {
                DataxAction.this.doGetJobWorkerMeta(context);
                AjaxValve.ActionExecResult actionExecResult = MockContext.getActionExecResult();
                DataXJobWorkerStatus jobWorkerStatus = (DataXJobWorkerStatus)((Object)actionExecResult.getBizResult());
                if (jobWorkerStatus == null || !jobWorkerStatus.isK8sReplicationControllerCreated()) {
                    throw new IllegalStateException("Job Controller launch faild please contract administer");
                }
                DataxAction.this.addActionMessage(context, "\u5df2\u7ecf\u6210\u529f\u542f\u52a8DataX\u6267\u884c\u5668");
            }
        };
        ServerLaunchToken launchToken = dataxJobWorker.getProcessTokenFile();
        DefaultSSERunnable.execute((DefaultSSERunnable)launchProcess, (boolean)dataxJobWorker.inService(), (ServerLaunchToken)launchToken, () -> dataxJobWorker.executeLaunchService((SSERunnable)launchProcess));
    }

    private DataXJobWorker getDataXJobWorker(DataXJobWorker.K8SWorkerCptType cptType) {
        DataXJobWorker dataxJobWorker = DataXJobWorker.getJobWorker((TargetResName)this.getK8SJobWorkerTargetName(), Optional.of(cptType));
        if (dataxJobWorker == null) {
            throw new IllegalStateException("dataxJobWorker can not be null,relevant target type:" + this.getK8SJobWorkerTargetName());
        }
        return dataxJobWorker;
    }

    @Func(value="dataX_manage")
    public void doRemoveDataxWorker(Context context) {
        DataXJobWorker jobWorker = DataXJobWorker.getJobWorker((TargetResName)this.getK8SJobWorkerTargetName());
        if (!jobWorker.inService()) {
            throw new IllegalStateException("dataxJobWorker is not in serivce ,can not remove");
        }
        jobWorker.remove();
        this.addActionMessage(context, "DataX Worker \u5df2\u7ecf\u88ab\u5220\u9664");
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doWorkerDesc(Context context) {
        TargetResName targetName = this.getK8SJobWorkerTargetName();
        PluginDescMeta pluginDescMeta = new PluginDescMeta(DataXJobWorker.getDesc((TargetResName)targetName));
        boolean addJobTplOverwritePlugin = this.getBoolean("addJobTplOverwritePlugin");
        if (addJobTplOverwritePlugin) {
            pluginDescMeta.addTypedPlugins(DataXJobWorker.K8SWorkerCptType.JobTplAppOverwrite, HeteroEnum.appJobWorkerTplReWriter.getPlugins((IPluginContext)this, null));
        }
        this.setBizResult(context, pluginDescMeta);
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doGetDataxWorkerMeta(Context context) {
        this.getJobWoker(context, TargetResName.K8S_DATAX_INSTANCE_NAME);
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doGetJobWorkerMeta(Context context) {
        TargetResName targetName = this.getK8SJobWorkerTargetName();
        this.getJobWoker(context, targetName);
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doGetFlinkSession(Context context) {
        TargetResName targetName = this.getK8SJobWorkerTargetName(false);
        Optional<ServerLaunchToken> launchToken = Optional.of(ServerLaunchToken.createFlinkClusterToken().token(ServerLaunchToken.FlinkClusterType.K8SSession, targetName));
        this.getJobWoker(context, targetName, launchToken);
    }

    private void getJobWoker(Context context, TargetResName targetName) {
        this.getJobWoker(context, targetName, DataXJobWorker.getLaunchToken((TargetResName)targetName));
    }

    private void getJobWoker(Context context, TargetResName targetName, Optional<ServerLaunchToken> launchToken) {
        DataXJobWorkerStatus jobWorkerStatus = new DataXJobWorkerStatus();
        if (!launchToken.isPresent()) {
            jobWorkerStatus.setState(IFlinkIncrJobStatus.State.NONE);
            this.setBizResult(context, (Object)jobWorkerStatus);
            return;
        }
        DataXJobWorker jobWorker = DataXJobWorker.getJobWorker((TargetResName)targetName, launchToken.map(t -> t.getWorkerCptType()));
        boolean disableRcdeployment = this.getBoolean("disableRcdeployment");
        jobWorkerStatus.setState(jobWorker != null && jobWorker.inService() ? IFlinkIncrJobStatus.State.RUNNING : IFlinkIncrJobStatus.State.NONE);
        if (jobWorkerStatus.getState() == IFlinkIncrJobStatus.State.RUNNING && !disableRcdeployment) {
            jobWorkerStatus.setPayloads(jobWorker.getPayloadInfo());
            jobWorkerStatus.setRcDeployments(jobWorker.getRCDeployments());
        }
        this.setBizResult(context, (Object)jobWorkerStatus);
    }

    private TargetResName getK8SJobWorkerTargetName() {
        return this.getK8SJobWorkerTargetName(true);
    }

    private TargetResName getK8SJobWorkerTargetName(boolean validate) {
        String targetName = this.getString("targetName");
        if (validate) {
            DataXJobWorker.validateTargetName((String)targetName);
        }
        return new TargetResName(targetName);
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doGetDataxWorkerHpa(Context context) {
        DataXJobWorker jobWorker = DataXJobWorker.getJobWorker((TargetResName)this.getK8SJobWorkerTargetName());
        if (jobWorker.getHpa() != null) {
            RcHpaStatus hpaStatus = jobWorker.getHpaStatus();
            this.setBizResult(context, hpaStatus);
        }
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doRelaunchPodProcess(Context context) throws Exception {
        DataXJobWorker jobWorker = DataXJobWorker.getJobWorker((TargetResName)this.getK8SJobWorkerTargetName());
        String podName = this.getString("podName");
        jobWorker.relaunch(podName);
    }

    @Func(value="dataX_manage")
    public void doSaveDataxWorker(Context context) {
        if (!this.isCollectionAware()) {
            throw new IllegalStateException("must be collection aware");
        }
        TargetResName resName = TargetResName.createTargetName((DataXName)this.getCollectionName());
        List<UploadPluginMeta> metas = this.getPluginMeta();
        DataXJobWorker.K8SWorkerCptType powerjobCptType = null;
        for (UploadPluginMeta meta : metas) {
            powerjobCptType = DataXJobWorker.K8SWorkerCptType.parse((String)meta.getDataXName().getPipelineName());
        }
        this.saveWorker(context, resName, Optional.of(powerjobCptType));
    }

    private void saveWorker(Context context, TargetResName resName, Optional<DataXJobWorker.K8SWorkerCptType> cptType) {
        JSONObject postContent = this.parseJsonPost();
        JSONObject k8sSpec = postContent.getJSONObject("k8sSpec");
        IncrUtils.IncrSpecResult incrSpecResult = IncrUtils.parseIncrSpec(context, k8sSpec, this);
        if (!incrSpecResult.isSuccess()) {
            return;
        }
        DataXJobWorker worker = DataXJobWorker.getJobWorker((TargetResName)resName, cptType);
        worker.setReplicasSpec(incrSpecResult.getSpec());
        if (incrSpecResult.hpa != null) {
            worker.setHpa(incrSpecResult.hpa);
        }
        DataXJobWorker.setJobWorker((TargetResName)resName, cptType, (DataXJobWorker)worker);
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doGetSupportedReaderWriterTypes(Context context) {
        DescriptorExtensionList readerTypes = TIS.get().getDescriptorList(DataxReader.class);
        Object writerTypes = TIS.get().getDescriptorList(DataxWriter.class);
        String writerPluginTag = this.getString("writerPluginTag");
        if (StringUtils.isNotEmpty((String)writerPluginTag)) {
            IPluginTaggable.PluginTag filterTag = IPluginTaggable.PluginTag.parse((String)writerPluginTag);
            writerTypes = writerTypes.stream().filter(desc -> {
                if (desc instanceof IPluginTaggable) {
                    IPluginTaggable taggable = (IPluginTaggable)desc;
                    return taggable.getTags().contains(filterTag);
                }
                return false;
            }).collect(Collectors.toList());
        }
        this.setBizResult(context, new DataxPluginDescMeta((DescriptorExtensionList<DataxReader, Descriptor<DataxReader>>)readerTypes, (List<Descriptor<DataxWriter>>)writerTypes));
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doGetGenCfgFile(Context context) throws Exception {
        String dataxName = this.getString(PARAM_KEY_DATAX_NAME);
        DataXCfgFile cfgFileCriteria = this.parseJsonPost(DataXCfgFile.class);
        GenCfgFileType fileType = GenCfgFileType.parse(this.getString("fileType"));
        ProcessModel pmodel = ProcessModel.parse((String)this.getString("processModel"));
        IDataxProcessor dataxProcessor = (IDataxProcessor)pmodel.loadDataXProcessor((IPluginContext)this, dataxName);
        HashMap fileMeta = Maps.newHashMap();
        switch (fileType) {
            case DATAX_CFG: {
                File cfgFile = dataxProcessor.getDataXCfgFile((IPluginContext)this, cfgFileCriteria);
                if (!cfgFile.exists()) {
                    throw new IllegalStateException("target file:" + cfgFile.getAbsolutePath());
                }
                fileMeta.put("content", FileUtils.readFileToString((File)cfgFile, (Charset)TisUTF8.get()));
                break;
            }
            case CREATE_TABLE_DDL: {
                File ddlDir = dataxProcessor.getDataxCreateDDLDir((IPluginContext)this);
                File sqlScript = new File(ddlDir, cfgFileCriteria.getFileName());
                if (!sqlScript.exists()) {
                    throw new IllegalStateException("target file:" + sqlScript.getAbsolutePath());
                }
                fileMeta.put("content", FileUtils.readFileToString((File)sqlScript, (Charset)TisUTF8.get()));
                break;
            }
            default: {
                throw new IllegalStateException("illegal fileType:" + fileType);
            }
        }
        this.setBizResult(context, fileMeta);
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doGetExecStatistics(Context context) throws Exception {
        WorkFlowBuildHistoryCriteria historyCriteria = new WorkFlowBuildHistoryCriteria();
        Date from = ManageUtils.getOffsetDate(-7);
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd");
        TreeMap execStatis = Maps.newTreeMap();
        ExecResult execResult = null;
        DataXExecStatus execStatus = null;
        String timeLab = null;
        for (int i = 0; i < 8; ++i) {
            timeLab = dateFormat.format(ManageUtils.getOffsetDate(-i));
            execStatis.put(timeLab, new DataXExecStatus(timeLab));
        }
        int successCount = 0;
        int errCount = 0;
        historyCriteria.createCriteria().andAppIdEqualTo(this.getAppDomain().getAppid()).andCreateTimeGreaterThan(from);
        for (WorkFlowBuildHistory h : this.wfDAOFacade.getWorkFlowBuildHistoryDAO().selectByExample(historyCriteria)) {
            execResult = ExecResult.parse((int)h.getState().byteValue());
            execStatus = (DataXExecStatus)execStatis.get(dateFormat.format(h.getCreateTime()));
            if (execStatus == null) continue;
            if (execResult == ExecResult.SUCCESS) {
                ++execStatus.successCount;
                ++successCount;
                continue;
            }
            if (execResult != ExecResult.FAILD) continue;
            ++execStatus.errCount;
            ++errCount;
        }
        HashMap bizResult = Maps.newHashMap();
        bizResult.put("data", execStatis.values());
        HashMap allStatis = Maps.newHashMap();
        allStatis.put("errCount", errCount);
        allStatis.put("successCount", successCount);
        bizResult.put("statis", allStatis);
        this.setBizResult(context, bizResult);
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doValidateDataxProfile(Context context) throws Exception {
        Application app = this.parseJsonPost(Application.class);
        SchemaAction.CreateAppResult validateResult = this.createNewApp(context, app, null, true, newAppId -> {
            throw new UnsupportedOperationException();
        }, new Object[0]);
    }

    public static void cleanDepsCache() {
        deps = null;
    }

    public static List<Option> getDepartments() {
        if (deps != null) {
            return deps;
        }
        RunContext runContext = BasicServlet.getBeanByType(ServletActionContext.getServletContext(), RunContext.class);
        Objects.requireNonNull(runContext, "runContext can not be null");
        deps = BasicModule.getDptList(runContext, new IDepartmentGetter(){});
        return deps;
    }

    @Func(value="dataX_manage")
    public void doGenerateDataxCfgs(Context context) throws Exception {
        String dataxName = this.getString(PARAM_KEY_DATAX_NAME);
        boolean getExist = this.getBoolean("getExist");
        ProcessModel pmodel = ProcessModel.parse((String)this.getString("processModel"));
        DataxAction.generateDataXCfgs(this, context, pmodel.resType, dataxName, getExist);
    }

    public static void generateDataXCfgs(IPluginContext pluginContext, Context context, StoreResourceType resType, String dataxName, boolean getExist) {
        if (StringUtils.isEmpty((String)dataxName)) {
            throw new IllegalArgumentException("param dataXName can not be null");
        }
        try {
            IDataxProcessor dataxProcessor = DataxProcessor.load((IPluginContext)pluginContext, (StoreResourceType)resType, (String)dataxName);
            DataXCfgGenerator cfgGenerator = new DataXCfgGenerator(pluginContext, dataxName, dataxProcessor);
            File dataxCfgDir = dataxProcessor.getDataxCfgDir(pluginContext);
            FileUtils.forceMkdir((File)dataxCfgDir);
            if (!getExist) {
                // empty if block
            }
            DataXCfgGenerator.GenerateCfgs generateCfgs = null;
            pluginContext.setBizResult(context, (Object)(getExist ? cfgGenerator.getExistCfg(dataxCfgDir) : (generateCfgs = cfgGenerator.startGenerateCfg(dataxCfgDir))));
            if (!getExist) {
                Objects.requireNonNull(generateCfgs, "generateCfgs can not be null");
                generateCfgs.write2GenFile(dataxCfgDir);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("resType:" + resType + ",name:" + dataxName, e);
        }
    }

    @Func(value="dataX_manage")
    public void doSyncSqlDdlCfgsToTarget(Context context) throws Exception {
    }

    @Func(value="dataX_manage")
    public void doRegenerateSqlDdlCfgs(Context context) throws Exception {
        String dataxName = this.getString(PARAM_KEY_DATAX_NAME);
        ProcessModel pmodel = ProcessModel.parse((String)this.getString("processModel"));
        final IDataxProcessor dataxProcessor = (IDataxProcessor)pmodel.loadDataXProcessor((IPluginContext)this, dataxName);
        DataXCfgGenerator cfgGenerator = new DataXCfgGenerator((IPluginContext)this, dataxName, dataxProcessor);
        IDataxWriter writer = dataxProcessor.getWriter((IPluginContext)this, true);
        if (writer.isGenerateCreateDDLSwitchOff()) {
            throw TisException.create((String)"\u81ea\u52a8\u751f\u6210Create Table DDL\u5df2\u7ecf\u5173\u95ed\uff0c\u8bf7\u5148\u6253\u5f00\u518d\u4f7f\u7528");
        }
        DataxWriter.BaseDataxWriterDescriptor writerDesc = writer.getWriterDescriptor();
        if (!writerDesc.isSupportTabCreate()) {
            throw new IllegalStateException("writerDesc:" + writerDesc.getDisplayName() + " is not support generate Table create DDL");
        }
        this.setBizResult(context, cfgGenerator.startGenerateCfg(new DataXCfgGenerator.IGenerateScriptFile(){

            public void generateScriptFile(SourceColMetaGetter colMetaGetter, IDataxReader reader, IDataxWriter writer, DataxWriter.BaseDataxWriterDescriptor writerDescriptor, IDataxReaderContext readerContext, Set<String> createDDLFiles, Optional<IDataxProcessor.TableMap> tableMapper) throws IOException {
                DataXCfgGenerator.generateTabCreateDDL((IPluginContext)DataxAction.this, (IDataxProcessor)dataxProcessor, (SourceColMetaGetter)colMetaGetter, (IDataxWriter)writer, (IDataxReaderContext)readerContext, createDDLFiles, tableMapper, (boolean)true);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Func(value="dataX_manage")
    public void doDeleteDatax(Context context) throws Exception {
        block19: {
            File scriptRootDir;
            File dataXDirTrash;
            File scriptDootDirTrash;
            File dataXDir;
            block17: {
                boolean deleteSuccess;
                AppDomainInfo appDomain;
                block15: {
                    block18: {
                        block16: {
                            appDomain = this.getAppDomain();
                            deleteSuccess = false;
                            dataXDir = null;
                            scriptDootDirTrash = null;
                            dataXDirTrash = null;
                            scriptRootDir = null;
                            try {
                                IFlinkIncrJobStatus.State state = null;
                                try {
                                    IndexIncrStatus incrStatus = CoreAction.getIndexIncrStatus((IControlMsgHandler)this, true);
                                    state = incrStatus.getState();
                                }
                                catch (Throwable e) {
                                    logger.error(e.getMessage(), e);
                                    state = IFlinkIncrJobStatus.State.NONE;
                                }
                                if (state == IFlinkIncrJobStatus.State.NONE) break block15;
                                this.addErrorMessage(context, "\u589e\u91cf\u5b9e\u4f8b\u5b58\u5728\uff0c\u8bf7\u5148\u5c06\u5176\u5220\u9664");
                                if (!deleteSuccess) break block16;
                            }
                            catch (Throwable throwable) {
                                if (deleteSuccess) {
                                    FileUtils.deleteDirectory(scriptDootDirTrash);
                                    FileUtils.deleteDirectory(dataXDirTrash);
                                } else {
                                    if (dataXDirTrash != null && dataXDirTrash.exists()) {
                                        FileUtils.moveDirectory((File)dataXDirTrash, dataXDir);
                                    }
                                    if (scriptDootDirTrash != null && scriptDootDirTrash.exists()) {
                                        FileUtils.moveDirectory((File)scriptDootDirTrash, scriptRootDir);
                                    }
                                }
                                throw throwable;
                            }
                            FileUtils.deleteDirectory((File)scriptDootDirTrash);
                            FileUtils.deleteDirectory((File)dataXDirTrash);
                            break block18;
                        }
                        if (dataXDirTrash != null && dataXDirTrash.exists()) {
                            FileUtils.moveDirectory((File)dataXDirTrash, dataXDir);
                        }
                        if (scriptDootDirTrash != null && scriptDootDirTrash.exists()) {
                            FileUtils.moveDirectory((File)scriptDootDirTrash, (File)scriptRootDir);
                        }
                    }
                    return;
                }
                scriptRootDir = StreamContextConstant.getStreamScriptRootDir((String)appDomain.getAppName());
                scriptDootDirTrash = StreamContextConstant.getStreamScriptRootDir((String)appDomain.getAppName(), (boolean)true).getFile();
                if (scriptRootDir.exists()) {
                    FileUtils.moveDirectory((File)scriptRootDir, (File)scriptDootDirTrash);
                }
                KeyedPluginStore appSource = IAppSource.getPluginStore((IPluginContext)this, (String)appDomain.getAppName());
                dataXDir = appSource.getTargetFile().getFile().getParentFile();
                dataXDirTrash = new File(dataXDir.getParentFile(), ".trash/" + appDomain.getAppName());
                if (dataXDir.exists()) {
                    FileUtils.moveDirectory((File)dataXDir, (File)dataXDirTrash);
                }
                WorkFlowBuildHistoryCriteria historyCriteria = new WorkFlowBuildHistoryCriteria();
                historyCriteria.createCriteria().andAppIdEqualTo(appDomain.getAppid());
                this.getWorkflowDAOFacade().getWorkFlowBuildHistoryDAO().deleteByExample(historyCriteria);
                this.getApplicationDAO().deleteByPrimaryKey(appDomain.getAppid());
                this.addActionMessage(context, "\u5df2\u7ecf\u6210\u529f\u5c06\u6570\u636e\u901a\u9053'" + appDomain.getAppName() + "'\u5220\u9664");
                IAppSource.cleanAppSourcePluginStoreCache((IPluginContext)this, (DataXName)DataXName.createDataXPipeline((String)appDomain.getAppName()));
                deleteSuccess = true;
                if (!deleteSuccess) break block17;
                FileUtils.deleteDirectory((File)scriptDootDirTrash);
                FileUtils.deleteDirectory((File)dataXDirTrash);
                break block19;
            }
            if (dataXDirTrash != null && dataXDirTrash.exists()) {
                FileUtils.moveDirectory((File)dataXDirTrash, (File)dataXDir);
            }
            if (scriptDootDirTrash != null && scriptDootDirTrash.exists()) {
                FileUtils.moveDirectory((File)scriptDootDirTrash, (File)scriptRootDir);
            }
        }
    }

    @Func(value="dataX_manage")
    public void doCreateDatax(Context context) throws Exception {
        String dataxName = this.getString(PARAM_KEY_DATAX_NAME);
        this.createPipeline(context, dataxName);
    }

    @Func(value="dataX_manage")
    public void doUpdatePowerJob(Context context) throws Exception {
        Optional dataXJobSubmit = DataXJobSubmit.getPowerJobSubmit();
        IDataXPowerJobSubmit jobSubmit = (IDataXPowerJobSubmit)dataXJobSubmit.orElseThrow(() -> new IllegalStateException("dataXJobSubmit must be present"));
        DataxProcessor dataxProcessor = (DataxProcessor)DataxProcessor.load(null, (StoreResourceType)StoreResourceType.DataApp, (String)this.getAppDomain().getAppName());
        this.setBizResult(context, jobSubmit.saveJob((IControlMsgHandler)this, context, (IDataxProcessor)dataxProcessor));
    }

    @Func(value="dataX_manage")
    public void doUpdateDatax(Context context) throws Exception {
        ProcessModel pmodel = ProcessModel.parse((String)this.getString("processModel"));
        DataXName dataxName = new DataXName(this.getCollectionName().getPipelineName(), pmodel.resType);
        IDataxProcessor old = (IDataxProcessor)pmodel.loadDataXProcessor(null, dataxName.getPipelineName());
        IDataxProcessor editting = (IDataxProcessor)pmodel.loadDataXProcessor((IPluginContext)this, dataxName.getPipelineName());
        File oldWorkDir = old.getDataXWorkDir((IPluginContext)null);
        File edittingDir = editting.getDataXWorkDir((IPluginContext)this);
        String edittingDirSuffix = StringUtils.substringAfter((String)edittingDir.getName(), (String)oldWorkDir.getName());
        Matcher matcher = PatternEdittingDirSuffix.matcher(edittingDirSuffix);
        if (!matcher.matches()) {
            throw new IllegalStateException("dir name is illegal,oldDir:" + oldWorkDir.getAbsolutePath() + " editting dir:" + edittingDir.getAbsolutePath());
        }
        File backDir = new File(oldWorkDir.getParentFile(), oldWorkDir.getName() + ".bak");
        try {
            FileUtils.moveDirectory((File)oldWorkDir, (File)backDir);
            FileUtils.moveDirectory((File)edittingDir, (File)oldWorkDir);
            FileUtils.forceDelete((File)backDir);
        }
        catch (Exception e) {
            try {
                FileUtils.moveDirectory((File)backDir, (File)oldWorkDir);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new IllegalStateException("oldWorkDir update is illegal:" + oldWorkDir.getAbsolutePath(), e);
        }
        Application dataXApp = new Application();
        dataXApp.setUpdateTime(new Date());
        ApplicationCriteria appCriteria = new ApplicationCriteria();
        appCriteria.createCriteria().andProjectNameEqualTo(dataxName.getPipelineName());
        this.getApplicationDAO().updateByExampleSelective(dataXApp, appCriteria);
        IAppSource.cleanAppSourcePluginStoreCache(null, (DataXName)dataxName);
        IAppSource.cleanAppSourcePluginStoreCache((IPluginContext)this, (DataXName)dataxName);
        SelectedTabExtend.clearTabExtend(null, (String)dataxName.getPipelineName());
        SelectedTabExtend.clearTabExtend((IPluginContext)this, (String)dataxName.getPipelineName());
        DataXJobSubmit.getPowerJobSubmit().ifPresent(submit -> submit.saveJob((IControlMsgHandler)this, context, old));
        this.addActionMessage(context, "\u5df2\u7ecf\u6210\u529f\u66f4\u65b0");
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doCreateUpdateProcess(Context context) throws Exception {
        DataXName dataXName = this.getCollectionName();
        String execId = this.getString("execId");
        if (StringUtils.isBlank((String)execId)) {
            throw new IllegalArgumentException("param execId can not be null");
        }
        ProcessModel pmodel = ProcessModel.parse((String)this.getString("processModel"));
        IDataxProcessor dataxProcessor = (IDataxProcessor)pmodel.loadDataXProcessor((IPluginContext)this, dataXName.getPipelineName());
        dataxProcessor.makeTempDir(execId);
        this.setBizResult(context, execId);
    }

    @Func(value="dataX_manage")
    public void doSaveTableMapper(Context context) {
        String dataxName = this.getString(PARAM_KEY_DATAX_NAME);
        JSONArray tabAliasList = this.parseJsonArrayPost();
        Objects.requireNonNull(tabAliasList, "tabAliasList can not be null");
        JSONObject alias = null;
        TableAlias tabAlias = null;
        ArrayList tableMaps = Lists.newArrayList();
        String mapperToVal = null;
        for (int i = 0; i < tabAliasList.size(); ++i) {
            alias = tabAliasList.getJSONObject(i);
            tabAlias = new TableAlias();
            tabAlias.setFrom(alias.getString("from"));
            mapperToVal = alias.getString("to");
            String mapper2FieldKey = "tabMapperTo[" + i + "]";
            if (Validator.require.validate((IFieldErrorHandler)this, context, mapper2FieldKey, mapperToVal)) {
                Validator.db_col_name.validate((IFieldErrorHandler)this, context, mapper2FieldKey, mapperToVal);
            }
            tabAlias.setTo(mapperToVal);
            tableMaps.add(tabAlias);
        }
        if (context.hasErrors()) {
            return;
        }
        TableAlias.saveTableMapper((IPluginContext)this, (String)dataxName, (List)tableMaps);
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doPreviewTableRows(Context context) {
        String targetTab = this.getString("table");
        JSONObject jsonPostContent = this.getJSONPostContent();
        if (StringUtils.isEmpty((String)targetTab)) {
            throw new IllegalArgumentException("param table can not be null");
        }
        DataXName dataXName = this.getCollectionName();
        Optional jobSubmit = DataXJobSubmit.getDataXJobSubmit((boolean)false, (DataXJobSubmit.InstanceType)DataXJobSubmit.InstanceType.LOCAL);
        DataXJobSubmit submit = (DataXJobSubmit)jobSubmit.orElseThrow(() -> new IllegalStateException("dataXJobSubmit must be present"));
        QueryCriteria queryCriteria = QueryCriteria.createCriteria((int)this.getInt("pageSize"), (JSONObject)jsonPostContent);
        HashMap preview = Maps.newHashMap();
        boolean needHeader = true;
        PreviewRowsData records = submit.previewRowsData(dataXName, targetTab, queryCriteria);
        List headerCursor = records.getHeaderCursor();
        List tailerCursor = records.getTailerCursor();
        if (CollectionUtils.isNotEmpty((Collection)headerCursor)) {
            preview.put("headerCursor", DataXResultPreviewOrderByCols.OffsetColVal.getPreviewCursor((List)headerCursor));
        }
        if (CollectionUtils.isNotEmpty((Collection)tailerCursor)) {
            preview.put("tailerCursor", DataXResultPreviewOrderByCols.OffsetColVal.getPreviewCursor((List)tailerCursor));
        }
        if (needHeader) {
            JSONArray headerCols = new JSONArray();
            JSONObject col = null;
            for (PreviewHeaderCol headerCol : records.getHeader()) {
                col = new JSONObject();
                col.put("key", (Object)headerCol.getKey());
                col.put("blob", (Object)headerCol.isBlob());
                headerCols.add((Object)col);
            }
            preview.put("header", headerCols);
        }
        preview.put("rows", records.getRows());
        this.setBizResult(context, preview);
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doGetTableMapper(Context context) {
        String dataxName = this.getString(PARAM_KEY_DATAX_NAME);
        boolean forceInit = this.getBoolean("forceInit");
        KeyedPluginStore readerStore = DataxReader.getPluginStore((IPluginContext)this, (String)dataxName);
        DataxReader dataxReader = (DataxReader)readerStore.getPlugin();
        Objects.requireNonNull(dataxReader, "dataReader:" + dataxName + " relevant instance can not be null");
        Optional dataXAppSource = IAppSource.loadNullable((IPluginContext)this, (DataXName)DataXName.createDataXPipeline((String)dataxName));
        TableAliasMapper tabMaps = null;
        AutoCreateTable mapperTabPrefixAutoTabCreator = null;
        if (dataXAppSource.isPresent()) {
            DataxProcessor dataxSource = (DataxProcessor)dataXAppSource.get();
            IDataxWriter dataXWriter = dataxSource.getWriter((IPluginContext)this, true);
            if (dataXWriter instanceof IInitWriterTableExecutor) {
                mapperTabPrefixAutoTabCreator = ((IInitWriterTableExecutor)dataXWriter).getAutoCreateTableCanNotBeNull();
            }
            tabMaps = dataxSource.getTabAlias((IPluginContext)this, false);
        }
        if (tabMaps == null) {
            throw new IllegalStateException("tableMaps can not be null");
        }
        if (!dataxReader.hasMulitTable()) {
            throw new IllegalStateException("reader (" + dataxReader.getClass().getSimpleName() + ") has not set table at least");
        }
        ArrayList tmapList = Lists.newArrayList();
        for (ISelectedTab selectedTab : dataxReader.getSelectedTabs()) {
            TableAlias tableAlias = tabMaps.get(selectedTab);
            if (forceInit || tableAlias == null) {
                TableAlias tableAlias2 = tableAlias = tableAlias == null ? new TableAlias(selectedTab.getName()) : tableAlias;
                if (mapperTabPrefixAutoTabCreator != null) {
                    tableAlias.setTo(mapperTabPrefixAutoTabCreator.appendTabPrefix(EntityName.parse((String)selectedTab.getName()).getTabName()));
                }
                tmapList.add(tableAlias);
                continue;
            }
            tmapList.add(tableAlias);
        }
        this.setBizResult(context, tmapList);
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doGetReaderWriterMeta(Context context) {
        String dataxName = this.getString(PARAM_KEY_DATAX_NAME);
        DataxProcessor.DataXCreateProcessMeta processMeta = DataxProcessor.getDataXCreateProcessMeta((IPluginContext)this, (String)dataxName, (boolean)false);
        this.setBizResult(context, processMeta);
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doGetWriterColsMeta(Context context) {
        String dataxName = this.getString(PARAM_KEY_DATAX_NAME);
        IDataxProcessor processor = DataxProcessor.load((IPluginContext)this, (String)dataxName);
        IDataxProcessor.TableMap tabMapper = DataxAction.getTableMapper(this, processor);
        this.setBizResult(context, DataTypeMeta.createViewBiz((DataTypeMeta.IMultiItemsView)DataTypeMeta.IMultiItemsView.unknow(), (Object)tabMapper));
    }

    public static IDataxProcessor.TableMap getTableMapper(IPluginContext pluginCtx, IDataxProcessor processor) {
        IDataxProcessor.TableMap tabMapper;
        block2: {
            block1: {
                TableAliasMapper tabAlias = processor.getTabAlias(pluginCtx, false);
                Optional findMapper = tabAlias.findFirst();
                tabMapper = null;
                if (!findMapper.isPresent()) break block1;
                tabMapper = (IDataxProcessor.TableMap)findMapper.get();
                List sourceCols = tabMapper.getSourceCols();
                IDataxProcessor.TableMap m = new IDataxProcessor.TableMap(sourceCols);
                m.setFrom(tabMapper.getFrom());
                m.setTo(tabMapper.getTo());
                tabMapper = m;
                break block2;
            }
            List tabs = processor.getReader(pluginCtx).getSelectedTabs();
            int selectedTabsSize = tabs.size();
            if (selectedTabsSize != 1) {
                throw new IllegalStateException("dataX reader getSelectedTabs size must be 1 ,but now is :" + selectedTabsSize);
            }
            Iterator iterator = tabs.iterator();
            if (!iterator.hasNext()) break block2;
            ISelectedTab selectedTab = (ISelectedTab)iterator.next();
            tabMapper = new IDataxProcessor.TableMap(selectedTab);
            tabMapper.setFrom(selectedTab.getName());
            tabMapper.setTo(selectedTab.getName());
        }
        return tabMapper;
    }

    @Func(value="app_add")
    public void doGotoEsAppCreateConfirm(Context context) throws Exception {
        this.errorsPageShow(context);
        CreateIndexConfirmModel confiemModel = this.parseJsonPost(CreateIndexConfirmModel.class);
        String schemaContent = null;
        SchemaAction.UploadSchemaWithRawContentForm schema = null;
        ISearchEngineTypeTransfer typeTransfer = ISearchEngineTypeTransfer.load((IPluginContext)this, (String)confiemModel.getDataxName());
        if (confiemModel.isExpertModel()) {
            CreateIndexConfirmModel.ExpertEditorModel expect = confiemModel.getExpert();
            schemaContent = expect.getXml();
            schema = typeTransfer.projectionFromExpertModel(expect.asJson());
        } else {
            schema = confiemModel.getStupid().getModel();
            schemaContent = typeTransfer.mergeFromStupidModel((ISchema)schema, ISearchEngineTypeTransfer.getOriginExpertSchema(null)).toJSONString();
        }
        if (!schema.isValid()) {
            for (String err : schema.getErrors()) {
                this.addErrorMessage(context, err);
            }
            return;
        }
        DataxProcessor.DataXCreateProcessMeta processMeta = DataxProcessor.getDataXCreateProcessMeta((IPluginContext)this, (String)confiemModel.getDataxName());
        List selectedTabs = processMeta.getReader().getSelectedTabs();
        ESTableAlias esTableAlias = new ESTableAlias(schemaContent);
        esTableAlias.setFrom(((ISelectedTab)selectedTabs.stream().findFirst().get()).getName());
        esTableAlias.setTo(((ISearchEngineTypeTransfer)processMeta.getWriter()).getIndexName());
        TableAlias.saveTableMapper((IPluginContext)this, (String)confiemModel.getDataxName(), Collections.singletonList(esTableAlias));
    }

    @Func(value="dataX_manage")
    public void doSaveWriterColsMeta(Context context) {
        String dataxName = this.getString(PARAM_KEY_DATAX_NAME);
        DataxProcessor.DataXCreateProcessMeta processMeta = DataxProcessor.getDataXCreateProcessMeta((IPluginContext)this, (String)dataxName);
        if (processMeta.isReaderRDBMS()) {
            throw new IllegalStateException("can not process the flow with:" + String.valueOf(processMeta));
        }
        DataxAction.validateAndSaveTableMapper(this, context, dataxName, this.getJSONPostContent());
    }

    public static boolean validateAndSaveTableMapper(final BasicModule delegate, Context context, String dataxName, JSONObject parseJsonPost) {
        final ArrayList writerCols = Lists.newArrayList();
        final IDataxProcessor.TableMap tableMapper = new IDataxProcessor.TableMap((ISelectedTab)new DefaultTab(dataxName, (List)writerCols));
        DelegateControl4JsonPostMsgHandler handler = new DelegateControl4JsonPostMsgHandler((IControlMsgHandler)delegate, parseJsonPost);
        if (!Validator.validate((IControlMsgHandler)handler, (Context)context, (Map)Validator.fieldsValidator((Object[])new Object[]{"writerTargetTabName", new Validator.FieldValidators(new Validator[]{Validator.require, Validator.db_col_name}){

            public void setFieldVal(String val) {
                tableMapper.setTo(val);
            }
        }, "writerFromTabName", new Validator.FieldValidators(new Validator[]{Validator.require, Validator.db_col_name}){

            public void setFieldVal(String val) {
                tableMapper.setFrom(val);
            }
        }, "colsMeta", new Validator.FieldValidators(new Validator[]{Validator.require}){

            public void setFieldVal(String val) {
            }
        }, new IFieldValidator(){

            public boolean validate(IFieldErrorHandler msgHandler, Context context, String fieldKey, String fieldData) {
                JSONArray targetCols = JSON.parseArray((String)fieldData);
                if (targetCols.size() < 1) {
                    msgHandler.addFieldError(context, fieldKey, "Writer\u76ee\u6807\u8868\u5217\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
                    return false;
                }
                CMeta.ParsePostMCols postMCols = new IdlistElementCreatorFactory().parsePostMCols(null, (IControlMsgHandler)msgHandler, context, fieldKey, targetCols);
                if (!postMCols.pkHasSelected) {
                    delegate.addErrorMessage(context, "\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u4e3b\u952e\u5217");
                    postMCols.validateFaild = true;
                }
                writerCols.addAll(postMCols.writerCols);
                return !postMCols.validateFaild;
            }
        }}))) {
            return false;
        }
        TableAlias.saveTableMapper((IPluginContext)delegate, (String)dataxName, Collections.singletonList(tableMapper));
        return true;
    }

    private ValdateReaderAndWriter getValdateReaderAndWriter(ProcessModel pmodel) {
        switch (pmodel) {
            case CreateDatax: {
                return (reader, writer, module, context) -> {
                    if (reader == null || writer == null) {
                        module.addErrorMessage(context, "\u8bf7\u9009\u62e9'Reader\u7c7b\u578b'\u548c'Writer\u7c7b\u578b'");
                        return false;
                    }
                    return true;
                };
            }
            case CreateWorkFlow: {
                return (reader, writer, module, context) -> {
                    if (writer == null) {
                        module.addErrorMessage(context, "\u8bf7\u9009\u62e9'\u5f15\u64ce\u7c7b\u578b'");
                        return false;
                    }
                    return true;
                };
            }
        }
        throw new IllegalStateException("illegal pmode:" + pmodel);
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doValidateReaderWriter(Context context) throws Exception {
        this.errorsPageShow(context);
        JSONObject post = this.parseJsonPost();
        ProcessModel pmodel = ProcessModel.parse((String)post.getString("processModel"));
        String dataxPipeName = post.getString("dataxPipeName");
        JSONObject reader = post.getJSONObject("readerDescriptor");
        JSONObject writer = post.getJSONObject("writerDescriptor");
        if (!this.getValdateReaderAndWriter(pmodel).valdateReaderAndWriter(reader, writer, this, context)) {
            return;
        }
        DataXBasicProcessMeta processMeta = pmodel.createProcessMeta((IPluginContext)this, dataxPipeName, reader, writer);
        this.setBizResult(context, processMeta);
    }

    @Func(value="dataX_manage", sideEffect=false)
    public void doGetDataXMeta(Context context) {
        DataXName dataXName = this.getCollectionName();
        ProcessModel pmodel = ProcessModel.parse((String)this.getString("processModel"));
        IDataxProcessor processor = (IDataxProcessor)pmodel.loadDataXProcessor((IPluginContext)this, dataXName.getPipelineName());
        HashMap result = Maps.newHashMap();
        Optional dataXReader = pmodel.getDataXReader((IPluginContext)this, dataXName.getPipelineName());
        DataxReader.BaseDataxReaderDescriptor readerDesc = null;
        DataxReader reader = null;
        if (dataXReader.isPresent()) {
            reader = (DataxReader)dataXReader.get();
            readerDesc = (DataxReader.BaseDataxReaderDescriptor)reader.getDescriptor();
            result.put("readerDesc", DescriptorsJSON.desc((Descriptor)readerDesc));
        }
        DataxWriter writer = (DataxWriter)processor.getWriter((IPluginContext)this, true);
        DataxWriter.BaseDataxWriterDescriptor writerDesc = (DataxWriter.BaseDataxWriterDescriptor)writer.getDescriptor();
        result.put("processMeta", ProcessModel.getDataXBasicProcessMeta(Optional.ofNullable(readerDesc), (DataxWriter.BaseDataxWriterDescriptor)writerDesc));
        result.put("writerDesc", DescriptorsJSON.desc((Descriptor)writerDesc));
        this.setBizResult(context, result);
    }

    public static List<String> getTablesInDB(SubFormFilter filter) {
        DataxReader reader = DataxReader.getDataxReader((SubFormFilter)filter);
        return reader.getTablesInDB().getTabs();
    }

    public static List<ColumnMetaData> getReaderTableSelectableCols(String dataxName, String table) {
        throw new UnsupportedOperationException();
    }

    static {
        PatternEdittingDirSuffix = Pattern.compile("\\-[\\da-z]{8}\\-[\\da-z]{4}\\-[\\da-z]{4}\\-[\\da-z]{4}\\-[\\da-z]{12}");
    }

    public static class DataxPluginDescMeta
    extends PluginDescMeta<DataxReader> {
        private final DescriptorsJSON writerTypesDesc;

        public DataxPluginDescMeta(DescriptorExtensionList<DataxReader, Descriptor<DataxReader>> readerTypes, List<Descriptor<DataxWriter>> writerTypes) {
            super(readerTypes);
            this.writerTypesDesc = new DescriptorsJSON(writerTypes);
        }

        @Override
        @JSONField(serialize=false)
        public DescriptorsJSONResult getPluginDesc() {
            throw new UnsupportedOperationException();
        }

        public DescriptorsJSONResult getReaderDesc() {
            return this.pluginDesc.getDescriptorsJSON();
        }

        public DescriptorsJSONResult getWriterDesc() {
            return this.writerTypesDesc.getDescriptorsJSON();
        }
    }

    private static class DataXExecStatus {
        private final String timeLab;
        int errCount;
        int successCount;

        public DataXExecStatus(String timeLab) {
            this.timeLab = timeLab;
        }

        public String getTimeLab() {
            return this.timeLab;
        }

        public int getErrCount() {
            return this.errCount;
        }

        public int getSuccessCount() {
            return this.successCount;
        }
    }

    static enum GenCfgFileType {
        DATAX_CFG("datax"),
        CREATE_TABLE_DDL("createTableDDL");

        private final String val;

        static GenCfgFileType parse(String val) {
            for (GenCfgFileType t : GenCfgFileType.values()) {
                if (!t.val.equalsIgnoreCase(val)) continue;
                return t;
            }
            throw new IllegalStateException("illegal val:" + val);
        }

        private GenCfgFileType(String val) {
            this.val = val;
        }
    }
}

