/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.coredefine.module.action;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.koubei.web.tag.pager.Pager;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.assemble.ExecResult;
import com.qlangtech.tis.async.message.client.consumer.impl.MQListenerFactory;
import com.qlangtech.tis.build.task.IBuildHistory;
import com.qlangtech.tis.cloud.ITISCoordinator;
import com.qlangtech.tis.compiler.streamcode.GenerateDAOAndIncrScript;
import com.qlangtech.tis.compiler.streamcode.IndexStreamCodeGenerator;
import com.qlangtech.tis.coredefine.biz.FCoreRequest;
import com.qlangtech.tis.coredefine.module.action.ExtendWorkFlowBuildHistory;
import com.qlangtech.tis.coredefine.module.action.IDeploymentDetail;
import com.qlangtech.tis.coredefine.module.action.IFlinkIncrJobStatus;
import com.qlangtech.tis.coredefine.module.action.IRCController;
import com.qlangtech.tis.coredefine.module.action.IndexIncrStatus;
import com.qlangtech.tis.coredefine.module.action.LaunchIncrSyncChannel;
import com.qlangtech.tis.coredefine.module.action.PluginAction;
import com.qlangtech.tis.coredefine.module.action.TISK8sDelegate;
import com.qlangtech.tis.coredefine.module.action.TargetResName;
import com.qlangtech.tis.coredefine.module.action.TriggerBuildResult;
import com.qlangtech.tis.coredefine.module.action.impl.FlinkJobDeploymentDetails;
import com.qlangtech.tis.coredefine.module.action.impl.RcDeployment;
import com.qlangtech.tis.coredefine.module.control.SelectableServer;
import com.qlangtech.tis.datax.DataXJobSubmit;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.impl.DataxProcessor;
import com.qlangtech.tis.datax.impl.DataxReader;
import com.qlangtech.tis.datax.impl.DataxWriter;
import com.qlangtech.tis.datax.job.ILaunchingOrchestrate;
import com.qlangtech.tis.datax.job.JobOrchestrateException;
import com.qlangtech.tis.datax.job.JobResName;
import com.qlangtech.tis.datax.job.SSEEventWriter;
import com.qlangtech.tis.datax.job.SSERunnable;
import com.qlangtech.tis.datax.job.ServerLaunchToken;
import com.qlangtech.tis.datax.job.SubJobResName;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.manage.IAppSource;
import com.qlangtech.tis.manage.IBasicAppSource;
import com.qlangtech.tis.manage.IDataFlowAppSource;
import com.qlangtech.tis.manage.ISingleTableAppSource;
import com.qlangtech.tis.manage.ISolrAppSource;
import com.qlangtech.tis.manage.biz.dal.pojo.Application;
import com.qlangtech.tis.manage.biz.dal.pojo.Server;
import com.qlangtech.tis.manage.biz.dal.pojo.ServerGroup;
import com.qlangtech.tis.manage.biz.dal.pojo.ServerGroupCriteria;
import com.qlangtech.tis.manage.biz.dal.pojo.SnapshotCriteria;
import com.qlangtech.tis.manage.common.AppDomainInfo;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.HttpUtils;
import com.qlangtech.tis.manage.common.ManageUtils;
import com.qlangtech.tis.manage.common.RunContext;
import com.qlangtech.tis.manage.servlet.DownloadServlet;
import com.qlangtech.tis.manage.spring.aop.Func;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.incr.IncrStreamFactory;
import com.qlangtech.tis.plugin.incr.TISSinkFactory;
import com.qlangtech.tis.pubhook.common.RunEnvironment;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.runtime.module.misc.IMessageHandler;
import com.qlangtech.tis.runtime.module.screen.BasicScreen;
import com.qlangtech.tis.runtime.pojo.ServerGroupAdapter;
import com.qlangtech.tis.sql.parser.stream.generate.StreamCodeContext;
import com.qlangtech.tis.sql.parser.tuple.creator.IStreamIncrGenerateStrategy;
import com.qlangtech.tis.util.AdapterPluginContext;
import com.qlangtech.tis.util.HeteroEnum;
import com.qlangtech.tis.util.ItemsSaveResult;
import com.qlangtech.tis.web.start.TisAppLaunch;
import com.qlangtech.tis.workflow.dao.IWorkFlowBuildHistoryDAO;
import com.qlangtech.tis.workflow.pojo.DatasourceDb;
import com.qlangtech.tis.workflow.pojo.DatasourceDbCriteria;
import com.qlangtech.tis.workflow.pojo.WorkFlow;
import com.qlangtech.tis.workflow.pojo.WorkFlowBuildHistory;
import com.qlangtech.tis.workflow.pojo.WorkFlowBuildHistoryCriteria;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreAction
extends BasicModule {
    private static final Logger logger = LoggerFactory.getLogger(CoreAction.class);
    public static final String ADMIN_COLLECTION_PATH = "/solr/admin/collections";
    public static final String CREATE_COLLECTION_PATH = "/solr/admin/collections?action=CREATE&name=";
    public static final String DEFAULT_SOLR_CONFIG = "tis_mock_config";
    private static final long serialVersionUID = -6753169329484480543L;
    private static final Pattern PATTERN_IP = Pattern.compile("^((\\d+?).(\\d+?).(\\d+?).(\\d+?)):(\\d+)_solr$");
    private static final int MAX_SHARDS_PER_NODE = 16;
    private static final Logger log = LoggerFactory.getLogger(CoreAction.class);
    private static final Pattern placehold_pattern = Pattern.compile("\\$\\{(.+)\\}");
    public static final String CREATE_CORE_SELECT_COREINFO = "selectCoreinfo";

    public static String getAssembleNodeAddress(ITISCoordinator coordinator) {
        return Config.getAssembleHttpHost();
    }

    public void doGetTaskInfo(Context context) throws Exception {
        Integer taskid = this.getInt("taskid", null, true);
        WorkFlowBuildHistory buildHistory = this.getWorkflowDAOFacade().getWorkFlowBuildHistoryDAO().selectByPrimaryKey(taskid);
        this.setBizResult(context, Collections.singletonMap("task", buildHistory));
    }

    @Func(value="incr_process_config_edit")
    public void doCreateNewSavepoint(Context context) throws Exception {
        IncrStreamFactory incrSync = this.getRCController();
        TargetResName resName = TargetResName.createTargetName((DataXName)this.getCollectionName());
        IRCController.SupportTriggerSavePointResult supportResult = null;
        supportResult = incrSync.supportTriggerSavePoint(resName);
        if (!supportResult.support) {
            this.addErrorMessage(context, supportResult.unSupportReason);
            return;
        }
        incrSync.triggerSavePoint(resName);
        IndexIncrStatus incrStatus = CoreAction.getIndexIncrStatus((IControlMsgHandler)this, false);
        this.setBizResult(context, incrStatus);
    }

    private IncrStreamFactory getRCController() {
        IPluginStore<IncrStreamFactory> incrStreamStore = CoreAction.getIncrStreamFactoryStore(this, true);
        IncrStreamFactory incrStream = (IncrStreamFactory)incrStreamStore.getPlugin();
        return incrStream;
    }

    @Func(value="incr_process_config_edit")
    public void doGetFlinkClusterList(Context context) throws Exception {
        ServerLaunchToken.FlinkClusterTokenManager clusters = ServerLaunchToken.createFlinkClusterToken();
        this.setBizResult(context, clusters.getAllFlinkSessionClusters());
    }

    @Func(value="incr_process_config_edit")
    public void doDiscardSavepoint(Context context) throws Exception {
        String savepointPath = this.getString("savepointPath");
        if (StringUtils.isEmpty((String)savepointPath)) {
            throw new IllegalArgumentException("param savepointPath can not be null");
        }
        IncrStreamFactory incrSync = this.getRCController();
        incrSync.discardSavepoint(TargetResName.createTargetName((DataXName)this.getCollectionName()), savepointPath);
        IndexIncrStatus incrStatus = CoreAction.getIndexIncrStatus((IControlMsgHandler)this, false);
        this.setBizResult(context, incrStatus);
    }

    @Func(value="app_rebuild")
    public void doRestoreFromCheckpoint(Context context) throws Exception {
        final Integer checkpointId = this.getInt("checkpointId");
        final IncrStreamFactory incrSync = this.getRCController();
        ServerLaunchToken incrLaunchToken = incrSync.getLaunchToken(TargetResName.createTargetName((DataXName)this.getCollectionName()));
        LaunchIncrSyncChannel incrLauncher = new LaunchIncrSyncChannel(this.getCollectionName(), this, context, incrLaunchToken, true){

            @Override
            protected ILaunchingOrchestrate<LaunchIncrSyncChannel.FlinkJobDeployDTO> getFlinkJobWorkingOrchestrate(TISK8sDelegate k8sClient) {
                return CoreAction.this.getFlinkJobRestoreFromCheckpointOrchestrate(incrSync, k8sClient, checkpointId);
            }
        };
        incrLauncher.executeLaunch();
        IndexIncrStatus incrStatus = new IndexIncrStatus();
        this.setBizResult(context, incrStatus);
    }

    private ILaunchingOrchestrate<LaunchIncrSyncChannel.FlinkJobDeployDTO> getFlinkJobRestoreFromCheckpointOrchestrate(IncrStreamFactory incrSync, TISK8sDelegate k8sClient, Integer checkpointId) {
        if (checkpointId == null) {
            throw new IllegalArgumentException("param checkpointId can not be empty");
        }
        if (incrSync == null) {
            throw new IllegalArgumentException("param incrSync can not be null");
        }
        SubJobResName checkEnvironment = JobResName.createSubJob((String)(this.getCollectionName() + " check environment"), dto -> k8sClient.checkUseable(true));
        SubJobResName relaunch = JobResName.createSubJob((String)(this.getCollectionName() + " launch"), dto -> incrSync.restoreFromCheckpoint(TargetResName.createTargetName((DataXName)this.getCollectionName()), checkpointId));
        String jobName = this.getCollectionName() + " wait to end";
        SubJobResName confirm = JobResName.createSubJob((String)jobName, dto -> {
            if (this.waittingiIntendedStatus(IFlinkIncrJobStatus.State.RUNNING) == null) {
                throw new JobOrchestrateException(jobName + " faild");
            }
        });
        return ILaunchingOrchestrate.create((String)"\u589e\u91cf\u5b9e\u65f6\u901a\u9053\u6062\u590d", (SubJobResName[])new SubJobResName[]{checkEnvironment, relaunch, confirm});
    }

    @Func(value="app_update")
    public void doCancelTask(Context context) throws Exception {
        Integer taskId = this.getInt("taskid");
        IWorkFlowBuildHistoryDAO workFlowBuildDAO = this.getWorkflowDAOFacade().getWorkFlowBuildHistoryDAO();
        WorkFlowBuildHistory buildHistory = workFlowBuildDAO.loadFromWriteDB(taskId);
        ExecResult processState = ExecResult.parse((int)buildHistory.getState().byteValue());
        if (!processState.isProcessing()) {
            this.addErrorMessage(context, "\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u4e3a\u5df2\u7ec8\u6b62\uff0c\u4e0d\u80fd\u6267\u884c\u7ec8\u6b62\u64cd\u4f5c");
            return;
        }
        DataXJobSubmit dataXJobSubmit = DataXJobSubmit.getDataXJobSubmit();
        dataXJobSubmit.cancelTask((IControlMsgHandler)this, context, (IBuildHistory)buildHistory);
        WorkFlowBuildHistory record = new WorkFlowBuildHistory();
        record.setState(Byte.valueOf((byte)ExecResult.CANCEL.getValue()));
        WorkFlowBuildHistoryCriteria criteria = new WorkFlowBuildHistoryCriteria();
        criteria.createCriteria().andIdEqualTo(buildHistory.getId());
        workFlowBuildDAO.updateByExampleSelective(record, criteria);
        this.addActionMessage(context, "\u5df2\u7ecf\u6210\u529f\u7ec8\u6b62\u5f53\u524d\u4efb\u52a1");
        this.setBizResult(context, new ExtendWorkFlowBuildHistory(this.getWorkflowDAOFacade().getWorkFlowBuildHistoryDAO().loadFromWriteDB(buildHistory.getId())));
    }

    private IDeploymentDetail waittingiIntendedStatus(final IFlinkIncrJobStatus.State targetStatus) throws JobOrchestrateException {
        int tryCount = 0;
        try {
            while (tryCount++ < 4) {
                IDeploymentDetail detail = TISK8sDelegate.getK8SDelegate(this.getCollectionName()).getRcConfig(false);
                final AtomicBoolean getTargetStatus = new AtomicBoolean(false);
                detail.accept(new IDeploymentDetail.IDeploymentDetailVisitor(){

                    public void visit(RcDeployment rcDeployment) {
                        throw new UnsupportedOperationException();
                    }

                    public void visit(FlinkJobDeploymentDetails details) {
                        getTargetStatus.set(!(targetStatus == IFlinkIncrJobStatus.State.RUNNING ^ details.isRunning()));
                    }
                });
                if (getTargetStatus.get()) {
                    return detail;
                }
                Thread.sleep(3000L);
            }
        }
        catch (InterruptedException e) {
            throw new JobOrchestrateException((Throwable)e);
        }
        return null;
    }

    public void doGetIncrStatus(Context context) throws Exception {
        boolean cache = this.getBoolean("cache");
        IndexIncrStatus incrStatus = CoreAction.getIndexIncrStatus((IControlMsgHandler)this, cache);
        CoreAction.setIncrScriptCreated(this, incrStatus);
        this.setBizResult(context, incrStatus);
    }

    public static IndexIncrStatus getIndexIncrStatus(IControlMsgHandler module, IDeploymentDetail rcConfig) throws Exception {
        final IndexIncrStatus incrStatus = CoreAction.doGetDataXReaderWriterDesc(module.getCollectionName());
        IPluginStore<IncrStreamFactory> store = CoreAction.getIncrStreamFactoryStore(module);
        IncrStreamFactory incrStreamFactory = null;
        incrStreamFactory = (IncrStreamFactory)store.getPlugin();
        if (incrStreamFactory == null) {
            incrStatus.setK8sPluginInitialized(false);
            return incrStatus;
        }
        incrStatus.setRestorableByCheckpoint(incrStreamFactory.restorable().isPresent());
        incrStatus.setK8sPluginInitialized(true);
        incrStatus.setState(rcConfig != null ? IFlinkIncrJobStatus.State.RUNNING : IFlinkIncrJobStatus.State.NONE);
        if (rcConfig != null) {
            rcConfig.accept(new IDeploymentDetail.IDeploymentDetailVisitor(){

                public void visit(RcDeployment rcDeployment) {
                    incrStatus.setRcDeployments(Collections.singletonList(rcDeployment));
                }

                public void visit(FlinkJobDeploymentDetails details) {
                    incrStatus.setFlinkJobDetail(details);
                    IFlinkIncrJobStatus status = details.getIncrJobStatus();
                    if (status.getState() != null) {
                        incrStatus.setState(status.getState());
                    }
                }
            });
            incrStatus.setIncrProcess(null);
        }
        return incrStatus;
    }

    private static void setIncrScriptCreated(BasicModule module, IndexIncrStatus incrStatus) {
        IndexStreamCodeGenerator indexStreamCodeGenerator = CoreAction.getIndexStreamCodeGenerator(module.getTISDataXName(), module);
        StreamCodeContext streamCodeContext = new StreamCodeContext(module.getCollectionName(), indexStreamCodeGenerator.incrScriptTimestamp);
        incrStatus.setIncrScriptCreated(streamCodeContext.isIncrScriptDirCreated());
    }

    public static IndexIncrStatus getIndexIncrStatus(IControlMsgHandler module, boolean getRcConfigInCache) throws Exception {
        IndexIncrStatus incrStatus = CoreAction.doGetDataXReaderWriterDesc(module.getCollectionName());
        return CoreAction.getIndexIncrStatus(module, incrStatus, getRcConfigInCache);
    }

    public static IndexIncrStatus getIndexIncrStatus(IControlMsgHandler module, IndexIncrStatus incrStatus, boolean getRcConfigInCache) throws Exception {
        IPluginStore<IncrStreamFactory> store = CoreAction.getIncrStreamFactoryStore(module);
        if (store.getPlugin() == null) {
            incrStatus.setK8sPluginInitialized(false);
            return incrStatus;
        }
        TISK8sDelegate k8s = TISK8sDelegate.getK8SDelegate(module.getCollectionName());
        if (!k8s.hasCreated()) {
            incrStatus.setK8sPluginInitialized(false);
            return incrStatus;
        }
        k8s.checkUseable(false);
        IDeploymentDetail rcConfig = k8s.getRcConfig(getRcConfigInCache);
        return CoreAction.getIndexIncrStatus(module, rcConfig);
    }

    public static IPluginStore<IncrStreamFactory> getIncrStreamFactoryStore(IControlMsgHandler module) {
        return CoreAction.getIncrStreamFactoryStore(module, false);
    }

    private static IPluginStore<IncrStreamFactory> getIncrStreamFactoryStore(IControlMsgHandler module, boolean validateNull) {
        IPluginStore store = TIS.getPluginStore((DataXName)module.getCollectionName(), IncrStreamFactory.class);
        if (validateNull && store.getPlugin() == null) {
            throw new IllegalStateException("collection:" + module.getCollectionName() + " relevant IncrStreamFactory store can not be null");
        }
        return store;
    }

    @Func(value="incr_process_config_edit", sideEffect=false)
    public void doCreateIncrSyncChannal(Context context) throws Exception {
        List<ItemsSaveResult> itemsSaveResult = PluginAction.getItemsSaveResultInRequest(this.getRequest());
        Optional<ItemsSaveResult> hasCfgChanged = itemsSaveResult.stream().filter(r -> r.cfgSaveResult.cfgChanged).findFirst();
        IndexIncrStatus incrStatus = CoreAction.generateDAOAndIncrScript(this, context, hasCfgChanged.isPresent());
        MQListenerFactory incrFactory = HeteroEnum.getIncrSourceListenerFactory((DataXName)this.getCollectionName());
        TISSinkFactory sinkFactory = TISSinkFactory.getIncrSinKFactory((DataXName)this.getCollectionName());
        incrStatus.setIncrSourceDesc(CoreAction.createDescVals(incrFactory.getDescriptor()));
        incrStatus.setIncrSinkDesc(CoreAction.createDescVals(sinkFactory.getDescriptor()));
        this.setBizResult(context, incrStatus);
    }

    @Func(value="incr_process_config_edit", sideEffect=false)
    public void doStartIncrSyncChannal(Context context) throws Exception {
        this.setBizResult(context, CoreAction.doGetDataXReaderWriterDesc(this.getCollectionName()));
    }

    public static IndexIncrStatus generateDAOAndIncrScript(BasicModule module, Context context, boolean hasCfgChanged) throws Exception {
        return CoreAction.generateDAOAndIncrScript(module, context, false, false, hasCfgChanged);
    }

    public static IndexIncrStatus generateDAOAndIncrScript(BasicModule module, Context context, boolean validateGlobalIncrStreamFactory, boolean compilerAndPackage, boolean hasCfgChanged) throws Exception {
        IStreamIncrGenerateStrategy appSource = (IStreamIncrGenerateStrategy)IAppSource.load(null, (DataXName)module.getCollectionName());
        return CoreAction.generateDAOAndIncrScript(module, context, validateGlobalIncrStreamFactory, compilerAndPackage, appSource.isExcludeFacadeDAOSupport(), hasCfgChanged);
    }

    public static IndexIncrStatus generateDAOAndIncrScript(BasicModule module, Context context, boolean validateGlobalIncrStreamFactory, boolean compilerAndPackage, boolean excludeFacadeDAOSupport, boolean hasCfgChanged) throws Exception {
        IndexStreamCodeGenerator indexStreamCodeGenerator = CoreAction.getIndexStreamCodeGenerator(module.getTISDataXName(), module);
        IndexIncrStatus incrStatus = CoreAction.doGetDataXReaderWriterDesc(module.getCollectionName());
        IPluginStore<IncrStreamFactory> collectionBindIncrStreamFactoryStore = CoreAction.getIncrStreamFactoryStore(module);
        if (collectionBindIncrStreamFactoryStore.getPlugin() == null) {
            // empty if block
        }
        incrStatus.setK8sPluginInitialized(false);
        if (indexStreamCodeGenerator.isIncrScriptDirCreated()) {
            incrStatus.setIncrScriptCreated(true);
            incrStatus.setIncrScriptMainFileContent(indexStreamCodeGenerator.readIncrScriptMainFileContent());
            log.info("incr script has create ignore it file path:{}", (Object)indexStreamCodeGenerator.getIncrScriptDirPath());
        }
        GenerateDAOAndIncrScript generateDAOAndIncrScript = new GenerateDAOAndIncrScript((IControlMsgHandler)module, indexStreamCodeGenerator);
        if (excludeFacadeDAOSupport) {
            generateDAOAndIncrScript.generateIncrScript(context, incrStatus, compilerAndPackage, Collections.emptyMap(), hasCfgChanged);
        } else {
            generateDAOAndIncrScript.generate(context, incrStatus, compilerAndPackage, CoreAction.getDependencyDbsMap(module, indexStreamCodeGenerator));
        }
        incrStatus.setIncrScriptTimestamp(indexStreamCodeGenerator.getIncrScriptTimestamp());
        return incrStatus;
    }

    private static IndexIncrStatus doGetDataXReaderWriterDesc(DataXName appName) throws Exception {
        IndexIncrStatus incrStatus = new IndexIncrStatus();
        incrStatus.setState(IFlinkIncrJobStatus.State.NONE);
        IDataxProcessor dataxProcessor = DataxProcessor.load(null, (StoreResourceType)appName.assetCheckDataAppType(), (String)appName.getPipelineName());
        DataxWriter writer = (DataxWriter)dataxProcessor.getWriter(null, true);
        incrStatus.setWriterDesc(CoreAction.createDescVals(writer.getDescriptor()));
        DataxReader reader = (DataxReader)dataxProcessor.getReader(null);
        incrStatus.setReaderDesc(CoreAction.createDescVals(reader.getDescriptor()));
        return incrStatus;
    }

    private static HashMap<String, Object> createDescVals(Descriptor desc) {
        HashMap newExtraProps = Maps.newHashMap((Map)desc.getExtractProps());
        newExtraProps.put("impl", desc.getId());
        newExtraProps.put("displayName", desc.getDisplayName());
        newExtraProps.put("extendPoint", desc.getT().getName());
        return newExtraProps;
    }

    @Func(value="incr_process_config_edit")
    public void doCompileAndPackage(Context context) {
        CoreAction.compileAndPackageIncrPipeline(this.getCollectionName(), this, context);
    }

    private static void compileAndPackageIncrPipeline(DataXName pipelineName, BasicModule module, Context context) {
        IndexStreamCodeGenerator indexStreamCodeGenerator = CoreAction.getIndexStreamCodeGenerator(pipelineName, module);
        IndexIncrStatus incrStatus = new IndexIncrStatus();
        GenerateDAOAndIncrScript daoAndIncrScript = new GenerateDAOAndIncrScript((IControlMsgHandler)module, indexStreamCodeGenerator);
        daoAndIncrScript.generateIncrScript(context, incrStatus, true, Collections.emptyMap(), false);
    }

    @Func(value="incr_process_config_edit")
    public void doReDeployIncrSyncChannal(Context context) throws Exception {
        CoreAction.deployIncrSyncChannal(context, this, this.getCollectionName());
    }

    public static void deployIncrSyncChannal(Context context, final BasicModule module, final DataXName pipelineName) throws Exception {
        IncrStreamFactory streamFactory = IncrStreamFactory.getFactory((String)pipelineName.getPipelineName());
        TargetResName targetName = TargetResName.createTargetName((DataXName)pipelineName);
        streamFactory.removeInstance(targetName);
        Thread.sleep(4000L);
        ServerLaunchToken incrLaunchToken = streamFactory.getLaunchToken(targetName);
        incrLaunchToken.deleteLaunchToken();
        LaunchIncrSyncChannel incrLauncher = new LaunchIncrSyncChannel(pipelineName, module, context, incrLaunchToken){

            @Override
            protected ILaunchingOrchestrate<LaunchIncrSyncChannel.FlinkJobDeployDTO> getFlinkJobWorkingOrchestrate(TISK8sDelegate k8sClient) {
                return CoreAction.getFlinkJobWorkingOrchestrate(pipelineName, module, k8sClient);
            }
        };
        incrLauncher.executeLaunch();
    }

    @Func(value="app_rebuild")
    public void doRelaunchIncrProcess(Context context) throws Exception {
        final String savepointPath = this.getString("savepointPath");
        if (StringUtils.isEmpty((String)savepointPath)) {
            throw new IllegalArgumentException("param savepointPath can not be null");
        }
        final IncrStreamFactory incrSync = this.getRCController();
        ServerLaunchToken incrLaunchToken = incrSync.getLaunchToken(TargetResName.createTargetName((DataXName)this.getCollectionName()));
        LaunchIncrSyncChannel incrLauncher = new LaunchIncrSyncChannel(this.getCollectionName(), this, context, incrLaunchToken, true){

            @Override
            protected ILaunchingOrchestrate<LaunchIncrSyncChannel.FlinkJobDeployDTO> getFlinkJobWorkingOrchestrate(TISK8sDelegate k8sClient) {
                return CoreAction.this.getFlinkJobRelaunchOrchestrate(incrSync, k8sClient, savepointPath);
            }
        };
        incrLauncher.executeLaunch();
        IndexIncrStatus incrStatus = new IndexIncrStatus();
        this.setBizResult(context, incrStatus);
    }

    private ILaunchingOrchestrate<LaunchIncrSyncChannel.FlinkJobDeployDTO> getFlinkJobRelaunchOrchestrate(IncrStreamFactory incrSync, TISK8sDelegate k8sClient, String savepointPath) {
        if (StringUtils.isEmpty((String)savepointPath)) {
            throw new IllegalArgumentException("param savepointPath can not be empty");
        }
        if (incrSync == null) {
            throw new IllegalArgumentException("param incrSync can not be null");
        }
        SubJobResName checkEnvironment = JobResName.createSubJob((String)(this.getCollectionName() + " check environment"), dto -> k8sClient.checkUseable(true));
        SubJobResName relaunch = JobResName.createSubJob((String)(this.getCollectionName() + " launch"), dto -> incrSync.relaunch(TargetResName.createTargetName((DataXName)this.getCollectionName()), new String[]{savepointPath}));
        String jobName = this.getCollectionName() + " wait to end";
        SubJobResName confirm = JobResName.createSubJob((String)jobName, dto -> {
            if (this.waittingiIntendedStatus(IFlinkIncrJobStatus.State.RUNNING) == null) {
                throw new JobOrchestrateException(jobName + " faild");
            }
        });
        return ILaunchingOrchestrate.create((String)"\u589e\u91cf\u5b9e\u65f6\u901a\u9053\u91cd\u65b0\u90e8\u7f72", (SubJobResName[])new SubJobResName[]{checkEnvironment, relaunch, confirm});
    }

    @Func(value="incr_process_config_edit")
    public void doDeployIncrSyncChannal(Context context) throws Exception {
        DataXName pipelineName = this.getCollectionName();
        IncrStreamFactory streamFactory = this.getRCController();
        CoreAction.startDeployIncrSyncChannal(this, context, streamFactory, pipelineName);
        IndexIncrStatus incrStatus = new IndexIncrStatus();
        this.setBizResult(context, incrStatus);
    }

    public static void startDeployIncrSyncChannal(BasicModule module, Context context, IncrStreamFactory streamFactory, DataXName pipelineName) {
        CoreAction.startDeployIncrSyncChannal(module.getEventStreamWriter(), module, context, streamFactory, pipelineName);
    }

    public static void startDeployIncrSyncChannal(final SSEEventWriter sseEventWriter, final BasicModule module, Context context, IncrStreamFactory streamFactory, final DataXName pipelineName) {
        ServerLaunchToken incrLaunchToken = streamFactory.getLaunchToken(TargetResName.createTargetName((DataXName)pipelineName));
        LaunchIncrSyncChannel incrLauncher = new LaunchIncrSyncChannel(pipelineName, (IControlMsgHandler)new AdapterPluginContext(module){

            public DataXName getTISDataXName() {
                return Objects.requireNonNull(pipelineName);
            }

            public SSEEventWriter getEventStreamWriter() {
                return sseEventWriter;
            }
        }, context, incrLaunchToken){

            @Override
            protected ILaunchingOrchestrate<LaunchIncrSyncChannel.FlinkJobDeployDTO> getFlinkJobWorkingOrchestrate(TISK8sDelegate k8sClient) {
                return CoreAction.getFlinkJobWorkingOrchestrate(pipelineName, module, k8sClient);
            }
        };
        incrLauncher.executeLaunch();
    }

    private static ILaunchingOrchestrate<LaunchIncrSyncChannel.FlinkJobDeployDTO> getFlinkJobWorkingOrchestrate(final DataXName pipelineName, BasicModule module, TISK8sDelegate k8sClient) {
        SubJobResName checkEnvironment = JobResName.createSubJob((String)(pipelineName + " check environment"), dto -> k8sClient.checkUseable(true));
        String subJobName = "Incr " + pipelineName + " Compile And Package";
        SubJobResName compileAndPackage = JobResName.createSubJob((String)subJobName, dto -> {
            SSERunnable sse = SSERunnable.getLocal();
            long start = System.currentTimeMillis();
            CoreAction.compileAndPackageIncrPipeline(pipelineName, Objects.requireNonNull(module, "module can not be null"), dto.context);
            if (dto.hasErrors()) {
                throw new JobOrchestrateException(subJobName + " faild");
            }
            dto.appendLog("\n compile and package consume:" + (System.currentTimeMillis() - start) + "ms ");
        });
        SubJobResName deploy = SubJobResName.createSubJob((String)("Incr " + pipelineName + " Deploy"), dto -> {
            IndexStreamCodeGenerator indexStreamCodeGenerator = CoreAction.getIndexStreamCodeGenerator(pipelineName, module);
            long start = System.currentTimeMillis();
            dto.k8sClient.deploy(null, indexStreamCodeGenerator.getIncrScriptTimestamp());
            dto.appendLog("\n deploy to flink cluster consume:" + (System.currentTimeMillis() - start) + "ms ");
        });
        SubJobResName confirm = SubJobResName.createSubJob((String)"Confirm", dto -> {
            final AtomicBoolean loop = new AtomicBoolean(true);
            AtomicInteger tryCount = new AtomicInteger();
            while (loop.get() && tryCount.getAndIncrement() < 10) {
                IDeploymentDetail rcConfig = dto.k8sClient.getRcConfig(false);
                rcConfig.accept(new IDeploymentDetail.IDeploymentDetailVisitor(){

                    public void visit(RcDeployment rcDeployment) {
                        throw new UnsupportedOperationException(rcDeployment.getName());
                    }

                    public void visit(FlinkJobDeploymentDetails details) {
                        switch (details.getIncrJobStatus().getState()) {
                            case FAILED: {
                                throw TisException.create((String)(pipelineName + " faild"));
                            }
                            case RUNNING: {
                                loop.set(false);
                                break;
                            }
                        }
                    }
                });
                if (!loop.get()) continue;
                log.info("check " + pipelineName + " deploy status,tryCount:" + tryCount.get());
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return ILaunchingOrchestrate.create((String)"\u589e\u91cf\u5b9e\u65f6\u901a\u9053\u542f\u52a8", (SubJobResName[])new SubJobResName[]{checkEnvironment, compileAndPackage, deploy, confirm});
    }

    private static Map<Integer, Long> getDependencyDbsMap(BasicModule module, IndexStreamCodeGenerator indexStreamCodeGenerator) {
        Map dbNameMap = indexStreamCodeGenerator.getDbTables();
        if (dbNameMap.size() < 1) {
            throw new IllegalStateException("dbNameMap size can not small than 1");
        }
        DatasourceDbCriteria dbCriteria = new DatasourceDbCriteria();
        dbCriteria.createCriteria().andIdIn(dbNameMap.keySet().stream().map(dbNode -> dbNode.getDbId()).collect(Collectors.toList()));
        return module.getWorkflowDAOFacade().getDatasourceDbDAO().selectByExample(dbCriteria).stream().collect(Collectors.toMap(DatasourceDb::getId, r -> ManageUtils.formatNowYyyyMMddHHmmss(r.getOpTime())));
    }

    private static IndexStreamCodeGenerator getIndexStreamCodeGenerator(DataXName dataXName, final BasicModule module) {
        Optional appSource = IAppSource.loadNullable(null, (StoreResourceType)Objects.requireNonNull(dataXName).getType(), (String)dataXName.getPipelineName());
        Date scriptLastOpTime = (Date)((IBasicAppSource)appSource.get()).accept((IBasicAppSource.IAppSourceVisitor)new IBasicAppSource.IAppSourceVisitor<Date>(){

            public Date visit(DataxProcessor app) {
                Application application = module.getApplicationDAO().selectByName(app.identityValue());
                Objects.requireNonNull(application, "app:" + app.identityValue() + " relevant app instance can not be null");
                return application.getUpdateTime();
            }

            public Date visit(ISingleTableAppSource single) {
                throw new UnsupportedOperationException();
            }

            public Date visit(IDataFlowAppSource dataflow) {
                Integer dfId = dataflow.getDfId();
                WorkFlow workFlow = module.getWorkflowDAOFacade().getWorkFlowDAO().loadFromWriteDB(dfId);
                return workFlow.getOpTime();
            }
        });
        return new IndexStreamCodeGenerator(dataXName, (IBasicAppSource)appSource.get(), ManageUtils.formatNowYyyyMMddHHmmss(scriptLastOpTime), (dbId, rewriteableTables) -> Collections.emptyList());
    }

    public static void main(String[] args) {
    }

    public static TriggerBuildResult triggerFullIndexSwape(BasicModule module, Context context, Application app, final int sharedCount) throws Exception {
        Objects.requireNonNull(app, "app can not be null");
        ISolrAppSource appSource = (ISolrAppSource)IAppSource.load(null, (DataXName)DataXName.createDataXPipeline((String)app.getProjectName()));
        if (!appSource.triggerFullIndexSwapeValidate((IMessageHandler)module, context)) {
            return new TriggerBuildResult(false);
        }
        return CoreAction.sendRequest2FullIndexSwapeNode(module, context, new AppendParams(){

            @Override
            List<HttpUtils.PostParam> getParam() {
                return Lists.newArrayList((Object[])new HttpUtils.PostParam[]{new HttpUtils.PostParam("index_shard_count", (Object)String.valueOf(sharedCount))});
            }
        });
    }

    public void doGetWorkflowBuildHistory(Context context) throws Exception {
        Integer taskid = this.getInt("taskid", null, false);
        WorkFlowBuildHistory buildHistory = this.getWorkflowDAOFacade().getWorkFlowBuildHistoryDAO().selectByPrimaryKey(taskid);
        if (buildHistory == null) {
            throw new IllegalStateException("taskid:" + taskid + "relevant buildHistory can not be null");
        }
        this.setBizResult(context, new ExtendWorkFlowBuildHistory(buildHistory));
    }

    @Func(value="app_trigger_full_dump")
    public void doTriggerDump(Context context) throws Exception {
        boolean success = CoreAction.sendRequest2FullIndexSwapeNode((BasicModule)this, (Context)context, (AppendParams)new AppendParams(){

            @Override
            List<HttpUtils.PostParam> getParam() {
                return Collections.emptyList();
            }
        }).success;
        if (success) {
            this.addActionMessage(context, "\u5df2\u7ecf\u89e6\u53d1\u4e86\u5168\u91cfDUMP(triggerServiceFullDump)");
        }
    }

    private static TriggerBuildResult sendRequest2FullIndexSwapeNode(BasicModule module, Context context, AppendParams appendParams) throws Exception {
        List<HttpUtils.PostParam> params = appendParams.getParam();
        params.add(new HttpUtils.PostParam("appname", (Object)module.getCollectionName()));
        return TriggerBuildResult.triggerBuild((IControlMsgHandler)module, (Context)context, params);
    }

    public void doGetWorkflow(Context context) throws Exception {
        Integer wfid = this.getInt("wfid");
        Integer taskid = this.getInt("taskid");
        WorkFlowBuildHistory buildHistory = this.getWorkflowDAOFacade().getWorkFlowBuildHistoryDAO().selectByPrimaryKey(taskid);
        HashMap result = Maps.newHashMap();
        result.put("task", buildHistory);
        WorkFlow workFlow = this.getWorkflowDAOFacade().getWorkFlowDAO().selectByPrimaryKey(wfid);
        result.put("workflow", workFlow);
        this.setBizResult(context, result);
    }

    public void doGetFullBuildHistory(Context context) throws Exception {
        Integer wfid = this.getInt("wfid", -1);
        boolean getwf = this.getBoolean("getwf");
        WorkFlow workFlow = new WorkFlow();
        WorkFlowBuildHistoryCriteria query = new WorkFlowBuildHistoryCriteria();
        WorkFlowBuildHistoryCriteria.Criteria criteria = query.createCriteria();
        if (wfid > 0) {
            criteria.andWorkFlowIdEqualTo(wfid);
            workFlow = new WorkFlow();
            if (getwf && (workFlow = this.getWorkflowDAOFacade().getWorkFlowDAO().selectByPrimaryKey(wfid)) == null) {
                throw new IllegalStateException("can not find workflow in db ,wfid:" + wfid);
            }
        } else {
            criteria.andAppIdEqualTo(this.getAppDomain().getAppid());
        }
        query.setOrderByClause("id desc");
        IWorkFlowBuildHistoryDAO historyDAO = this.getWorkflowDAOFacade().getWorkFlowBuildHistoryDAO();
        Pager pager = this.createPager();
        pager.setTotalCount(historyDAO.countByExample(query));
        this.setBizResult(context, new BasicModule.PaginationResult(pager, this.adapterBuildHistory(historyDAO.selectByExample(query, pager.getCurPage(), pager.getRowsPerPage())), workFlow.getName()));
    }

    private List<ExtendWorkFlowBuildHistory> adapterBuildHistory(List<WorkFlowBuildHistory> histories) {
        return histories.stream().map(r -> new ExtendWorkFlowBuildHistory((WorkFlowBuildHistory)r)).collect(Collectors.toList());
    }

    public void doDownloadTaskLog(Context context) throws Exception {
        int taskId = this.getInt("taskid");
        String taskLogFileName = "full-" + taskId + ".log";
        File logFile = new File(TisAppLaunch.getAssebleTaskDir(), taskLogFileName);
        if (!logFile.exists()) {
            throw new IllegalStateException("logfile is not exist:" + logFile.getAbsolutePath());
        }
        CoreAction.getResponse().setContentType("text/xml");
        DownloadServlet.setDownloadName(CoreAction.getResponse(), taskLogFileName);
        FileUtils.copyFile((File)logFile, (OutputStream)CoreAction.getResponse().getOutputStream());
    }

    public void doGetIndexExist(Context context) throws Exception {
        HashMap biz = Maps.newHashMap();
        biz.put("indexExist", this.isIndexExist());
        biz.put("app", this.getAppDomain().getApp());
        this.setBizResult(context, biz);
    }

    public static ServerGroupAdapter getServerGroup0(final AppDomainInfo domain, BasicModule module) {
        List<ServerGroupAdapter> groupList = BasicScreen.createServerGroupAdapterList(new BasicScreen.ServerGroupCriteriaSetter(){

            @Override
            public void process(ServerGroupCriteria.Criteria criteria) {
                criteria.andAppIdEqualTo(domain.getAppid()).andRuntEnvironmentEqualTo(domain.getRunEnvironment().getId());
                criteria.andGroupIndexEqualTo(Short.valueOf((short)0));
                criteria.andPublishSnapshotIdIsNotNull();
            }

            @Override
            public List<Server> getServers(RunContext daoContext, ServerGroup group) {
                return Collections.emptyList();
            }

            @Override
            public int getMaxSnapshotId(ServerGroup group, RunContext daoContext) {
                SnapshotCriteria snapshotCriteria = new SnapshotCriteria();
                snapshotCriteria.createCriteria().andAppidEqualTo(group.getAppId());
                return daoContext.getSnapshotDAO().getMaxSnapshotId(snapshotCriteria);
            }
        }, true, module);
        Iterator<ServerGroupAdapter> iterator = groupList.iterator();
        if (iterator.hasNext()) {
            ServerGroupAdapter group = iterator.next();
            return group;
        }
        return null;
    }

    @Func(value="incr_process_config_edit")
    public void doIncrDelete(Context context) throws Exception {
        IndexStreamCodeGenerator indexStreamCodeGenerator = CoreAction.getIndexStreamCodeGenerator(this.getTISDataXName(), this);
        indexStreamCodeGenerator.deleteScript();
        try {
            TISK8sDelegate k8sDelegate = TISK8sDelegate.getK8SDelegate(this.getCollectionName());
            k8sDelegate.removeIncrProcess();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Func(value="incr_process_config_edit")
    public void doIncrStop(Context context) throws Exception {
        IndexStreamCodeGenerator indexStreamCodeGenerator = CoreAction.getIndexStreamCodeGenerator(this.getTISDataXName(), this);
        indexStreamCodeGenerator.deleteScript();
        TISK8sDelegate k8sDelegate = TISK8sDelegate.getK8SDelegate(this.getCollectionName());
        k8sDelegate.stopIncrProcess((IMessageHandler)this, context);
        if (this.hasErrors(context)) {
            return;
        }
        IDeploymentDetail detail = null;
        detail = this.waittingiIntendedStatus(IFlinkIncrJobStatus.State.STOPED);
        if (detail == null) {
            this.addErrorMessage(context, "\u64cd\u4f5c\u8d85\u65f6");
            return;
        }
        IndexIncrStatus incrStatus = CoreAction.getIndexIncrStatus((IControlMsgHandler)this, detail);
        this.setBizResult(context, incrStatus);
    }

    @Func(value="app_initialization")
    public void doCreateCoreSetp1(Context context) throws Exception {
        Integer groupNum = this.getInt("group");
        Integer repliation = this.getInt("replica");
        if (groupNum == null || groupNum < 1) {
            this.addErrorMessage(context, "\u7ec4\u6570\u4e0d\u80fd\u5c0f\u4e8e1");
            return;
        }
        if (repliation == null || repliation < 1) {
            this.addErrorMessage(context, "\u7ec4\u5185\u526f\u672c\u6570\u4e0d\u80fd\u5c0f\u4e8e1");
            return;
        }
        context.put(CREATE_CORE_SELECT_COREINFO, (Object)new CreateCorePageDTO(groupNum, repliation, "y".equals(this.getString("exclusive"))));
    }

    @Func(value="app_initialization")
    public void doCreateCore(Context context) throws Exception {
        Integer groupNum = this.getInt("group");
        Integer repliation = this.getInt("replica");
        if (groupNum == null || groupNum < 1) {
            this.addErrorMessage(context, "\u7ec4\u6570\u4e0d\u80fd\u5c0f\u4e8e1");
            return;
        }
        if (repliation == null || repliation < 1) {
            this.addErrorMessage(context, "\u7ec4\u5185\u526f\u672c\u6570\u4e0d\u80fd\u5c0f\u4e8e1");
            return;
        }
        FCoreRequest request = this.createCoreRequest(context, groupNum, repliation, "\u521b\u5efa", true);
        CoreAction.createCollection(this, context, groupNum, repliation, request, this.getServerGroup0().getPublishSnapshotId());
    }

    public static void deleteCollection(BasicModule module, Context context) throws Exception {
    }

    public static List<String> listCollection(BasicModule module, Context context) throws Exception {
        ArrayList collections = Lists.newArrayList();
        return collections;
    }

    public static boolean createCollection(BasicModule module, Context context, Integer groupNum, Integer repliationCount, FCoreRequest request, int publishSnapshotId) throws Exception {
        return true;
    }

    public static String getCloudOverseerNode(ITISCoordinator zkClient) {
        Map v = (Map)JSON.parseObject((byte[])zkClient.getData("/overseer_elect/leader", true), Map.class, (Feature[])new Feature[]{Feature.AllowUnQuotedFieldNames});
        String id = (String)v.get("id");
        if (id == null) {
            throw new IllegalStateException("collection cluster overseer node has not launch");
        }
        String[] arr = StringUtils.split((String)id, (String)"-");
        if (arr.length < 3) {
            throw new IllegalStateException("overseer ephemeral node id:" + id + " is illegal");
        }
        return StringUtils.substringBefore((String)arr[1], (String)"_");
    }

    private Map<String, SelectableServer.CoreNode> getCoreNodeMap(boolean isAppNameAware) {
        SelectableServer.CoreNode[] nodelist = SelectableServer.getCoreNodeInfo(this.getRequest(), this, false, isAppNameAware);
        HashMap<String, SelectableServer.CoreNode> result = new HashMap<String, SelectableServer.CoreNode>();
        for (SelectableServer.CoreNode node : nodelist) {
            result.put(node.getNodeName(), node);
        }
        return result;
    }

    private ParseIpResult parseIps(Context context, String serverSuffix, boolean isAppNameAware, boolean mustSelectMoreOneReplicAtLeast) {
        ParseIpResult result = new ParseIpResult();
        result.valid = false;
        ArrayList<String> parseips = new ArrayList<String>();
        String[] ips = this.getRequest().getParameterValues("selectedServer" + StringUtils.trimToEmpty((String)serverSuffix));
        if (ips == null) {
            return result;
        }
        if (mustSelectMoreOneReplicAtLeast && ips.length < 1) {
            this.addErrorMessage(context, "\u8bf7" + (String)(StringUtils.isNotEmpty((String)serverSuffix) ? "\u4e3a\u7b2c" + serverSuffix + "\u7ec4" : "") + "\u9009\u62e9\u670d\u52a1\u5668");
            return result;
        }
        result.ipLiteria.append("[");
        Matcher matcher = null;
        Map<String, SelectableServer.CoreNode> serverdetailMap = this.getCoreNodeMap(isAppNameAware);
        SelectableServer.CoreNode nodeinfo = null;
        SelectableServer.CoreNode current = null;
        for (String ip : ips) {
            matcher = this.isValidIpPattern(ip);
            if (!matcher.matches()) {
                this.addErrorMessage(context, "IP:" + ip + "\u4e0d\u7b26\u5408\u683c\u5f0f\u89c4\u8303");
                return result;
            }
            current = serverdetailMap.get(ip);
            if (current == null) {
                this.addErrorMessage(context, "\u670d\u52a1\u5668" + ip + "\uff0c\u4e0d\u5728\u53ef\u9009\u96c6\u5408\u4e4b\u5185");
                return result;
            }
            if (nodeinfo != null && current.getLuceneSpecVersion() != nodeinfo.getLuceneSpecVersion()) {
                this.addErrorMessage(context, (String)(StringUtils.isNotEmpty((String)serverSuffix) ? "\u7b2c" + serverSuffix + "\u7ec4" : "") + "\u670d\u52a1\u5668Lucene\u7248\u672c\u4e0d\u4e00\u81f4");
                return result;
            }
            nodeinfo = current;
            parseips.add(matcher.group(0));
            result.ipLiteria.append(ip).append(",");
        }
        result.ipLiteria.append("]");
        result.ips = parseips.toArray(new String[parseips.size()]);
        result.valid = true;
        return result;
    }

    public static CoreRequest createIps(Context context, String appName, String[] ips) {
        CoreRequest request = new CoreRequest();
        request.setIncludeIps(ips);
        request.setServiceName(appName);
        request.runtime = RunEnvironment.getSysRuntime();
        log.debug("request.getRunEnv():" + request.getRunEnv());
        return request;
    }

    @Func(value="app_trigger_full_dump")
    public void doTriggerSynIndexFile(Context context) throws Exception {
        String userpoint = this.getString("userpoint");
        if (StringUtils.isBlank((String)userpoint)) {
            this.addErrorMessage(context, "\u8bf7\u586b\u5199userpoint\uff0c\u683c\u5f0f\uff1aadmin#yyyyMMddHHmmss");
            return;
        }
        boolean success = this.triggerBuild("indexBackflow", context, userpoint);
        if (success) {
            this.addActionMessage(context, "\u5df2\u7ecf\u89e6\u53d1\u4e86userpoint\u56de\u6d41" + StringUtils.defaultIfEmpty((String)userpoint, (String)"-1"));
        }
    }

    private boolean triggerBuild(final String startPhrase, Context context, String userpoint) throws Exception {
        String ps = null;
        String user = null;
        if (StringUtils.indexOf((String)userpoint, (String)"#") > -1) {
            ps = StringUtils.substringAfter((String)userpoint, (String)"#");
            user = StringUtils.substringBefore((String)userpoint, (String)"#");
        } else {
            ps = userpoint;
        }
        final String pps = ps;
        final String fuser = user;
        boolean success = CoreAction.sendRequest2FullIndexSwapeNode((BasicModule)this, (Context)context, (AppendParams)new AppendParams(){

            @Override
            List<HttpUtils.PostParam> getParam() {
                ArrayList params = Lists.newArrayList();
                params.add(new HttpUtils.PostParam("component.start", (Object)startPhrase));
                params.add(new HttpUtils.PostParam("component.start", (Object)pps));
                if (StringUtils.isNotBlank((String)fuser)) {
                    params.add(new HttpUtils.PostParam("user", (Object)fuser));
                }
                return params;
            }
        }).success;
        return success;
    }

    @Func(value="app_trigger_full_dump")
    public void doTriggerFullDumpFile(Context context) throws Exception {
        String userpoint = this.getString("userpoint");
        if (StringUtils.isBlank((String)userpoint)) {
            this.addErrorMessage(context, "\u8bf7\u586b\u5199userpoint\uff0c\u683c\u5f0f\uff1aadmin#yyyyMMddHHmmss");
            return;
        }
        boolean success = this.triggerBuild("indexBuild", context, userpoint);
        if (success) {
            this.addActionMessage(context, "\u5df2\u7ecf\u89e6\u53d1\u4e86triggerFullDumpFile,userpoint:" + StringUtils.defaultIfEmpty((String)userpoint, (String)"-1"));
        }
    }

    private Matcher isValidIpPattern(String server) {
        return PATTERN_IP.matcher(StringUtils.trimToEmpty((String)server));
    }

    private FCoreRequest createCoreRequest(Context context, Integer group, Integer replica, String setVerbs, boolean mustSelectMoreOneReplicAtLeast) {
        return this.createCoreRequest(context, 0, group, replica, setVerbs, mustSelectMoreOneReplicAtLeast);
    }

    private FCoreRequest createCoreRequest(Context context, int assignGroupCount, int group, int replica, String setVerbs, boolean mustSelectMoreOneReplicAtLeast) {
        return this.createCoreRequest(context, assignGroupCount, group, replica, setVerbs, false, mustSelectMoreOneReplicAtLeast);
    }

    private FCoreRequest createCoreRequest(Context context, int assignGroupCount, int group, int replica, String setVerbs, boolean isAppNameAware, boolean mustSelectMoreOneReplicAtLeast) {
        CoreRequest coreRequest = CoreAction.createIps(context, this.getCollectionName().getPipelineName(), null);
        FCoreRequest result = new FCoreRequest(coreRequest, assignGroupCount + group, assignGroupCount);
        boolean GROUP_SIZE = true;
        for (int i = 0; i < 1; ++i) {
            ParseIpResult parseResult = this.parseIps(context, String.valueOf(assignGroupCount + i), isAppNameAware, mustSelectMoreOneReplicAtLeast);
            if (!parseResult.valid || parseResult.ips.length <= 0) continue;
            if (parseResult.ips.length * 16 < group * replica) {
                this.addErrorMessage(context, "\u60a8\u9009\u62e9\u7684\u673a\u5668\u8282\u70b9\u4e0d\u8db3,\u81f3\u5c11\u8981" + group * replica / 16 + "\u53f0\u673a\u5668");
                continue;
            }
            for (int j = 0; j < parseResult.ips.length; ++j) {
                result.addNodeIps(assignGroupCount + i, parseResult.ips[j]);
            }
            this.addActionMessage(context, "\u9009\u62e9\u7684\u673a\u5668\u4e3a:" + parseResult.ipLiteria);
            result.setValid(true);
        }
        if (!result.isValid()) {
            this.addErrorMessage(context, "\u8bf7\u81f3\u5c11\u4e3a\u4efb\u4f55\u4e00\u7ec4\u6dfb\u52a0\u4e00\u4e2a\u4ee5\u4e0a\u526f\u672c\u8282\u70b9");
        }
        return result;
    }

    private static abstract class AppendParams {
        private AppendParams() {
        }

        abstract List<HttpUtils.PostParam> getParam();
    }

    public static class CoreRequest {
        private String[] ips;
        private String serviceName;
        private RunEnvironment runtime;

        public void addNodeIps(String groupIndex, String ip) {
        }

        public void setIncludeIps(String[] ips) {
            this.ips = ips;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public RunEnvironment getRunEnv() {
            return this.runtime;
        }
    }

    private static class ParseIpResult {
        private boolean valid;
        private String[] ips;
        private final StringBuffer ipLiteria = new StringBuffer();

        private ParseIpResult() {
        }
    }

    public static class CreateCorePageDTO {
        private final int groupNum;
        private final int replication;
        private final int assignGroupCount;
        private final boolean excludeHaveAppServer;

        public CreateCorePageDTO(int groupNum, int replication, boolean excludeHaveAppServers) {
            this(0, groupNum, replication, excludeHaveAppServers);
        }

        public CreateCorePageDTO(int assignGroupCount, int groupNum, int replication, boolean excludeHaveAppServers) {
            this.groupNum = groupNum;
            this.replication = replication;
            this.assignGroupCount = assignGroupCount;
            this.excludeHaveAppServer = excludeHaveAppServers;
        }

        public int getAssignGroupCount() {
            return this.assignGroupCount;
        }

        public int getGroupNum() {
            return this.groupNum;
        }

        public int getReplication() {
            return this.replication;
        }

        public boolean isExcludeHaveAppServers() {
            return this.excludeHaveAppServer;
        }

        public int[] getGroupArray() {
            int[] result = new int[this.groupNum];
            for (int i = 0; i < this.groupNum; ++i) {
                result[i] = this.assignGroupCount + i;
            }
            return result;
        }
    }
}

