/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.coredefine.module.action;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.aiagent.core.AgentContext;
import com.qlangtech.tis.aiagent.core.PluginPropsComplement;
import com.qlangtech.tis.aiagent.core.RequestKey;
import com.qlangtech.tis.aiagent.core.SelectionOptions;
import com.qlangtech.tis.aiagent.core.TISPlanAndExecuteAgent;
import com.qlangtech.tis.aiagent.llm.LLMProvider;
import com.qlangtech.tis.aiagent.sessiondata.ColsMetaSetterSessionData;
import com.qlangtech.tis.aiagent.sessiondata.TableSelectApplySessionData;
import com.qlangtech.tis.aiagent.template.TaskTemplateRegistry;
import com.qlangtech.tis.coredefine.module.action.PluginAction;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.TableAliasMapper;
import com.qlangtech.tis.datax.impl.DataxProcessor;
import com.qlangtech.tis.datax.job.SSEEventWriter;
import com.qlangtech.tis.datax.job.SSERunnable;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.util.PluginExtraProps;
import com.qlangtech.tis.lang.PayloadLink;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.manage.common.UserProfile;
import com.qlangtech.tis.manage.spring.aop.Func;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import com.qlangtech.tis.util.AttrValMap;
import com.qlangtech.tis.util.IPluginContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.servlet.AsyncContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatPipelineAction
extends BasicModule {
    private static final Logger logger = LoggerFactory.getLogger(ChatPipelineAction.class);
    private static final String KEY_SESSION_ID = "sessionId";
    private static final ConcurrentHashMap<String, ChatSession> sessions = new ConcurrentHashMap();
    private static final ExecutorService executorService = Executors.newCachedThreadPool();

    @Func(value="ai_agent", sideEffect=false)
    public void doGetPageInitialize(Context context) throws Exception {
        JSONObject response = new JSONObject();
        TaskTemplateRegistry registry = new TaskTemplateRegistry();
        JSONArray templates = new JSONArray();
        for (TaskTemplateRegistry.TaskTemplate template : registry.getAllTemplates()) {
            JSONObject templateJson = new JSONObject();
            templateJson.put("id", (Object)template.getId());
            templateJson.put("name", (Object)template.getName());
            templateJson.put("description", (Object)template.getDescription());
            templateJson.put("sampleText", (Object)template.getSampleText());
            templates.add((Object)templateJson);
        }
        response.put("templates", (Object)templates);
        response.put("session", (Object)this.createSession());
        response.put("hetero", (Object)PluginAction.getDescrible(this).toJSON());
        response.put("applyUserInputMaxWaitMillis", (Object)300000L);
        this.setBizResult(context, response);
    }

    @Func(value="ai_agent", sideEffect=false)
    public void doCreateSession(Context context) {
        JSONObject result = this.createSession();
        this.setBizResult(context, result);
    }

    private JSONObject createSession() {
        String sessionId = UUID.randomUUID().toString();
        ChatSession session = new ChatSession(sessionId);
        sessions.put(sessionId, session);
        JSONObject result = new JSONObject();
        result.put(KEY_SESSION_ID, (Object)sessionId);
        result.put("createTime", (Object)System.currentTimeMillis());
        return result;
    }

    @Func(value="ai_agent", sideEffect=false)
    public void doGetSessionHistory(Context context) {
        String sessionId = this.getString(KEY_SESSION_ID);
        if (StringUtils.isEmpty((String)sessionId)) {
            throw new IllegalStateException("sessionId can not be empty");
        }
        ChatSession session = sessions.get(sessionId);
        if (session == null) {
            throw new IllegalStateException("session can not be found for sessionId: " + sessionId);
        }
        JSONArray history = new JSONArray();
        for (ChatMessage message : session.getMessages()) {
            JSONObject msg = new JSONObject();
            msg.put("role", (Object)message.getRole());
            msg.put("content", (Object)message.getContent());
            msg.put("timestamp", (Object)message.getTimestamp());
            history.add((Object)msg);
        }
        this.setBizResult(context, history);
    }

    @Func(value="ai_agent", sideEffect=false)
    public void doCancelCurrentTask(Context context) {
        JSONObject jsonContent = this.getJSONPostContent();
        String sessionId = jsonContent.getString(KEY_SESSION_ID);
        if (StringUtils.isEmpty((String)sessionId)) {
            throw new IllegalStateException("sessionId can not be empty");
        }
        ChatSession session = sessions.get(sessionId);
        if (session == null) {
            throw new IllegalStateException("session can not be found for sessionId: " + sessionId);
        }
        AgentContext agentContext = session.getAgentContext();
        if (agentContext == null) {
            this.addErrorMessage(context, "\u5f53\u524d\u4f1a\u8bdd\u6ca1\u6709\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1");
            return;
        }
        agentContext.cancel();
        logger.info("User {} cancelled task for session: {}", (Object)this.getUser().getName(), (Object)sessionId);
    }

    @Func(value="ai_agent", sideEffect=false)
    public void doChangeLlm(Context context) {
        String llm = this.getString("llm");
        if (StringUtils.isEmpty((String)llm)) {
            throw new IllegalArgumentException("param llm can not be empty");
        }
        UserProfile profile = UserProfile.load((IPluginContext)this, (boolean)false);
        if (profile == null) {
            profile = new UserProfile();
            profile.name = this.getUser().getName();
        }
        if (StringUtils.equals((String)llm, (String)profile.llm)) {
            return;
        }
        profile.llm = llm;
        UserProfile.update((IPluginContext)this, (UserProfile)profile);
        this.addActionMessage(context, "\u6210\u529f\u5207\u6362\u6a21\u578b\u4e3a\uff1a" + llm);
    }

    @Func(value="ai_agent", sideEffect=false)
    public void doChat(Context context) throws IOException {
        String sessionId = this.getString(KEY_SESSION_ID);
        String userInput = this.getString("input");
        if (sessionId == null || sessionId.isEmpty()) {
            sessionId = UUID.randomUUID().toString();
        }
        ChatSession session = sessions.computeIfAbsent(sessionId, ChatSession::new);
        session.addMessage("user", userInput);
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout(600000L);
        SSEEventWriter sseWriter = this.getEventStreamWriter();
        JSONObject sessionInfo = new JSONObject();
        sessionInfo.put(KEY_SESSION_ID, (Object)sessionId);
        sseWriter.writeSSEEvent(SSERunnable.SSEEventType.AI_AGNET_SESSION, sessionInfo.toJSONString());
        AgentContext agentContext = new AgentContext(sessionId, sseWriter);
        session.setAgentContext(agentContext);
        UserProfile userProfile = Objects.requireNonNull(UserProfile.load((IPluginContext)this, (boolean)true));
        LLMProvider llmProvider = userProfile.getLlmProvider();
        String finalSessionId = sessionId;
        executorService.execute(() -> {
            try {
                ServletActionContext.getActionContext((HttpServletRequest)request);
                TISPlanAndExecuteAgent agent = new TISPlanAndExecuteAgent(agentContext, llmProvider, this);
                agent.execute(userInput);
                session.addMessage("assistant", "\u4efb\u52a1\u6267\u884c\u5b8c\u6210");
            }
            catch (Exception e) {
                logger.error("Agent execution failed", (Throwable)e);
                TisException.ErrMsg errMsg = TisException.getErrMsg((Throwable)e);
                session.getAgentContext().sendError(errMsg.getMessage(), new PayloadLink[0]);
            }
            finally {
                try {
                    sseWriter.writeSSEEvent(SSERunnable.SSEEventType.AI_AGNET_DONE, "{\"finished\":true}");
                }
                finally {
                    session.setAgentContext(null);
                    asyncContext.complete();
                }
            }
        });
    }

    @Func(value="ai_agent", sideEffect=false)
    public void doUserResponse(Context context) {
        String sessionId = this.getString(KEY_SESSION_ID);
        String fieldId = this.getString("fieldId");
        String userResponse = this.getString("response");
        if (StringUtils.isEmpty((String)sessionId)) {
            throw new IllegalStateException("sessionId can not be empty");
        }
        if (StringUtils.isEmpty((String)fieldId)) {
            throw new IllegalStateException("fieldId can not be empty");
        }
        ChatSession session = sessions.get(sessionId);
        if (session == null) {
            throw new IllegalStateException("session can not be found for sessionId: " + sessionId);
        }
        session.addUserResponse(fieldId, userResponse);
        JSONObject result = new JSONObject();
        result.put("success", (Object)true);
        this.setBizResult(context, result);
    }

    @Func(value="ai_agent", sideEffect=false)
    public void doCheckTdfsColsMetaSetterDialog(Context context) {
        ColsMetaSetterSessionData colsMetaSetter;
        JSONObject jsonContent = this.getJSONPostContent();
        RequestKey requestId = RequestKey.create(jsonContent.getString("requestId"));
        ChatSession session = this.getChatSession(jsonContent);
        AgentContext agentContext = Objects.requireNonNull(session.getAgentContext(), "agentContext can not be null");
        IDataxProcessor processor = DataxProcessor.load((IPluginContext)this, (String)(colsMetaSetter = (ColsMetaSetterSessionData)agentContext.getSessionData(requestId)).getPipeline().identityValue());
        TableAliasMapper tabAlias = processor.getTabAlias((IPluginContext)this, false);
        colsMetaSetter.setHasValidSet(tabAlias != TableAliasMapper.Null);
        agentContext.notifyUserSelectionSubmitted(requestId);
        this.setBizResult(context, colsMetaSetter.isHasValidSet());
    }

    @Func(value="ai_agent", sideEffect=false)
    public void doConfirmTableSelection(Context context) {
        JSONObject jsonContent = this.getJSONPostContent();
        RequestKey requestId = RequestKey.create(jsonContent.getString("requestId"));
        ChatSession session = this.getChatSession(jsonContent);
        AgentContext agentContext = Objects.requireNonNull(session.getAgentContext(), "agentContext can not be null");
        TableSelectApplySessionData tableSelectionSessionData = (TableSelectApplySessionData)agentContext.getSessionData(requestId);
        JSONArray selectedTab = jsonContent.getJSONArray("selectedTabs");
        tableSelectionSessionData.setTableSelectConfirm(!selectedTab.isEmpty());
        if (!tableSelectionSessionData.isTableSelectConfirm()) {
            this.addErrorMessage(context, "\u8bf7\u9009\u62e9\u76ee\u6807\u8868");
            return;
        }
        tableSelectionSessionData.setTableSelected(selectedTab.stream().map(String::valueOf).collect(Collectors.toList()));
        agentContext.notifyUserSelectionSubmitted(requestId);
        this.setBizResult(context, tableSelectionSessionData.isTableSelectConfirm());
    }

    @Func(value="ai_agent", sideEffect=false)
    public void doCheckInstallOption(Context context) {
        JSONObject jsonContent = this.getJSONPostContent();
        RequestKey requestId = RequestKey.create(jsonContent.getString("requestId"));
        ChatSession session = this.getChatSession(jsonContent);
        AgentContext agentContext = Objects.requireNonNull(session.getAgentContext(), "sessionId:" + session.getSessionId() + " relevant agentContext can not be null");
        SelectionOptions selectionOptions = (SelectionOptions)agentContext.getSessionData(requestId);
        List<PluginExtraProps.CandidatePlugin> cplugins = selectionOptions.getCandidatePlugins();
        for (PluginExtraProps.CandidatePlugin candidatePlugin : cplugins) {
            candidatePlugin.getInstalledPluginDescriptor(true);
        }
        this.setBizResult(context, PluginExtraProps.CandidatePlugin.convertOptionsArray(Optional.empty(), cplugins));
    }

    private ChatSession getChatSession(JSONObject post) {
        String sessionId = post.getString(KEY_SESSION_ID);
        if (sessionId == null) {
            throw new IllegalStateException("sessionId == null");
        }
        ChatSession session = sessions.get(sessionId);
        if (session == null) {
            throw new IllegalStateException("sessionId:" + sessionId + " relevant session instance can not be null");
        }
        return session;
    }

    public void doSubmitPluginPropsComplement(Context context) {
        JSONObject jsonContent = this.getJSONPostContent();
        ChatSession session = this.getChatSession(jsonContent);
        RequestKey requestId = RequestKey.create(jsonContent.getString("requestId"));
        AgentContext agentContext = Objects.requireNonNull(session.getAgentContext(), "agentContext can not be null,sessionId:" + session.getSessionId());
        PluginPropsComplement complement = (PluginPropsComplement)agentContext.getSessionData(requestId);
        Pair<Describable, AttrValMap> postItems = PluginAction.getPostItems(this.getRequest());
        complement.setPluginValMap(postItems);
        agentContext.notifyUserSelectionSubmitted(requestId);
        this.setBizResult(context, requestId);
    }

    @Func(value="ai_agent", sideEffect=false)
    public void doSubmitSelection(Context context) {
        JSONObject jsonContent = this.getJSONPostContent();
        String sessionId = jsonContent.getString(KEY_SESSION_ID);
        RequestKey requestId = RequestKey.create(jsonContent.getString("requestId"));
        Integer selectedIndex = jsonContent.getInteger("selectedIndex");
        if (sessionId == null || requestId == null || selectedIndex == null) {
            throw new IllegalStateException("sessionId == null || requestId == null || selectedIndex == null");
        }
        ChatSession session = this.getChatSession(jsonContent);
        AgentContext agentContext = Objects.requireNonNull(session.getAgentContext(), "agentContext can not be null,sessionId:" + sessionId);
        SelectionOptions selectionOptions = (SelectionOptions)agentContext.getSessionData(requestId);
        agentContext.setSessionData(requestId, selectionOptions.setSelectedIndex(selectedIndex));
        agentContext.notifyUserSelectionSubmitted(requestId);
        logger.info("User selection submitted for session={}, requestId={}, selectedIndex={}", new Object[]{sessionId, requestId, selectedIndex});
        JSONObject result = new JSONObject();
        result.put("success", (Object)true);
        this.setBizResult(context, result);
    }

    @Func(value="ai_agent", sideEffect=false)
    public void doClearSession(Context context) {
        String sessionId = this.getString(KEY_SESSION_ID);
        sessions.remove(sessionId);
        JSONObject result = new JSONObject();
        result.put("success", (Object)true);
        this.setBizResult(context, result);
    }

    private static class ChatMessage {
        private final String role;
        private final String content;
        private final long timestamp;

        public ChatMessage(String role, String content) {
            this.role = role;
            this.content = content;
            this.timestamp = System.currentTimeMillis();
        }

        public String getRole() {
            return this.role;
        }

        public String getContent() {
            return this.content;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    private static class ChatSession {
        private final String sessionId;
        private final List<ChatMessage> messages;
        private final Map<String, String> userResponses;
        private final long createTime;
        private AgentContext agentContext;

        public ChatSession(String sessionId) {
            this.sessionId = sessionId;
            this.messages = new ArrayList<ChatMessage>();
            this.userResponses = new ConcurrentHashMap<String, String>();
            this.createTime = System.currentTimeMillis();
        }

        public void addMessage(String role, String content) {
            this.messages.add(new ChatMessage(role, content));
        }

        public void addUserResponse(String fieldId, String response) {
            this.userResponses.put(fieldId, response);
        }

        public String getUserResponse(String fieldId) {
            return this.userResponses.get(fieldId);
        }

        public List<ChatMessage> getMessages() {
            return this.messages;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public AgentContext getAgentContext() {
            return this.agentContext;
        }

        public void setAgentContext(AgentContext agentContext) {
            this.agentContext = agentContext;
        }
    }
}

