/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.coredefine.biz;

import com.qlangtech.tis.coredefine.module.action.CoreAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FCoreRequest {
    protected final CoreAction.CoreRequest request;
    private boolean valid = false;
    protected final List<String> ips = new ArrayList<String>(0);
    private final int assigndGroup;
    private final short[] replicCount;
    private final Map<Integer, Collection<String>> serversView = new HashMap<Integer, Collection<String>>();

    public FCoreRequest(CoreAction.CoreRequest request, int groupCount) {
        this(request, groupCount, 0);
    }

    public FCoreRequest(CoreAction.CoreRequest request, int groupCount, int assigndGroup) {
        this.request = request;
        if (groupCount < 1) {
            throw new IllegalArgumentException("groupCount can not be null");
        }
        this.replicCount = new short[groupCount];
        this.assigndGroup = assigndGroup;
    }

    public String getCreateNodeSet() {
        return this.ips.stream().collect(Collectors.joining(","));
    }

    public String getIndexName() {
        return this.request.getServiceName();
    }

    public void addNodeIps(int group, String ip) {
        this.ips.add(ip);
        this.request.addNodeIps(String.valueOf(group), ip);
        int n = group;
        this.replicCount[n] = (short)(this.replicCount[n] + 1);
        Collection<String> servers = this.serversView.get(group);
        if (servers == null) {
            servers = new ArrayList<String>();
            this.serversView.put(group, servers);
        }
        servers.add(ip);
    }

    public Map<Integer, Collection<String>> getServersView() {
        return this.serversView;
    }

    public short[] getReplicCount() {
        return Arrays.copyOfRange(this.replicCount, this.assigndGroup, this.replicCount.length);
    }

    public String[] getIps() {
        return this.ips.toArray(new String[this.ips.size()]);
    }

    public List<String> getAllIps() {
        return this.ips;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public CoreAction.CoreRequest getRequest() {
        return this.request;
    }
}

