/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.config.module.screen;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.ConfigFileContext;
import com.qlangtech.tis.manage.common.DefaultFilter;
import com.qlangtech.tis.manage.spring.aop.Func;
import com.qlangtech.tis.runtime.module.action.HdfsAction;
import com.qlangtech.tis.runtime.module.screen.BasicScreen;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamScriptRepo
extends BasicScreen {
    private static final Logger logger = LoggerFactory.getLogger(StreamScriptRepo.class);

    @Override
    @Func(value="plugin_get_config", sideEffect=false)
    public void execute(Context context) throws Exception {
        File rootDir = Config.getDataDir();
        String path = this.getString("path");
        if (StringUtils.isEmpty((String)path)) {
            throw new IllegalArgumentException("illegal argument 'path'");
        }
        HttpServletResponse response = (HttpServletResponse)DefaultFilter.getRespone();
        File targetFile = new File(rootDir, path);
        if (!targetFile.exists()) {
            response.addHeader("notexist", String.valueOf(Boolean.TRUE));
            return;
        }
        boolean getMeta = Boolean.parseBoolean(this.getRequest().getHeader(ConfigFileContext.StreamProcess.HEADER_KEY_GET_FILE_META));
        logger.info("path:{},getChildren:{},local file exist:{},getMeta:{}", new Object[]{path, !targetFile.isFile(), targetFile.exists(), getMeta});
        if (targetFile.isFile()) {
            response = HdfsAction.getDownloadResponse(targetFile, !getMeta);
            if (!getMeta) {
                try (FileInputStream input = FileUtils.openInputStream((File)targetFile);){
                    IOUtils.copyLarge((InputStream)input, (OutputStream)response.getOutputStream());
                }
            }
        } else {
            response.addHeader("download", String.valueOf(false));
            ArrayList<CallSite> subs = new ArrayList<CallSite>();
            File sub = null;
            String[] stringArray = targetFile.list((d, fn) -> !StringUtils.endsWith((String)fn, (String)".lastmodified"));
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String d2;
                sub = new File(targetFile, d2 = stringArray[i]);
                subs.add((CallSite)((Object)(d2 + ":" + (sub.isDirectory() ? "d" : "f"))));
            }
            response.addHeader("dirlist", subs.stream().collect(Collectors.joining(",")));
            IOUtils.write((byte[])com.qlangtech.tis.extension.impl.IOUtils.writeZip((File)targetFile), (OutputStream)response.getOutputStream());
        }
    }

    @Override
    protected String getReturnCode() {
        return "none";
    }
}

