/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.config.module.action;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.assemble.ExecResult;
import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.assemble.TriggerType;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.exec.ExecutePhaseRange;
import com.qlangtech.tis.exec.IExecChainContext;
import com.qlangtech.tis.exec.impl.DataXPipelineExecContext;
import com.qlangtech.tis.exec.impl.WorkflowExecContext;
import com.qlangtech.tis.manage.common.CreateNewTaskResult;
import com.qlangtech.tis.manage.spring.aop.Func;
import com.qlangtech.tis.plugin.rate.IncrRateController;
import com.qlangtech.tis.realtime.yarn.rpc.IncrRateControllerCfgDTO;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import com.qlangtech.tis.workflow.pojo.WorkFlowBuildHistory;
import com.qlangtech.tis.workflow.pojo.WorkFlowBuildHistoryCriteria;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullbuildWorkflowAction
extends BasicModule {
    private static final Logger logger = LoggerFactory.getLogger(FullbuildWorkflowAction.class);
    private static final String TIS_WORK_FLOW_CHANNEL = "tisWorkflowChannel";
    private static final long serialVersionUID = 1L;
    private static final long VALID_TIME = 14400000L;
    public static int MAX_CAS_RETRY_COUNT = 5;

    public void doInitializeTriggerTask(Context context) {
        this.getLong("powerJobWorkflowInstanceId");
        BasicModule.Rundata rundata = this.getRundata();
        if (this.getBoolean(TIS_WORK_FLOW_CHANNEL)) {
            rundata.forwardTo("offline", "offline_datasource_action", "execute_workflow");
        } else {
            rundata.forwardTo("coredefine", "datax_action", "trigger_fullbuild_task");
        }
    }

    public void doGetRateController(Context context) {
        DataXName dataXPipeline = DataXName.createDataXPipeline((String)this.getString("pipeline"));
        Long lastModified = this.getLong("lastModified");
        IncrRateController rateController = IncrRateController.getRateController((DataXName)dataXPipeline);
        if (rateController == null) {
            return;
        }
        if (lastModified != null && lastModified >= Objects.requireNonNull(rateController.lastModified, "lastModified can not be null")) {
            return;
        }
        IncrRateControllerCfgDTO controllerCfgDTO = rateController.createIncrRateControllerCfgDTO();
        this.setBizResult(context, controllerCfgDTO);
    }

    @Func(value="dataflow_manage", sideEffect=false)
    public void doCreateNewTask(Context context) {
        TriggerType triggerType = TriggerType.parse((int)this.getInt("triggertype"));
        Object app = null;
        String appname = this.getString("appname");
        Integer workflowId = this.getInt("workflow_id", null, false);
        DataXPipelineExecContext execContext = null;
        if (StringUtils.isEmpty((String)appname)) {
            if (workflowId == null) {
                throw new IllegalStateException("workflowId can not be null");
            }
            execContext = new WorkflowExecContext(workflowId, 0L);
        } else {
            execContext = new DataXPipelineExecContext(appname, Long.valueOf(0L));
        }
        execContext.setExecutePhaseRange(new ExecutePhaseRange(FullbuildPhase.parse((int)this.getInt("component.start", FullbuildPhase.FullDump.getValue())), FullbuildPhase.parse((int)this.getInt("component.end", FullbuildPhase.IndexBackFlow.getValue()))));
        CreateNewTaskResult newTaskResult = this.createNewDataXTask((IExecChainContext)execContext, triggerType);
        this.setBizResult(context, newTaskResult);
    }

    @Func(value="dataflow_manage", sideEffect=false)
    public void doGetWf(Context context) {
        Integer taskId = this.getInt("taskid");
        this.setBizResult(context, this.getWorkflowDAOFacade().getWorkFlowBuildHistoryDAO().loadFromWriteDB(taskId));
    }

    @Func(value="dataflow_manage", sideEffect=false)
    public void doTaskComplete(Context context) {
        Integer taskid = this.getInt("taskid");
        ExecResult execResult = ExecResult.parse((int)this.getInt("execresult"));
        String[] asynJobsName = this.getStringArray("asynJobName");
        this.updateWfHistory(taskid, execResult, asynJobsName, 0);
    }

    @Func(value="dataflow_manage", sideEffect=false)
    public void doFeedbackAsynTaskStatus(Context context) {
        Integer taskid = this.getInt("taskid");
        String jobName = this.getString("asynJobName");
        boolean execSuccess = this.getBoolean("success");
        this.updateAsynTaskState(taskid, jobName, execSuccess, 0);
        this.setBizResult(context, new CreateNewTaskResult(taskid.intValue(), null));
    }

    private void updateAsynTaskState(Integer taskid, String jobName, boolean execSuccess, int tryCount) {
        this.validateMaxCasRetryCount(taskid, tryCount);
        WorkFlowBuildHistory history = this.getBuildHistory(taskid);
        if (ExecResult.ASYN_DOING != ExecResult.parse((int)history.getState().byteValue())) {
            this.updateAsynTaskState(taskid, jobName, execSuccess, ++tryCount);
            return;
        }
        JSONObject status = JSON.parseObject((String)history.getAsynSubTaskStatus());
        JSONObject tskStat = status.getJSONObject(jobName);
        if (tskStat == null) {
            throw new IllegalStateException("jobName:" + jobName + " relevant status is not in history,now exist keys:" + status.keySet().stream().collect(Collectors.joining(",")));
        }
        tskStat.put("complete", (Object)true);
        tskStat.put("success", (Object)execSuccess);
        status.put(jobName, (Object)tskStat);
        boolean[] allComplete = new boolean[]{true};
        boolean[] faild = new boolean[]{false};
        status.forEach((key, val) -> {
            JSONObject s = (JSONObject)val;
            if (s.getBoolean("complete").booleanValue()) {
                if (!s.getBoolean("success").booleanValue()) {
                    faild[0] = true;
                }
            } else {
                allComplete[0] = false;
            }
        });
        WorkFlowBuildHistory updateHistory = new WorkFlowBuildHistory();
        updateHistory.setAsynSubTaskStatus(status.toJSONString());
        updateHistory.setLastVer(Integer.valueOf(history.getLastVer() + 1));
        ExecResult execResult = null;
        if (faild[0]) {
            execResult = ExecResult.FAILD;
        } else if (allComplete[0]) {
            execResult = ExecResult.SUCCESS;
        }
        if (execResult != null) {
            updateHistory.setState(Byte.valueOf((byte)execResult.getValue()));
            updateHistory.setEndTime(new Date());
        }
        WorkFlowBuildHistoryCriteria hq = new WorkFlowBuildHistoryCriteria();
        hq.createCriteria().andIdEqualTo(taskid).andLastVerEqualTo(history.getLastVer());
        if (this.getHistoryDAO().updateByExampleSelective(updateHistory, hq) < 1) {
            this.updateAsynTaskState(taskid, jobName, execSuccess, ++tryCount);
        }
    }

    private void validateMaxCasRetryCount(Integer taskid, int tryCount) {
        try {
            if (tryCount > 0) {
                Thread.sleep(200L);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (tryCount > MAX_CAS_RETRY_COUNT) {
            throw new IllegalStateException("taskId:" + taskid + " exceed max try count " + MAX_CAS_RETRY_COUNT);
        }
    }

    private void updateWfHistory(Integer taskid, ExecResult execResult, String[] asynJobsName, int tryCount) {
        this.validateMaxCasRetryCount(taskid, tryCount);
        WorkFlowBuildHistory history = this.getBuildHistory(taskid);
        WorkFlowBuildHistoryCriteria hq = new WorkFlowBuildHistoryCriteria();
        WorkFlowBuildHistoryCriteria.Criteria criteria = hq.createCriteria().andIdEqualTo(taskid);
        criteria.andLastVerEqualTo(history.getLastVer());
        WorkFlowBuildHistory upHistory = new WorkFlowBuildHistory();
        upHistory.setLastVer(Integer.valueOf(history.getLastVer() + 1));
        JSONObject jobState = null;
        if (asynJobsName != null && asynJobsName.length > 0) {
            JSONObject asynSubTaskStatus = new JSONObject();
            for (String jobName : asynJobsName) {
                jobState = new JSONObject();
                jobState.put("complete", (Object)false);
                jobState.put("success", (Object)false);
                asynSubTaskStatus.put(jobName, (Object)jobState);
            }
            upHistory.setState(Byte.valueOf((byte)ExecResult.ASYN_DOING.getValue()));
            upHistory.setAsynSubTaskStatus(asynSubTaskStatus.toJSONString());
        } else {
            upHistory.setState(Byte.valueOf((byte)execResult.getValue()));
            upHistory.setEndTime(new Date());
        }
        if (this.getHistoryDAO().updateByExampleSelective(upHistory, hq) < 1) {
            this.updateWfHistory(taskid, execResult, asynJobsName, ++tryCount);
        }
    }

    private WorkFlowBuildHistory getBuildHistory(Integer taskid) {
        WorkFlowBuildHistory history = this.getHistoryDAO().loadFromWriteDB(taskid);
        if (history == null) {
            throw new IllegalStateException("taskid:" + taskid + " relevant WorkFlowBuildHistory obj can not be null");
        }
        return history;
    }

    public static class ValidTableDump {
        boolean hasValidTableDump;
        String pt = "";

        public boolean isHasValidTableDump() {
            return this.hasValidTableDump;
        }

        public void setHasValidTableDump(boolean hasValidTableDump) {
            this.hasValidTableDump = hasValidTableDump;
        }

        public String getPt() {
            return this.pt;
        }

        public void setPt(String pt) {
            this.pt = pt;
        }
    }
}

