/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.config.module.action;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.config.k8s.ReplicasSpec;
import com.qlangtech.tis.config.module.action.SubCriteria;
import com.qlangtech.tis.coredefine.module.action.CoreAction;
import com.qlangtech.tis.coredefine.module.action.IndexIncrStatus;
import com.qlangtech.tis.coredefine.module.action.PluginItemsParser;
import com.qlangtech.tis.coredefine.module.action.Specification;
import com.qlangtech.tis.coredefine.module.action.TISK8sDelegate;
import com.qlangtech.tis.coredefine.module.control.SelectableServer;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.DescriptorExtensionList;
import com.qlangtech.tis.manage.biz.dal.dao.impl.SnapshotViewImplDAO;
import com.qlangtech.tis.manage.biz.dal.pojo.Application;
import com.qlangtech.tis.manage.common.AppDomainInfo;
import com.qlangtech.tis.manage.common.ILoginUser;
import com.qlangtech.tis.offline.module.manager.impl.OfflineManager;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.ds.ColumnMetaData;
import com.qlangtech.tis.plugin.ds.DataSourceFactory;
import com.qlangtech.tis.plugin.ds.ReflectSchemaFieldType;
import com.qlangtech.tis.plugin.ds.TableNotFoundException;
import com.qlangtech.tis.plugin.incr.IncrStreamFactory;
import com.qlangtech.tis.pubhook.common.RunEnvironment;
import com.qlangtech.tis.rpc.grpc.log.stream.PExecuteState;
import com.qlangtech.tis.runtime.module.action.AddAppAction;
import com.qlangtech.tis.runtime.module.action.CreateIndexConfirmModel;
import com.qlangtech.tis.runtime.module.action.SchemaAction;
import com.qlangtech.tis.runtime.module.misc.FormVaildateType;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.runtime.module.misc.IFieldErrorHandler;
import com.qlangtech.tis.solrdao.ISchemaField;
import com.qlangtech.tis.solrdao.ISchemaPluginContext;
import com.qlangtech.tis.solrdao.SchemaResult;
import com.qlangtech.tis.solrdao.pojo.PSchemaField;
import com.qlangtech.tis.sql.parser.SqlTaskNodeMeta;
import com.qlangtech.tis.sql.parser.er.ERRules;
import com.qlangtech.tis.sql.parser.meta.DependencyNode;
import com.qlangtech.tis.sql.parser.meta.NodeType;
import com.qlangtech.tis.sql.parser.meta.Position;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.trigger.jst.ILogListener;
import com.qlangtech.tis.util.AttrValMap;
import com.qlangtech.tis.util.HeteroEnum;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.IUploadPluginMeta;
import com.qlangtech.tis.util.PluginItems;
import com.qlangtech.tis.util.UploadPluginMeta;
import com.qlangtech.tis.workflow.pojo.WorkFlow;
import com.qlangtech.tis.workflow.pojo.WorkFlowBuildHistoryCriteria;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class CollectionAction
extends AddAppAction {
    private static final String QUERY_PARSIING_DEF_TYPE = "defType";
    private static final Position DEFAULT_SINGLE_TABLE_POSITION;
    private static final Position DEFAULT_SINGLE_JOINER_POSITION;
    private static final Logger logger;
    private static final int SHARED_COUNT = 1;
    public static final String KEY_SHOW_LOG = "log";
    public static final String KEY_INDEX_NAME = "indexName";
    public static final String KEY_QUERY_SEARCH_FIELDS = "search_fields";
    public static final String KEY_QUERY_FIELDS = "fields";
    public static final String KEY_QUERY_LIMIT = "limit";
    public static final String KEY_QUERY_ORDER_BY = "orderBy";
    public static final String KEY_QUERY_ROWS_OFFSET = "rowsOffset";
    public static final String RESULT_KEY_ROWS_COUNT = "rowsCount";
    public static final String RESULT_KEY_ROWS = "rows";
    public static final String KEY_PK = "pk";
    public static final String KEY_SHARD_NAME = "name";
    public static final String KEY_CORE_URL = "coreUrl";
    public static final String KEY_IS_ACTIVE = "active";
    public static final String KEY_REPLICS = "replics";
    public static final String KEY_COLS_META = "colMetas";
    private IndexName indexName = null;
    private PlatformTransactionManager transactionManager;

    @Autowired
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void doGetIncrStatus(Context context) throws Exception {
        this.getIndexWithPost();
        this.setBizResult(context, CoreAction.getIndexIncrStatus((IControlMsgHandler)this, true));
    }

    public void doCreate(Context context) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataXName getCollectionName() {
        if (this.indexName == null) {
            throw new IllegalStateException("indexName can not be null");
        }
        return DataXName.createDataXPipeline((String)this.indexName.getCollectionName());
    }

    public void doFullbuild(Context context) throws Exception {
        this.getIndexWithPost();
        Application app = this.getApplicationDAO().selectByName(this.indexName.getCollectionName());
        WorkFlow wf = this.loadDF(app.getWorkFlowId());
        this.setBizResult(context, CoreAction.triggerFullIndexSwape(this, context, app, 1));
    }

    private JSONObject getIndexWithPost() {
        JSONObject post = this.parseJsonPost();
        if (StringUtils.isEmpty((String)post.getString(KEY_INDEX_NAME))) {
            throw new IllegalArgumentException("indexName can not be null");
        }
        this.indexName = new IndexName(post.getString(KEY_INDEX_NAME));
        return post;
    }

    public void doDeleteIndex(Context context) throws Exception {
        this.getIndexWithPost();
        Application app = this.getApplicationDAO().selectByName(this.indexName.getCollectionName());
        if (app == null) {
            throw new IllegalStateException("indexName:" + this.indexName.getCollectionName() + " relevant instance in db can not be empty");
        }
        this.rescycleAppDB(app.getAppId());
        WorkFlowBuildHistoryCriteria wfHistoryCriteria = new WorkFlowBuildHistoryCriteria();
        this.getWorkflowDAOFacade().getWorkFlowBuildHistoryDAO().deleteByExample(wfHistoryCriteria);
        this.deleteCollectionInCloud(context, app.getProjectName());
        IPluginStore<IncrStreamFactory> store = CoreAction.getIncrStreamFactoryStore(this);
        try {
            if (store.getPlugin() != null) {
                TISK8sDelegate k8sDelegate = TISK8sDelegate.getK8SDelegate(this.getCollectionName());
                k8sDelegate.removeIncrProcess();
            }
        }
        catch (Throwable e) {
            logger.warn("k8sDelegate illegal", e);
        }
    }

    private void deleteCollectionInCloud(Context context, String collectionName) {
    }

    private String createQuery(List<SubCriteria> andQueryCriteria) {
        return andQueryCriteria.stream().map(sc -> "(" + sc.ors.stream().map(or -> or.getName() + ":" + or.getValue()).collect(Collectors.joining(" OR ")) + ")").collect(Collectors.joining(" AND "));
    }

    @Override
    public AppDomainInfo getAppDomain() {
        Application application = this.getApplicationDAO().selectByName(this.getCollectionName().getPipelineName());
        if (application == null) {
            throw new IllegalStateException("indexName:" + this.indexName + " relevant app can not be null");
        }
        return new AppDomainInfo(0, application.getAppId(), RunEnvironment.getSysRuntime(), application);
    }

    private TargetColumnMeta getTargetColumnMeta(IControlMsgHandler pluginContext, Context context, JSONObject post, String targetTable, PluginItems dataSourceItems) throws TableNotFoundException {
        TargetColumnMeta columnMeta = new TargetColumnMeta(targetTable);
        Map<String, ColumnMetaData> colMetas = null;
        if (dataSourceItems.validate((IPluginContext)this, (Context)context, (int)0, (FormVaildateType)FormVaildateType.create((boolean)false)).faild) {
            return columnMeta.invalid();
        }
        Iterator<AttrValMap> iterator = dataSourceItems.items.iterator();
        if (iterator.hasNext()) {
            AttrValMap vals = iterator.next();
            DataSourceFactory dsFactory = (DataSourceFactory)vals.createDescribable(pluginContext, context).getInstance();
            List tableMetadata = null;
            tableMetadata = dsFactory.getTableMetadata(false, (IPluginContext)pluginContext, EntityName.parse((String)targetTable));
            colMetas = tableMetadata.stream().collect(Collectors.toMap(m -> m.getKey(), m -> m));
        }
        Objects.requireNonNull(colMetas, "colMetas can not null");
        Map<String, TargetCol> targetColMap = this.getTargetCols(post);
        columnMeta.targetColMap = targetColMap;
        ColumnMetaData colMeta = null;
        for (Map.Entry<String, TargetCol> tc : targetColMap.entrySet()) {
            colMeta = (ColumnMetaData)colMetas.get(tc.getKey());
            if (colMeta == null) {
                throw new IllegalStateException("target col:" + tc.getKey() + " is not exist in table:" + targetTable + " meta cols" + colMetas.values().stream().map(c -> c.getKey()).collect(Collectors.joining(",")));
            }
            columnMeta.targetColMetas.add(colMeta);
        }
        return columnMeta;
    }

    private Optional<Application> createCollection(Context context, WorkFlow df, String indexName, TargetColumnMeta targetColMetas) throws Exception {
        SelectableServer.CoreNode[] coreNodeInfo;
        Objects.requireNonNull(df, "param df can not be null");
        CreateIndexConfirmModel confirmModel = new CreateIndexConfirmModel();
        SelectableServer.ServerNodeTopology coreNode = new SelectableServer.ServerNodeTopology();
        for (SelectableServer.CoreNode n : coreNodeInfo = SelectableServer.getCoreNodeInfo(this.getRequest(), this, false, true)) {
            n.setHostName(n.getNodeName());
        }
        coreNode.setReplicaCount(1);
        coreNode.setShardCount(1);
        coreNode.setHosts(coreNodeInfo);
        confirmModel.setCoreNode(coreNode);
        confirmModel.setTplAppId(CollectionAction.getTemplateApp(this).getAppId());
        AddAppAction.ExtendApp extendApp = new AddAppAction.ExtendApp();
        extendApp.setDptId(2);
        extendApp.setName(indexName);
        extendApp.setRecept(this.getUser().getName());
        Objects.requireNonNull(df.getId(), "id of dataflow can not be null");
        extendApp.setWorkflow(df.getId() + ":" + df.getName());
        confirmModel.setAppform(extendApp);
        SchemaResult schemaResult = SchemaAction.mergeWfColsWithTplCollection(this, context, null, ISchemaPluginContext.NULL, (cols, schemaParseResult) -> {
            ColumnMetaData pkMeta = targetColMetas.getPKMeta();
            PSchemaField field = null;
            ColMetaTuple rft = null;
            TargetCol tcol = null;
            Map<String, ColMetaTuple> targetCols = targetColMetas.getTargetCols();
            for (ISchemaField f : schemaParseResult.getSchemaFields()) {
                field = (PSchemaField)f;
                rft = targetCols.get(f.getName());
                if (rft == null) {
                    throw new IllegalStateException("field:" + f.getName() + " relevant reflect 'SchemaFieldType' can not be null");
                }
                boolean isPk = false;
                if (StringUtils.equals((String)pkMeta.getKey(), (String)field.getName())) {
                    isPk = true;
                    field.setIndexed(true);
                    field.setType(schemaParseResult.getTisType(ReflectSchemaFieldType.STRING.literia));
                } else {
                    field.setType(schemaParseResult.getTisType(rft.getSchemaFieldType()));
                }
                if ((tcol = targetColMetas.targetColMap.get(field.getName())) == null) continue;
                if (tcol.isIndexable()) {
                    field.setIndexed(true);
                }
                if (!rft.colMeta.getSchemaFieldType().tokenizer) continue;
                if (StringUtils.isNotEmpty((String)tcol.getToken())) {
                    field.setTokenizerType(tcol.getToken());
                    continue;
                }
                if (isPk || !rft.isTypeOf(ReflectSchemaFieldType.STRING)) continue;
                field.setTokenizerType(ReflectSchemaFieldType.LIKE.literia);
            }
            schemaParseResult.setUniqueKey(pkMeta.getKey());
            schemaParseResult.setSharedKey(pkMeta.getKey());
        });
        return this.createCollection(context, confirmModel, schemaResult, (Context ctx, AddAppAction.ExtendApp app, int publishSnapshotId, byte[] schemaContent) -> this.createNewApp(ctx, app, publishSnapshotId, schemaContent));
    }

    private SqlTaskNodeMeta.SqlDataFlowTopology createTopology(String topologyName, OfflineManager.ProcessedTable dsTable, TargetColumnMeta targetColMetas) throws Exception {
        SqlTaskNodeMeta.SqlDataFlowTopology topology = new SqlTaskNodeMeta.SqlDataFlowTopology();
        SqlTaskNodeMeta.TopologyProfile profile = new SqlTaskNodeMeta.TopologyProfile();
        profile.setName(topologyName);
        profile.setTimestamp(System.currentTimeMillis());
        topology.setProfile(profile);
        DependencyNode dNode = this.createDumpNode(dsTable);
        topology.addDumpTab(dNode);
        SqlTaskNodeMeta joinNodeMeta = new SqlTaskNodeMeta();
        joinNodeMeta.setId(String.valueOf(UUID.randomUUID()));
        joinNodeMeta.addDependency(dNode);
        joinNodeMeta.setExportName(topologyName);
        joinNodeMeta.setType(NodeType.JOINER_SQL.getType());
        joinNodeMeta.setPosition(DEFAULT_SINGLE_JOINER_POSITION);
        joinNodeMeta.setSql(ColumnMetaData.buildExtractSQL((String)dsTable.getName(), (boolean)true, targetColMetas.targetColMetas).toString());
        topology.addNodeMeta(joinNodeMeta);
        ERRules.createErRule((String)topologyName, (DependencyNode)this.createDumpNode(dsTable), (ColumnMetaData)targetColMetas.getPKMeta());
        return topology;
    }

    private DependencyNode createDumpNode(OfflineManager.ProcessedTable dsTable) {
        DependencyNode dNode = new DependencyNode();
        dNode.setId(String.valueOf(UUID.randomUUID()));
        dNode.setDbName(dsTable.getDBName());
        dNode.setName(dsTable.getName());
        dNode.setDbid(String.valueOf(dsTable.getDbId()));
        dNode.setTabid(String.valueOf(dsTable.getId()));
        dNode.setExtraSql(dsTable.getExtraSql());
        dNode.setPosition(DEFAULT_SINGLE_TABLE_POSITION);
        dNode.setType(NodeType.DUMP.getType());
        return dNode;
    }

    private Map<String, TargetCol> getTargetCols(JSONObject post) {
        ThreadLocal<SnapshotViewImplDAO.MergeData> mergeDataContext = SnapshotViewImplDAO.mergeDataContext;
        mergeDataContext.remove();
        SnapshotViewImplDAO.MergeData mergeData = mergeDataContext.get();
        JSONObject colMeta = post.getJSONObject("colMeta");
        JSONObject options = colMeta.getJSONObject("options");
        if (options != null) {
            List<String> acceptKeys = this.getSnapshotViewDAO().getOptionParamKeys();
            options.forEach((key, val) -> {
                if (!acceptKeys.contains(key)) {
                    throw new IllegalArgumentException("key:" + key + " is not acceptable,params:" + acceptKeys.stream().collect(Collectors.joining(",")));
                }
                mergeData.put(key, val);
            });
        }
        JSONArray targetCols = colMeta.getJSONArray("columns");
        Map<String, TargetCol> targetColMap = targetCols.stream().map(c -> {
            JSONObject o = (JSONObject)c;
            TargetCol targetCol = new TargetCol(o.getString(KEY_SHARD_NAME));
            Boolean indexable = o.getBoolean("search");
            targetCol.setIndexable(indexable == null ? true : indexable);
            targetCol.setToken(o.getString("parser"));
            return targetCol;
        }).collect(Collectors.toMap(c -> c.getName(), c -> c));
        return targetColMap;
    }

    private boolean createIncrSyncChannel(Context context, JSONObject incrCfg) throws Exception {
        HeteroEnum pluginType = HeteroEnum.MQ;
        UploadPluginMeta pluginMeta = UploadPluginMeta.parse((String)(pluginType.identity + ":require"));
        PluginItems incrPluginItems = this.getPluginItems(context, incrCfg, pluginType, pluginMeta);
        if (incrPluginItems.items.size() < 1) {
            throw new IllegalStateException("incr plugin item size can not small than 1");
        }
        PluginItemsParser validate = incrPluginItems.validate(this, context, 0, FormVaildateType.create((boolean)false));
        if (validate.faild) {
            return false;
        }
        incrPluginItems.save(context);
        IndexIncrStatus incrStatus = CoreAction.generateDAOAndIncrScript(this, context, true, true, false);
        if (context.hasErrors()) {
            return false;
        }
        ReplicasSpec incrPodSpec = new ReplicasSpec();
        incrPodSpec.setReplicaCount(1);
        incrPodSpec.setMemoryRequest(Specification.parse((String)"1G"));
        incrPodSpec.setMemoryLimit(Specification.parse((String)"2G"));
        incrPodSpec.setCpuRequest(Specification.parse((String)"500m"));
        incrPodSpec.setCpuLimit(Specification.parse((String)"1"));
        TISK8sDelegate k8sClient = TISK8sDelegate.getK8SDelegate(this.getCollectionName());
        k8sClient.deploy(incrPodSpec, incrStatus.getIncrScriptTimestamp());
        return true;
    }

    private PluginItems getPluginItems(Context context, JSONObject pluginCfg, HeteroEnum pluginType, UploadPluginMeta pluginMeta) {
        HashMap dsParams = Maps.newHashMap();
        for (String dsKey : pluginCfg.keySet()) {
            dsParams.put(dsKey, pluginCfg.getString(dsKey));
        }
        DescriptorExtensionList descriptorList = TIS.get().getDescriptorList(pluginType.extensionPoint);
        String plugin = (String)dsParams.remove("plugin");
        if (StringUtils.isEmpty((String)plugin)) {
            throw new IllegalStateException("pluginCfg/plugin can not be null");
        }
        Optional<Descriptor> pluginDesc = descriptorList.stream().filter(des -> plugin.equals(des.getDisplayName())).findFirst();
        Descriptor dsDescriptpr = null;
        if (!pluginDesc.isPresent()) {
            throw new IllegalStateException("plugin:'" + plugin + "' relevant plugin descriper can not be null");
        }
        dsDescriptpr = pluginDesc.get();
        PluginItems items = new PluginItems(new DftPluginContext(pluginType, this), context, pluginMeta);
        JSONArray itemsArray = new JSONArray();
        JSONObject item = new JSONObject();
        JSONObject vals = new JSONObject();
        JSONObject val = null;
        for (Map.Entry p : dsParams.entrySet()) {
            val = new JSONObject();
            val.put("_primaryVal", p.getValue());
            vals.put((String)p.getKey(), (Object)val);
        }
        item.put("impl", (Object)dsDescriptpr.getId());
        item.put("vals", (Object)vals);
        itemsArray.add((Object)item);
        items.items = AttrValMap.describableAttrValMapList((JSONArray)itemsArray, (Optional)pluginMeta.getSubFormFilter());
        return items;
    }

    static {
        logger = LoggerFactory.getLogger(CollectionAction.class);
        DEFAULT_SINGLE_TABLE_POSITION = new Position();
        DEFAULT_SINGLE_TABLE_POSITION.setX(141);
        DEFAULT_SINGLE_TABLE_POSITION.setY(121);
        DEFAULT_SINGLE_JOINER_POSITION = new Position();
        DEFAULT_SINGLE_JOINER_POSITION.setX(237);
        DEFAULT_SINGLE_JOINER_POSITION.setY(296);
    }

    public static class IndexName {
        private final String param;
        private final String collectionName;

        public IndexName(String param) {
            this.param = param;
            this.collectionName = param;
        }

        public String getCollectionName() {
            return this.collectionName;
        }
    }

    private static class LogReader
    implements ILogListener {
        private final StringBuffer logContent = new StringBuffer();

        private LogReader() {
        }

        public void sendMsg2Client(Object biz) throws IOException {
        }

        public void read(Object event) {
            PExecuteState state = (PExecuteState)event;
            this.logContent.append(state.getMsg()).append("\n");
        }

        public boolean isClosed() {
            return false;
        }
    }

    private class DftPluginContext
    implements IPluginContext {
        private final HeteroEnum pluginType;
        private final IPluginContext delegateContext;

        public DftPluginContext(HeteroEnum pluginType, IPluginContext delegateContext) {
            this.pluginType = pluginType;
            this.delegateContext = Objects.requireNonNull(delegateContext, "delegateContext");
        }

        public void executeBizLogic(IFieldErrorHandler.BizLogic logicType, Context context, Object param) throws Exception {
            throw new UnsupportedOperationException();
        }

        public boolean isCollectionAware() {
            return this.pluginType == HeteroEnum.MQ;
        }

        public DataXName getCollectionName() {
            return CollectionAction.this.getCollectionName();
        }

        public boolean isDataSourceAware() {
            return this.pluginType == HeteroEnum.DATASOURCE;
        }

        public JSONObject getJSONPostContent() {
            throw new UnsupportedOperationException();
        }

        public List<IUploadPluginMeta> parsePluginMeta(String[] plugins, boolean useCache) {
            throw new UnsupportedOperationException();
        }

        public void errorsPageShow(Context context) {
        }

        public ILoginUser getLoginUser() {
            throw new UnsupportedOperationException();
        }

        public String getExecId() {
            throw new UnsupportedOperationException();
        }

        public void addActionMessage(Context context, String msg) {
        }

        public void setBizResult(Context context, Object result, boolean overwriteable) {
            CollectionAction.this.setBizResult(context, result, overwriteable);
        }

        public void addErrorMessage(Context context, String msg) {
        }

        public void addDb(Descriptor.ParseDescribable<DataSourceFactory> dbDesc, String dbName, Context context, boolean shallUpdateDB) {
            this.delegateContext.addDb(dbDesc, dbName, context, shallUpdateDB);
        }
    }

    private static class ColMetaTuple {
        public final TargetCol targetCol;
        public final ColumnMetaData colMeta;

        public ColMetaTuple(TargetCol targetCol, ColumnMetaData colMeta) {
            if (targetCol == null) {
                throw new IllegalArgumentException("targetCol can not be null");
            }
            if (colMeta == null) {
                throw new IllegalArgumentException("colMeta can not be null");
            }
            this.targetCol = targetCol;
            this.colMeta = colMeta;
        }

        public String getSchemaFieldType() {
            return this.colMeta.getSchemaFieldType().type.literia;
        }

        public boolean isTypeOf(ReflectSchemaFieldType type) {
            return this.colMeta.getSchemaFieldType().type == type;
        }
    }

    private static class TargetCol {
        private final String name;
        private String token;
        private boolean indexable;

        public TargetCol(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public boolean isIndexable() {
            return this.indexable;
        }

        public void setIndexable(boolean indexable) {
            this.indexable = indexable;
        }
    }

    public static class TargetColumnMeta {
        private final String tableName;
        boolean valid = true;
        private Map<String, TargetCol> targetColMap = null;
        final List<ColumnMetaData> targetColMetas = Lists.newArrayList();

        public TargetColumnMeta(String tableName) {
            this.tableName = tableName;
        }

        public ColumnMetaData getPKMeta() {
            List pks = this.targetColMetas.stream().filter(c -> c.isPk()).collect(Collectors.toList());
            if (pks.size() > 1) {
                throw new IllegalStateException("table:" + this.tableName + "'s pk col can not much than 1,now is:" + pks.stream().map(r -> r.getKey()).collect(Collectors.joining(",")));
            }
            if (pks.size() < 1) {
                throw new IllegalStateException("table:" + this.tableName + " can not find pk");
            }
            Iterator iterator = pks.iterator();
            if (iterator.hasNext()) {
                ColumnMetaData pk = (ColumnMetaData)iterator.next();
                TargetCol targetCol = this.targetColMap.get(pk.getKey());
                Objects.requireNonNull(targetCol, "pk:" + pk.getKey() + " is not in target cols:" + this.targetColMap.values().stream().map(r -> r.getName()).collect(Collectors.joining(",")));
                return pk;
            }
            throw new IllegalStateException("can not find primary key");
        }

        public Map<String, ColMetaTuple> getTargetCols() {
            Objects.requireNonNull(this.targetColMap, "targetColMap can not be bull");
            return this.targetColMetas.stream().collect(Collectors.toMap(c -> c.getKey(), c -> new ColMetaTuple(this.targetColMap.get(c.getKey()), (ColumnMetaData)c)));
        }

        private TargetColumnMeta invalid() {
            this.valid = false;
            return this;
        }
    }
}

