/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.config.module.action;

import com.qlangtech.tis.manage.biz.dal.dao.IDepartmentDAO;
import com.qlangtech.tis.manage.biz.dal.pojo.Department;
import com.qlangtech.tis.manage.biz.dal.pojo.DepartmentCriteria;
import com.qlangtech.tis.runtime.module.action.BasicModule;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

public class AppSynAction
extends BasicModule {
    private static final long serialVersionUID = 1L;

    public static void insertDepartment(String departmentName, IDepartmentDAO dptDAO, int iterateCount) {
        String[] dptary = StringUtils.split((String)departmentName, (String)"-");
        Department department = null;
        Integer parentDptId = null;
        StringBuffer parentPath = new StringBuffer();
        for (int i = 0; i < dptary.length; ++i) {
            parentPath.append(dptary[i]);
            if (!AppSynAction.hasNode(dptDAO, parentPath.toString())) {
                department = new Department();
                department.setParentId(parentDptId == null ? -1 : parentDptId);
                department.setFullName(parentPath.toString());
                department.setName(dptary[i]);
                department.setGmtCreate(new Date());
                department.setGmtModified(new Date());
                department.setLeaf(i + 1 == dptary.length);
                parentDptId = dptDAO.insertSelective(department);
            } else {
                parentDptId = AppSynAction.getParentId(dptDAO, parentPath.toString());
                if (i + 1 == dptary.length) {
                    department = new Department();
                    DepartmentCriteria q = new DepartmentCriteria();
                    q.createCriteria().andDptIdEqualTo(parentDptId);
                    dptDAO.updateByExampleSelective(department, q);
                    return;
                }
            }
            if (i + 1 >= dptary.length) continue;
            parentPath.append("-");
        }
    }

    private static Integer getParentId(IDepartmentDAO dptDAO, String parentName) {
        if (StringUtils.isNotEmpty((CharSequence)parentName)) {
            DepartmentCriteria dptCriteria = new DepartmentCriteria();
            dptCriteria.createCriteria().andFullNameEqualTo(parentName);
            Iterator<Department> iterator = dptDAO.selectByExample(dptCriteria).iterator();
            if (iterator.hasNext()) {
                Department dpt = iterator.next();
                return dpt.getDptId();
            }
        }
        return null;
    }

    private static boolean hasNode(IDepartmentDAO dptDAO, String name) {
        DepartmentCriteria dptCriteria = new DepartmentCriteria();
        dptCriteria.createCriteria().andFullNameEqualTo(name);
        return StringUtils.isNotEmpty((CharSequence)name) && dptDAO.countByExample(dptCriteria) > 0;
    }

    private Department getDpt(String dptFullName) {
        DepartmentCriteria dptCriteria = new DepartmentCriteria();
        dptCriteria.createCriteria().andFullNameEqualTo(dptFullName);
        Iterator<Department> iterator = this.getDepartmentDAO().selectByExample(dptCriteria).iterator();
        if (iterator.hasNext()) {
            Department dpt = iterator.next();
            return dpt;
        }
        return null;
    }
}

