/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.alert;

import com.google.common.collect.Lists;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.config.flink.JobManagerAddress;
import com.qlangtech.tis.coredefine.module.action.CoreAction;
import com.qlangtech.tis.coredefine.module.action.IFlinkIncrJobStatus;
import com.qlangtech.tis.coredefine.module.action.IndexIncrStatus;
import com.qlangtech.tis.coredefine.module.action.impl.FlinkJobDeploymentDetails;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.DefaultDataXProcessorManipulate;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.lang.ErrorValue;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.plugin.alert.AlertChannel;
import com.qlangtech.tis.plugin.alert.AlertTemplate;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class FlinkJobsMonitor
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(FlinkJobsMonitor.class);
    private final Map<String, IFlinkIncrJobStatus.State> lastJobStates = new ConcurrentHashMap<String, IFlinkIncrJobStatus.State>();
    private final Map<String, Date> jobStartTimes = new ConcurrentHashMap<String, Date>();

    public void afterPropertiesSet() throws Exception {
        logger.info("FlinkJobsMonitor initialized successfully");
    }

    public void executeTask() {
        try {
            logger.debug("Starting Flink jobs status check...");
            List<FlinkJobDeploymentDetails> runningJobs = this.getAllRunningFlinkJobs();
            for (FlinkJobDeploymentDetails jobInfo : runningJobs) {
                this.checkJobStatus(jobInfo);
            }
            logger.debug("Flink jobs status check completed");
        }
        catch (Exception e) {
            TisException.ErrMsg errMsg = TisException.getErrMsg((Throwable)e);
            ErrorValue errCode = errMsg.getErrCode();
            if (errCode != null) {
                if (errCode.getCode() == TisException.ErrorCode.FLINK_INSTANCE_LOSS_OF_CONTACT) {
                    this.doAlert(FlinkJobsMonitor.createNoneDeployment(errCode));
                }
            }
            logger.error("Error during Flink jobs monitoring", (Throwable)e);
        }
    }

    private static FlinkJobDeploymentDetails createNoneDeployment(ErrorValue errCode) {
        return FlinkJobDeploymentDetails.noneState((DataXName)DataXName.createDataXPipeline((String)((String)errCode.getPayload("appname"))), () -> Optional.ofNullable((JobManagerAddress)errCode.getPayload("jobManagerAddress")).orElseGet(() -> new JobManagerAddress("127.0.0.1", 8081)), (IFlinkIncrJobStatus)new NoneFlinkIncrJobStatus());
    }

    private void checkJobStatus(FlinkJobDeploymentDetails jobInfo) {
        IFlinkIncrJobStatus.State lastState;
        String jobName = jobInfo.getJobName();
        IFlinkIncrJobStatus.State currentState = jobInfo.getIncrJobStatus().getState();
        if (!this.jobStartTimes.containsKey(jobName) && currentState == IFlinkIncrJobStatus.State.RUNNING) {
            this.jobStartTimes.put(jobName, new Date());
        }
        if (this.shouldAlert(lastState = this.lastJobStates.get(jobName), currentState)) {
            logger.info("Job [{}] state changed from [{}] to [{}], triggering alert", new Object[]{jobName, lastState, currentState});
            this.doAlert(jobInfo);
        }
        this.lastJobStates.put(jobName, currentState);
        if (currentState != IFlinkIncrJobStatus.State.RUNNING) {
            this.jobStartTimes.remove(jobName);
        }
    }

    private boolean shouldAlert(IFlinkIncrJobStatus.State lastState, IFlinkIncrJobStatus.State currentState) {
        if (lastState == null) {
            return false;
        }
        if (lastState == IFlinkIncrJobStatus.State.RUNNING) {
            return currentState == IFlinkIncrJobStatus.State.FAILED || currentState == IFlinkIncrJobStatus.State.DISAPPEAR || currentState == IFlinkIncrJobStatus.State.NONE;
        }
        return false;
    }

    private void doAlert(FlinkJobDeploymentDetails jobInfo) {
        try {
            Date startTime = this.jobStartTimes.get(jobInfo.getJobName());
            Date endTime = new Date();
            AlertTemplate alertTemplate = AlertTemplate.builder().title("TIS Flink Job \u544a\u8b66").subject(String.format("Flink Job [%s] \u72b6\u6001\u5f02\u5e38", jobInfo.getJobName())).jobName(jobInfo.getJobName()).status(String.valueOf(jobInfo.getIncrJobStatus().getState())).type(Integer.valueOf(1)).startTime(startTime).endTime(endTime).duration(startTime, endTime).link(jobInfo.getJobManagerUrl()).restart(Boolean.valueOf(false), Integer.valueOf(0)).build();
            Pair<List<AlertChannel>, DefaultDataXProcessorManipulate.MonitorForEventsManager> pair = this.getPipelineAlertChannels(jobInfo.getJobName());
            List alertChannels = (List)pair.getKey();
            if (alertChannels.isEmpty()) {
                logger.warn("No alert channels configured, skip sending alert for job [{}]", (Object)jobInfo.getJobName());
                return;
            }
            boolean hasSuccess = false;
            for (AlertChannel channel : alertChannels) {
                try {
                    logger.info("Sending alert via channel [{}] for job [{}]", (Object)channel.identityValue(), (Object)jobInfo.getJobName());
                    channel.send(alertTemplate);
                    hasSuccess = true;
                }
                catch (Exception e) {
                    logger.error("Failed to send alert via channel [{}] for job [{}]", new Object[]{channel.identityValue(), jobInfo.getJobName(), e});
                }
            }
            if (hasSuccess) {
                ((DefaultDataXProcessorManipulate.MonitorForEventsManager)pair.getValue()).addSendCount();
            }
        }
        catch (Exception e) {
            logger.error("Error during alert execution for job [{}]", (Object)jobInfo.getJobName(), (Object)e);
        }
    }

    private Pair<List<AlertChannel>, DefaultDataXProcessorManipulate.MonitorForEventsManager> getPipelineAlertChannels(String pipelineName) {
        DefaultDataXProcessorManipulate.DataXProcessorTemplateManipulateStore manipulateStore = DefaultDataXProcessorManipulate.getManipulateStore((String)pipelineName);
        DefaultDataXProcessorManipulate.MonitorForEventsManager monitorManager = manipulateStore.getAlertManager();
        if (monitorManager == null) {
            return Pair.of(Collections.emptyList(), null);
        }
        if (!monitorManager.isActivate()) {
            return Pair.of(Collections.emptyList(), (Object)monitorManager);
        }
        return Pair.of((Object)monitorManager.getAlertChannels(), (Object)monitorManager);
    }

    public static List<String> loadExistRunningIncrPipeline() {
        File appDir = new File(TIS.pluginCfgRoot, StoreResourceType.DataApp.getType());
        String[] subDirs = null;
        if (!appDir.exists() || (subDirs = appDir.list()) == null) {
            return Collections.emptyList();
        }
        ArrayList runningIncrPipelines = Lists.newArrayList();
        for (String subDir : subDirs) {
            if (!new File(appDir, subDir + File.separator + "incrJob.log").exists()) continue;
            runningIncrPipelines.add(subDir);
        }
        return runningIncrPipelines;
    }

    public static void main(String[] args) {
        System.out.println(String.join((CharSequence)" ,", FlinkJobsMonitor.loadExistRunningIncrPipeline()));
    }

    private List<FlinkJobDeploymentDetails> getAllRunningFlinkJobs() throws Exception {
        ArrayList result = Lists.newArrayList();
        for (String pipelineName : FlinkJobsMonitor.loadExistRunningIncrPipeline()) {
            IndexIncrStatus indexIncrStatus = null;
            try {
                IndexIncrStatus incrStatus = new IndexIncrStatus();
                indexIncrStatus = CoreAction.getIndexIncrStatus(IControlMsgHandler.namedContext((String)pipelineName), incrStatus, false);
            }
            catch (Throwable e) {
                throw new RuntimeException("pipe:" + pipelineName, e);
            }
            if (indexIncrStatus.getFlinkJobDetail() == null) {
                ErrorValue errCode = ErrorValue.create((TisException.ErrorCode)TisException.ErrorCode.FLINK_INSTANCE_LOSS_OF_CONTACT, (String)"appname", (Object)pipelineName);
                indexIncrStatus.setFlinkJobDetail(FlinkJobsMonitor.createNoneDeployment(errCode));
            }
            result.add(Objects.requireNonNull(indexIncrStatus.getFlinkJobDetail(), "pipelineName:" + pipelineName + " relevant FlinkJobDetail can not be null"));
        }
        return result;
    }

    private static class NoneFlinkIncrJobStatus
    implements IFlinkIncrJobStatus<Object> {
        private NoneFlinkIncrJobStatus() {
        }

        public IFlinkIncrJobStatus.State getState() {
            return IFlinkIncrJobStatus.State.DISAPPEAR;
        }

        public Object createNewJob(Object o) {
            return null;
        }

        public Object getLaunchJobID() {
            return null;
        }

        public void relaunch(Object o) {
        }

        public void addSavePoint(String savepointDirectory, IFlinkIncrJobStatus.State state) {
        }

        public void discardSavepoint(String savepointDirectory) {
        }

        public void stop(String savepointDirectory) {
        }

        public void cancel() {
        }

        public Optional<IFlinkIncrJobStatus.FlinkSavepoint> containSavepoint(String path) {
            return Optional.empty();
        }

        public void setState(IFlinkIncrJobStatus.State state) {
        }

        public List<IFlinkIncrJobStatus.FlinkSavepoint> getSavepointPaths() {
            return List.of();
        }
    }
}

