/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.aiagent.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaskTemplateRegistry {
    private final Map<String, TaskTemplate> templates = new HashMap<String, TaskTemplate>();

    public TaskTemplateRegistry() {
        this.initTemplates();
    }

    private void initTemplates() {
        TaskTemplate mysqlToPaimon = new TaskTemplate();
        mysqlToPaimon.setId("mysql-to-paimon");
        mysqlToPaimon.setName("MySQL\u540c\u6b65\u5230Paimon");
        mysqlToPaimon.setDescription("\u521b\u5efaMySQL\u5230Paimon\u7684\u6570\u636e\u540c\u6b65\u7ba1\u9053");
        mysqlToPaimon.setSourceType("mysql");
        mysqlToPaimon.setTargetType("paimon");
        mysqlToPaimon.setSampleText("\u6211\u9700\u8981\u521b\u5efa\u4e00\u4e2a\u6570\u636e\u540c\u6b65\u7ba1\u9053\uff0c\u4eceMySQL\u540c\u6b65\u5230Paimon\u6570\u636e\u5e93\uff0cMySQL\u6570\u636e\u6e90\u7528\u6237\u540d\u4e3aroot\uff0c\u5bc6\u7801\u4e3a123456\uff0c\u4e3b\u673a\u5730\u5740\u4e3a192.168.1.100\uff0c\u7aef\u53e3\u4e3a3306\uff0c\u6570\u636e\u5e93\u540d\u79f0\u4e3amydb\u3002Paimon\u7aef\u7684Hive\u914d\u7f6e\u4e3a\uff0c\u5730\u5740\uff1a192.168.1.200\uff0c\u6570\u636e\u5e93\u540d\u79f0\uff1adefault\u3002\u540c\u6b65\u7ba1\u9053\u521b\u5efa\u5b8c\u6210\u540e\u81ea\u52a8\u89e6\u53d1\u5386\u53f2\u6570\u636e\u540c\u6b65\uff0c\u5e76\u5f00\u542f\u589e\u91cf\u540c\u6b65\u3002");
        this.templates.put(mysqlToPaimon.getId(), mysqlToPaimon);
        TaskTemplate mysqlToDoris = new TaskTemplate();
        mysqlToDoris.setId("mysql-to-doris");
        mysqlToDoris.setName("MySQL\u540c\u6b65\u5230Doris");
        mysqlToDoris.setDescription("\u521b\u5efaMySQL\u5230Doris\u7684\u6570\u636e\u540c\u6b65\u7ba1\u9053");
        mysqlToDoris.setSourceType("mysql");
        mysqlToDoris.setTargetType("doris");
        mysqlToDoris.setSampleText("\u521b\u5efaMySQL\u5230Doris\u7684\u6570\u636e\u540c\u6b65\u7ba1\u9053\uff0cMySQL\u6e90\u7aef\uff1ahost=192.168.28.200, port=3306, user=root, password=123456, database=order2\u3002Doris\u76ee\u6807\u7aef\uff1ahost=192.168.28.200 ,port=9030, be\u8282\u70b9\u5730\u5740\u4e3a\uff1a192.168.28.200:8030, user=root, password=doris123\u3002");
        this.templates.put(mysqlToDoris.getId(), mysqlToDoris);
        TaskTemplate pgToStarRocks = new TaskTemplate();
        pgToStarRocks.setId("postgresql-to-starrocks");
        pgToStarRocks.setName("PostgreSQL\u540c\u6b65\u5230StarRocks");
        pgToStarRocks.setDescription("\u521b\u5efaPostgreSQL\u5230StarRocks\u7684\u6570\u636e\u540c\u6b65\u7ba1\u9053");
        pgToStarRocks.setSourceType("postgresql");
        pgToStarRocks.setTargetType("starrocks");
        pgToStarRocks.setSampleText("\u914d\u7f6ePostgreSQL\u5230StarRocks\u7684\u5b9e\u65f6\u540c\u6b65\uff0cPG\u6570\u636e\u5e93\u4f4d\u4e8e10.0.1.5:5432\uff0c\u7528\u6237postgres\uff0c\u5bc6\u7801pg123\uff0c\u6570\u636e\u5e93analytics\u3002StarRocks\u96c6\u7fa4FE\u8282\u70b910.0.2.10:9030\uff0c\u7528\u6237admin\u3002");
        this.templates.put(pgToStarRocks.getId(), pgToStarRocks);
        TaskTemplate oracleToDoris = new TaskTemplate();
        oracleToDoris.setId("oracle-to-doris");
        oracleToDoris.setName("Oracle\u540c\u6b65\u5230Doris");
        oracleToDoris.setDescription("\u521b\u5efaOracle\u5230Doris\u7684\u4f01\u4e1a\u7ea7\u6570\u636e\u4ed3\u5e93\u540c\u6b65\u7ba1\u9053");
        oracleToDoris.setSourceType("oracle");
        oracleToDoris.setTargetType("doris");
        oracleToDoris.setSampleText("\u642d\u5efaOracle\u5230Doris\u7684\u5b9e\u65f6\u6570\u636e\u540c\u6b65\u7ba1\u9053\u3002Oracle\u6570\u636e\u6e90\u914d\u7f6e\uff1a\u4e3b\u673a\u5730\u5740192.168.10.50\uff0c\u7aef\u53e31521\uff0c\u670d\u52a1\u540dORCL\uff0c\u7528\u6237\u540dsystem\uff0c\u5bc6\u7801oracle123\uff0c\u9700\u8981\u540c\u6b65\u7684Schema\u4e3aSALES\u3002Doris\u76ee\u6807\u7aef\u914d\u7f6e\uff1aFE\u8282\u70b9192.168.20.100:9030\uff0cBE\u8282\u70b9192.168.20.101-103\uff0c\u7528\u6237\u540droot\uff0c\u5bc6\u7801doris456\uff0c\u76ee\u6807\u6570\u636e\u5e93warehouse\u3002\u5f00\u542fCDC\u5b9e\u65f6\u6355\u83b7\uff0c\u4f7f\u7528Log Mining Strategy\u4e3aredo_log_catalog\u6a21\u5f0f\uff0cPoll Interval\u8bbe\u7f6e\u4e3a500ms\u3002Doris\u7aef\u914d\u7f6eStreamLoad\u53c2\u6570\uff0c\u6279\u91cf\u5927\u5c0f10000\u6761\uff0c\u81ea\u52a8\u5efa\u8868\u6a21\u5f0f\u9009\u62e9Unique\u6a21\u578b\uff0c\u526f\u672c\u65703\uff0c\u5206\u6876\u657020\u3002\u540c\u6b65\u5b8c\u6210\u540e\u81ea\u52a8\u521b\u5efa\u7269\u5316\u89c6\u56fe\u52a0\u901f\u67e5\u8be2\u3002");
        this.templates.put(oracleToDoris.getId(), oracleToDoris);
        TaskTemplate mysqlToES = new TaskTemplate();
        mysqlToES.setId("mysql-to-elasticsearch");
        mysqlToES.setName("MySQL\u540c\u6b65\u5230ElasticSearch");
        mysqlToES.setDescription("\u521b\u5efaMySQL\u5230ElasticSearch\u7684\u5168\u6587\u641c\u7d22\u7d22\u5f15\u540c\u6b65\u7ba1\u9053");
        mysqlToES.setSourceType("mysql");
        mysqlToES.setTargetType("elasticsearch");
        mysqlToES.setSampleText("\u6784\u5efaMySQL\u5230ElasticSearch\u7684\u5b9e\u65f6\u641c\u7d22\u5f15\u64ce\u3002MySQL\u6e90\u7aef\uff1a\u4e3b\u673a192.168.1.10\uff0c\u7aef\u53e33306\uff0c\u7528\u6237root\uff0c\u5bc6\u7801mysql123\uff0c\u6570\u636e\u5e93product_catalog\uff0c\u9700\u8981\u540c\u6b65products\u4e09\u5f20\u8868\u3002ElasticSearch\u76ee\u6807\u7aef\uff1a\u8282\u70b9\u5730\u5740http://192.168.2.20:9200\uff0c\u8ba4\u8bc1\u65b9\u5f0fuser\uff0c\u7528\u6237\u540delastic\uff0c\u5bc6\u7801es789\u3002\u7d22\u5f15\u914d\u7f6e\uff1a\u6279\u91cf\u5199\u5165\u5927\u5c0f5000\u6761\uff0c\u5237\u65b0\u95f4\u969410\u79d2\uff0c\u7d22\u5f15settings\u8bbe\u7f6e\u5206\u7247\u65705\u3001\u526f\u672c\u65701\u3002mapping\u914d\u7f6e\uff1aproduct_name\u548cdescription\u5b57\u6bb5\u4f7f\u7528ik\u5206\u8bcd\u5668\uff0cprice\u5b57\u6bb5\u7c7b\u578b\u4e3adouble\uff0ccreated_at\u4e3adate\u7c7b\u578b\u3002\u5b8c\u6210\u540e\u521b\u5efa\u522b\u540dproduct_search\u6307\u5411\u65b0\u7d22\u5f15\uff0c\u652f\u6301\u96f6\u505c\u673a\u66f4\u65b0\u3002\u5f00\u542f\u5b9e\u65f6\u540c\u6b65\uff0c\u76d1\u542cbinlog\u53d8\u66f4\u4e8b\u4ef6\uff0c\u5ef6\u8fdf\u63a7\u5236\u57281\u79d2\u5185\u3002");
        this.templates.put(mysqlToES.getId(), mysqlToES);
        TaskTemplate mongoToMySQL = new TaskTemplate();
        mongoToMySQL.setId("mongodb-to-mysql");
        mongoToMySQL.setName("MongoDB\u540c\u6b65\u5230MySQL");
        mongoToMySQL.setDescription("\u521b\u5efaMongoDB\u5230MySQL\u7684NoSQL\u6570\u636e\u5173\u7cfb\u5316\u540c\u6b65\u7ba1\u9053");
        mongoToMySQL.setSourceType("mongodb");
        mongoToMySQL.setTargetType("mysql");
        mongoToMySQL.setSampleText("\u5b9e\u73b0MongoDB\u5230MySQL\u7684\u6570\u636e\u5173\u7cfb\u5316\u8f6c\u6362\u3002MongoDB\u6e90\u7aef\uff1a\u96c6\u7fa4\u5730\u5740192.168.3.10:27017;192.168.3.11:27017;192.168.3.12:27017\uff0c\u6570\u636e\u5e93social_media\uff0c\u96c6\u5408users\u3001posts\u3001comments\uff0c\u8ba4\u8bc1\u7528\u6237admin\uff0c\u5bc6\u7801mongo456\u3002MySQL\u76ee\u6807\u7aef\uff1a\u4e3b\u673a192.168.4.20\uff0c\u7aef\u53e33306\uff0c\u7528\u6237root\uff0c\u5bc6\u7801mysql789\uff0c\u76ee\u6807\u5e93relational_social\u3002\u6570\u636e\u8f6c\u6362\u89c4\u5219\uff1aMongoDB\u5d4c\u5957\u6587\u6863\u5c55\u5f00\u4e3a\u5173\u8054\u8868\uff0c\u6570\u7ec4\u5b57\u6bb5\u8f6c\u4e3a\u5b50\u8868\uff0cObjectId\u6620\u5c04\u4e3aVARCHAR(24)\u3002\u9884\u8bfb500\u6761\u8bb0\u5f55\u81ea\u52a8\u63a8\u65adSchema\u3002\u5b9e\u65f6\u540c\u6b65\u914d\u7f6e\uff1a\u76d1\u542cMongoDB\u7684oplog\uff0c\u8d77\u59cb\u4f4d\u7f6eINITIAL\uff08\u5168\u91cf+\u589e\u91cf\uff09\uff0c\u8865\u5168\u7b56\u7565FULL_CHANGE_LOG\uff08\u5305\u542bbefore/after\u503c\uff09\uff0c\u5fc3\u8df3\u95f4\u969430\u79d2\u3002\u6279\u91cf\u5199\u5165\u6a21\u5f0f\u8bbe\u4e3aINSERT ON DUPLICATE KEY UPDATE\uff0c\u786e\u4fdd\u6570\u636e\u4e00\u81f4\u6027\u3002");
        this.templates.put(mongoToMySQL.getId(), mongoToMySQL);
        TaskTemplate sqlserverToPG = new TaskTemplate();
        sqlserverToPG.setId("sqlserver-to-postgresql");
        sqlserverToPG.setName("SqlServer\u540c\u6b65\u5230PostgreSQL");
        sqlserverToPG.setDescription("\u521b\u5efaSqlServer\u5230PostgreSQL\u7684\u5f02\u6784\u6570\u636e\u5e93\u8fc1\u79fb\u7ba1\u9053");
        sqlserverToPG.setSourceType("sqlserver");
        sqlserverToPG.setTargetType("postgresql");
        sqlserverToPG.setSampleText("\u914d\u7f6eSqlServer\u5230PostgreSQL\u7684\u4f01\u4e1a\u7ea7\u6570\u636e\u5e93\u8fc1\u79fb\u3002SqlServer\u6e90\u7aef\uff1a\u4e3b\u673a192.168.5.30\uff0c\u7aef\u53e31433\uff0c\u5b9e\u4f8b\u540dMSSQLSERVER\uff0c\u6570\u636e\u5e93ERP_PROD\uff0cSchema\u4e3adbo\uff0c\u7528\u6237sa\uff0c\u5bc6\u7801sqlserver123\uff0c\u542f\u7528\u5206\u5e93\u5206\u8868\u652f\u6301\u3002PostgreSQL\u76ee\u6807\u7aef\uff1a\u4e3b\u673a192.168.6.40\uff0c\u7aef\u53e35432\uff0c\u6570\u636e\u5e93erp_new\uff0cSchema\u4e3apublic\uff0c\u7528\u6237postgres\uff0c\u5bc6\u7801pg456\u3002\u8fc1\u79fb\u914d\u7f6e\uff1a\u6279\u91cf\u8bfb\u53d6\u4f7f\u7528splitPk\u5e76\u884c\u5206\u7247\uff0c\u6bcf\u6279fetchSize\u8bbe\u4e3a5000\u3002\u5b9e\u65f6\u540c\u6b65\u57fa\u4e8eTransaction Log\uff0c\u8d77\u59cb\u9009\u9879Initial\uff08\u5168\u91cf+\u589e\u91cf\uff09\u3002\u5904\u7406\u7279\u6b8a\u5b57\u6bb5\uff1aIDENTITY\u5217\u8f6cSERIAL\uff0c\u8ba1\u7b97\u5217\u8df3\u8fc7\uff0c\u7a7a\u95f4\u6570\u636e\u7c7b\u578b\u4f7f\u7528PostGIS\u6269\u5c55\u3002\u5b8c\u6210\u540e\u6267\u884cVACUUM ANALYZE\u4f18\u5316\u6027\u80fd\u3002");
        this.templates.put(sqlserverToPG.getId(), sqlserverToPG);
        TaskTemplate kafkaToClickhouse = new TaskTemplate();
        kafkaToClickhouse.setId("kafka-to-clickhouse");
        kafkaToClickhouse.setName("Kafka\u540c\u6b65\u5230Clickhouse");
        kafkaToClickhouse.setDescription("\u521b\u5efaKafka\u5230Clickhouse\u7684\u5b9e\u65f6\u6d41\u5f0f\u5206\u6790\u7ba1\u9053");
        kafkaToClickhouse.setSourceType("kafka");
        kafkaToClickhouse.setTargetType("clickhouse");
        kafkaToClickhouse.setSampleText("\u642d\u5efaKafka\u5230Clickhouse\u7684\u5b9e\u65f6\u65e5\u5fd7\u5206\u6790\u7cfb\u7edf\u3002Kafka\u6e90\u7aef\uff1aBootstrap Servers\u4e3a192.168.7.50:9092;192.168.7.51:9092;192.168.7.52:9092\uff0c\u6d88\u8d39Topic\u4e3aapp_logs\u3001system_metrics\u3001user_events\uff0c\u6d88\u8d39\u7ec4ID\u4e3aclickhouse_consumer\uff0c\u6d88\u606f\u683c\u5f0f\u4e3aJSON\u3002\u8ba4\u8bc1\u914d\u7f6e\uff1aProtocol\u4e3aSASL_PLAINTEXT\uff0cSASL\u673a\u5236PLAIN\uff0c\u7528\u6237kafka_user\uff0c\u5bc6\u7801kafka123\u3002\u8d77\u59cb\u4f4d\u7f6eEarliest\uff0c\u81ea\u52a8\u63a8\u65ad\u5b57\u6bb5\u7c7b\u578b\u3002Clickhouse\u76ee\u6807\u7aef\uff1aHTTP\u7aef\u53e3http://192.168.8.60:8123\uff0c\u7528\u6237default\uff0c\u5bc6\u7801ch789\uff0c\u6570\u636e\u5e93analytics\u3002\u5efa\u8868\u5f15\u64ce\u4f7f\u7528MergeTree\uff0c\u5206\u533a\u952e\u6309\u5929(toYYYYMMDD(timestamp))\uff0c\u6392\u5e8f\u952e(timestamp, user_id)\u3002\u6279\u91cf\u5199\u5165\uff1abatchSize\u8bbe\u4e3a10000\uff0cbatchByteSize\u4e3a20MB\u3002\u5b9e\u65f6\u5199\u5165\u914d\u7f6e\uff1a\u8bed\u4e49\u4fdd\u8bc1exactly-once\uff0c\u5e76\u884c\u5ea68\uff0c\u5237\u65b0\u95f4\u96945\u79d2\u3002\u914d\u7f6eTTL\u81ea\u52a8\u6e05\u740630\u5929\u524d\u7684\u6570\u636e\u3002");
        this.templates.put(kafkaToClickhouse.getId(), kafkaToClickhouse);
        TaskTemplate mysqlToKafka = new TaskTemplate();
        mysqlToKafka.setId("mysql-to-kafka");
        mysqlToKafka.setName("MySQL\u540c\u6b65\u5230Kafka");
        mysqlToKafka.setDescription("\u521b\u5efaMySQL\u5230Kafka\u7684\u53d8\u66f4\u4e8b\u4ef6\u53d1\u5e03\u7ba1\u9053");
        mysqlToKafka.setSourceType("mysql");
        mysqlToKafka.setTargetType("kafka");
        mysqlToKafka.setSampleText("\u6784\u5efaMySQL\u5230Kafka\u7684CDC\u4e8b\u4ef6\u6d41\u5e73\u53f0\u3002MySQL\u6e90\u7aef\uff1a\u4e3b\u673a192.168.9.70\uff0c\u7aef\u53e33306\uff0c\u7528\u6237root\uff0c\u5bc6\u7801mysql456\uff0c\u76d1\u63a7\u6570\u636e\u5e93order_service\u3002\u5f00\u542f\u5206\u5e93\u5206\u8868\u652f\u6301\uff0c\u8868\u540d\u6b63\u5219\u5339\u914dorder_\\d{4}\u3002Kafka\u76ee\u6807\u7aef\uff1aBootstrap Servers\u4e3a192.168.10.80:9092;192.168.10.81:9092\uff0cTopic\u4f7f\u7528\u52a8\u6001\u8def\u7531{database}_{table}\u6a21\u5f0f\u3002\u6d88\u606f\u683c\u5f0f\u9009\u62e9Canal-JSON\uff08\u5305\u542bDDL\u548cDML\u4fe1\u606f\uff09\u3002\u751f\u4ea7\u8005\u914d\u7f6e\uff1a\u8ba4\u8bc1Protocol\u4e3aSASL_SSL\uff0c\u7528\u6237producer\uff0c\u5bc6\u7801prod123\u3002\u53ef\u9760\u6027\u53c2\u6570\uff1aACKs\u8bbe\u4e3aall\uff0c\u91cd\u8bd5\u6b21\u65705\uff0c\u542f\u7528\u5e42\u7b49\u6027\u3002\u538b\u7f29\u7c7b\u578bsnappy\uff0c\u6279\u91cf\u5927\u5c0f32KB\uff0c\u5ef6\u8fdf\u65f6\u95f4100ms\u3002\u5b9e\u65f6CDC\u914d\u7f6e\uff1a\u76d1\u542cbinlog\u4f4d\u70b9LATEST_OFFSET\uff0c\u4e8b\u4ef6\u8fc7\u6ee4\u4fdd\u7559INSERT\u3001UPDATE_AFTER\u3001DELETE\u3002\u5e76\u884c\u5ea6\u8bbe\u7f6e\u4e3a4\uff0c\u786e\u4fdd\u987a\u5e8f\u6027\u4f7f\u7528\u8868\u7ea7\u522b\u5206\u533a\u952e\u3002");
        this.templates.put(mysqlToKafka.getId(), mysqlToKafka);
        TaskTemplate oracleToPaimon = new TaskTemplate();
        oracleToPaimon.setId("oracle-to-paimon");
        oracleToPaimon.setName("Oracle\u540c\u6b65\u5230Paimon");
        oracleToPaimon.setDescription("\u521b\u5efaOracle\u5230Paimon\u7684\u5f00\u653e\u6570\u636e\u6e56\u540c\u6b65\u7ba1\u9053");
        oracleToPaimon.setSourceType("oracle");
        oracleToPaimon.setTargetType("paimon");
        oracleToPaimon.setSampleText("\u914d\u7f6eOracle\u5230Paimon\u7684\u4f01\u4e1a\u6570\u636e\u6e56\u65b9\u6848\u3002Oracle\u6e90\u7aef\uff1a\u4e3b\u673a192.168.11.90\uff0c\u7aef\u53e31521\uff0cServiceName\u4e3aPROD\uff0c\u7528\u6237system\uff0c\u5bc6\u7801oracle789\uff0c\u5305\u542bSchema\uff1aFINANCE\u3002\u542f\u7528\u6388\u6743\u7528\u6237\u8fc7\u6ee4\uff0c\u4fdd\u7559\u4e1a\u52a1Schema\u3002CDC\u914d\u7f6e\uff1a\u4f7f\u7528LogMiner\uff0c\u7b56\u7565redo_log_catalog\uff0cPoll\u95f4\u9694200ms\uff0c\u6355\u83b7LOB\u5b57\u6bb5\u3002Paimon\u76ee\u6807\u7aef\uff1aHive Metastore\u5730\u5740192.168.12.100:9083\uff0cHDFS\u8def\u5f84hdfs://192.168.12.101:9000/data/paimon\uff0c\u6570\u636e\u5e93datalake\u3002\u5199\u5165\u4f18\u5316\uff1awrite-buffer-size\u8bbe\u4e3a512MB\uff0ctarget-file-size\u4e3a256MB\u3002\u5206\u6876\u7b56\u7565Dynamic Bucket\uff0c\u76ee\u6807\u884c\u6570500\u4e07\u3002\u5199\u5165\u6a21\u5f0fStream\uff08\u4f4e\u5ef6\u8fdf15-30\u79d2\u53ef\u89c1\uff09\u3002Compaction\u53c2\u6570\uff1amin-file-num\u4e3a3\uff0csorted-run\u89e6\u53d1\u65705\u3002Snapshot\u7ba1\u7406\uff1a\u4fdd\u7559\u6700\u5c1120\u4e2a\uff0c\u6700\u591a100\u4e2a\uff0c\u65f6\u95f4\u4fdd\u755924\u5c0f\u65f6\u3002\u5f00\u542fChangelog Producer\u8ffd\u8e2a\u6240\u6709\u53d8\u66f4\uff0c\u652f\u6301\u4e0b\u6e38Flink/Spark\u6d41\u5f0f\u6d88\u8d39\u3002\u6587\u4ef6\u683c\u5f0f\u9009\u62e9Parquet\uff0c\u542f\u7528Zstandard\u538b\u7f29\u3002");
        this.templates.put(oracleToPaimon.getId(), oracleToPaimon);
        TaskTemplate pgToES = new TaskTemplate();
        pgToES.setId("postgresql-to-elasticsearch");
        pgToES.setName("PostgreSQL\u540c\u6b65\u5230ElasticSearch");
        pgToES.setDescription("\u521b\u5efaPostgreSQL\u5230ElasticSearch\u7684\u5730\u7406\u7a7a\u95f4\u641c\u7d22\u540c\u6b65\u7ba1\u9053");
        pgToES.setSourceType("postgresql");
        pgToES.setTargetType("elasticsearch");
        pgToES.setSampleText("\u642d\u5efaPostgreSQL\u5230ElasticSearch\u7684\u5730\u7406\u4f4d\u7f6e\u641c\u7d22\u670d\u52a1\u3002PostgreSQL\u6e90\u7aef\uff1a\u4e3b\u673a192.168.13.110\uff0c\u7aef\u53e35432\uff0c\u6570\u636e\u5e93location_service\uff0cSchema\u4e3apublic\uff0c\u7528\u6237postgres\uff0c\u5bc6\u7801pg789\uff0c\u540c\u6b65\u8868\uff1astores\u3001deliveries\u3001user_locations\u3002\u5305\u542bPostGIS\u7a7a\u95f4\u6570\u636e\u7c7b\u578b\u3002ElasticSearch\u76ee\u6807\u7aef\uff1a\u96c6\u7fa4\u8282\u70b9http://192.168.14.120:9200;http://192.168.14.121:9200\uff0c\u8ba4\u8bc1\u7528\u6237elastic\uff0c\u5bc6\u7801es456\u3002\u7d22\u5f15\u6620\u5c04\uff1ageometry\u5b57\u6bb5\u8f6cgeo_shape\uff0cpoint\u8f6cgeo_point\uff0c\u652f\u6301\u5730\u7406\u7a7a\u95f4\u67e5\u8be2\u3002\u7d22\u5f15\u8bbe\u7f6e\uff1a\u5206\u7247\u65706\uff0c\u526f\u672c\u65702\uff0crefresh_interval\u4e3a1s\u3002\u6279\u91cf\u53c2\u6570\uff1abatchSize\u4e3a3000\uff0cdiscovery\u542f\u7528\u8282\u70b9\u81ea\u52a8\u53d1\u73b0\u3002\u5b9e\u65f6\u540c\u6b65\uff1a\u4f7f\u7528wal2json\u89e3\u7801\u5668\uff08\u9700\u9884\u88c5\u63d2\u4ef6\uff09\uff0cREPLICA IDENTITY\u8bbe\u4e3aFULL\u6355\u83b7\u5b8c\u6574\u53d8\u66f4\u3002\u5199\u5165\u8bed\u4e49at-least-once\uff0cbulkFlushIntervalMs\u4e3a5000\uff0cbulkFlushMaxActions\u4e3a5000\u3002\u5b8c\u6210\u540e\u521b\u5efa\u522b\u540dgeo_search\uff0c\u652f\u6301\u534a\u5f84\u641c\u7d22\u3001\u591a\u8fb9\u5f62\u641c\u7d22\u7b49\u7a7a\u95f4\u67e5\u8be2\u3002");
        this.templates.put(pgToES.getId(), pgToES);
        TaskTemplate mysqlToMysqlCross = new TaskTemplate();
        mysqlToMysqlCross.setId("mysql-to-mysql-cross");
        mysqlToMysqlCross.setName("MySQL\u8de8\u533a\u57df\u540c\u6b65");
        mysqlToMysqlCross.setDescription("\u521b\u5efaMySQL\u4e3b\u4ece\u8de8\u533a\u57df\u707e\u5907\u540c\u6b65\u7ba1\u9053");
        mysqlToMysqlCross.setSourceType("mysql");
        mysqlToMysqlCross.setTargetType("mysql");
        mysqlToMysqlCross.setSampleText("\u6784\u5efaMySQL\u8de8\u6570\u636e\u4e2d\u5fc3\u7684\u707e\u5907\u540c\u6b65\u7cfb\u7edf\u3002\u4e3b\u5e93\u914d\u7f6e\uff1a\u5317\u4eac\u673a\u623f192.168.15.130\uff0c\u7aef\u53e33306\uff0c\u7528\u6237repl_user\uff0c\u5bc6\u7801repl456\uff0c\u6570\u636e\u5e93business_core\u3002\u5f00\u542f\u5206\u5e93\u5206\u8868\uff0c\u8bc6\u522b\u6b63\u5219^(order|user)_\\d{4}$\u3002\u4ece\u5e93\u914d\u7f6e\uff1a\u4e0a\u6d77\u673a\u623f192.168.16.140\uff0c\u7aef\u53e33306\uff0c\u7528\u6237root\uff0c\u5bc6\u7801mysql789\u3002\u7f51\u7edc\u4f18\u5316\uff1a\u542f\u7528\u538b\u7f29\u4f20\u8f93\uff0c\u8fde\u63a5\u8d85\u65f630\u79d2\uff0c\u7f16\u7801UTF8MB4\u3002\u6279\u91cf\u540c\u6b65\uff1asplitPk\u5e76\u884c16\u4e2a\u5206\u7247\uff0cfetchSize\u4e3a8000\uff0c\u63d0\u5347\u8de8\u533a\u57df\u4f20\u8f93\u6548\u7387\u3002\u5b9e\u65f6\u540c\u6b65\uff1abinlog\u72ec\u7acb\u76d1\u542c\u8d44\u6e90\u9694\u79bb\uff0c\u8d77\u59cb\u4f4d\u7f6eLATEST_OFFSET\u3002\u5199\u5165\u914d\u7f6e\uff1awriteMode\u4e3aREPLACE\u4fdd\u8bc1\u5e42\u7b49\uff0cbatchSize\u4e3a5000\uff0c\u5e76\u884c\u5ea68\u3002\u5bb9\u9519\u673a\u5236\uff1a\u5931\u8d25\u91cd\u8bd53\u6b21\uff0ccheckpoint\u95f4\u969460\u79d2\u3002\u76d1\u63a7\u544a\u8b66\uff1a\u5ef6\u8fdf\u8d85\u8fc75\u79d2\u89e6\u53d1\u544a\u8b66\u3002\u540c\u6b65\u8fc7\u6ee4\uff1a\u6392\u9664\u7cfb\u7edf\u8868\u3001\u4e34\u65f6\u8868\u3001\u65e5\u5fd7\u8868\u3002\u5b9a\u671f\u6267\u884cchecksum\u6821\u9a8c\u786e\u4fdd\u6570\u636e\u4e00\u81f4\u6027\u3002");
        this.templates.put(mysqlToMysqlCross.getId(), mysqlToMysqlCross);
        TaskTemplate sqlserverToDoris = new TaskTemplate();
        sqlserverToDoris.setId("sqlserver-to-doris");
        sqlserverToDoris.setName("SqlServer\u540c\u6b65\u5230Doris");
        sqlserverToDoris.setDescription("\u521b\u5efaSqlServer\u5230Doris\u7684BI\u5b9e\u65f6\u5206\u6790\u7ba1\u9053");
        sqlserverToDoris.setSourceType("sqlserver");
        sqlserverToDoris.setTargetType("doris");
        sqlserverToDoris.setSampleText("\u914d\u7f6eSqlServer\u5230Doris\u7684\u5b9e\u65f6BI\u5206\u6790\u5e73\u53f0\u3002SqlServer\u6e90\u7aef\uff1a\u4e3b\u673a192.168.17.150\uff0c\u7aef\u53e31433\uff0c\u5b9e\u4f8bBISERVER\uff0c\u6570\u636e\u5e93DW_SOURCE\uff0cSchema\u5305\u62ecsales\uff0c\u7528\u6237bi_reader\uff0c\u5bc6\u7801sql789\u3002\u542f\u7528\u5206\u5e93\u5206\u8868\uff0c\u652f\u6301\u6309\u6708\u5206\u533a\u8868fact_sales_202*\u3002Doris\u76ee\u6807\u7aef\uff1aFE\u8d1f\u8f7d\u5747\u8861\u5730\u5740192.168.18.160:9030\uff0cBE\u8282\u70b9192.168.18.161-165\uff0c\u7528\u6237admin\uff0c\u5bc6\u7801doris456\uff0c\u76ee\u6807\u5e93bi_analytics\u3002\u6570\u636e\u6a21\u578b\uff1a\u4e8b\u5b9e\u8868\u4f7f\u7528Aggregate\u6a21\u578b\uff0c\u7ef4\u5ea6\u8868\u4f7f\u7528Duplicate\u6a21\u578b\u3002\u5206\u533a\u7b56\u7565\uff1a\u6309\u5929RANGE\u5206\u533a(sale_date)\uff0c\u5206\u6876\u657030\u3002StreamLoad\u4f18\u5316\uff1amaxBatchRows\u4e3a20000\uff0cmaxBatchSize\u4e3a200MB\uff0ccolumn_separator\u4e3a\\t\u3002\u5b9e\u65f6CDC\uff1aTransaction Log\u6a21\u5f0f\uff0cSnapshot\u8d77\u59cb\uff0c\u5305\u542bSchema\u53d8\u66f4\u540c\u6b65\u3002\u5e76\u884c\u5199\u5165\uff1a\u8bbe\u7f6e4\u4e2a\u5e76\u53d1\uff0c\u8fde\u63a5\u8d85\u65f660\u79d2\uff0csocket\u8d85\u65f6180\u79d2\u3002\u540e\u7f6e\u5904\u7406\uff1a\u81ea\u52a8\u521b\u5efaRollup\u7269\u5316\u89c6\u56fe\uff0c\u52a0\u901f\u805a\u5408\u67e5\u8be2\u3002\u6570\u636e\u4fdd\u7559\u7b56\u7565\uff1a\u4fdd\u7559\u6700\u8fd1365\u5929\u6570\u636e\uff0c\u81ea\u52a8\u6e05\u7406\u5386\u53f2\u5206\u533a\u3002");
        this.templates.put(sqlserverToDoris.getId(), sqlserverToDoris);
        TaskTemplate kafkaToPaimon = new TaskTemplate();
        kafkaToPaimon.setId("kafka-to-paimon");
        kafkaToPaimon.setName("Kafka\u540c\u6b65\u5230Paimon");
        kafkaToPaimon.setDescription("\u521b\u5efaKafka\u5230Paimon\u7684\u6d41\u6279\u4e00\u4f53\u6570\u636e\u6e56\u7ba1\u9053");
        kafkaToPaimon.setSourceType("kafka");
        kafkaToPaimon.setTargetType("paimon");
        kafkaToPaimon.setSampleText("\u642d\u5efaKafka\u5230Paimon\u7684\u6d41\u6279\u4e00\u4f53\u6570\u636e\u6e56\u67b6\u6784\u3002Kafka\u6e90\u7aef\uff1a\u96c6\u7fa4\u5730\u5740192.168.19.170:9092;192.168.19.171:9092;192.168.19.172:9092\uff0cTopic\u8ba2\u9605\uff1a\u5b9e\u65f6\u4ea4\u6613ods_transactions\u3001\u7528\u6237\u884c\u4e3aods_behaviors\u3001\u7cfb\u7edf\u65e5\u5fd7ods_logs\u3002\u6d88\u8d39\u7ec4streaming_lake\uff0c\u6d88\u606f\u683c\u5f0fDebezium-JSON\uff08\u652f\u6301DELETE\uff09\u3002\u5b89\u5168\u8ba4\u8bc1\uff1aSASL_SSL\u534f\u8bae\uff0cKerberos\u8ba4\u8bc1\uff0ckeytab\u6587\u4ef6\u8def\u5f84/etc/security/kafka.keytab\u3002Paimon\u914d\u7f6e\uff1aHive Metastore\u4e3a192.168.20.180:9083\uff0cHDFS\u96c6\u7fa4hdfs://namenode:8020/warehouse/streaming\uff0ccatalog\u540dstreaming_catalog\u3002\u8868\u914d\u7f6e\uff1aDynamic Bucket\u81ea\u9002\u5e94\uff0c\u521d\u59cbbucket\u657010\uff0ctarget-row-num\u4e3a100\u4e07\u3002\u5199\u5165\u6a21\u5f0fStream\uff0ccheckpoint\u95f4\u969430\u79d2\uff0cwrite-buffer\u4e3a256MB\u3002\u6587\u4ef6\u683c\u5f0fORC\uff0csnappy\u538b\u7f29\u3002Compaction\u7b56\u7565\uff1asorted-run\u89e6\u53d13\uff0c\u6587\u4ef6\u6570\u89e6\u53d15\uff0csize-ratio\u4e3a1.5\u3002Changelog\u6a21\u5f0fall\uff0c\u8bb0\u5f55\u5b8c\u6574\u53d8\u66f4\u5386\u53f2\u3002Snapshot\u4fdd\u7559\uff1a\u6700\u5c1150\u4e2a\uff0c\u6700\u591a500\u4e2a\uff0c\u65f6\u95f4\u7a97\u53e37\u5929\u3002Tag\u7ba1\u7406\uff1a\u6bcf\u5c0f\u65f6\u521b\u5efa\u4e00\u4e2atag\uff0c\u652f\u6301\u65f6\u95f4\u65c5\u884c\u67e5\u8be2\u3002\u4e0b\u6e38\u6d88\u8d39\uff1a\u540c\u65f6\u652f\u6301Flink\u6d41\u8ba1\u7b97\u548cSpark\u6279\u5904\u7406\u3002");
        this.templates.put(kafkaToPaimon.getId(), kafkaToPaimon);
        TaskTemplate mongoToClickhouse = new TaskTemplate();
        mongoToClickhouse.setId("mongodb-to-clickhouse");
        mongoToClickhouse.setName("MongoDB\u540c\u6b65\u5230Clickhouse");
        mongoToClickhouse.setDescription("\u521b\u5efaMongoDB\u5230Clickhouse\u7684\u65e5\u5fd7\u5206\u6790\u540c\u6b65\u7ba1\u9053");
        mongoToClickhouse.setSourceType("mongodb");
        mongoToClickhouse.setTargetType("clickhouse");
        mongoToClickhouse.setSampleText("\u914d\u7f6eMongoDB\u5230Clickhouse\u7684\u6d77\u91cf\u65e5\u5fd7\u5206\u6790\u7cfb\u7edf\u3002MongoDB\u6e90\u7aef\uff1a\u526f\u672c\u96c6\u5730\u5740192.168.21.190:27017;192.168.21.191:27017;192.168.21.192:27017\uff0c\u6570\u636e\u5e93log_center\uff0c\u96c6\u5408app_logs\u3001error_logs\u3001audit_logs\u3001metrics\u3002\u8ba4\u8bc1\u6570\u636e\u5e93admin\uff0c\u7528\u6237monitor\uff0c\u5bc6\u7801mongo789\u3002\u9884\u8bfb1000\u6761\u81ea\u52a8Schema\u63a8\u65ad\u3002Clickhouse\u76ee\u6807\u7aef\uff1a\u96c6\u7fa4\u5730\u5740http://192.168.22.200:8123\uff0c\u5206\u5e03\u5f0f\u8868\u914d\u7f6e\uff0c\u7528\u6237analytics\uff0c\u5bc6\u7801ch456\uff0c\u6570\u636e\u5e93logs_analysis\u3002\u8868\u5f15\u64ce\uff1a\u4f7f\u7528ReplacingMergeTree\u53bb\u91cd\uff0c\u5206\u533a\u952etoYYYYMM(log_date)\uff0c\u6392\u5e8f\u952e(log_date, level, app_id)\u3002\u6570\u636e\u8f6c\u6362\uff1aMongoDB\u7684ObjectId\u8f6cString\uff0cISODate\u8f6cDateTime\uff0c\u5d4c\u5957\u6587\u6863\u5c55\u5e73\u4e3a\u5217\u3002\u6279\u91cf\u5199\u5165\uff1abatchByteSize\u4e3a50MB\uff0cbatchSize\u4e3a20000\u3002\u5b9e\u65f6\u540c\u6b65\uff1a\u76d1\u542coplog\uff0c\u8d77\u59cbTIMESTAMP\uff08\u6700\u8fd11\u5c0f\u65f6\uff09\uff0c\u8865\u5168\u7b56\u7565UPDATE_LOOKUP\u51cf\u5c11\u4f20\u8f93\u91cf\u3002\u5e76\u884c\u5ea612\u5145\u5206\u5229\u7528\u96c6\u7fa4\u3002\u6570\u636e\u805a\u5408\uff1a\u9884\u805a\u5408\u8868\u6309\u5c0f\u65f6\u7edf\u8ba1\uff0c\u4f7f\u7528SummingMergeTree\u3002TTL\u914d\u7f6e\uff1a\u8be6\u7ec6\u65e5\u5fd7\u4fdd\u755930\u5929\uff0c\u805a\u5408\u6570\u636e\u4fdd\u75591\u5e74\u3002\u76d1\u63a7\u6307\u6807\uff1a\u6bcf\u5206\u949f\u65e5\u5fd7\u91cf\u3001\u9519\u8bef\u7387\u3001\u54cd\u5e94\u65f6\u95f4P99\u7b49\u5b9e\u65f6\u8ba1\u7b97\u3002");
        this.templates.put(mongoToClickhouse.getId(), mongoToClickhouse);
        TaskTemplate oracleToStarRocks = new TaskTemplate();
        oracleToStarRocks.setId("oracle-to-starrocks");
        oracleToStarRocks.setName("Oracle\u540c\u6b65\u5230StarRocks");
        oracleToStarRocks.setDescription("\u521b\u5efaOracle\u5230StarRocks\u7684\u5b9e\u65f6\u6570\u636e\u4ed3\u5e93\u540c\u6b65\u7ba1\u9053");
        oracleToStarRocks.setSourceType("oracle");
        oracleToStarRocks.setTargetType("starrocks");
        oracleToStarRocks.setSampleText("\u642d\u5efaOracle\u5230StarRocks\u7684\u91d1\u878d\u7ea7\u5b9e\u65f6\u6570\u4ed3\u3002Oracle\u6e90\u7aef\uff1aRAC\u96c6\u7fa4scan\u5730\u5740192.168.23.210\uff0c\u7aef\u53e31521\uff0cServiceName\u4e3aFINPROD\uff0c\u7528\u6237etl_user\uff0c\u5bc6\u7801oracle456\u3002Schema\u8303\u56f4\uff1aCORE_BANKING\u3002\u4f1a\u8bdd\u53c2\u6570\uff1aNLS_DATE_FORMAT='YYYY-MM-DD HH24:MI:SS'\uff0cNLS_TIMESTAMP_FORMAT\u5305\u542b\u65f6\u533a\u3002StarRocks\u76ee\u6807\u7aef\uff1aFE\u9ad8\u53ef\u7528\u5730\u5740192.168.24.220:9030;192.168.24.221:9030\uff0c\u7528\u6237root\uff0c\u5bc6\u7801sr789\uff0c\u6570\u636e\u5e93finance_dw\u3002\u6570\u636e\u6a21\u578b\u9009\u62e9\uff1a\u4ea4\u6613\u8868Primary Key\u6a21\u578b\uff08\u652f\u6301\u66f4\u65b0\uff09\uff0c\u5386\u53f2\u8868Duplicate\u6a21\u578b\uff08\u8ffd\u52a0\uff09\u3002\u5206\u533a\u5206\u6876\uff1aRANGE\u5206\u533a\u6309\u5929(trade_date)\uff0c\u5206\u6876\u952e(account_id)\uff0c\u6876\u657050\u3002StreamLoad\u53c2\u6570\uff1astrict_mode\u4e3atrue\u4e25\u683c\u6a21\u5f0f\uff0cmax_filter_ratio\u4e3a0\u62d2\u7edd\u810f\u6570\u636e\uff0ctimeout\u4e3a600\u79d2\u3002CDC\u914d\u7f6e\uff1aLogMiner continuous\u6a21\u5f0f\uff0c\u6355\u83b7DDL\u53d8\u66f4\uff0cLOB\u652f\u6301\uff0c\u5fc3\u8df3\u8868\u76d1\u63a7\u5ef6\u8fdf\u3002\u5199\u5165\u4f18\u5316\uff1a\u5e76\u884c\u5ea616\uff0cloadProps\u8bbe\u7f6ecolumn_separator='\\x01'\u907f\u514d\u51b2\u7a81\u3002\u7269\u5316\u89c6\u56fe\uff1a\u521b\u5efa\u591a\u4e2a\u7269\u5316\u89c6\u56fe\u52a0\u901f\u4e0d\u540c\u7ef4\u5ea6\u67e5\u8be2\u3002\u76d1\u63a7\u544a\u8b66\uff1a\u6570\u636e\u5ef6\u8fdf\u8d85\u8fc730\u79d2\u3001\u9519\u8bef\u7387\u8d85\u8fc70.1%\u89e6\u53d1\u544a\u8b66\u3002");
        this.templates.put(oracleToStarRocks.getId(), oracleToStarRocks);
        TaskTemplate pgToKafka = new TaskTemplate();
        pgToKafka.setId("postgresql-to-kafka");
        pgToKafka.setName("PostgreSQL\u540c\u6b65\u5230Kafka");
        pgToKafka.setDescription("\u521b\u5efaPostgreSQL\u5230Kafka\u7684\u4e8b\u4ef6\u9a71\u52a8\u67b6\u6784\u540c\u6b65\u7ba1\u9053");
        pgToKafka.setSourceType("postgresql");
        pgToKafka.setTargetType("kafka");
        pgToKafka.setSampleText("\u6784\u5efaPostgreSQL\u5230Kafka\u7684\u5fae\u670d\u52a1\u4e8b\u4ef6\u603b\u7ebf\u3002PostgreSQL\u6e90\u7aef\uff1a\u4e3b\u673a192.168.25.230\uff0c\u7aef\u53e35432\uff0c\u6570\u636e\u5e93microservices\uff0cSchema\u5217\u8868\uff1aorders\u3001inventory\u3001shipping\u3001payment\uff0c\u7528\u6237cdc_user\uff0c\u5bc6\u7801pg456\u3002\u9700\u8981\u9884\u88c5wal2json\u63d2\u4ef6\u652f\u6301\u3002Kafka\u76ee\u6807\u7aef\uff1a\u96c6\u7fa4192.168.26.240:9092;192.168.26.241:9092;192.168.26.242:9092\uff0cTopic\u8def\u7531\u89c4\u5219\uff1apostgres.{schema}.{table}\u3002\u6d88\u606f\u683c\u5f0fDebezium-JSON\uff0c\u5305\u542b\u5b8c\u6574Schema\u4fe1\u606f\u3002\u751f\u4ea7\u8005\u914d\u7f6e\uff1aSASL_PLAINTEXT\u8ba4\u8bc1\uff0c\u7528\u6237event_producer\uff0c\u5bc6\u7801kafka789\u3002\u53ef\u9760\u6027\uff1aACKs=-1\uff08\u5168\u90e8\u526f\u672c\u786e\u8ba4\uff09\uff0cenable.idempotence=true\uff08\u7cbe\u786e\u4e00\u6b21\uff09\u3002\u6027\u80fd\u4f18\u5316\uff1acompression.type=lz4\uff0cbatch.size=64KB\uff0clinger.ms=50\uff0cbuffer.memory=64MB\u3002CDC\u914d\u7f6e\uff1aslot\u540d\u79f0pg_to_kafka_slot\uff0cdecoder\u4f7f\u7528wal2json\uff0cpublication\u521b\u5efa\u6240\u6709\u8868\u3002\u8d77\u59cb\u4f4d\u7f6eLatest\uff0cREPLICA IDENTITY FULL\u83b7\u53d6\u5b8c\u6574before\u503c\u3002\u4e8b\u4ef6\u8fc7\u6ee4\uff1a\u53ea\u53d1\u9001INSERT\u3001UPDATE_AFTER\u3001DELETE\u4e8b\u4ef6\u3002\u5206\u533a\u7b56\u7565\uff1a\u4f7f\u7528\u4e3b\u952e\u54c8\u5e0c\u5206\u533a\u4fdd\u8bc1\u987a\u5e8f\u3002\u76d1\u63a7\u6307\u6807\uff1a\u6d88\u606f\u53d1\u9001\u901f\u7387\u3001\u5ef6\u8fdf\u3001\u79ef\u538b\u91cf\u5b9e\u65f6\u76d1\u63a7\u3002\u4e0b\u6e38\u6d88\u8d39\u8005\uff1a\u652f\u6301\u591a\u4e2a\u5fae\u670d\u52a1\u8ba2\u9605\u4e0d\u540cTopic\u5b9e\u73b0\u4e8b\u4ef6\u9a71\u52a8\u3002");
        this.templates.put(pgToKafka.getId(), pgToKafka);
    }

    public List<TaskTemplate> getAllTemplates() {
        return new ArrayList<TaskTemplate>(this.templates.values());
    }

    public TaskTemplate getTemplate(String templateId) {
        return this.templates.get(templateId);
    }

    public TaskTemplate findTemplate(String sourceType, String targetType) {
        for (TaskTemplate template : this.templates.values()) {
            if (!template.getSourceType().equalsIgnoreCase(sourceType) || !template.getTargetType().equalsIgnoreCase(targetType)) continue;
            return template;
        }
        return null;
    }

    public void registerTemplate(TaskTemplate template) {
        this.templates.put(template.getId(), template);
    }

    public static class TaskTemplate {
        private String id;
        private String name;
        private String description;
        private String sourceType;
        private String targetType;
        private String sampleText;
        private Map<String, Object> defaultConfig = new HashMap<String, Object>();

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public String getTargetType() {
            return this.targetType;
        }

        public void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public String getSampleText() {
            return this.sampleText;
        }

        public void setSampleText(String sampleText) {
            this.sampleText = sampleText;
        }

        public Map<String, Object> getDefaultConfig() {
            return this.defaultConfig;
        }

        public void setDefaultConfig(Map<String, Object> defaultConfig) {
            this.defaultConfig = defaultConfig;
        }
    }
}

