/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.aiagent.plan;

import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.aiagent.core.AgentContext;
import com.qlangtech.tis.aiagent.execute.StepExecutor;
import com.qlangtech.tis.aiagent.execute.impl.PipelineBatchExecutor;
import com.qlangtech.tis.aiagent.execute.impl.PipelineIncrExecutor;
import com.qlangtech.tis.aiagent.execute.impl.PipelineSourceSelectTabsExecutor;
import com.qlangtech.tis.aiagent.execute.impl.PluginDownloadAndInstallExecutor;
import com.qlangtech.tis.aiagent.execute.impl.PluginInstanceCreateExecutor;
import com.qlangtech.tis.aiagent.plan.TaskPlan;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TaskStep {
    private String stepId;
    private String name;
    private String description;
    private StepType type;
    private Status status = Status.PENDING;
    private String pluginImpl;
    private JSONObject pluginConfig;
    private List<TaskStep> subSteps = new ArrayList<TaskStep>();
    private String errorMessage;
    private long startTime;
    private long endTime;
    private boolean requireUserConfirm;

    public TaskStep() {
    }

    public TaskStep(String name, StepType type) {
        this();
        this.name = name;
        this.type = type;
    }

    public void addSubStep(TaskStep subStep) {
        this.subSteps.add(subStep);
    }

    public void markAsStarted() {
        this.status = Status.IN_PROGRESS;
        this.startTime = System.currentTimeMillis();
    }

    public void markAsCompleted() {
        this.status = Status.COMPLETED;
        this.endTime = System.currentTimeMillis();
    }

    public void markAsFailed(String errorMessage) {
        this.status = Status.FAILED;
        this.errorMessage = errorMessage;
        this.endTime = System.currentTimeMillis();
    }

    public void markAsSkipped() {
        this.status = Status.SKIPPED;
    }

    public String getStepId() {
        return this.stepId;
    }

    public void setStepId(String stepId) {
        this.stepId = stepId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean execute(TaskPlan plan, TaskStep step, AgentContext context) {
        return Objects.requireNonNull(this.type, "type can not be null").execute(plan, step, context);
    }

    public StepType getType() {
        return this.type;
    }

    public void setType(StepType type) {
        this.type = type;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getPluginImpl() {
        return this.pluginImpl;
    }

    public void setPluginImpl(String pluginImpl) {
        this.pluginImpl = pluginImpl;
    }

    public JSONObject getPluginConfig() {
        return this.pluginConfig;
    }

    public void setPluginConfig(JSONObject pluginConfig) {
        this.pluginConfig = pluginConfig;
    }

    public List<TaskStep> getSubSteps() {
        return this.subSteps;
    }

    public void setSubSteps(List<TaskStep> subSteps) {
        this.subSteps = subSteps;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public boolean isRequireUserConfirm() {
        return this.requireUserConfirm;
    }

    public void setRequireUserConfirm(boolean requireUserConfirm) {
        this.requireUserConfirm = requireUserConfirm;
    }

    public long getExecutionTime() {
        if (this.startTime > 0L && this.endTime > 0L) {
            return this.endTime - this.startTime;
        }
        return 0L;
    }

    public static enum StepType {
        PLUGIN_INSTALL(new PluginDownloadAndInstallExecutor()),
        PLUGIN_CREATE(new PluginInstanceCreateExecutor()),
        USER_INPUT(null),
        EXECUTE_BATCH(new PipelineBatchExecutor()),
        EXECUTE_INCR(new PipelineIncrExecutor()),
        SELECT_TABLES(new PipelineSourceSelectTabsExecutor());

        private final StepExecutor executor;

        private StepType(StepExecutor executor) {
            this.executor = executor;
        }

        public boolean execute(TaskPlan plan, TaskStep step, AgentContext context) {
            return Objects.requireNonNull(this.executor, "executor can not be null").execute(plan, step, context);
        }
    }

    public static enum Status {
        PENDING,
        IN_PROGRESS,
        COMPLETED,
        FAILED,
        SKIPPED;

    }
}

