/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.aiagent.plan;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.citrus.turbine.impl.DefaultContext;
import com.google.common.collect.ImmutableMap;
import com.qlangtech.tis.IPluginEnum;
import com.qlangtech.tis.aiagent.llm.LLMProvider;
import com.qlangtech.tis.aiagent.plan.DescribableImpl;
import com.qlangtech.tis.aiagent.plan.TaskStep;
import com.qlangtech.tis.async.message.client.consumer.impl.MQListenerFactory;
import com.qlangtech.tis.datax.impl.DataxReader;
import com.qlangtech.tis.datax.impl.DataxWriter;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.lang.PayloadLink;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.manage.IAppSource;
import com.qlangtech.tis.manage.common.MockContext;
import com.qlangtech.tis.plugin.IDataXEndTypeGetter;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.incr.TISSinkFactory;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.util.HeteroEnum;
import com.qlangtech.tis.util.UploadPluginMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;

public class TaskPlan {
    public final Map<Class<? extends Describable>, DescribableImpl> readerExtendPoints;
    public final Map<Class<? extends Describable>, DescribableImpl> writerExtendPoints;
    public final DescribableImpl processorExtendPoints;
    private MockContext runtimeContext;
    private String planId;
    private final SourceDataEndCfg sourceEnd;
    private final DataEndCfg targetEnd;
    private List<TaskStep> steps = new ArrayList<TaskStep>();
    private String userInput;
    private long createTime = System.currentTimeMillis();
    private final LLMProvider llmProvider;
    private final IControlMsgHandler controlMsgHandler;

    public Context getRuntimeContext(boolean createNew) {
        if (createNew) {
            DefaultContext ctx = new DefaultContext();
            TaskPlan.setPluginMeta((Context)ctx);
            return ctx;
        }
        if (this.runtimeContext == null) {
            this.runtimeContext = new MockContext();
            TaskPlan.setPluginMeta(this.runtimeContext);
        }
        return this.runtimeContext;
    }

    private static void setPluginMeta(Context ctx) {
        ctx.put(UploadPluginMeta.KEY_PLUGIN_META, (Object)UploadPluginMeta.create((IPluginEnum)HeteroEnum.APP_SOURCE).putExtraParams("update", Boolean.FALSE.toString()));
    }

    public void checkDescribableImplHasSet() {
        this.checkDescribableImplHasSet(this.readerExtendPoints);
        this.checkDescribableImplHasSet(this.writerExtendPoints);
    }

    private void checkDescribableImplHasSet(Map<Class<? extends Describable>, DescribableImpl> extendPoints) {
        for (DescribableImpl dImpl : extendPoints.values()) {
            if (dImpl.isIncrStreamEndType() || !CollectionUtils.isEmpty((Collection)dImpl.getImpls())) continue;
            throw TisException.create((String)(dImpl.getExtendPoint().getSimpleName() + "\uff1a" + dImpl.getEndType().map(String::valueOf).orElse("") + "\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u7684\u7aef\u76ee\u524d\u662f\u5426\u652f\u6301")).setPayloadLink(new PayloadLink("TIS\u652f\u6301\u7684\u7aef\u7c7b\u578b", "https://tis.pub/docs/plugin/source-sink/"));
        }
    }

    public TaskPlan(SourceDataEndCfg sourceEnd, DataEndCfg targetEnd, LLMProvider llmProvider, IControlMsgHandler controlMsgHandler) {
        this.llmProvider = Objects.requireNonNull(llmProvider, "llmProvider can not be null");
        this.sourceEnd = Objects.requireNonNull(sourceEnd, "sourceEnd can not be null");
        this.targetEnd = Objects.requireNonNull(targetEnd, "targetEnd can not be null");
        this.controlMsgHandler = Objects.requireNonNull(controlMsgHandler, "controlMsgHandler can not be null");
        this.processorExtendPoints = new DescribableImpl(IAppSource.class, Optional.empty()).addImpl("com.qlangtech.tis.plugin.datax.DefaultDataxProcessor");
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        mapBuilder.put(DataxReader.class, (Object)new DescribableImpl(DataxReader.class, Optional.of(sourceEnd.getType())));
        mapBuilder.put(MQListenerFactory.class, (Object)new DescribableImpl(MQListenerFactory.class, Optional.of(sourceEnd.getType())));
        this.readerExtendPoints = mapBuilder.build();
        mapBuilder = new ImmutableMap.Builder();
        mapBuilder.put(DataxWriter.class, (Object)new DescribableImpl(DataxWriter.class, Optional.of(targetEnd.getType())));
        mapBuilder.put(TISSinkFactory.class, (Object)new DescribableImpl(TISSinkFactory.class, Optional.of(targetEnd.getType())));
        this.writerExtendPoints = mapBuilder.build();
    }

    public <T> T getControlMsgHandler() {
        return (T)Objects.requireNonNull(this.controlMsgHandler, "controlMsgHandler can not be null");
    }

    public LLMProvider getLLMProvider() {
        return this.llmProvider;
    }

    public void addStep(TaskStep step) {
        this.steps.add(step);
    }

    public String getPlanId() {
        return this.planId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    public SourceDataEndCfg getSourceEnd() {
        return this.sourceEnd;
    }

    public DataEndCfg getTargetEnd() {
        return this.targetEnd;
    }

    public List<TaskStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<TaskStep> steps) {
        this.steps = steps;
    }

    public String getUserInput() {
        return this.userInput;
    }

    public void setUserInput(String userInput) {
        this.userInput = userInput;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public int getTotalSteps() {
        return this.steps != null ? this.steps.size() : 0;
    }

    public int getCompletedSteps() {
        return (int)this.steps.stream().filter(step -> step.getStatus() == TaskStep.Status.COMPLETED).count();
    }

    public static class SourceDataEndCfg
    extends DataEndCfg {
        private String extraSelectedTabInfo;
        private IAppSource processor;
        private boolean executeBatch;
        private boolean executeIncr;

        public SourceDataEndCfg(IEndTypeGetter.EndType type) {
            super(type);
        }

        public String getExtraSelectedTabInfo() {
            return this.extraSelectedTabInfo;
        }

        public void setExtraSelectedTabInfo(String info) {
            this.extraSelectedTabInfo = info;
        }

        public void setExecuteBatch(boolean val) {
            this.executeBatch = val;
        }

        public void setExecuteIncr(boolean val) {
            this.executeIncr = val;
        }

        public boolean isExecuteBatch() {
            return this.executeBatch;
        }

        public boolean isExecuteIncr() {
            return this.executeIncr;
        }

        public IAppSource getProcessor() {
            return this.processor;
        }

        public void setProcessor(IAppSource processor) {
            this.processor = processor;
        }
    }

    public static class DataEndCfg {
        private final IEndTypeGetter.EndType type;
        private IDataXEndTypeGetter endTypeMeta;
        private String relevantDesc;

        public DataEndCfg(IEndTypeGetter.EndType type) {
            this.type = type;
        }

        public IDataXEndTypeGetter getEndTypeMeta() {
            return this.endTypeMeta;
        }

        public void setEndTypeMeta(IDataXEndTypeGetter endTypeMeta) {
            this.endTypeMeta = endTypeMeta;
        }

        public IEndTypeGetter.EndType getType() {
            return this.type;
        }

        public String getRelevantDesc() {
            return this.relevantDesc;
        }

        public void setRelevantDesc(String relevantDesc) {
            this.relevantDesc = relevantDesc;
        }
    }
}

