/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.aiagent.plan;

import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.aiagent.llm.LLMProvider;
import com.qlangtech.tis.aiagent.plan.AgentTaskIntention;
import com.qlangtech.tis.aiagent.plan.TaskPlan;
import com.qlangtech.tis.aiagent.plan.TaskStep;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import java.util.Objects;

public class PlanGenerator {
    public static String KEY_INTENTION = "intention";
    public static String KEY_EXECUTE_BATCH = "execute_batch";
    public static String KEY_EXECUTE_INCR = "enable_incr";
    public static String KEY_EXECUTE_OPTION_CONFIG = "options";
    public static String KEY_SOURCE = "source";
    public static String KEY_TARGET = "target";
    public static String KEY_TYPE = "type";
    public static String KEY_EXTRACT_INFO = "extractInfo";
    private final LLMProvider llmProvider;
    private final IControlMsgHandler controlMsgHandler;

    public PlanGenerator(LLMProvider llmProvider, IControlMsgHandler controlMsgHandler) {
        this.llmProvider = llmProvider;
        this.controlMsgHandler = Objects.requireNonNull(controlMsgHandler, "controlMsgHandler can not be null");
    }

    public TaskPlan generatePlan(String userInput, JSONObject llmAnalysis) {
        AgentTaskIntention taskIntention = AgentTaskIntention.valueOf(llmAnalysis.getString(KEY_INTENTION));
        if (taskIntention != AgentTaskIntention.CreatePipeline) {
            throw TisException.create((String)("\u76ee\u524dTIS Data Pipeline Agent \u4e0d\u652f\u6301\u975e" + String.valueOf((Object)AgentTaskIntention.CreatePipeline) + "\u7684\u4efb\u52a1"));
        }
        JSONObject source = llmAnalysis.getJSONObject(KEY_SOURCE);
        JSONObject target = llmAnalysis.getJSONObject(KEY_TARGET);
        JSONObject options = llmAnalysis.getJSONObject(KEY_EXECUTE_OPTION_CONFIG);
        TaskPlan.SourceDataEndCfg sourceEnd = new TaskPlan.SourceDataEndCfg(PlanGenerator.parseEndType(source));
        sourceEnd.setRelevantDesc(source.getString(KEY_EXTRACT_INFO));
        sourceEnd.setExtraSelectedTabInfo(source.getString("selectedTabs"));
        if (options != null) {
            sourceEnd.setExecuteBatch(options.getBooleanValue(KEY_EXECUTE_BATCH));
            sourceEnd.setExecuteIncr(options.getBooleanValue(KEY_EXECUTE_INCR));
        }
        TaskPlan.DataEndCfg targetEnd = new TaskPlan.DataEndCfg(PlanGenerator.parseEndType(target));
        targetEnd.setRelevantDesc(target.getString(KEY_EXTRACT_INFO));
        TaskPlan plan = new TaskPlan(sourceEnd, targetEnd, this.llmProvider, this.controlMsgHandler);
        plan.setUserInput(userInput);
        this.generateGenericPlan(plan, llmAnalysis);
        return plan;
    }

    private static IEndTypeGetter.EndType parseEndType(JSONObject target) {
        String type = target.getString(KEY_TYPE);
        IEndTypeGetter.EndType endType = IEndTypeGetter.EndType.parse((String)type, (boolean)false, (boolean)false);
        if (endType == null) {
            throw TisException.create((String)("TIS\u76ee\u524d\u4e0d\u652f\u6301\u7aef\u7c7b\u578b\uff1a'" + type + "' "));
        }
        return endType;
    }

    private void generateMySQLToPaimonPlan(TaskPlan plan, JSONObject options) {
        TaskStep installStep = new TaskStep("\u68c0\u67e5\u5e76\u5b89\u88c5\u5fc5\u8981\u63d2\u4ef6", TaskStep.StepType.PLUGIN_INSTALL);
        installStep.setDescription("\u68c0\u67e5" + plan.getSourceEnd() + " Reader\u548c" + plan.getTargetEnd() + " Writer\u63d2\u4ef6\u662f\u5426\u5df2\u5b89\u88c5");
        plan.addStep(installStep);
        TaskStep mysqlDsStep = new TaskStep("\u521b\u5efaMySQL\u6570\u636e\u6e90", TaskStep.StepType.PLUGIN_CREATE);
        mysqlDsStep.setPluginImpl("com.qlangtech.tis.plugin.ds.mysql.MySQLV5DataSourceFactory");
        mysqlDsStep.setDescription("\u914d\u7f6eMySQL\u6570\u636e\u6e90\u8fde\u63a5\u4fe1\u606f");
        JSONObject mysqlDsConfig = new JSONObject();
        mysqlDsStep.setPluginConfig(mysqlDsConfig);
        plan.addStep(mysqlDsStep);
        TaskStep mysqlReaderStep = new TaskStep("\u521b\u5efaMySQL Reader", TaskStep.StepType.PLUGIN_CREATE);
        mysqlReaderStep.setPluginImpl("com.qlangtech.tis.plugin.datax.DataxMySQLReader");
        mysqlReaderStep.setDescription("\u914d\u7f6eMySQL\u6570\u636e\u8bfb\u53d6\u5668");
        JSONObject readerConfig = new JSONObject();
        mysqlReaderStep.setPluginConfig(readerConfig);
        plan.addStep(mysqlReaderStep);
        TaskStep hdfsStep = new TaskStep("\u914d\u7f6eHDFS\u8d44\u6e90", TaskStep.StepType.PLUGIN_CREATE);
        hdfsStep.setPluginImpl("com.qlangtech.tis.hdfs.impl.HdfsFileSystemFactory");
        hdfsStep.setDescription("\u914d\u7f6eHDFS\u6587\u4ef6\u7cfb\u7edf");
        plan.addStep(hdfsStep);
        TaskStep hiveDsStep = new TaskStep("\u521b\u5efaHive\u6570\u636e\u6e90", TaskStep.StepType.PLUGIN_CREATE);
        hiveDsStep.setPluginImpl("com.qlangtech.tis.hive.Hiveserver2DataSourceFactory");
        hiveDsStep.setDescription("\u914d\u7f6eHive MetaStore\u8fde\u63a5");
        JSONObject hiveConfig = new JSONObject();
        hiveDsStep.setPluginConfig(hiveConfig);
        plan.addStep(hiveDsStep);
        TaskStep paimonWriterStep = new TaskStep("\u521b\u5efaPaimon Writer", TaskStep.StepType.PLUGIN_CREATE);
        paimonWriterStep.setPluginImpl("com.qlangtech.tis.plugin.paimon.datax.DataxPaimonWriter");
        paimonWriterStep.setDescription("\u914d\u7f6ePaimon\u6570\u636e\u5199\u5165\u5668");
        plan.addStep(paimonWriterStep);
        TaskStep selectTablesStep = new TaskStep("\u9009\u62e9\u540c\u6b65\u8868", TaskStep.StepType.SELECT_TABLES);
        selectTablesStep.setDescription("\u9009\u62e9\u9700\u8981\u540c\u6b65\u7684\u6570\u636e\u8868");
        selectTablesStep.setRequireUserConfirm(true);
        plan.addStep(selectTablesStep);
        if (options != null && options.getBooleanValue("execute_batch")) {
            TaskStep batchStep = new TaskStep("\u6267\u884c\u6279\u91cf\u5386\u53f2\u6570\u636e\u540c\u6b65", TaskStep.StepType.EXECUTE_BATCH);
            batchStep.setDescription("\u540c\u6b65\u5386\u53f2\u5b58\u91cf\u6570\u636e");
            plan.addStep(batchStep);
        }
        if (options != null && options.getBooleanValue("enable_incr")) {
            TaskStep binlogStep = new TaskStep("\u914d\u7f6eMySQL Binlog\u76d1\u542c", TaskStep.StepType.PLUGIN_CREATE);
            binlogStep.setPluginImpl("com.qlangtech.tis.plugins.incr.flink.cdc.mysql.FlinkCDCMySQLSourceFactory");
            binlogStep.setDescription("\u914d\u7f6eMySQL\u5b9e\u65f6\u53d8\u66f4\u6570\u636e\u6355\u83b7");
            plan.addStep(binlogStep);
            TaskStep paimonIncrStep = new TaskStep("\u914d\u7f6ePaimon\u5b9e\u65f6\u5199\u5165", TaskStep.StepType.PLUGIN_CREATE);
            paimonIncrStep.setPluginImpl("com.qlangtech.tis.plugins.incr.flink.pipeline.paimon.sink.PaimonPipelineSinkFactory");
            paimonIncrStep.setDescription("\u914d\u7f6ePaimon\u5b9e\u65f6\u6570\u636e\u5199\u5165");
            plan.addStep(paimonIncrStep);
            TaskStep startIncrStep = new TaskStep("\u542f\u52a8\u589e\u91cf\u540c\u6b65\u4efb\u52a1", TaskStep.StepType.EXECUTE_INCR);
            startIncrStep.setDescription("\u542f\u52a8\u5b9e\u65f6\u589e\u91cf\u6570\u636e\u540c\u6b65");
            plan.addStep(startIncrStep);
        }
    }

    private void generateGenericPlan(TaskPlan plan, JSONObject llmAnalysis) {
        TaskStep installStep = new TaskStep("\u68c0\u67e5\u5e76\u5b89\u88c5\u5fc5\u8981\u63d2\u4ef6", TaskStep.StepType.PLUGIN_INSTALL);
        plan.addStep(installStep);
        TaskStep readerStep = new TaskStep("\u521b\u5efa\u6570\u636e\u6e90Reader\u3001Writer\u63d2\u4ef6\u5b9e\u4f8b", TaskStep.StepType.PLUGIN_CREATE);
        readerStep.setDescription("\u914d\u7f6e\u6e90\u7aef\u6570\u636e\u8bfb\u53d6\u5668\u53ca\u5199\u5165\u5668");
        plan.addStep(readerStep);
        TaskStep executeStep = new TaskStep("\u6267\u884c\u6570\u636e\u540c\u6b65", TaskStep.StepType.EXECUTE_BATCH);
        executeStep.setDescription("\u6267\u884c\u6570\u636e\u540c\u6b65\u4efb\u52a1");
        plan.addStep(executeStep);
        TaskStep incrStep = new TaskStep("\u589e\u91cf\u5b9e\u65f6\u6570\u636e\u540c\u6b65\u542f\u52a8", TaskStep.StepType.EXECUTE_INCR);
        incrStep.setDescription("\u6784\u5efa\u589e\u91cf\u5b9e\u65f6\u6570\u636e\u540c\u6b65\u901a\u9053");
        plan.addStep(incrStep);
    }
}

