/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.aiagent.core;

import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.aiagent.core.AgentContext;
import com.qlangtech.tis.aiagent.core.IAgentContext;
import com.qlangtech.tis.aiagent.llm.LLMProvider;
import com.qlangtech.tis.aiagent.llm.UserPrompt;
import com.qlangtech.tis.aiagent.plan.AgentTaskIntention;
import com.qlangtech.tis.aiagent.plan.PlanGenerator;
import com.qlangtech.tis.aiagent.plan.TaskPlan;
import com.qlangtech.tis.aiagent.plan.TaskStep;
import com.qlangtech.tis.aiagent.template.TaskTemplateRegistry;
import com.qlangtech.tis.lang.PayloadLink;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TISPlanAndExecuteAgent {
    private static final Logger logger = LoggerFactory.getLogger(TISPlanAndExecuteAgent.class);
    private final AgentContext context;
    private final LLMProvider llmProvider;
    private final PlanGenerator planGenerator;
    private final TaskTemplateRegistry templateRegistry;
    private IControlMsgHandler controlMsgHandler;

    public TISPlanAndExecuteAgent(AgentContext context, LLMProvider llmProvider, IControlMsgHandler controlMsgHandler) {
        this.context = context;
        this.llmProvider = Objects.requireNonNull(llmProvider, "llmProvider can not be null");
        this.controlMsgHandler = controlMsgHandler;
        this.planGenerator = new PlanGenerator(llmProvider, this.controlMsgHandler);
        this.templateRegistry = new TaskTemplateRegistry();
    }

    public void execute(String userInput) {
        TaskPlan plan = this.generatePlan(userInput);
        if (plan == null || plan.getSteps().isEmpty()) {
            this.context.sendError("\u62b1\u6b49\uff0c\u6211\u65e0\u6cd5\u7406\u89e3\u60a8\u7684\u9700\u6c42\uff0c\u8bf7\u91cd\u65b0\u63cf\u8ff0\u3002", new PayloadLink[0]);
            return;
        }
        this.context.sendMessage(String.format("\u6211\u5df2\u7ecf\u7406\u89e3\u60a8\u7684\u9700\u6c42\uff1a\u4ece%s\u540c\u6b65\u5230%s\u3002\u73b0\u5728\u5f00\u59cb\u6267\u884c...", plan.getSourceEnd().getType(), plan.getTargetEnd().getType()), new PayloadLink[0]);
        this.executePlan(plan);
    }

    TaskPlan generatePlan(String userInput) {
        try {
            String systemPrompt = this.buildSystemPrompt();
            String prompt = this.buildUserPrompt(userInput);
            LLMProvider.LLMResponse response = this.llmProvider.chatJson((IAgentContext)Objects.requireNonNull(this.context, "context can not be null"), new UserPrompt("\u60a8\u597d\uff01\u6211\u6b63\u5728\u5206\u6790\u60a8\u7684\u9700\u6c42...", prompt), Collections.singletonList(systemPrompt), this.getPlanSchema());
            if (!response.isSuccess()) {
                throw new IllegalStateException("LLM call failed: " + response.getErrorMessage());
            }
            JSONObject planJson = response.getJsonContent();
            if (planJson == null) {
                logger.error("Failed to parse LLM response plan");
                return null;
            }
            TaskPlan plan = this.planGenerator.generatePlan(userInput, planJson);
            plan.setPlanId(UUID.randomUUID().toString());
            return plan;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private void executePlan(TaskPlan plan) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean executeStep(TaskPlan plan, TaskStep step) {
        return step.execute(plan, step, this.context);
    }

    private String waitForUserInput(String fieldId, int timeoutSeconds) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return "yes";
    }

    private String buildSystemPrompt() {
        Set dataEnds = IEndTypeGetter.EndType.getDataEnds();
        String supportedDataEnds = dataEnds.stream().map(end -> {
            Optional desc = end.getDesc();
            StringBuilder endDesc = new StringBuilder(String.valueOf(end));
            desc.ifPresent(d -> endDesc.append("(").append((String)d).append(")"));
            return endDesc.toString();
        }).collect(Collectors.joining("\uff0c"));
        return "\u4f60\u662fTIS\u6570\u636e\u96c6\u6210\u5e73\u53f0\u7684\u667a\u80fd\u52a9\u624b\u3002\u4f60\u7684\u4efb\u52a1\u662f\u5e2e\u52a9\u7528\u6237\u521b\u5efa\u6570\u636e\u540c\u6b65\u7ba1\u9053\u3002\nTIS\u652f\u6301\u591a\u79cd\u6570\u636e\u6e90\uff0c\u679a\u4e3e\u7aef\u7c7b\u578b\u4e3a\uff1a" + supportedDataEnds + "\uff0c\u8bf7\u6839\u636e\u7528\u6237\u7684\u63cf\u8ff0\uff0c\u8bc6\u522b\u6e90\u7aef\u548c\u76ee\u6807\u7aef\u7684\u7c7b\u578b\u3002\u73b0\u5728\u667a\u80fd\u5e73\u53f0\u63a5\u53d7\u7528\u6237\u63d0\u4ea4\u4efb\u52a1\uff0c\u9700\u8981\u8bc6\u522b\u4efb\u52a1\u610f\u56fe\u5bf9\u5e94\u8f93\u51fajson\u7ed3\u679c\u4e2d\u7684'" + PlanGenerator.KEY_INTENTION + "'\u5b57\u6bb5\uff0c\u4ed6\u662f\u4e00\u4e2a\u679a\u4e3e\u7c7b\u578b\uff0c\u652f\u6301\u7684\u503c\u4e3a\uff1a" + Arrays.stream(AgentTaskIntention.values()).map(String::valueOf).collect(Collectors.joining(","));
    }

    private String buildUserPrompt(String userInput) {
        return String.format("\u7528\u6237\u9700\u6c42\uff1a%s\n\n\u8bf7\u5206\u6790\u4e0a\u8ff0\u9700\u6c42\uff0c\u8bc6\u522b\u6570\u636e\u540c\u6b65\u7684\u6e90\u7aef\u548c\u76ee\u6807\u7aef\u7c7b\u578b\uff0c\u5e76\u63d0\u53d6\u914d\u7f6e\u53c2\u6570\u3002", userInput);
    }

    private String getPlanSchema() {
        return "{\n  \"" + PlanGenerator.KEY_INTENTION + "\":\"string\u7c7b\u578b\",\n  \"" + PlanGenerator.KEY_SOURCE + "\": {\"" + PlanGenerator.KEY_TYPE + "\":\"string,\u503c\u5fc5\u987b\u4e3a\u7cfb\u7edf\u63d0\u793a\u8bcd\u4e2d\u679a\u4e3e\u5230\u7684\u7aef\u7c7b\u578b\u5173\u952e\u8bcd\uff0c\u5927\u5c0f\u5199\u5fc5\u987b\u4e00\u81f4\",\"" + PlanGenerator.KEY_EXTRACT_INFO + "\":\"\u7c7b\u578b\u4e3astring\uff0c\u4ece\u7528\u6237\u63d0\u4f9b\u7684\u6570\u636e\u901a\u9053\u4efb\u52a1\u63cf\u8ff0\u4fe1\u606f\u4e2d\u62bd\u53d6\u6e90\u7aef\u76f8\u5173\u7684\u63cf\u8ff0\u4fe1\u606f\",\"selectedTabs\":\"\u7c7b\u578b\u4e3astring\uff0c\u4ece\u7528\u6237\u63d0\u4f9b\u7684\u6570\u636e\u901a\u9053\u4efb\u52a1\u63cf\u8ff0\u4fe1\u606f\u4e2d\u62bd\u53d6\u6e90\u7aef\u76f8\u5173\u7684\u4fe1\u606f\uff08\u5982\uff1a\u2018\u9664AA\u3001BB\u8868\u4ee5\u5916\u7684\u6240\u6709\u8868\u2019\uff0c\u2018\u524d\u7f00\u4e3auser\u7684\u8868\u2019\uff0c\u2018AA\uff0cBB\u2019\uff09,\u5982\u4e0d\u80fd\u62bd\u53d6\u5f97\u5230\u5219\u8bbe\u7f6e\u4e3a\u7a7a\u5b57\u7b26\u4e32\"} ,\n  \"" + PlanGenerator.KEY_TARGET + "\": {\"" + PlanGenerator.KEY_TYPE + "\":\"string,\u503c\u5fc5\u987b\u4e3a\u7cfb\u7edf\u63d0\u793a\u8bcd\u4e2d\u679a\u4e3e\u5230\u7684\u7aef\u7c7b\u578b\u5173\u952e\u8bcd\uff0c\u5927\u5c0f\u5199\u5fc5\u987b\u4e00\u81f4\",\"" + PlanGenerator.KEY_EXTRACT_INFO + "\":\"\u7c7b\u578b\u4e3astring\uff0c\u4ece\u7528\u6237\u63d0\u4f9b\u7684\u6570\u636e\u901a\u9053\u4efb\u52a1\u63cf\u8ff0\u4fe1\u606f\u4e2d\u62bd\u53d6\u76ee\u6807\u7aef\u76f8\u5173\u7684\u63cf\u8ff0\u4fe1\u606f\"} ,\n  \"" + PlanGenerator.KEY_EXECUTE_OPTION_CONFIG + "\": {\n    \"" + PlanGenerator.KEY_EXECUTE_BATCH + "\": \"\u7c7b\u578b\u4e3aboolean\uff0c\u8868\u660e\u6570\u636e\u7ba1\u9053\u521b\u5efa\u5b8c\u6210\u4e4b\u540e\u662f\u5426\u7acb\u5373\u89e6\u53d1\u5168\u91cf\u6570\u636e\u540c\u6b65\uff0c\u9ed8\u8ba4\u4e3afalse\",\n    \"" + PlanGenerator.KEY_EXECUTE_INCR + "\": \"\u7c7b\u578b\u4e3aboolean\uff0c\u8868\u660e\u6570\u636e\u7ba1\u9053\u521b\u5efa\u5b8c\u6210\u540e\u662f\u5426\u7acb\u5373\u542f\u52a8\u589e\u91cf\u4e8b\u5b9e\u540c\u6b65\uff0c\u9ed8\u8ba4\u4e3afalse\"\n  }\n}";
    }
}

