/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.aiagent.core;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.IPluginEnum;
import com.qlangtech.tis.aiagent.core.IAgentContext;
import com.qlangtech.tis.aiagent.core.ISessionData;
import com.qlangtech.tis.aiagent.core.PluginPropsComplement;
import com.qlangtech.tis.aiagent.core.RequestKey;
import com.qlangtech.tis.aiagent.core.SelectionOptions;
import com.qlangtech.tis.aiagent.llm.LLMProvider;
import com.qlangtech.tis.aiagent.plan.DescribableImpl;
import com.qlangtech.tis.aiagent.sessiondata.ColsMetaSetterSessionData;
import com.qlangtech.tis.aiagent.sessiondata.TableSelectApplySessionData;
import com.qlangtech.tis.datax.job.SSEEventWriter;
import com.qlangtech.tis.datax.job.SSERunnable;
import com.qlangtech.tis.extension.model.UpdateCenter;
import com.qlangtech.tis.extension.util.PluginExtraProps;
import com.qlangtech.tis.lang.PayloadLink;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.manage.common.valve.AjaxValve;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.trigger.util.JsonUtil;
import com.qlangtech.tis.util.AttrValMap;
import com.qlangtech.tis.util.DescriptorsJSON;
import com.qlangtech.tis.util.HeteroList;
import com.qlangtech.tis.util.UploadPluginMeta;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class AgentContext
implements IAgentContext {
    public static final String KEY_REQUEST_ID = "requestId";
    public static final String KEY_CONTENT_DETAIL = "content";
    public static final String KEY_VALIDATE_PLUGIN_ATTR_VALS = "config";
    public static final long maxWaitMillis = 300000L;
    private final String sessionId;
    private final SSEEventWriter sseWriter;
    private final Map<String, ISessionData> sessionData;
    private final AtomicLong tokenCount;
    private volatile boolean cancelled = false;
    private final Map<String, Object> selectionLocks = new ConcurrentHashMap<String, Object>();
    private static final String KEY_PAYLOAD_LINK = "payloadLink";

    public AgentContext(String sessionId, SSEEventWriter sseWriter) {
        this.sessionId = sessionId;
        this.sseWriter = sseWriter;
        this.sessionData = new HashMap<String, ISessionData>();
        this.tokenCount = new AtomicLong(0L);
    }

    public SSEEventWriter getSseWriter() {
        return this.sseWriter;
    }

    public void sendMessage(String message, PayloadLink ... link) {
        if (!this.cancelled && this.sseWriter != null) {
            JSONObject data = new JSONObject();
            data.put("type", (Object)"text");
            data.put(KEY_CONTENT_DETAIL, (Object)message);
            PayloadLink[] payloadLinkArray = link;
            int n = payloadLinkArray.length;
            int n2 = 0;
            if (n2 < n) {
                PayloadLink l = payloadLinkArray[n2];
                data.put(KEY_PAYLOAD_LINK, (Object)l);
            }
            this.sendSSEEvent(SSERunnable.SSEEventType.AI_AGNET_MESSAGE, JsonUtil.toString((Object)data, (boolean)false));
        }
    }

    public void sendPluginInstallStatus(RequestKey requestKey, List<UpdateCenter.UpdateCenterJob> installJobs, boolean complete) {
        if (!this.cancelled && this.sseWriter != null) {
            JSONObject data = new JSONObject();
            data.put(KEY_REQUEST_ID, (Object)requestKey.getSessionKey());
            data.put("installJobs", installJobs);
            data.put("complete", (Object)complete);
            this.sendSSEEvent(SSERunnable.SSEEventType.AI_AGNET_PLUGIN_INSTALL_STATUS, JsonUtil.toString((Object)data, (boolean)false));
        }
    }

    public void sendOpenColsMetaSetter(RequestKey requestId, IdentityName pipeline, AjaxValve.ActionExecResult execResult, Map<String, Object> colsMetaViewBiz) {
        if (MapUtils.isEmpty(colsMetaViewBiz)) {
            throw new IllegalArgumentException("param colsMetaViewBiz can not be empty");
        }
        if (!this.cancelled && this.sseWriter != null) {
            JSONObject data = new JSONObject();
            data.put(KEY_REQUEST_ID, (Object)requestId.getSessionKey());
            data.put(KEY_CONTENT_DETAIL, (Object)execResult.createErrors());
            data.put("colsMetaViewBiz", colsMetaViewBiz);
            data.put("dataxName", (Object)pipeline.identityValue());
            this.setSessionData(requestId, new ColsMetaSetterSessionData(pipeline));
            this.sendSSEEvent(SSERunnable.SSEEventType.AI_AGNET_TDFS_COLS_META_SETTER, JsonUtil.toString((Object)data, (boolean)false));
        }
    }

    public void sendTableSelectApply(RequestKey requestId, String reasonDetail, IdentityName pipeline, DescribableImpl dataXReaderImpl) throws Exception {
        if (!this.cancelled && this.sseWriter != null) {
            JSONObject data = new JSONObject();
            data.put(KEY_REQUEST_ID, (Object)requestId.getSessionKey());
            data.put("dataxName", (Object)Objects.requireNonNull(pipeline, "pipeline can not be null").identityValue());
            if (StringUtils.isEmpty((CharSequence)reasonDetail)) {
                throw new IllegalArgumentException("reasonDetail can not be empty");
            }
            data.put(KEY_CONTENT_DETAIL, (Object)reasonDetail);
            data.put("dataXReaderDesc", (Object)new DescriptorsJSON(dataXReaderImpl.getImplDesc()).getDescriptorsJSON());
            this.setSessionData(requestId, new TableSelectApplySessionData());
            this.sendSSEEvent(SSERunnable.SSEEventType.AI_AGNET_SELECT_TABLE, data);
        }
    }

    public void sendPluginConfig(RequestKey requestId, AjaxValve.ActionExecResult validateResult, IPluginEnum pluginEnum, String pluginImpl, AttrValMap valMap) throws Exception {
        if (!this.cancelled && this.sseWriter != null) {
            if (validateResult == null) {
                throw new IllegalArgumentException("reasonDetail can not be empty");
            }
            JSONObject data = new JSONObject();
            data.put("type", (Object)"plugin");
            data.put("impl", (Object)pluginImpl);
            JSONArray items = new JSONArray();
            items.add((Object)valMap.getPostJsonBody());
            UploadPluginMeta pmeta = UploadPluginMeta.create((IPluginEnum)pluginEnum);
            HeteroList heteroList = pmeta.createEmptyItemAndDescriptorsHetero();
            heteroList.setDescriptors(Collections.singletonList(valMap.descriptor));
            data.put(KEY_VALIDATE_PLUGIN_ATTR_VALS, (Object)heteroList.toJSON(items));
            data.put(KEY_REQUEST_ID, (Object)requestId.getSessionKey());
            this.setSessionData(requestId, new PluginPropsComplement(valMap));
            JSONObject errors = validateResult.createErrors();
            data.put(KEY_CONTENT_DETAIL, (Object)errors);
            this.sendSSEEvent(SSERunnable.SSEEventType.AI_AGNET_PLUGIN, data);
        }
    }

    public void requestUserSelection(RequestKey requestId, String prompt, Optional<IEndTypeGetter.EndType> endType, List<PluginExtraProps.CandidatePlugin> candidatePlugins) {
        if (!this.cancelled && this.sseWriter != null) {
            JSONObject optionsData = new JSONObject();
            JSONArray optionsArray = PluginExtraProps.CandidatePlugin.convertOptionsArray(endType, candidatePlugins);
            optionsData.put("candidates", (Object)optionsArray);
            JSONObject data = new JSONObject();
            data.put("type", (Object)"selection_request");
            data.put(KEY_REQUEST_ID, (Object)requestId.getSessionKey());
            data.put("prompt", (Object)prompt);
            data.put("options", (Object)optionsData);
            this.setSessionData(requestId, SelectionOptions.createUnSelectedOptions(candidatePlugins));
            this.sendSSEEvent(SSERunnable.SSEEventType.AI_AGNET_SELECTION_REQUEST, data);
        }
    }

    public void sendProgress(String taskName, int current, int total) {
        if (!this.cancelled && this.sseWriter != null) {
            JSONObject data = new JSONObject();
            data.put("type", (Object)"progress");
            data.put("task", (Object)taskName);
            data.put("current", (Object)current);
            data.put("total", (Object)total);
            this.sendSSEEvent(SSERunnable.SSEEventType.AI_AGNET_PROGRESS, data.toJSONString());
        }
    }

    public void updateTokenUsage(long tokens) {
        this.tokenCount.addAndGet(tokens);
        if (!this.cancelled && this.sseWriter != null) {
            JSONObject data = new JSONObject();
            data.put("type", (Object)"token");
            data.put("count", (Object)this.tokenCount.get());
            this.sendSSEEvent(SSERunnable.SSEEventType.AI_AGNET_TOKEN, data.toJSONString());
        }
    }

    public void sendLLMStatus(LLMProvider.LLMChatPhase llmChatPhase, String detailInfo) {
        if (!this.cancelled && this.sseWriter != null) {
            JSONObject data = new JSONObject();
            if (StringUtils.isNotEmpty((CharSequence)detailInfo)) {
                data.put("detail", (Object)detailInfo);
            }
            data.put("status", (Object)llmChatPhase);
            this.sendSSEEvent(SSERunnable.SSEEventType.AI_AGNET_LLM_CHAT_STATUS, JsonUtil.toString((Object)data, (boolean)false));
        }
    }

    public void sendError(String error, PayloadLink ... link) {
        if (!this.cancelled && this.sseWriter != null) {
            JSONObject data = new JSONObject();
            data.put("type", (Object)"error");
            data.put("message", (Object)error);
            PayloadLink[] payloadLinkArray = link;
            int n = payloadLinkArray.length;
            int n2 = 0;
            if (n2 < n) {
                PayloadLink l = payloadLinkArray[n2];
                data.put(KEY_PAYLOAD_LINK, (Object)l);
            }
            this.sendSSEEvent(SSERunnable.SSEEventType.AI_AGNET_ERROR, JsonUtil.toString((Object)data, (boolean)false));
        }
    }

    public void requestUserInput(String prompt, String field) {
        if (!this.cancelled && this.sseWriter != null) {
            JSONObject data = new JSONObject();
            data.put("type", (Object)"input_request");
            data.put("prompt", (Object)prompt);
            data.put("field", (Object)field);
            this.sendSSEEvent(SSERunnable.SSEEventType.AI_AGENT_INPUT_REQUEST, data.toJSONString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUserSelectionSubmitted(RequestKey requestId) {
        Object lock = this.selectionLocks.get(requestId.getSessionKey());
        if (lock != null) {
            Object object = lock;
            synchronized (object) {
                lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <ChatSessionData extends ISessionData> ChatSessionData waitForUserPost(RequestKey requestId, Predicate<ChatSessionData> predicate) {
        Object lock = this.selectionLocks.computeIfAbsent(requestId.getSessionKey(), k -> new Object());
        try {
            Object object = lock;
            synchronized (object) {
                long startTime = System.currentTimeMillis();
                while (!this.cancelled) {
                    Object selection = this.getSessionData(requestId);
                    if (predicate.test(selection)) {
                        this.sessionData.remove(requestId.getSessionKey());
                        Object t = selection;
                        return (ChatSessionData)t;
                    }
                    long elapsedTime = System.currentTimeMillis() - startTime;
                    long remainingTime = 300000L - elapsedTime;
                    if (remainingTime <= 0L) {
                        throw TisException.create((String)"\u64cd\u4f5c\u5df2\u7ecf\u8d85\u65f6");
                    }
                    try {
                        lock.wait(remainingTime);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw TisException.create((String)"\u5df2\u7ecf\u53d6\u6d88\u6b64\u6b21\u64cd\u4f5c", (Throwable)e);
                    }
                }
                return null;
            }
        }
        finally {
            this.selectionLocks.remove(requestId);
        }
    }

    private void sendSSEEvent(SSERunnable.SSEEventType event, JSONObject data) {
        this.sseWriter.writeSSEEvent(event, data);
    }

    private void sendSSEEvent(SSERunnable.SSEEventType event, String data) {
        this.sseWriter.writeSSEEvent(event, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.cancelled = true;
        Iterator<Object> iterator = this.selectionLocks.values().iterator();
        while (iterator.hasNext()) {
            Object lock;
            Object object = lock = iterator.next();
            synchronized (object) {
                lock.notifyAll();
            }
        }
        this.selectionLocks.clear();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionData(RequestKey requestId, ISessionData value) {
        this.sessionData.put(Objects.requireNonNull(requestId).getSessionKey(), value);
    }

    public <T extends ISessionData> T getSessionData(RequestKey selectedKey) {
        return (T)Objects.requireNonNull(this.sessionData.get(selectedKey.getSessionKey()), "key:" + selectedKey + " relevant instance can not be null");
    }

    public long getTokenCount() {
        return this.tokenCount.get();
    }
}

