/*
 * Decompiled with CFR 0.152.
 */
package com.koubei.web.tag.pager.k2;

import com.koubei.web.tag.pager.AbstractPageNumShowRule;
import com.koubei.web.tag.pager.AroundTag;
import com.koubei.web.tag.pager.FormtDirectJump;
import com.koubei.web.tag.pager.GlobalStyleFactory;
import com.koubei.web.tag.pager.Pager;
import com.koubei.web.tag.pager.k2.K2AroundTag;

public class K2StyleFactory
extends GlobalStyleFactory {
    private final K2AroundTag aroundTag;
    private boolean havePageStatistics;

    public K2StyleFactory(Pager pager, K2AroundTag aroundTag) {
        this(pager, aroundTag, false);
    }

    public K2StyleFactory(Pager pager, K2AroundTag aroundTag, boolean havePageStatistics) {
        super(pager);
        this.aroundTag = aroundTag;
        this.havePageStatistics = havePageStatistics;
    }

    @Override
    public Pager.DirectJump getDirectJump() {
        if (this.aroundTag.isContainForm()) {
            return new FormtDirectJump(this.getPager(), new FormtDirectJump.DirectJumpCss("jump", "jump-inp", "submit", "option"));
        }
        return NULL_DIRECT_JUMP;
    }

    @Override
    public Pager.PageStatistics getPageStatistics() {
        if (!this.havePageStatistics) {
            return NULL_PAGE_STSTISTICS;
        }
        return new Pager.PageStatistics(){

            @Override
            public void build(StringBuffer builder, int page, int pageCount) {
                builder.append("<span class=\"sum\">\u7b2c<b>").append(page).append("</b>").append("/").append(pageCount).append("\u9875</span>");
            }
        };
    }

    @Override
    public Pager.PageNumShowRule getPageNumShowRule() {
        return new AbstractPageNumShowRule.PageNumShowRule20101203("<span class=\"more\">...</span>");
    }

    @Override
    public Pager.NavigationStyle getNaviagationStyle() {
        return new GlobalStyleFactory.NavigationStyle20101203(){

            @Override
            public AroundTag getAroundStyle() {
                return K2StyleFactory.this.aroundTag;
            }

            @Override
            public String getCurrentPageTag(int page) {
                return "<strong class=\"current\">" + page + "</strong>";
            }

            @Override
            public void popNextPageLink(StringBuffer pageHtml, int page) {
                this.popDivHreLink(pageHtml, page, "\u4e0b\u4e00\u9875", "next");
            }

            @Override
            public void popPerPageLink(StringBuffer pageHtml, int page) {
                this.popDivHreLink(pageHtml, page, "\u4e0a\u4e00\u9875", "pre");
            }
        };
    }
}

