/*
 * Decompiled with CFR 0.152.
 */
package com.koubei.web.tag.pager;

import com.koubei.web.tag.pager.AroundTag;
import com.koubei.web.tag.pager.LinkBuilder;
import com.koubei.web.tag.pager.Offset;
import com.koubei.web.tag.pager.PagerDTO;
import com.koubei.web.tag.pager.StyleFactory;
import com.koubei.web.tag.pager.util.DefaultStaticTool;
import com.koubei.web.tag.pager.util.StaticTool;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class Pager {
    private StaticTool staticTool = new DefaultStaticTool();
    private final LinkBuilder linkBuilder;
    private String schema;
    private int curPage = 1;
    private int rowsPerPage = 20;
    private int totalCount;

    public void setStaticTool(StaticTool staticTool) {
        this.staticTool = staticTool;
    }

    public LinkBuilder getLinkBuilder() {
        return this.linkBuilder;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public Pager(LinkBuilder builder) {
        this.linkBuilder = builder;
    }

    public int getTotalPage() {
        int totalPage = this.getTotalCount() / this.getRowsPerPage();
        if (this.getTotalCount() % this.getRowsPerPage() != 0) {
            ++totalPage;
        }
        return totalPage;
    }

    public String getUrl(int page) {
        return this.staticTool.process(this.linkBuilder.getPageUrl(page).toString());
    }

    public String getCurrentPageUrl() {
        return this.getUrl(this.getCurPage());
    }

    public static Pager register(String name, LinkBuilder builder, HttpServletRequest request) {
        Pager pager = new Pager(builder);
        PagerDTO dto = PagerDTO.get((ServletRequest)request);
        dto.add(name, pager);
        return pager;
    }

    public String getLink() {
        int totlePage = this.getTotalPage();
        if (totlePage < 2) {
            return "";
        }
        StringBuffer pageHtml = new StringBuffer(this.getStyle().getAroundStyle().getStart());
        int curPage = this.getCurPage();
        DirectJump directJump = this.getStyleFactory().getDirectJump();
        pageHtml.append(directJump.getAroundTag().getStart());
        this.getPageStatistics().build(pageHtml, curPage, totlePage);
        int startIndex = this.getStartIndex();
        int endIndex = this.getEndIndex();
        if (curPage < 2) {
            pageHtml.append(this.getStyle().getCurrentPageTag(1));
        } else {
            this.getStyle().popPerPageLink(pageHtml, curPage - 1);
            if (this.showFirstPage()) {
                this.popDivHreLink(pageHtml, 1, "1");
            }
        }
        if (startIndex > 1 && this.getCurPage() >= this.getPageNumShowRule().startRangeLength()) {
            pageHtml.append(this.getPreIgnore());
        }
        for (int i = 2; i <= totlePage; ++i) {
            if (startIndex <= i && i <= endIndex) {
                if (curPage == i) {
                    pageHtml.append(this.getStyle().getCurrentPageTag(curPage));
                } else {
                    this.popDivHreLink(pageHtml, i, String.valueOf(i));
                }
            }
            if (i != endIndex || totlePage <= endIndex) continue;
            pageHtml.append(this.getTailIgnore());
            if (!this.getPageNumShowRule().isShowLastPage()) continue;
            this.popDivHreLink(pageHtml, totlePage, String.valueOf(totlePage));
        }
        if (curPage != totlePage && totlePage != 0) {
            this.getStyle().popNextPageLink(pageHtml, curPage + 1);
        }
        directJump.build(pageHtml);
        pageHtml.append(directJump.getAroundTag().getEnd());
        pageHtml.append(this.getStyle().getAroundStyle().getEnd());
        return pageHtml.toString();
    }

    private boolean showFirstPage() {
        int startIndex = this.getStartIndex();
        if (startIndex != 1) {
            return this.getPageNumShowRule().isShowFirstPage();
        }
        return true;
    }

    private String getPreIgnore() {
        return this.getPageNumShowRule().getPreOffset().getIgnor();
    }

    private String getTailIgnore() {
        return this.getPageNumShowRule().getTailOffset().getIgnor();
    }

    private int getStartIndex() {
        int answer = this.getCurPage() - this.getPageNumShowRule().getPreOffset().getSetp();
        int tailOffset = this.getCurPage() + this.getPageNumShowRule().getTailOffset().getSetp();
        if (tailOffset > this.getTotalPage()) {
            answer -= tailOffset - this.getTotalPage();
        }
        return answer < 1 ? 1 : answer;
    }

    private int getEndIndex() {
        int answer = this.getStartIndex() + this.getPageNumShowRule().getRangeWidth();
        return answer > this.getTotalPage() ? this.getTotalPage() : answer;
    }

    private PageStatistics getPageStatistics() {
        return this.getStyleFactory().getPageStatistics();
    }

    private void popDivHreLink(StringBuffer pageHtml, int page, String name) {
        this.getStyle().popDivHreLink(pageHtml, page, name);
    }

    private void popDivHreLink(StringBuffer pageHtml, int page, String name, String cssClass) {
        this.getStyle().popDivHreLink(pageHtml, page, name, cssClass);
    }

    private PageNumShowRule getPageNumShowRule() {
        return this.getStyleFactory().getPageNumShowRule();
    }

    public int getCurPage() {
        if (this.curPage < 1) {
            return 1;
        }
        if (this.getTotalPage() > 0 && this.curPage > this.getTotalPage()) {
            this.curPage = this.getTotalPage();
        }
        return this.curPage;
    }

    public void setCurPage(int curPage) {
        this.curPage = curPage;
    }

    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    public void setRowsPerPage(int rowsPerPage) {
        this.rowsPerPage = rowsPerPage;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    private NavigationStyle getStyle() {
        return this.getStyleFactory().getNaviagationStyle();
    }

    private StyleFactory getStyleFactory() {
        return StyleFactory.getInstance(this);
    }

    public static interface PageNumShowRule {
        public Offset getPreOffset();

        public Offset getTailOffset();

        public boolean isShowLastPage();

        public boolean isShowFirstPage();

        public int startRangeLength();

        public int getRangeWidth();
    }

    public static interface DirectJump {
        public void build(StringBuffer var1);

        public AroundTag getAroundTag();
    }

    public static interface PageStatistics {
        public void build(StringBuffer var1, int var2, int var3);
    }

    public static interface NavigationStyle {
        public AroundTag getAroundStyle();

        public String getCurrentPageTag(int var1);

        public void popDivHreLink(StringBuffer var1, int var2, String var3);

        public void popDivHreLink(StringBuffer var1, int var2, String var3, String var4);

        public void popPerPageLink(StringBuffer var1, int var2);

        public void popNextPageLink(StringBuffer var1, int var2);
    }
}

