/*
 * Decompiled with CFR 0.152.
 */
import com.qlangtech.tis.TIS;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;

public class CreateSoftLink {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            throw new IllegalArgumentException("args length must be 1");
        }
        File pluginModuleDir = new File(args[0]);
        if (!pluginModuleDir.exists() || !pluginModuleDir.isDirectory()) {
            throw new IllegalArgumentException("pluginModuleDir is not illegal:" + pluginModuleDir.getAbsolutePath());
        }
        File targetPluginDir = TIS.pluginDirRoot;
        FileUtils.forceMkdir((File)targetPluginDir);
        FileUtils.cleanDirectory((File)targetPluginDir);
        Iterator fileIt = FileUtils.iterateFiles((File)pluginModuleDir, (String[])new String[]{"tpi"}, (boolean)true);
        File tpiFile = null;
        int fileCount = 0;
        while (fileIt.hasNext()) {
            tpiFile = (File)fileIt.next();
            ++fileCount;
            System.out.println("mk link:" + tpiFile.getAbsolutePath());
            Files.createSymbolicLink(new File(targetPluginDir, tpiFile.getName()).toPath(), tpiFile.toPath(), new FileAttribute[0]);
        }
        if (fileCount < 1) {
            throw new IllegalStateException("fileCount must more than 0");
        }
    }
}

