/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.web.start;

import com.qlangtech.tis.web.start.TisRunMode;
import java.io.File;
import java.util.Objects;

public class TisAppLaunch {
    public static final String KEY_TIS_LAUNCH_PORT = "tis.launch.port";
    public static final String KEY_ASSEMBLE_TASK_DIR = "assemble.task.dir";
    public static final String KEY_LOG_DIR = "log.dir";
    private static boolean test = false;
    public final Integer launchPort;
    private static final String logDir = System.getProperty("log.dir", "/opt/logs/tis");
    private TisRunMode runMode;
    public static TisAppLaunch instance;

    public static File getLogDir() {
        return new File(logDir);
    }

    private TisAppLaunch() {
        if (logDir == null) {
            throw new IllegalStateException("logDir can not be null");
        }
        this.launchPort = Integer.parseInt(System.getProperty(KEY_TIS_LAUNCH_PORT, "8080"));
    }

    public void setRunMode(TisRunMode runMode) {
        this.runMode = runMode;
    }

    public TisRunMode getRunMode() {
        if (this.runMode == null && TisAppLaunch.isTestMock()) {
            this.runMode = TisRunMode.LocalTest;
        }
        return Objects.requireNonNull(this.runMode, "runMode can not be null");
    }

    public static TisAppLaunch get() {
        if (instance == null) {
            instance = new TisAppLaunch();
        }
        return instance;
    }

    public static final File getAssebleTaskDir() {
        return new File(System.getProperty(KEY_ASSEMBLE_TASK_DIR));
    }

    public static void setTest(boolean val) {
        test = val;
    }

    public static boolean isTestMock() {
        return test;
    }

    static {
        System.setProperty(KEY_ASSEMBLE_TASK_DIR, logDir + "/assemble/task");
    }
}

