/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax.job;

import com.qlangtech.tis.coredefine.module.action.ResName;
import com.qlangtech.tis.trigger.feedback.IJobFeedback;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public interface SSERunnable
extends Runnable,
IJobFeedback {
    public static final char splitChar = '\u0005';
    public static final ThreadLocal<SSERunnable> local = new ThreadLocal();
    public static final Map<Class, Object> contextAttrs = new HashMap<Class, Object>();

    default public <T> void setContextAttr(Class<T> key, T val) {
        contextAttrs.put(Objects.requireNonNull(key, "key can not be null"), Objects.requireNonNull(val, "val can not be null"));
    }

    default public <T> void cleanContextAttr(Class<T> key) {
        contextAttrs.remove(Objects.requireNonNull(key));
    }

    default public <T> T getContextAttr(Class<T> key) {
        return (T)Objects.requireNonNull(contextAttrs.get(key), "key:" + key + " relevant instance can not be null");
    }

    public static void setLocalThread(SSERunnable sseRunnable) {
        local.set(sseRunnable);
    }

    public static SSERunnable createMock() {
        return new SSERunnable(){

            @Override
            public void writeComplete(ResName subJob, boolean success) {
            }

            @Override
            public void info(String serviceName, long timestamp, String msg) {
                System.out.println("sseInfo:" + msg);
            }

            @Override
            public void error(String serviceName, long timestamp, String msg) {
                System.out.println("sseError:" + msg);
            }

            @Override
            public void fatal(String serviceName, long timestamp, String msg) {
            }

            @Override
            public void run() {
            }
        };
    }

    public static SSERunnable getLocal() {
        return Objects.requireNonNull(local.get(), "instance shall not null in threadlocal");
    }

    public static boolean sseAware() {
        return local.get() != null;
    }

    default public void afterLaunched() {
    }

    public void writeComplete(ResName var1, boolean var2);

    public static enum SSEEventType {
        TASK_MILESTONE("taskMilestone"),
        TASK_EXECUTE_STEPS("executeSteps"),
        TASK_LOG("message"),
        AI_AGNET_SESSION("session"),
        AI_AGNET_MESSAGE("ai_agent_message"),
        AI_AGNET_TOKEN("ai_agent_token"),
        AI_AGNET_LLM_CHAT_STATUS("ai_agent_llm_chat_status"),
        AI_AGNET_PROGRESS("ai_agent_progress"),
        AI_AGNET_PLUGIN("ai_agent_plugin"),
        AI_AGNET_SELECT_TABLE("ai_agent_select_tabs"),
        AI_AGNET_ERROR("ai_agent_error"),
        AI_AGENT_INPUT_REQUEST("ai_agent_input_request"),
        AI_AGNET_OPEN_LAUNCHING_PROCESS("ai_agent_open_launching_process"),
        AI_AGNET_PLUGIN_INSTALL_STATUS("ai_agent_plugin_install_status"),
        AI_AGNET_TDFS_COLS_META_SETTER("ai_agent_tdfs_cols_meta_setter"),
        AI_AGNET_SELECTION_REQUEST("ai_agent_selection_request"),
        AI_AGNET_DONE("ai_agent_done");

        private final String eventType;

        private SSEEventType(String type) {
            this.eventType = type;
        }

        public static SSEEventType parse(String token) {
            for (SSEEventType type : SSEEventType.values()) {
                if (!type.eventType.equalsIgnoreCase(token)) continue;
                return type;
            }
            throw new IllegalStateException("illegal token:" + token);
        }

        public String getEventType() {
            return this.eventType;
        }
    }
}

