/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.coredefine.module.action;

import com.koubei.abator.AdapterUserDefineProperties;
import com.koubei.abator.KoubeiIbatorRunner;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.manage.common.incr.StreamContextConstant;
import com.qlangtech.tis.plugin.ds.FacadeDataSource;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbatorProperties
extends AdapterUserDefineProperties {
    private final List<String> tables;
    private final Properties props;
    private static String PARENT_PACKAGE = "com.qlangtech.tis.realtime";
    private static final Logger logger = LoggerFactory.getLogger(IbatorProperties.class);
    private File daoDir;
    private final String databaseName;
    private final boolean daoScriptCreated;
    private final DataSource dataSource;

    public IbatorProperties(FacadeDataSource facadeDataSource, List<String> tables, long timestamp) {
        if (facadeDataSource == null) {
            throw new IllegalArgumentException("param dbConfig can not be null");
        }
        this.props = new Properties();
        this.dataSource = facadeDataSource.dataSource;
        if (timestamp < 1L) {
            throw new IllegalArgumentException("param timestamp:" + timestamp + " can not small than 1");
        }
        this.daoDir = StreamContextConstant.getDAORootDir((String)facadeDataSource.dbMeta.getName(), (long)timestamp);
        this.daoScriptCreated = this.daoDir.exists();
        try {
            FileUtils.forceMkdir((File)this.daoDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        logger.info("db dao generate local dir:" + this.daoDir.getAbsolutePath());
        this.props.setProperty("outputDir", this.daoDir.getAbsolutePath());
        this.props.setProperty("project", PARENT_PACKAGE + "." + facadeDataSource.dbMeta.getFormatDBName());
        this.tables = tables;
        this.databaseName = facadeDataSource.dbMeta.getName();
    }

    public boolean isDaoScriptCreated() {
        return this.daoScriptCreated;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public File getDaoDir() {
        return this.daoDir;
    }

    public boolean generateDataSourceConfig() {
        return false;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Properties getProperty() {
        return this.props;
    }

    public String getTables() {
        return this.tables.stream().collect(Collectors.joining(","));
    }

    public String getOutputfileEncode() {
        return TisUTF8.getName();
    }

    public boolean isBooleanMapEnable() {
        return false;
    }

    public boolean isDisableGenerateModifyDAOMethod() {
        return true;
    }

    public String getDependencyPackageParentName() {
        return "com.qlangtech.tis.ibatis";
    }

    public KoubeiIbatorRunner.PojoExtendsClass getPojoExtendsClass() {
        return new KoubeiIbatorRunner.PojoExtendsClass("com.qlangtech.tis.realtime.transfer.AbstractRowValueGetter", "AbstractRowValueGetter");
    }
}

