/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.compiler.streamcode;

import com.google.common.collect.Lists;
import com.qlangtech.tis.compiler.java.FileObjectsContext;
import com.qlangtech.tis.compiler.java.ResourcesFile;
import com.qlangtech.tis.compiler.java.ZipPath;
import com.qlangtech.tis.compiler.streamcode.IDBTableNamesGetter;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.manage.IBasicAppSource;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.manage.common.incr.StreamContextConstant;
import com.qlangtech.tis.sql.parser.DBNode;
import com.qlangtech.tis.sql.parser.stream.generate.FacadeContext;
import com.qlangtech.tis.sql.parser.stream.generate.StreamComponentCodeGeneratorFlink;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import javax.tools.JavaFileObject;
import org.apache.commons.io.FileUtils;

public class IndexStreamCodeGenerator {
    public final DataXName collection;
    private final IBasicAppSource streamIncrGenerateStrategy;
    public final long incrScriptTimestamp;
    private List<FacadeContext> facadeList;
    private StreamComponentCodeGeneratorFlink streamCodeGenerator;
    private File streamScriptRootDir;
    private final IDBTableNamesGetter dbTableNamesGetter;

    public IndexStreamCodeGenerator(DataXName collection, IBasicAppSource streamIncrGenerateStrategy, long incrScriptTimestamp, IDBTableNamesGetter dbTableNamesGetter) {
        this.collection = Objects.requireNonNull(collection, "param collection can not be null");
        this.streamIncrGenerateStrategy = streamIncrGenerateStrategy;
        this.dbTableNamesGetter = dbTableNamesGetter;
        if (incrScriptTimestamp < 1L) {
            throw new IllegalArgumentException("illegal incrScriptTimestamp can not small than 1");
        }
        this.incrScriptTimestamp = incrScriptTimestamp;
        this.initialize();
    }

    public void deleteScript() {
        FileUtils.deleteQuietly((File)this.streamScriptRootDir);
    }

    private void initialize() {
        this.facadeList = Lists.newArrayList();
        this.streamCodeGenerator = new StreamComponentCodeGeneratorFlink(this.collection, this.incrScriptTimestamp, this.facadeList, this.streamIncrGenerateStrategy);
        this.streamScriptRootDir = StreamContextConstant.getStreamScriptRootDir((String)this.collection.getPipelineName(), (long)this.incrScriptTimestamp);
    }

    public Map<DBNode, List<String>> getDbTables() {
        return Collections.emptyMap();
    }

    public boolean isIncrScriptDirCreated() {
        return this.streamCodeGenerator.isIncrScriptDirCreated();
    }

    public String getIncrScriptDirPath() {
        return this.streamCodeGenerator.getIncrScriptDir().getAbsolutePath();
    }

    public long getIncrScriptTimestamp() {
        return this.incrScriptTimestamp;
    }

    public List<FacadeContext> getFacadeList() {
        return this.facadeList;
    }

    public void generateConfigFiles() throws Exception {
        this.streamCodeGenerator.generateConfigFiles();
    }

    public FileObjectsContext getSpringXmlConfigsObjectsContext() {
        FileObjectsContext xmlConfigs = new FileObjectsContext();
        Stack childPath = new Stack();
        File parent = this.streamCodeGenerator.getSpringConfigFilesDir();
        if (!parent.exists()) {
            throw new IllegalStateException("file:" + parent.getAbsolutePath() + " is not exist");
        }
        FileObjectsContext.traversingFiles(childPath, (File)parent, (FileObjectsContext)xmlConfigs, (zp, child) -> {
            ZipPath zipPath = new ZipPath(zp, child.getName(), JavaFileObject.Kind.OTHER);
            ResourcesFile res = new ResourcesFile(zipPath, FileUtils.readFileToByteArray((File)child));
            xmlConfigs.resources.add(res);
        });
        return xmlConfigs;
    }

    public String readIncrScriptMainFileContent() throws Exception {
        File incrScript = this.streamCodeGenerator.getIncrScriptMainFile();
        if (!incrScript.exists()) {
            throw new IllegalStateException("incrScript:" + incrScript.getAbsolutePath() + " is not exist");
        }
        return FileUtils.readFileToString((File)incrScript, (String)TisUTF8.getName());
    }

    public StreamComponentCodeGeneratorFlink getStreamCodeGenerator() {
        return this.streamCodeGenerator;
    }

    public void generateStreamScriptCode() throws Exception {
        this.streamCodeGenerator.build();
    }
}

