/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.compiler.streamcode;

import com.alibaba.citrus.turbine.Context;
import com.google.common.collect.Lists;
import com.koubei.abator.IUserDefineProperties;
import com.koubei.abator.KoubeiIbatorRunner;
import com.koubei.abator.KoubeiProgressCallback;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.compiler.java.JavaCompilerProcess;
import com.qlangtech.tis.compiler.streamcode.IndexStreamCodeGenerator;
import com.qlangtech.tis.coredefine.module.action.IbatorProperties;
import com.qlangtech.tis.coredefine.module.action.IndexIncrStatus;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.incr.StreamContextConstant;
import com.qlangtech.tis.offline.DbScope;
import com.qlangtech.tis.plugin.ds.DBIdentity;
import com.qlangtech.tis.plugin.ds.DataSourceFactoryPluginStore;
import com.qlangtech.tis.plugin.ds.FacadeDataSource;
import com.qlangtech.tis.plugin.ds.PostedDSProp;
import com.qlangtech.tis.plugin.incr.TISSinkFactory;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.sql.parser.DBNode;
import com.qlangtech.tis.sql.parser.IDBNodeMeta;
import com.qlangtech.tis.sql.parser.stream.generate.FacadeContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.ibatis.ibator.config.IbatorContext;

public class GenerateDAOAndIncrScript {
    private final IControlMsgHandler msgHandler;
    private final IndexStreamCodeGenerator indexStreamCodeGenerator;

    public GenerateDAOAndIncrScript(IControlMsgHandler msgHandler, IndexStreamCodeGenerator indexStreamCodeGenerator) {
        this.msgHandler = msgHandler;
        this.indexStreamCodeGenerator = indexStreamCodeGenerator;
    }

    public void generate(Context context, IndexIncrStatus incrStatus, boolean compilerAndPackage, Map<Integer, Long> dependencyDbs) {
        this.generateDAOScript(context, dependencyDbs);
        this.generateIncrScript(context, incrStatus, compilerAndPackage, Collections.unmodifiableMap(this.indexStreamCodeGenerator.getDbTables()), false);
    }

    public static boolean incrStreamCodeCompileFaild(File sourceRootDir) {
        File compileFaildToken = new File(sourceRootDir, "compile_faild");
        boolean exist = compileFaildToken.exists();
        try {
            if (exist) {
                FileUtils.deleteDirectory((File)sourceRootDir);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return exist;
    }

    public void generateIncrScript(Context context, IndexIncrStatus incrStatus, boolean compilerAndPackage, Map<DBNode, List<String>> dbNameMap, boolean hasCfgChanged) {
        try {
            DataXName dataXName = this.indexStreamCodeGenerator.collection;
            File sourceRoot = StreamContextConstant.getStreamScriptRootDir((String)dataXName.getPipelineName(), (long)this.indexStreamCodeGenerator.incrScriptTimestamp);
            if (!this.indexStreamCodeGenerator.isIncrScriptDirCreated() || GenerateDAOAndIncrScript.incrStreamCodeCompileFaild(sourceRoot) || hasCfgChanged) {
                this.indexStreamCodeGenerator.generateStreamScriptCode();
                DBNode.dump(dbNameMap.keySet().stream().collect(Collectors.toList()), (File)StreamContextConstant.getDbDependencyConfigMetaFile((String)dataXName.getPipelineName(), (long)this.indexStreamCodeGenerator.incrScriptTimestamp));
                this.indexStreamCodeGenerator.generateConfigFiles();
            }
            incrStatus.setIncrScriptMainFileContent(this.indexStreamCodeGenerator.readIncrScriptMainFileContent());
            if (compilerAndPackage) {
                TISSinkFactory streamFactory = TISSinkFactory.getIncrSinKFactory((DataXName)dataXName);
                Objects.requireNonNull(streamFactory, "relevant streamFactory can not be null,collection:" + dataXName);
                streamFactory.getCompileAndPackageManager().process(context, this.msgHandler, dataXName.getPipelineName(), dbNameMap.entrySet().stream().collect(Collectors.toMap(e -> (IDBNodeMeta)e.getKey(), e -> (List)e.getValue())), sourceRoot, this.indexStreamCodeGenerator.getSpringXmlConfigsObjectsContext());
            }
        }
        catch (Exception e2) {
            try {
                FileUtils.forceDelete((File)this.indexStreamCodeGenerator.getStreamCodeGenerator().getIncrScriptDir());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException(e2);
        }
    }

    private void generateDAOScript(Context context, Map<Integer, Long> dependencyDbs) {
        Map<DBNode, List<String>> dbNameMap = Collections.unmodifiableMap(this.indexStreamCodeGenerator.getDbTables());
        if (dbNameMap.size() < 1) {
            throw new IllegalStateException("dbNameMap size can not small than 1");
        }
        if (dbNameMap.size() != dependencyDbs.size()) {
            throw new IllegalStateException("dbNameMap.size() " + dbNameMap.size() + " != dependencyDbs.size()" + dependencyDbs.size());
        }
        DataSourceFactoryPluginStore dbPluginStore = null;
        final KoubeiProgressCallback koubeiProgressCallback = new KoubeiProgressCallback();
        ArrayList daoFacadeList = Lists.newArrayList();
        Long lastOptime = null;
        ArrayList leakFacadeDsPlugin = Lists.newArrayList();
        for (Map.Entry<DBNode, List<String>> entry : dbNameMap.entrySet()) {
            dbPluginStore = this.getFacadePluginStore(entry);
            if (dbPluginStore.getPlugin() != null) continue;
            leakFacadeDsPlugin.add(dbPluginStore);
        }
        if (leakFacadeDsPlugin.size() > 0) {
            this.msgHandler.addErrorMessage(context, "\u6570\u636e\u5e93:" + leakFacadeDsPlugin.stream().map(p -> "'" + p.getDSKey().keyVal + "'").collect(Collectors.joining(",")) + "\u8fd8\u6ca1\u6709\u5b9a\u4e49\u5bf9\u5e94\u7684Facade\u6570\u636e\u6e90");
            return;
        }
        for (Map.Entry<DBNode, List<String>> entry : dbNameMap.entrySet()) {
            lastOptime = dependencyDbs.get(entry.getKey().getDbId());
            if (lastOptime == null) {
                throw new IllegalStateException("db " + entry.getKey() + " is not find in dependency dbs:" + dbNameMap.keySet().stream().map(r -> "[" + r.getDbId() + ":" + r.getDbName() + "]").collect(Collectors.joining(",")));
            }
            long timestamp = lastOptime;
            dbPluginStore = this.getFacadePluginStore(entry);
            FacadeDataSource facadeDataSource = dbPluginStore.createFacadeDataSource();
            IbatorProperties properties = new IbatorProperties(facadeDataSource, entry.getValue(), timestamp);
            entry.getKey().setTimestampVer(timestamp);
            if (entry.getValue().size() < 1) {
                throw new IllegalStateException("db:" + entry.getKey() + " relevant tablesList can not small than 1");
            }
            KoubeiIbatorRunner runner = new KoubeiIbatorRunner((IUserDefineProperties)properties){

                protected KoubeiProgressCallback getProgressCallback() {
                    return koubeiProgressCallback;
                }
            };
            IbatorContext ibatorContext = runner.getIbatorContext();
            daoFacadeList.add(ibatorContext);
            try {
                if (properties.isDaoScriptCreated()) continue;
                runner.build();
                File classpathDir = new File(Config.getDataDir(), "libs/tis-ibatis");
                JavaCompilerProcess daoCompilerPackageProcess = new JavaCompilerProcess(facadeDataSource.dbMeta, properties.getDaoDir(), classpathDir);
                daoCompilerPackageProcess.compileAndBuildJar();
            }
            catch (Exception e) {
                FileUtils.deleteQuietly((File)properties.getDaoDir());
                throw new RuntimeException("dao path:" + properties.getDaoDir(), e);
            }
        }
        if (daoFacadeList.size() < 1) {
            throw new IllegalStateException("daoFacadeList can not small than 1");
        }
        daoFacadeList.stream().forEach(r -> {
            FacadeContext fc = new FacadeContext();
            fc.setFacadeInstanceName(r.getFacadeInstanceName());
            fc.setFullFacadeClassName(r.getFacadeFullClassName());
            fc.setFacadeInterfaceName(r.getFacadeInterface());
            this.indexStreamCodeGenerator.getFacadeList().add(fc);
        });
    }

    private DataSourceFactoryPluginStore getFacadePluginStore(Map.Entry<DBNode, List<String>> entry) {
        DataSourceFactoryPluginStore dbPluginStore = TIS.getDataSourceFactoryPluginStore((PostedDSProp)new PostedDSProp(DBIdentity.parseId((String)entry.getKey().getDbName()), DbScope.FACADE));
        return dbPluginStore;
    }
}

