/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.compiler.java;

import com.google.common.collect.Lists;
import com.qlangtech.tis.compiler.java.FileObjectsContext;
import com.qlangtech.tis.compiler.java.MyJavaFileManager;
import com.qlangtech.tis.compiler.java.SourceGetterStrategy;
import com.qlangtech.tis.plugin.ds.DBConfig;
import com.qlangtech.tis.plugin.ds.IDbMeta;
import java.io.File;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCompilerProcess {
    private static final Logger logger = LoggerFactory.getLogger(JavaCompilerProcess.class);
    private final File sourceRootDir;
    private final File classpathDir;
    private final IDbMeta dbConfig;
    private final File sourceDir;
    private static final SourceGetterStrategy JAVA_GETTER = new SourceGetterStrategy(true, "java", ".java");

    public JavaCompilerProcess(IDbMeta dbConfig, File sourceDir, File classpathDir) {
        if (sourceDir == null || !sourceDir.exists()) {
            throw new IllegalArgumentException("param sourceDir can not be null");
        }
        this.sourceDir = sourceDir;
        this.sourceRootDir = new File(sourceDir, "src/main");
        this.classpathDir = classpathDir;
        if (dbConfig == null) {
            throw new IllegalStateException("param dbConfig can not be null");
        }
        this.dbConfig = dbConfig;
    }

    public static void main(String[] args) throws Exception {
        File rootDir = new File("D:\\j2ee_solution\\import_pj\\ibator_koubei\\ibator_koubei\\targett\\src\\main");
        File classpathDir = new File("D:/j2ee_solution/tis-ibatis/target/dependency/");
        DBConfig dbConfig = new DBConfig();
        dbConfig.setName("shop");
        JavaCompilerProcess compilerProcess = new JavaCompilerProcess((IDbMeta)dbConfig, rootDir, classpathDir);
        compilerProcess.compileAndBuildJar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileAndBuildJar() throws Exception {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector collector = new DiagnosticCollector();
        FileObjectsContext fileObjects = FileObjectsContext.getFileObjects((File)this.sourceRootDir, (SourceGetterStrategy)JAVA_GETTER);
        MyJavaFileManager manager = new MyJavaFileManager(compiler.getStandardFileManager(collector, null, null), fileObjects.classMap);
        try {
            File outdir = new File(this.sourceRootDir, "out");
            FileUtils.forceMkdir((File)outdir);
            ArrayList options = Lists.newArrayList();
            options.add("-classpath");
            this.setClasspath(options);
            options.add("-target");
            options.add("1.8");
            options.add("-d");
            options.add(outdir.getAbsolutePath());
            options.add("-nowarn");
            logger.info("javac options:{}", (Object)options.stream().collect(Collectors.joining(" ")));
            ArrayList classes = Lists.newArrayList();
            JavaCompiler.CompilationTask compileTask = compiler.getTask(new OutputStreamWriter(System.err), manager, collector, options, classes, fileObjects.classMap.values().stream().map(r -> r.getFileObject()).collect(Collectors.toList()));
            compileTask.call();
            collector.getDiagnostics().forEach(item -> System.out.println(item.toString()));
            FileObjectsContext.packageJar((File)new File(this.sourceDir, this.dbConfig.getDAOJarName()), (FileObjectsContext[])new FileObjectsContext[]{fileObjects});
        }
        finally {
            try {
                manager.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void setClasspath(List<String> options) {
        if (this.classpathDir != null) {
            if (!this.classpathDir.exists()) {
                throw new IllegalStateException("path:" + this.classpathDir.getAbsolutePath() + " is not exist");
            }
            ArrayList jars = Lists.newArrayList();
            for (String c : this.classpathDir.list()) {
                jars.add(new File(this.classpathDir, c));
            }
            options.add(jars.stream().map(r -> r.getAbsolutePath()).collect(Collectors.joining(SystemUtils.IS_OS_UNIX ? ":" : ";")));
        } else {
            options.add(System.getProperty("java.class.path"));
        }
    }
}

