/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.solrdao.parser;

import java.io.File;
import java.io.StringReader;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.FileUtils;

public class ModifiedPomXMLEventReader
implements XMLEventReader {
    private static final int MAX_MARKS = 3;
    private final StringBuffer pom;
    private boolean modified = false;
    private final XMLInputFactory factory;
    private int nextStart = 0;
    private int nextEnd = 0;
    private int[] markStart = new int[3];
    private int[] markEnd = new int[3];
    private int[] markDelta = new int[3];
    private int lastStart = -1;
    private int lastEnd;
    private int lastDelta = 0;
    private XMLEvent next = null;
    private int nextDelta = 0;
    private XMLEventReader backing;

    public ModifiedPomXMLEventReader(StringBuffer pom, XMLInputFactory factory) throws XMLStreamException {
        this.pom = pom;
        this.factory = factory;
        this.rewind();
    }

    public void rewind() throws XMLStreamException {
        this.backing = this.factory.createXMLEventReader(new StringReader(this.pom.toString()));
        this.nextEnd = 0;
        this.nextDelta = 0;
        for (int i = 0; i < 3; ++i) {
            this.markStart[i] = -1;
            this.markEnd[i] = -1;
            this.markDelta[i] = 0;
        }
        this.lastStart = -1;
        this.lastEnd = -1;
        this.lastDelta = 0;
        this.next = null;
    }

    public boolean isModified() {
        return this.modified;
    }

    @Override
    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException xMLStreamException) {
            return null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        try {
            XMLEvent localXMLEvent;
            XMLEvent xMLEvent = localXMLEvent = this.next;
            return xMLEvent;
        }
        finally {
            this.next = null;
            this.lastStart = this.nextStart;
            this.lastEnd = this.nextEnd;
            this.lastDelta = this.nextDelta;
        }
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        return this.backing.peek();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return this.backing.getElementText();
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        while (this.hasNext()) {
            XMLEvent e = this.nextEvent();
            if (e.isCharacters() && !((Characters)e).isWhiteSpace()) {
                throw new XMLStreamException("Unexpected text");
            }
            if (!e.isStartElement() && !e.isEndElement()) continue;
            return e;
        }
        throw new XMLStreamException("Unexpected end of Document");
    }

    @Override
    public Object getProperty(String name) {
        return this.backing.getProperty(name);
    }

    @Override
    public void close() throws XMLStreamException {
        this.backing.close();
        this.next = null;
        this.backing = null;
    }

    public StringBuffer asStringBuffer() {
        return new StringBuffer(this.pom.toString());
    }

    public void clearMark(int index) {
        this.markStart[index] = -1;
    }

    public String getMarkVerbatim(int index) {
        if (this.hasMark(index)) {
            return this.pom.substring(this.markDelta[index] + this.markStart[index], this.markDelta[index] + this.markEnd[index]);
        }
        return "";
    }

    public String getPeekVerbatim() {
        if (this.hasNext()) {
            return this.pom.substring(this.nextDelta + this.nextStart, this.nextDelta + this.nextEnd);
        }
        return "";
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (!this.backing.hasNext()) {
            return false;
        }
        try {
            this.next = this.backing.nextEvent();
            this.nextStart = this.nextEnd;
            if (this.backing.hasNext()) {
                this.nextEnd = this.backing.peek().getLocation().getCharacterOffset();
            }
            if (this.nextEnd != -1) {
                if (!this.next.isCharacters()) {
                    while (this.nextStart < this.nextEnd && this.nextStart < this.pom.length() && (this.c(this.nextStart) == '\n' || this.c(this.nextStart) == '\r')) {
                        ++this.nextStart;
                    }
                }
                while (this.nextEndIncludesNextEvent() || this.nextEndIncludesNextEndElement()) {
                    --this.nextEnd;
                }
            }
            return this.nextStart < this.pom.length();
        }
        catch (XMLStreamException xMLStreamException) {
            return false;
        }
    }

    public String getVerbatim() {
        if (this.lastStart >= 0 && this.lastEnd >= this.lastStart) {
            return this.pom.substring(this.lastDelta + this.lastStart, this.lastDelta + this.lastEnd);
        }
        return "";
    }

    public void mark(int index) {
        this.markStart[index] = this.lastStart;
        this.markEnd[index] = this.lastEnd;
        this.markDelta[index] = this.lastDelta;
    }

    private boolean nextEndIncludesNextEndElement() {
        return this.nextEnd > this.nextStart + 2 && this.nextEnd - 2 < this.pom.length() && this.c(this.nextEnd - 2) == '<';
    }

    private boolean nextEndIncludesNextEvent() {
        return this.nextEnd > this.nextStart + 1 && this.nextEnd - 2 < this.pom.length() && (this.c(this.nextEnd - 1) == '<' || this.c(this.nextEnd - 1) == '&');
    }

    private char c(int index) {
        return this.pom.charAt(this.nextDelta + index);
    }

    public void replace(String replacement) {
        if (this.lastStart < 0 || this.lastEnd < this.lastStart) {
            throw new IllegalStateException();
        }
        int start = this.lastDelta + this.lastStart;
        int end = this.lastDelta + this.lastEnd;
        if (replacement.equals(this.pom.substring(start, end))) {
            return;
        }
        this.pom.replace(start, end, replacement);
        int delta = replacement.length() - this.lastEnd - this.lastStart;
        this.nextDelta += delta;
        for (int i = 0; i < 3; ++i) {
            if (!this.hasMark(i) || this.lastStart != this.markStart[i] || this.markEnd[i] != this.lastEnd) continue;
            int n = i;
            this.markEnd[n] = this.markEnd[n] + delta;
        }
        this.lastEnd += delta;
        this.modified = true;
    }

    public boolean hasMark(int index) {
        return this.markStart[index] != -1;
    }

    public String getBetween(int index1, int index2) {
        if (!this.hasMark(index1) || !this.hasMark(index2) || this.markStart[index1] > this.markStart[index2]) {
            throw new IllegalStateException();
        }
        int start = this.markDelta[index1] + this.markEnd[index1];
        int end = this.markDelta[index2] + this.markStart[index2];
        return this.pom.substring(start, end);
    }

    public void replaceBetween(int index1, int index2, String replacement) {
        if (!this.hasMark(index1) || !this.hasMark(index2) || this.markStart[index1] > this.markStart[index2]) {
            throw new IllegalStateException();
        }
        int start = this.markDelta[index1] + this.markEnd[index1];
        int end = this.markDelta[index2] + this.markStart[index2];
        if (replacement.equals(this.pom.substring(start, end))) {
            return;
        }
        this.pom.replace(start, end, replacement);
        int delta = replacement.length() - (end - start);
        this.nextDelta += delta;
        for (int i = 0; i < 3; ++i) {
            if (i == index1 || i == index2 || this.markStart[i] == -1) continue;
            if (this.markStart[i] > this.markStart[index2]) {
                int n = i;
                this.markDelta[n] = this.markDelta[n] + delta;
                continue;
            }
            if (this.markStart[i] == this.markEnd[index1] && this.markEnd[i] == this.markStart[index1]) {
                int n = i;
                this.markDelta[n] = this.markDelta[n] + delta;
                continue;
            }
            if (this.markStart[i] <= this.markEnd[index1] && this.markEnd[i] >= this.markStart[index2]) continue;
            this.markStart[i] = -1;
        }
        this.modified = true;
    }

    public void replaceMark(int index, String replacement) {
        if (!this.hasMark(index)) {
            throw new IllegalStateException();
        }
        int start = this.markDelta[index] + this.markStart[index];
        int end = this.markDelta[index] + this.markEnd[index];
        if (replacement.equals(this.pom.substring(start, end))) {
            return;
        }
        this.pom.replace(start, end, replacement);
        int delta = replacement.length() - this.markEnd[index] - this.markStart[index];
        this.nextDelta += delta;
        if (this.lastStart == this.markStart[index] && this.lastEnd == this.markEnd[index]) {
            this.lastEnd += delta;
        } else if (this.lastStart > this.markStart[index]) {
            this.lastDelta += delta;
        }
        for (int i = 0; i < 3; ++i) {
            if (i == index || this.markStart[i] == -1) continue;
            if (this.markStart[i] > this.markStart[index]) {
                int n = i;
                this.markDelta[n] = this.markDelta[n] + delta;
                continue;
            }
            if (this.markStart[i] != this.markStart[index] || this.markEnd[i] != this.markEnd[index]) continue;
            int n = i;
            this.markDelta[n] = this.markDelta[n] + delta;
        }
        int n = index;
        this.markEnd[n] = this.markEnd[n] + delta;
        this.modified = true;
    }

    public static void main(String[] arg) throws Exception {
        String content = FileUtils.readFileToString((File)new File("C:\\Users\\baisui\\Desktop\\tsearcher_test\\tsearcher_home1\\juinstance\\search4juitem-0\\conf\\schema.xml"));
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isValidating", false);
        ModifiedPomXMLEventReader pom = new ModifiedPomXMLEventReader(new StringBuffer(content), inputFactory);
        Stack<String> stack = new Stack<String>();
        Object path = "";
        Pattern matchScopeRegex = Pattern.compile("/schema/uniqueKey");
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push((String)path);
                path = (String)path + "/" + event.asStartElement().getName().getLocalPart();
                if (matchScopeRegex.matcher((CharSequence)path).matches()) {
                    pom.mark(0);
                }
            }
            if (!event.isEndElement()) continue;
            if (matchScopeRegex.matcher((CharSequence)path).matches()) {
                pom.mark(1);
                if (pom.hasMark(0) && pom.hasMark(1)) {
                    System.out.println(pom.getBetween(0, 1).trim());
                }
                pom.clearMark(0);
                pom.clearMark(1);
            }
            path = (String)stack.pop();
        }
    }
}

