/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.solrdao;

import com.qlangtech.tis.exec.IIndexMetaData;
import com.qlangtech.tis.solrdao.BuilderContext;
import com.qlangtech.tis.solrdao.IBuilderContext;
import com.qlangtech.tis.solrdao.ISchemaFieldTypeContext;
import com.qlangtech.tis.solrdao.ISchemaPluginContext;
import com.qlangtech.tis.solrdao.SolrFieldsParser;
import com.qlangtech.tis.solrdao.pojo.PSchemaField;
import java.io.InputStream;
import java.io.PrintWriter;
import org.apache.commons.io.IOUtils;

public class SolrPojoBuilder {
    final IBuilderContext buildContext;

    public SolrPojoBuilder(IBuilderContext buildContext) {
        this.buildContext = buildContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws Exception {
        PrintWriter writer = null;
        InputStream reader = null;
        try {
            writer = new PrintWriter(this.buildContext.getOutputStream());
            IIndexMetaData metaData = SolrFieldsParser.parse(() -> this.buildContext.getResourceInputStream(), (ISchemaFieldTypeContext)ISchemaPluginContext.NULL);
            SolrFieldsParser.SchemaFields fields = metaData.getSchemaParseResult().dFields;
            writer.print("package ");
            writer.println(this.buildContext.getTargetNameSpace() + ";");
            writer.println();
            writer.println();
            if (SolrFieldsParser.hasMultiValuedField(fields)) {
                writer.println("import java.util.List;");
            }
            writer.println("import org.apache.solr.client.solrj.beans.Field;");
            writer.println();
            writer.println("public class " + this.buildContext.getPojoName() + "{");
            for (PSchemaField f : fields) {
                if (f.isStored()) {
                    writer.println("\t@Field(\"" + f.getName() + "\")");
                    writer.println("\tprivate " + f.getFileTypeLiteria() + " " + f.getPropertyName() + ";");
                }
                writer.println();
            }
            for (PSchemaField f : fields) {
                if (!f.isStored()) continue;
                writer.println("\tpublic void " + f.getSetMethodName() + "(" + f.getFileTypeLiteria() + " " + f.getPropertyName() + "){");
                writer.println("\t   this." + f.getPropertyName() + " = " + f.getPropertyName() + ";");
                writer.println("\t}");
                writer.println();
                writer.println("\tpublic " + f.getFileTypeLiteria() + " " + f.getGetterMethodName() + "(){");
                writer.println("\t   return this." + f.getPropertyName() + ";");
                writer.println("\t}");
                writer.println();
            }
            writer.println("}");
            System.out.println(" successful create new pojo file  ");
        }
        finally {
            IOUtils.closeQuietly(reader);
            writer.flush();
            this.buildContext.closeWriter(writer);
        }
    }

    public static void main(String[] args) throws Exception {
        String serverAddress = System.getProperty("server_address");
        String indexName = System.getProperty("index_name");
        String pojoName = System.getProperty("pojo_name");
        String pkg = System.getProperty("pkg");
        String outdir = System.getProperty("outdir");
        Assert.assertNotNull("serverAddress", serverAddress);
        Assert.assertNotNull("indexName", indexName);
        Assert.assertNotNull("pojoName", pojoName);
        Assert.assertNotNull("pkg", pkg);
        Assert.assertNotNull("outdir", outdir);
        BuilderContext buildContext = new BuilderContext();
        buildContext.setServerAddress(serverAddress);
        buildContext.setAppName(indexName);
        buildContext.setPojoName(pojoName);
        buildContext.setTargetNameSpace(pkg);
        buildContext.setTargetDir(outdir);
        SolrPojoBuilder builder = new SolrPojoBuilder(buildContext);
        builder.create();
    }

    private static class Assert {
        private Assert() {
        }

        private static void assertNotNull(String msg, Object o) {
            if (o == null) {
                throw new NullPointerException(msg);
            }
        }
    }
}

