/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.solrdao;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public enum SolrJavaType {
    INT(Integer.class, 1),
    FLOAT(Float.class, 2),
    DOUBLE(Double.class, 3),
    LONG(Long.class, 4),
    TIMESTAMP(Timestamp.class, 5),
    DATE(Date.class, 6),
    DATETIME(Date.class, 7),
    STRING(String.class, 8);

    private final Class<?> javaType;
    private final int typeCode;

    public static SolrJavaType parse(String fieldType) {
        if (SolrJavaType.isTypeMatch(fieldType, "int")) {
            return INT;
        }
        if (SolrJavaType.isTypeMatch(fieldType, "float")) {
            return FLOAT;
        }
        if (SolrJavaType.isTypeMatch(fieldType, "double")) {
            return DOUBLE;
        }
        if (SolrJavaType.isTypeMatch(fieldType, "long")) {
            return LONG;
        }
        if (SolrJavaType.isTypeMatch(fieldType, "timestamp")) {
            return TIMESTAMP;
        }
        if (SolrJavaType.isTypeMatch(fieldType, "datetime")) {
            return DATETIME;
        }
        if (SolrJavaType.isTypeMatch(fieldType, "date")) {
            return DATE;
        }
        return STRING;
    }

    private static boolean isTypeMatch(String fieldType, String matchLetter) {
        return StringUtils.indexOfAny((String)fieldType, (String[])new String[]{matchLetter, StringUtils.capitalize((String)matchLetter)}) > -1;
    }

    private SolrJavaType(Class<?> javaType, int typeCode) {
        this.javaType = javaType;
        this.typeCode = typeCode;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public String getSimpleName() {
        return StringUtils.lowerCase((String)this.javaType.getSimpleName());
    }
}

