/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.solrdao;

import com.qlangtech.tis.exec.IIndexMetaData;
import com.qlangtech.tis.exec.lifecycle.hook.IIndexBuildLifeCycleHook;
import com.qlangtech.tis.exec.lifecycle.hook.impl.AdapterIndexBuildLifeCycleHook;
import com.qlangtech.tis.fullbuild.indexbuild.LuceneVersion;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.ConfigFileContext;
import com.qlangtech.tis.plugin.ds.ColumnMetaData;
import com.qlangtech.tis.solr.common.DOMUtil;
import com.qlangtech.tis.solrdao.ISchemaFieldTypeContext;
import com.qlangtech.tis.solrdao.ISchemaPluginContext;
import com.qlangtech.tis.solrdao.ISolrConfigGetter;
import com.qlangtech.tis.solrdao.SolrJavaType;
import com.qlangtech.tis.solrdao.extend.IndexBuildHook;
import com.qlangtech.tis.solrdao.extend.ProcessorSchemaField;
import com.qlangtech.tis.solrdao.impl.ParseResult;
import com.qlangtech.tis.solrdao.pojo.PSchemaField;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SolrFieldsParser {
    public static final String KEY_PLUGIN = "plugin";
    static final XPathFactory xpathFactory = XPathFactory.newInstance();
    public static IFieldTypesVisit fieldTypeVisitor = typeNodes -> {};
    private static final DocumentBuilder solrConfigDocumentbuilder;
    private static SolrFieldsParser solrFieldsParser;
    private static final Pattern SPACE;
    private static final Pattern PATTERN_COMMENT_PROCESSOR;
    private static final Pattern PATTERN_INDEX_BUILD_HOOK;

    private SolrFieldsParser() {
    }

    public static IIndexMetaData parse(ISolrConfigGetter configGetter) throws Exception {
        return SolrFieldsParser.parse(configGetter, fieldType -> false);
    }

    public static IIndexMetaData parse(ISolrConfigGetter configGetter, ISchemaFieldTypeContext schemaPlugin) throws Exception {
        return SolrFieldsParser.parse(configGetter, schemaPlugin, false);
    }

    public static IIndexMetaData parse(ISolrConfigGetter configGetter, ISchemaFieldTypeContext schemaPlugin, boolean validateSchema) throws Exception {
        ParseResult schemaParseResult;
        try (ByteArrayInputStream reader = new ByteArrayInputStream(configGetter.getSchema());){
            schemaParseResult = solrFieldsParser.parseSchema(reader, schemaPlugin, validateSchema);
        }
        return new IIndexMetaData(){

            @Override
            public ParseResult getSchemaParseResult() {
                return schemaParseResult;
            }

            @Override
            public IIndexBuildLifeCycleHook getIndexBuildLifeCycleHook() {
                return AdapterIndexBuildLifeCycleHook.create(schemaParseResult);
            }

            @Override
            public LuceneVersion getLuceneVersion() {
                return LuceneVersion.LUCENE_7;
            }
        };
    }

    public static XPath createXPath() {
        return xpathFactory.newXPath();
    }

    public static void main(String[] args) throws Exception {
    }

    public static boolean hasMultiValuedField(ArrayList<PSchemaField> fields) {
        for (PSchemaField field : fields) {
            if (!field.isMltiValued()) continue;
            return true;
        }
        return false;
    }

    public ArrayList<PSchemaField> readSchemaFields(InputStream is, ISchemaPluginContext schemaPlugin) throws Exception {
        ParseResult result = this.parseSchema(is, (ISchemaFieldTypeContext)schemaPlugin);
        if (!result.isValid()) {
            throw new IllegalStateException(result.getErrorSummary());
        }
        return result.dFields;
    }

    public ParseResult readSchema(InputStream is, ISchemaPluginContext schemaPlugin) throws Exception {
        ParseResult result = this.parseSchema(is, (ISchemaFieldTypeContext)schemaPlugin);
        if (!result.isValid()) {
            throw new IllegalStateException(result.getErrorSummary());
        }
        return result;
    }

    public ParseResult parseSchema(InputStream is, ISchemaFieldTypeContext schemaPlugin) throws Exception {
        return this.parseSchema(is, schemaPlugin, true);
    }

    public ParseResult parseSchema(InputStream is, ISchemaFieldTypeContext schemaPlugin, boolean shallValidate) throws Exception {
        DocumentBuilderFactory schemaDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
        schemaDocumentBuilderFactory.setValidating(shallValidate);
        final ParseResult result = new ParseResult(shallValidate);
        DocumentBuilder builder = schemaDocumentBuilderFactory.newDocumentBuilder();
        InputSource input = new InputSource(is);
        if (!shallValidate) {
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    InputSource source = new InputSource();
                    source.setCharacterStream(new StringReader(""));
                    return source;
                }
            });
        } else {
            DefaultHandler mh = new DefaultHandler(){

                @Override
                public void error(SAXParseException e) throws SAXException {
                    result.errlist.add("\u884c\u53f7:" + e.getLineNumber() + " " + e.getMessage() + "<br/>");
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    this.error(e);
                }
            };
            builder.setErrorHandler(mh);
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    String tisrepository = Config.getConfigRepositoryHost();
                    URL url = new URL(tisrepository + "/dtd/solrschema.dtd");
                    return new InputSource(new ByteArrayInputStream((byte[])ConfigFileContext.processContent((URL)url, (ConfigFileContext.StreamProcess)new ConfigFileContext.StreamProcess<byte[]>(){

                        public byte[] p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                            try {
                                return IOUtils.toByteArray((InputStream)stream);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    })));
                }
            });
        }
        Document document = null;
        try {
            document = builder.parse(input);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (!result.isValid()) {
            return result;
        }
        return this.parse(document, schemaPlugin, shallValidate);
    }

    public static ParseResult parseDocument(Document document, ISchemaPluginContext schemaPlugin, boolean shallValidate) throws Exception {
        return solrFieldsParser.parse(document, (ISchemaFieldTypeContext)schemaPlugin, shallValidate);
    }

    public ParseResult parse(Document document, ISchemaFieldTypeContext schemaPlugin, boolean shallValidate) throws Exception {
        NodeList schemaNodes;
        String indexMakerClassName;
        XPath xpath = SolrFieldsParser.createXPath();
        ParseResult parseResult = new ParseResult(shallValidate);
        parseResult.dFieldsNames = new HashSet<String>();
        SchemaFields dFields = parseResult.dFields;
        String expression = "/schema/types/fieldType|/schema/types/fieldtype";
        NodeList nodes = (NodeList)xpath.evaluate(expression, document, XPathConstants.NODESET);
        String typeName = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NamedNodeMap attrs = node.getAttributes();
            typeName = DOMUtil.getAttr((NamedNodeMap)attrs, (String)"name");
            if (shallValidate && parseResult.types.containsKey(typeName)) {
                parseResult.errlist.add("\u91cd\u590d\u5b9a\u4e49\u4e86\u5b57\u6bb5\u7c7b\u578b\u2018" + typeName + "\u2019");
                return parseResult;
            }
            parseResult.types.put(typeName, SolrFieldsParser.parseFieldType(typeName, DOMUtil.getAttr((NamedNodeMap)attrs, (String)"class", (String)"class definition"), schemaPlugin.isTokenizer(typeName)));
        }
        fieldTypeVisitor.visit(nodes);
        this.addExtenionProcessor(parseResult, xpath, document);
        expression = "/schema/fields/field";
        ParseResult result = this.parseField(document, shallValidate, xpath, parseResult, dFields, expression, false);
        if (!result.isValid()) {
            return result;
        }
        expression = "/schema/fields/dynamicField";
        result = this.parseField(document, shallValidate, xpath, parseResult, dFields, expression, true);
        if (!result.isValid()) {
            return result;
        }
        if (parseResult.dFieldsNames == null) {
            throw new IllegalStateException("parseResult.dFieldsNames can not be null");
        }
        parseResult.dFieldsNames = Collections.unmodifiableSet(parseResult.dFieldsNames);
        String uniqueKey = (String)xpath.evaluate("/schema/uniqueKey", document, XPathConstants.STRING);
        String sharedKey = (String)xpath.evaluate("/schema/sharedKey", document, XPathConstants.STRING);
        boolean uniqueKeyDefined = false;
        boolean shareKeyDefined = false;
        if (shallValidate) {
            for (PSchemaField f : dFields) {
                if (f.getName().equals(uniqueKey)) {
                    uniqueKeyDefined = true;
                    if (!f.isIndexed()) {
                        parseResult.errlist.add("\u4e3b\u952e:\u2018" + uniqueKey + "\u2019\u5c5e\u6027'indexed'\u5fc5\u987b\u4e3atrue");
                        return result;
                    }
                    if (f.isMultiValue()) {
                        parseResult.errlist.add("\u4e3b\u952e:\u2018" + uniqueKey + "\u2019\u5c5e\u6027'multiValued'\u5fc5\u987b\u4e3afalse");
                    }
                }
                if (!f.getName().equals(sharedKey)) continue;
                shareKeyDefined = true;
            }
            if (!shareKeyDefined) {
                parseResult.errlist.add("\u8bf7\u8bbe\u7f6e\u5206\u533a\u952e");
            }
            if (!uniqueKeyDefined) {
                parseResult.errlist.add("\u8bf7\u8bbe\u7f6e\u4e3b\u952e");
                return result;
            }
        }
        parseResult.setUniqueKey(uniqueKey);
        parseResult.setSharedKey(sharedKey);
        String indexBuilder = this.getIndexBuilder((NodeList)xpath.evaluate("/schema", document, XPathConstants.NODESET));
        if (!StringUtils.isBlank((String)indexBuilder)) {
            parseResult.setIndexBuilder(indexBuilder);
        }
        if (!StringUtils.isBlank((String)(indexMakerClassName = this.getIndexMakerClassName(schemaNodes = (NodeList)xpath.evaluate("/schema", document, XPathConstants.NODESET))))) {
            parseResult.setIndexMakerClassName(indexMakerClassName);
        }
        parseResult.setDocumentCreatorType(this.getDocMaker(schemaNodes));
        return parseResult;
    }

    private void addExtenionProcessor(ParseResult parseResult, XPath xPath, Document document) throws XPathExpressionException {
        Node fieldsNode = (Node)xPath.evaluate("/schema/fields", document, XPathConstants.NODE);
        NodeList nodes = fieldsNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node fieldNode = nodes.item(i);
            String comment = fieldNode.getTextContent();
            if (fieldNode.getNodeType() != 8 || StringUtils.isBlank((String)comment)) continue;
            Matcher matcher = PATTERN_INDEX_BUILD_HOOK.matcher(comment);
            if (matcher.find() && matcher.groupCount() == 1) {
                parseResult.addIndexBuildHook(IndexBuildHook.create(matcher.group(1)));
                continue;
            }
            matcher = PATTERN_COMMENT_PROCESSOR.matcher(comment);
            if (!matcher.find() || matcher.groupCount() != 2) continue;
            parseResult.addProcessorSchema(ProcessorSchemaField.create(matcher.group(1), matcher.group(2)));
        }
    }

    private String getIndexMakerClassName(NodeList nodes) {
        return this.getFirstNodeAtt(nodes, "indexMaker");
    }

    private String getDocMaker(NodeList nodes) {
        return this.getFirstNodeAtt(nodes, "docMaker");
    }

    private String getFirstNodeAtt(NodeList nodes, String attriName) {
        String indexBuilder = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = DOMUtil.getAttr((NamedNodeMap)node.getAttributes(), (String)attriName, null);
            if (StringUtils.isBlank((String)name)) continue;
            indexBuilder = name;
            break;
        }
        return indexBuilder;
    }

    private String getIndexBuilder(NodeList nodes) {
        String indexBuilder = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = DOMUtil.getAttr((NamedNodeMap)node.getAttributes(), (String)"indexBuilder", null);
            if (StringUtils.isBlank((String)name)) continue;
            indexBuilder = name;
            break;
        }
        return indexBuilder;
    }

    private ParseResult parseField(Document document, boolean shallValidate, XPath xpath, ParseResult parseResult, ArrayList<PSchemaField> dFields, String expression, boolean dynamicField) throws Exception {
        NodeList nodes = (NodeList)xpath.evaluate(expression, document, XPathConstants.NODESET);
        PSchemaField field = null;
        Matcher matcher = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            field = new PSchemaField();
            field.setDynamic(dynamicField);
            Node node = nodes.item(i);
            NamedNodeMap attrs = node.getAttributes();
            String name = DOMUtil.getAttr((NamedNodeMap)attrs, (String)"name", (String)"field definition");
            matcher = SPACE.matcher(name);
            if (shallValidate && matcher.find()) {
                parseResult.errlist.add("\u5b57\u6bb5\u540d\u79f0:\u2018" + name + "\u2019\u4e2d\u4e0d\u80fd\u6709\u7a7a\u683c");
                return parseResult;
            }
            field.setName(name);
            String typeKey = DOMUtil.getAttr((NamedNodeMap)attrs, (String)"type", (String)("field " + name));
            SolrType type = parseResult.types.get(typeKey);
            if (shallValidate && type == null) {
                parseResult.errlist.add("\u5b57\u6bb5\u7c7b\u578b:\u2018" + typeKey + "\u2019\u5728\u5df2\u6709\u7c7b\u578b\u4e2d\u4e0d\u5b58\u5728");
                return parseResult;
            }
            if (!shallValidate && type == null) {
                type = SolrFieldsParser.parseFieldType(typeKey, typeKey);
            }
            field.setType(type);
            Map args = DOMUtil.toMapExcept((NamedNodeMap)attrs, (String[])new String[]{"name", "type"});
            if (args.get("required") != null) {
                field.setRequired(Boolean.valueOf((String)args.get("required")));
            }
            if (args.get("indexed") != null) {
                field.setIndexed(Boolean.valueOf((String)args.get("indexed")));
            }
            if (args.get("stored") != null) {
                field.setStored(Boolean.valueOf((String)args.get("stored")));
            }
            if (args.get("multiValued") != null) {
                field.setMltiValued(Boolean.valueOf((String)args.get("multiValued")));
            }
            if (args.get("docValues") != null) {
                field.setDocValue(Boolean.valueOf((String)args.get("docValues")));
            }
            if (args.get("useDocValuesAsStored") != null) {
                field.setUseDocValuesAsStored(Boolean.valueOf((String)args.get("useDocValuesAsStored")));
            }
            if (args.get("default") != null) {
                field.setDefaultValue((String)args.get("default"));
            }
            parseResult.dFieldsNames.add(field.getName());
            dFields.add(field);
        }
        return parseResult;
    }

    public static SolrType parseFieldType(String name, String fieldType) {
        return SolrFieldsParser.parseFieldType(name, fieldType, false);
    }

    public static SolrType parseFieldType(String name, String fieldType, boolean splittable) {
        SolrType type = new SolrType(splittable, StringUtils.startsWith((String)fieldType, (String)"plugin:"));
        Type t = new Type(name);
        t.setSolrType(fieldType);
        type.setSolrType(t);
        type.setJavaType(SolrJavaType.parse(fieldType));
        return type;
    }

    static {
        solrFieldsParser = new SolrFieldsParser();
        try {
            DocumentBuilderFactory solrConfigBuilderFactory = DocumentBuilderFactory.newInstance();
            solrConfigBuilderFactory.setValidating(false);
            solrConfigDocumentbuilder = solrConfigBuilderFactory.newDocumentBuilder();
            solrConfigDocumentbuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    InputSource source = new InputSource();
                    source.setCharacterStream(new StringReader(""));
                    return source;
                }
            });
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        SPACE = Pattern.compile("\\s+");
        PATTERN_COMMENT_PROCESSOR = Pattern.compile("^\\{(\\w+?) (.*)\\}$");
        PATTERN_INDEX_BUILD_HOOK = Pattern.compile("^\\{\\s*buildhook (.*)\\}$");
    }

    public static interface IFieldTypesVisit {
        public void visit(NodeList var1);
    }

    public static interface ParseResultCallback {
        public void process(List<ColumnMetaData> var1, ParseResult var2);
    }

    public static class SchemaFields
    extends ArrayList<PSchemaField> {
        private static final long serialVersionUID = 1L;
        private final Map<String, PSchemaField> fieldMap = new HashMap<String, PSchemaField>();

        @Override
        public boolean add(PSchemaField e) {
            this.fieldMap.put(e.getName(), e);
            return super.add(e);
        }

        public PSchemaField getField(String fieldName) {
            return this.fieldMap.get(fieldName);
        }
    }

    public static class SolrType {
        public final boolean tokenizerable;
        public final boolean plugin;
        private SolrJavaType javaType;
        private Type solrType;
        private Method valueof;

        private SolrType(boolean tokenizerable, boolean plugin) {
            this.tokenizerable = tokenizerable;
            this.plugin = plugin;
        }

        public String getPluginName() {
            if (!this.plugin) {
                return null;
            }
            return StringUtils.substringAfter((String)this.getSolrType(), (String)"plugin:");
        }

        public SolrJavaType getJavaType() {
            return this.javaType;
        }

        public Object valueOf(Object val) throws Exception {
            return this.valueof.invoke(null, val);
        }

        public void setJavaType(SolrJavaType javaType) {
            this.javaType = javaType;
        }

        public String getSolrType() {
            return this.solrType.getSolrType();
        }

        public Type getSType() {
            return this.solrType;
        }

        public void setSolrType(Type solrType) {
            this.solrType = solrType;
        }
    }

    public static class Type {
        private String solrType;
        private final String name;

        public String getName() {
            return this.name;
        }

        public Type(String name) {
            this.name = name;
        }

        public String getSolrType() {
            return this.solrType;
        }

        public void setSolrType(String solrType) {
            this.solrType = solrType;
        }
    }
}

