/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.solrdao;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.exec.IIndexMetaData;
import com.qlangtech.tis.runtime.module.misc.IMessageHandler;
import com.qlangtech.tis.solrdao.ISchema;
import com.qlangtech.tis.solrdao.ISchemaFieldTypeContext;
import com.qlangtech.tis.solrdao.SchemaMetaContent;
import com.qlangtech.tis.solrdao.SolrFieldsParser;
import com.qlangtech.tis.solrdao.impl.ParseResult;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaResult
extends SchemaMetaContent {
    private static final Logger logger = LoggerFactory.getLogger(SchemaResult.class);
    private boolean success = false;
    private int tplAppId;

    public boolean isSuccess() {
        return this.success;
    }

    public SchemaResult faild() {
        this.success = false;
        return this;
    }

    public static SchemaResult create(ISchema parseResult, byte[] schemaContent) {
        SchemaResult schema = new SchemaResult();
        schema.parseResult = parseResult;
        schema.content = schemaContent;
        schema.success = true;
        return schema;
    }

    protected void appendExtraProps(JSONObject schema) {
        if (this.getTplAppId() > 0) {
            schema.put("tplAppId", (Object)this.getTplAppId());
        }
    }

    public static SchemaResult parseSchemaResult(IMessageHandler module, Context context, byte[] schemaContent, boolean shallValidate, ISchemaFieldTypeContext schemaPlugin, SolrFieldsParser.ParseResultCallback ... parseResultCallback) {
        ParseResult parseResult;
        if (schemaContent == null) {
            throw new IllegalStateException("schemaContent can not be null");
        }
        if (schemaPlugin == null) {
            throw new IllegalArgumentException("param schemaPlugin can not be null");
        }
        try {
            IIndexMetaData meta = SolrFieldsParser.parse(() -> schemaContent, schemaPlugin, shallValidate);
            parseResult = meta.getSchemaParseResult();
            for (SolrFieldsParser.ParseResultCallback process : parseResultCallback) {
                process.process(Collections.emptyList(), parseResult);
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            parseResult = new ParseResult(shallValidate);
            parseResult.errlist.add(e.getMessage());
        }
        if (!parseResult.isValid() || parseResult.errlist.size() > 0) {
            for (String err : parseResult.errlist) {
                module.addErrorMessage(context, err);
            }
            return SchemaResult.create(null, schemaContent).faild();
        }
        return SchemaResult.create(parseResult, schemaContent);
    }

    public int getTplAppId() {
        return this.tplAppId;
    }

    public void setTplAppId(int tplAppId) {
        this.tplAppId = tplAppId;
    }

    private SchemaResult() {
    }
}

