/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.exec.lifecycle.hook.impl;

import com.qlangtech.tis.exec.lifecycle.hook.IIndexBuildLifeCycleHook;
import com.qlangtech.tis.order.center.IParamContext;
import com.qlangtech.tis.solrdao.extend.IndexBuildHook;
import com.qlangtech.tis.solrdao.impl.ParseResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AdapterIndexBuildLifeCycleHook
implements IIndexBuildLifeCycleHook {
    private static final Logger logger = LoggerFactory.getLogger(AdapterIndexBuildLifeCycleHook.class);

    public static IIndexBuildLifeCycleHook create(ParseResult schemaParse) {
        try {
            final ArrayList<IIndexBuildLifeCycleHook> indexBuildLifeCycleHooks = new ArrayList<IIndexBuildLifeCycleHook>();
            List<IndexBuildHook> indexBuildHooks = schemaParse.getIndexBuildHooks();
            for (IndexBuildHook buildHook : indexBuildHooks) {
                Class<?> clazz = Class.forName(buildHook.getFullClassName());
                IIndexBuildLifeCycleHook indexBuildHook = (IIndexBuildLifeCycleHook)clazz.newInstance();
                if (indexBuildHook instanceof AdapterIndexBuildLifeCycleHook) {
                    ((AdapterIndexBuildLifeCycleHook)indexBuildHook).init(buildHook.getParams());
                }
                indexBuildLifeCycleHooks.add(indexBuildHook);
            }
            return new IIndexBuildLifeCycleHook(){

                @Override
                public void start(IParamContext ctx) {
                    try {
                        indexBuildLifeCycleHooks.forEach(e -> e.start(ctx));
                    }
                    catch (Throwable e2) {
                        logger.error(e2.getMessage(), e2);
                    }
                }

                @Override
                public void buildFaild(IParamContext ctx) {
                    try {
                        indexBuildLifeCycleHooks.forEach(e -> e.buildFaild(ctx));
                    }
                    catch (Throwable e2) {
                        logger.error(e2.getMessage(), e2);
                    }
                }

                @Override
                public void buildSuccess(IParamContext ctx) {
                    try {
                        indexBuildLifeCycleHooks.forEach(e -> e.buildSuccess(ctx));
                    }
                    catch (Throwable e2) {
                        logger.error(e2.getMessage(), e2);
                    }
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void init(Map<String, String> params) {
    }

    @Override
    public void start(IParamContext ctx) {
    }

    @Override
    public void buildFaild(IParamContext ctx) {
    }

    @Override
    public void buildSuccess(IParamContext ctx) {
    }
}

