/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.realtime.utils;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public class NetUtils {
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static final String NETWORK_PRIORITY_DEFAULT = "default";
    private static final String NETWORK_PRIORITY_INNER = "inner";
    private static final String NETWORK_PRIORITY_OUTER = "outer";
    private static InetAddress LOCAL_ADDRESS = null;
    private static volatile String HOST_ADDRESS;
    private static String ANY_HOST_VALUE;
    public static final String LOCAL_HOST_VALUE = "127.0.0.1";
    public static final String TIS_PREFERRED_NETWORK_INTERFACE = "tis.network.interface.preferred";

    public static void main(String[] args) throws Exception {
        System.out.println("\n=== \u7ed3\u679c ===");
        System.out.println("getHostname(): " + NetUtils.getHostname());
        System.out.println("getHost(): " + NetUtils.getHost());
    }

    public static int getFreeSocketPort() {
        int port = 0;
        try {
            ServerSocket s = new ServerSocket(0);
            port = s.getLocalPort();
            s.close();
            return port;
        }
        catch (IOException iOException) {
            return port;
        }
    }

    public static boolean isPortAvailable(String host, int port) {
        boolean bl;
        int TIMEOUT_MS = 3000;
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(host, port), 3000);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SocketTimeoutException e) {
                return false;
            }
            catch (ConnectException e) {
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        socket.close();
        return bl;
    }

    public static String getHostname() {
        return NetUtils.getLocalAddress().getHostName();
    }

    public static String getHost() {
        if (HOST_ADDRESS != null) {
            return HOST_ADDRESS;
        }
        InetAddress address = NetUtils.getLocalAddress();
        if (address != null) {
            HOST_ADDRESS = address.getHostAddress();
            return HOST_ADDRESS;
        }
        return LOCAL_HOST_VALUE;
    }

    private static InetAddress getLocalAddress() {
        if (null != LOCAL_ADDRESS) {
            return LOCAL_ADDRESS;
        }
        return NetUtils.getLocalAddress0();
    }

    public static boolean isReachable(String host) {
        try {
            InetAddress address = InetAddress.getByName(host);
            if (NetUtils.isReachable(address)) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isReachable(InetAddress address) {
        Optional<InetAddress> addressOp = NetUtils.toValidAddress(address);
        if (addressOp.isPresent()) {
            try {
                if (addressOp.get().isReachable(5000)) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private static synchronized InetAddress getLocalAddress0() {
        if (null != LOCAL_ADDRESS) {
            return LOCAL_ADDRESS;
        }
        InetAddress localAddress = null;
        NetworkInterface networkInterface = NetUtils.findNetworkInterface();
        Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
        while (addresses.hasMoreElements()) {
            localAddress = addresses.nextElement();
            if (!NetUtils.isReachable(localAddress)) continue;
            Optional<InetAddress> addressOp = NetUtils.toValidAddress(localAddress);
            LOCAL_ADDRESS = addressOp.get();
            return LOCAL_ADDRESS;
        }
        try {
            localAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException addressOp) {
            // empty catch block
        }
        Optional<InetAddress> addressOp = NetUtils.toValidAddress(localAddress);
        if (addressOp.isPresent()) {
            LOCAL_ADDRESS = addressOp.get();
        }
        return LOCAL_ADDRESS;
    }

    private static Optional<InetAddress> toValidAddress(InetAddress address) {
        if (address instanceof Inet6Address) {
            Inet6Address v6Address = (Inet6Address)address;
            if (NetUtils.isPreferIPV6Address()) {
                return Optional.ofNullable(NetUtils.normalizeV6Address(v6Address));
            }
        }
        if (NetUtils.isValidV4Address(address)) {
            return Optional.of(address);
        }
        return Optional.empty();
    }

    private static InetAddress normalizeV6Address(Inet6Address address) {
        String addr = address.getHostAddress();
        int i = addr.lastIndexOf(37);
        if (i > 0) {
            try {
                return InetAddress.getByName(addr.substring(0, i) + "%" + address.getScopeId());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return address;
    }

    public static boolean isValidV4Address(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && IP_PATTERN.matcher(name).matches() && !ANY_HOST_VALUE.equals(name) && !LOCAL_HOST_VALUE.equals(name);
    }

    private static boolean isPreferIPV6Address() {
        return Boolean.getBoolean("java.net.preferIPv6Addresses");
    }

    private static NetworkInterface findNetworkInterface() {
        String name;
        List<Object> validNetworkInterfaces = Collections.emptyList();
        try {
            validNetworkInterfaces = NetUtils.getValidNetworkInterfaces();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        NetworkInterface result = null;
        for (NetworkInterface networkInterface : validNetworkInterfaces) {
            if (!NetUtils.isSpecifyNetworkInterface(networkInterface)) continue;
            result = networkInterface;
            break;
        }
        if (null != result) {
            return result;
        }
        for (NetworkInterface networkInterface : validNetworkInterfaces) {
            name = networkInterface.getName();
            if (!name.startsWith("en") && !name.startsWith("eth") && !name.startsWith("wlan")) continue;
            return networkInterface;
        }
        for (NetworkInterface networkInterface : validNetworkInterfaces) {
            name = networkInterface.getName();
            if (name.startsWith("utun") || name.startsWith("tun") || name.startsWith("tap") || name.startsWith("vmnet") || name.startsWith("vboxnet") || name.startsWith("docker") || name.startsWith("virbr") || name.startsWith("veth")) continue;
            return networkInterface;
        }
        return (NetworkInterface)validNetworkInterfaces.get(0);
    }

    private static boolean isSpecifyNetworkInterface(NetworkInterface networkInterface) {
        String preferredNetworkInterface = System.getProperty(TIS_PREFERRED_NETWORK_INTERFACE);
        return Objects.equals(networkInterface.getDisplayName(), preferredNetworkInterface);
    }

    private static List<NetworkInterface> getValidNetworkInterfaces() throws SocketException {
        LinkedList<NetworkInterface> validNetworkInterfaces = new LinkedList<NetworkInterface>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            if (NetUtils.ignoreNetworkInterface(networkInterface)) continue;
            validNetworkInterfaces.add(networkInterface);
        }
        return validNetworkInterfaces;
    }

    public static boolean ignoreNetworkInterface(NetworkInterface networkInterface) throws SocketException {
        return networkInterface == null || networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp();
    }

    static {
        ANY_HOST_VALUE = "0.0.0.0";
    }
}

