/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.web.start;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerStop {
    private static final Logger logger = LoggerFactory.getLogger(TriggerStop.class);

    public static boolean isStopCommand(String[] args) {
        for (String arg : args) {
            if (!"--stop".equals(arg)) continue;
            return true;
        }
        return false;
    }

    public static void stop(String host, int port, String key, int timeout) {
        if (host == null || host.length() == 0) {
            host = "127.0.0.1";
        }
        try {
            if (port <= 0 || port > 65535) {
                System.err.println("STOP.PORT property must be specified with a valid port number");
                TriggerStop.usageExit(-7);
            }
            if (key == null) {
                key = "";
                System.err.println("STOP.KEY property must be specified");
                System.err.println("Using empty key");
                TriggerStop.usageExit(-7);
            }
            try (Socket s = new Socket(InetAddress.getByName(host), port);){
                if (timeout > 0) {
                    s.setSoTimeout(timeout * 1000);
                }
                try (OutputStream out = s.getOutputStream();){
                    out.write((key + "\r\nstop\r\n").getBytes());
                    out.flush();
                    if (timeout > 0) {
                        String response;
                        logger.info("Waiting %,d seconds for jetty to stop%n", (Object)timeout);
                        LineNumberReader lin = new LineNumberReader(new InputStreamReader(s.getInputStream()));
                        while ((response = lin.readLine()) != null) {
                            logger.info("Received \"%s\"", (Object)response);
                            if (!"Stopped".equals(response)) continue;
                            logger.warn("Server reports itself as Stopped");
                        }
                    }
                }
            }
        }
        catch (SocketTimeoutException e) {
            logger.warn("Timed out waiting for stop confirmation");
            System.exit(-9);
        }
        catch (ConnectException e) {
            TriggerStop.usageExit(e, -4, false);
        }
        catch (Exception e) {
            TriggerStop.usageExit(e, -9, false);
        }
    }

    static void usageExit(int exit) {
        TriggerStop.usageExit(null, exit, false);
    }

    static void usageExit(Throwable t, int exit, boolean test) {
        if (t != null) {
            t.printStackTrace(System.err);
        }
        System.err.println();
        System.err.println("Usage: java -jar $JETTY_HOME/start.jar [options] [properties] [configs]");
        System.err.println("       java -jar $JETTY_HOME/start.jar --help  # for more information");
        if (test) {
            System.err.println("EXIT: " + exit);
        } else {
            System.exit(exit);
        }
    }

    public static void main(String[] args) {
    }
}

