/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.web.start;

import com.qlangtech.tis.web.start.IWebAppContextCollector;
import com.qlangtech.tis.web.start.JettyTISRunner;
import com.qlangtech.tis.web.start.TisAppLaunch;
import com.qlangtech.tis.web.start.TisRunMode;
import com.qlangtech.tis.web.start.TisSubModule;
import com.qlangtech.tis.web.start.TriggerStop;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TisApp {
    public static final String KEY_WEB_ROOT_DIR = "web.root.dir";
    private static Logger logger;
    private final JettyTISRunner jetty;
    static final String APP_CONSOLE = "root";
    static final String PATH_WEB_XML = "WEB-INF/web.xml";

    public static void setLogbackContextSelector() {
        System.setProperty("logback.ContextSelector", "JNDI");
    }

    public static void main(String[] args) throws Exception {
        if (TriggerStop.isStopCommand(args)) {
            int stopPort = Integer.parseInt(System.getProperty("STOP.PORT"));
            String key = System.getProperty("STOP.KEY");
            TriggerStop.stop("127.0.0.1", stopPort, key, 5);
            return;
        }
        TisAppLaunch.get().setRunMode(TisRunMode.Standalone);
        TisApp.launchTISApp(JettyTISRunner.class.getClassLoader(), args);
    }

    public static void launchTISApp(ClassLoader parentLoader, String[] args) throws Exception {
        TisApp tisApp = new TisApp(TisSubModule.WEB_START.getLaunchPort(), parentLoader, context -> {
            context.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
            context.setInitParameter("org.eclipse.jetty.servlet.Default.welcomeServlets", "true");
        });
        tisApp.start(args);
    }

    public TisApp(TisSubModule subModule, IWebAppContextCollector webAppContextCollector) throws Exception {
        this.jetty = new JettyTISRunner(subModule.getLaunchPort(), webAppContextCollector);
    }

    public TisApp(TisSubModule subModule, JettyTISRunner.IWebAppContextSetter contextSetter) throws Exception {
        this.jetty = new JettyTISRunner(subModule.servletContext, subModule.getLaunchPort(), contextSetter);
    }

    public TisApp(int port, JettyTISRunner.IWebAppContextSetter contextSetter) throws Exception {
        this(port, JettyTISRunner.class.getClassLoader(), contextSetter);
    }

    public TisApp(int port, ClassLoader parentLoader, JettyTISRunner.IWebAppContextSetter contextSetter) throws Exception {
        this.jetty = new JettyTISRunner(port, parentLoader, contextSetter);
        this.initContext();
    }

    public void addContext(String context, File contextDir) throws Exception {
        this.jetty.addContext(context, contextDir, false, false);
    }

    private void initContext() throws Exception {
        File root = this.getWebRootDir();
        logger.info("webapps context dir:{}", (Object)root.getAbsolutePath());
        File contextDir = null;
        for (String context : root.list()) {
            contextDir = new File(root, context);
            if (!contextDir.isDirectory() || TisSubModule.WEB_START.moduleName.equals(context) || APP_CONSOLE.equals(context)) continue;
            logger.info("load context:{}", (Object)context);
            this.jetty.addContext(contextDir);
        }
        contextDir = new File(root, APP_CONSOLE);
        if (contextDir.exists() && contextDir.isDirectory()) {
            this.addRootContext(contextDir);
        }
        if (this.jetty.validateContextHandler()) {
            throw new IllegalStateException("handlers can not small than 1,web rootDir:" + root.getAbsolutePath());
        }
    }

    public void addRootContext(File contextDir) throws Exception {
        File webappFile = new File(this.jetty.getWebapp(contextDir), PATH_WEB_XML);
        if (!webappFile.exists()) {
            throw new IllegalStateException(webappFile.getAbsolutePath() + " shall be exist");
        }
        this.jetty.addContext("/", contextDir, false, true);
    }

    private void addJars(File libDir, List<URL> jars) throws MalformedURLException {
        this.addJars(libDir, jars, f -> true);
    }

    private void addJars(File libDir, List<URL> jars, FileFilter fileFilter) throws MalformedURLException {
        if (!libDir.exists()) {
            throw new IllegalStateException("libDir:" + libDir.getAbsolutePath());
        }
        Iterator jarIt = FileUtils.iterateFiles((File)libDir, (String[])new String[]{"jar"}, (boolean)false);
        File childFile = null;
        while (jarIt.hasNext()) {
            childFile = (File)jarIt.next();
            if (!fileFilter.accept(childFile)) continue;
            jars.add(childFile.toURI().toURL());
        }
    }

    private File getWebRootDir() {
        File root = new File(System.getProperty(KEY_WEB_ROOT_DIR, "."));
        if (!root.exists()) {
            throw new IllegalStateException("web.root.dir not exist:" + root.getAbsolutePath());
        }
        return root;
    }

    public void start(String[] args) throws Exception {
        logger.info("start TIS with port:{}", (Object)this.jetty.getPort());
        this.jetty.start();
    }

    static {
        TisApp.setLogbackContextSelector();
        logger = LoggerFactory.getLogger(TisApp.class);
    }
}

