/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.web.start;

import com.qlangtech.tis.health.check.IStatusChecker;
import com.qlangtech.tis.health.check.StatusLevel;
import com.qlangtech.tis.health.check.StatusModel;
import com.qlangtech.tis.web.start.IServletContextAware;
import com.qlangtech.tis.web.start.IWebAppContextCollector;
import com.qlangtech.tis.web.start.TISAppClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.NetworkTrafficServerConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyTISRunner {
    private Server server;
    public static boolean enableJndi = true;
    private static JettyTISRunner jetty;
    private static final Logger logger;
    private final ClassLoader parentLoader;
    private final int port;
    private final IWebAppContextSetter contextSetter;
    private HandlerList handlers = new HandlerList(){

        public void addHandler(Handler handler) {
            if (handler instanceof WebAppContext) {
                JettyTISRunner.this.contextSetter.process((WebAppContext)handler);
            }
            super.addHandler(handler);
            JettyTISRunner.this.contextAddCount.incrementAndGet();
        }
    };
    private final AtomicInteger contextAddCount = new AtomicInteger();
    private List<IWebAppContextCollector> webAppContextCollector;
    private static final String KEY_DATA_DIR = "data.dir";

    public static void start(String contextPath, int port) throws Exception {
        JettyTISRunner.start(contextPath, port, c -> {});
    }

    public int getPort() {
        return this.port;
    }

    public static void start(String contextPath, int port, IWebAppContextSetter contextSetter) throws Exception {
        if (jetty != null) {
            throw new IllegalStateException("instance jetty shall be null");
        }
        jetty = new JettyTISRunner(contextPath, port, contextSetter);
        jetty.start();
    }

    public static void stopJetty() throws Exception {
        if (jetty == null) {
            throw new IllegalStateException("instance jetty have not been initialize");
        }
        jetty.stop();
    }

    JettyTISRunner(String context, int port, IWebAppContextSetter contextSetter) throws Exception {
        this(port, JettyTISRunner.class.getClassLoader(), contextSetter);
        this.addContext(context, new File("."), false, true);
    }

    JettyTISRunner(int port, IWebAppContextCollector webAppContextCollector) throws Exception {
        this(port, JettyTISRunner.class.getClassLoader(), (WebAppContext c) -> {});
        this.addContext(webAppContextCollector);
    }

    public void addContext(IWebAppContextCollector webAppContextCollector) throws IOException {
        webAppContextCollector.launchContext(this.getHandlers());
        if (this.webAppContextCollector != null) {
            throw new IllegalStateException("webAppContextCollector shall not be set twice");
        }
        this.webAppContextCollector = Collections.singletonList(webAppContextCollector);
    }

    JettyTISRunner(int port, ClassLoader parentLoader, IWebAppContextSetter contextSetter) {
        this.port = port;
        this.parentLoader = parentLoader;
        this.contextSetter = contextSetter;
    }

    public final HandlerCollection getHandlers() {
        return this.handlers;
    }

    public void addContext(File contextDir) throws Exception {
        this.addContext("/" + contextDir.getName(), contextDir, true, true);
    }

    public void addContext(WebAppContext webAppContext) throws Exception {
        this.handlers.addHandler((Handler)webAppContext);
    }

    public void addContext(String context, File contextDir, boolean addDirJars, boolean checkWebXmlExist) throws Exception {
        File webappDir = this.getWebapp(contextDir);
        if (!webappDir.exists() || !webappDir.isDirectory() || checkWebXmlExist && !new File(webappDir, "WEB-INF/web.xml").exists()) {
            logger.warn("dir is not webapp,skip:{}", (Object)webappDir.getAbsolutePath());
            return;
        }
        Resource webContentResource = Resource.newResource((File)webappDir);
        WebAppContext webAppContext = new WebAppContext(webContentResource, context);
        if (addDirJars) {
            File libsDir = new File(contextDir, "lib");
            if (!libsDir.exists() || !libsDir.isDirectory()) {
                throw new IllegalStateException("libs is illegal:" + libsDir.getAbsolutePath());
            }
            ArrayList<URL> jarfiles = new ArrayList<URL>();
            ArrayList<String> resNames = new ArrayList<String>();
            for (String path : libsDir.list()) {
                resNames.add(path);
                jarfiles.add(new File(libsDir, path).toURI().toURL());
            }
            File confDir = new File(contextDir, "conf");
            if (!confDir.exists()) {
                throw new IllegalStateException("web context:" + context + " dir not exist:" + confDir.getAbsolutePath());
            }
            resNames.add(confDir.getName());
            jarfiles.add(confDir.toURI().toURL());
            TISAppClassLoader contextCloassLoader = new TISAppClassLoader(context, this.parentLoader, jarfiles.toArray(new URL[jarfiles.size()]));
            logger.info("context:" + context + " start with customer classLoader,resCount:" + jarfiles.size() + ",enums:" + String.join((CharSequence)",", resNames));
            webAppContext.setClassLoader((ClassLoader)contextCloassLoader);
        } else {
            logger.info("context:" + context + " start with system classloader");
            webAppContext.setClassLoader(this.getClass().getClassLoader());
        }
        webAppContext.setDescriptor("/WEB-INF/web.xml");
        webAppContext.setDisplayName(context);
        webAppContext.setConfigurationDiscovered(true);
        webAppContext.setParentLoaderPriority(true);
        webAppContext.setThrowUnavailableOnStartupException(true);
        webAppContext.addServlet(CheckHealth.class, "/check_health");
        this.addContext(webAppContext);
    }

    public File getWebapp(File contextDir) {
        return new File(contextDir, "webapp");
    }

    private void init() {
        if (this.validateContextHandler()) {
            throw new IllegalStateException("handlers can not small than 1");
        }
        this.server = new Server((ThreadPool)new QueuedThreadPool(450));
        if (enableJndi) {
            Configuration.ClassList classlist = Configuration.ClassList.setServerDefault((Server)this.server);
            classlist.addAfter("org.eclipse.jetty.webapp.FragmentConfiguration", new String[]{"org.eclipse.jetty.plus.webapp.EnvConfiguration", "org.eclipse.jetty.plus.webapp.PlusConfiguration"});
        }
        NetworkTrafficServerConnector connector = new NetworkTrafficServerConnector(this.server);
        HttpConfiguration configuration = new HttpConfiguration();
        connector.addConnectionFactory((ConnectionFactory)new HTTP2CServerConnectionFactory(configuration));
        connector.setPort(this.port);
        this.server.setConnectors(new Connector[]{connector});
        this.server.setStopAtShutdown(true);
        this.server.setHandler((Handler)this.handlers);
    }

    public boolean validateContextHandler() {
        return this.contextAddCount.get() < 1 || this.handlers.getHandlers().length < 1;
    }

    public void addServlet(HttpServlet servlet, String pathSpec) {
    }

    public void addFilter(FilterHolder filter, String urlpattern) {
    }

    public void start() throws Exception {
        this.start(true);
    }

    private static File getDataDir() {
        File dir = new File(System.getProperty(KEY_DATA_DIR, "/opt/data/tis"));
        if (!dir.isDirectory() || !dir.exists()) {
            throw new IllegalStateException("dir:" + dir.getAbsolutePath() + " is invalid DATA DIR");
        }
        return dir;
    }

    private void start(boolean waitForSolr) throws Exception {
        this.init();
        if (!this.server.isRunning()) {
            this.server.start();
            if (this.webAppContextCollector != null) {
                for (IWebAppContextCollector c : this.webAppContextCollector) {
                    c.afterLaunchContext();
                }
            }
            this.server.join();
        }
    }

    private void stop() throws Exception {
        if (this.server.isRunning()) {
            this.server.stop();
        }
    }

    static {
        logger = LoggerFactory.getLogger(JettyTISRunner.class);
    }

    public static class Servlet404
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        public void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
            res.sendError(404, "Can not find: " + req.getRequestURI());
        }
    }

    public static class CheckHealth
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        private List<IStatusChecker> checks;

        public void init() throws ServletException {
            this.checks = new ArrayList<IStatusChecker>();
            ServiceLoader.load(IStatusChecker.class).forEach(r -> {
                if (r instanceof IServletContextAware) {
                    ((IServletContextAware)((Object)r)).setServletContext(this.getServletContext());
                }
                this.checks.add((IStatusChecker)r);
            });
        }

        public void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
            for (IStatusChecker check : this.checks) {
                StatusModel model = check.check();
                if (model.level == StatusLevel.OK) continue;
                res.getWriter().print("Check[" + check.getClass() + "] fail:" + model.message);
                return;
            }
            res.getWriter().write("ok");
        }
    }

    public static interface IWebAppContextSetter {
        public void process(WebAppContext var1);
    }
}

