/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.qlangtech.tis.datax.job.SSERunnable;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;

public class WaittingProcessCollectorAppender
extends UnsynchronizedAppenderBase<LoggingEvent> {
    private PatternLayout layout;

    public void start() {
        this.layout = new PatternLayout();
        this.layout.setPattern("%msg%n");
        this.layout.setContext(this.getContext());
        super.start();
        this.layout.start();
    }

    protected void append(LoggingEvent e) {
        Level level = null;
        if (SSERunnable.sseAware()) {
            SSERunnable sse = SSERunnable.getLocal();
            level = e.getLevel();
            if (level.isGreaterOrEqual(Level.ERROR)) {
                try (LineIterator lines = IOUtils.lineIterator((Reader)new StringReader(this.layout.doLayout((ILoggingEvent)e)));){
                    while (lines.hasNext()) {
                        sse.error(null, e.getTimeStamp(), lines.next());
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                return;
            }
            if (level.isGreaterOrEqual(Level.DEBUG)) {
                sse.info(null, e.getTimeStamp(), e.getFormattedMessage());
                return;
            }
            throw new IllegalStateException("unhandler error level:" + level + " msg:" + e.getFormattedMessage());
        }
    }
}

