/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.log;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.FileAppender;
import com.qlangtech.tis.web.start.TisAppLaunch;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class RealtimeLoggerCollectorAppender
extends FileAppender<LoggingEvent> {
    private static final Map<String, RealtimeLoggerCollectorAppender> bufferAppenderMap = new HashMap<String, RealtimeLoggerCollectorAppender>();
    public static final LoggerCollectorAppenderListenerWrapper appenderListener = new LoggerCollectorAppenderListenerWrapper();

    public static void addListener(String targetAppenderName, LoggingEventMeta mtarget, LoggerCollectorAppenderListener listener) {
        appenderListener.addLoggerEventListener(targetAppenderName, mtarget, listener);
    }

    static RealtimeLoggerCollectorAppender getBufferAppender(String name) {
        RealtimeLoggerCollectorAppender appender = bufferAppenderMap.get(name);
        if (appender == null) {
            throw new IllegalStateException("appender:" + name + " relevant appender can not be null,exist keys:" + bufferAppenderMap.keySet());
        }
        return appender;
    }

    protected void append(LoggingEvent eventObject) {
        super.append((Object)eventObject);
        if (!this.isStarted()) {
            return;
        }
        appenderListener.process(this.name, eventObject);
    }

    public void setName(String name) {
        super.setName(name);
        bufferAppenderMap.put(name, this);
    }

    public static class LogTypeListeners {
        private final LoggingEventMeta mtarget;
        private final List<LoggerCollectorAppenderListener> listeners = new ArrayList<LoggerCollectorAppenderListener>();

        public LogTypeListeners(LoggingEventMeta mtarget) {
            this.mtarget = mtarget;
        }

        public int getListenerSize() {
            return this.listeners.size();
        }

        boolean send(LoggingEvent event) {
            Iterator<LoggerCollectorAppenderListener> it = this.listeners.iterator();
            LoggerCollectorAppenderListener listener = null;
            boolean hasListener = false;
            while (it.hasNext()) {
                listener = it.next();
                if (listener.isClosed()) {
                    it.remove();
                    continue;
                }
                listener.process(this.mtarget, event);
                hasListener = true;
            }
            return hasListener;
        }
    }

    public static class LoggerCollectorAppenderListenerWrapper {
        private final Map<String, LogTypeListeners> targetAppenderLister = new WeakHashMap<String, LogTypeListeners>();

        public LogTypeListeners getLogTypeListeners(String targetAppenderName) {
            return this.targetAppenderLister.get(targetAppenderName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void process(String targetAppenderName, LoggingEvent event) {
            LogTypeListeners targetListeners = this.targetAppenderLister.get(targetAppenderName);
            if (targetListeners == null) {
                return;
            }
            boolean hasListener = targetListeners.send(event);
            if (hasListener) return;
            Class<LoggerCollectorAppenderListenerWrapper> clazz = LoggerCollectorAppenderListenerWrapper.class;
            synchronized (LoggerCollectorAppenderListenerWrapper.class) {
                this.targetAppenderLister.remove(targetAppenderName);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLoggerEventListener(String targetAppenderName, LoggingEventMeta mtarget, LoggerCollectorAppenderListener l) {
            Class<LoggerCollectorAppenderListenerWrapper> clazz = LoggerCollectorAppenderListenerWrapper.class;
            synchronized (LoggerCollectorAppenderListenerWrapper.class) {
                LogTypeListeners listeners = this.targetAppenderLister.get(targetAppenderName);
                if (listeners == null) {
                    listeners = new LogTypeListeners(mtarget);
                    this.targetAppenderLister.put(targetAppenderName, listeners);
                }
                RealtimeLoggerCollectorAppender appender = bufferAppenderMap.get(targetAppenderName);
                File file = null;
                file = appender != null ? new File(appender.getFile()) : new File(TisAppLaunch.getAssebleTaskDir(), targetAppenderName + ".log");
                if (file.exists()) {
                    l.readLogTailer(mtarget, file);
                }
                listeners.listeners.add(l);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }
    }

    public static class LoggingEventMeta {
        public Integer taskid;
        public String collection;
        public int logTypeVal;
    }

    public static interface LoggerCollectorAppenderListener {
        public void process(LoggingEventMeta var1, LoggingEvent var2);

        public void readLogTailer(LoggingEventMeta var1, File var2);

        public boolean isClosed();
    }
}

