/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.trigger.socket;

import com.qlangtech.tis.trigger.socket.LogType;
import java.io.Serializable;
import java.util.Objects;

public class ExecuteState<T>
implements Serializable {
    private static final long serialVersionUID = -2958243389261902244L;
    private final LogType logType;
    private final T msg;
    private Long jobId;
    private Long taskId;
    private String serviceName;
    private String execState;
    private long time;
    private String component;

    public LogType getLogType() {
        return this.logType;
    }

    private ExecuteState(LogType logType, T msg) {
        Objects.requireNonNull(logType, "infotype can not be null");
        Objects.requireNonNull(msg, "param msg can not be null");
        this.logType = logType;
        this.msg = msg;
    }

    public String getExecState() {
        return this.execState;
    }

    public void setExecState(String execState) {
        this.execState = execState;
    }

    public String getCollectionName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public static <TT> ExecuteState<TT> create(LogType infoType, TT msg) {
        ExecuteState<TT> state = new ExecuteState<TT>(infoType, msg);
        state.time = System.currentTimeMillis();
        return state;
    }

    public String toString() {
        return "event{logType=" + this.logType + ", msg=" + this.msg + ", jobId=" + this.jobId + ", taskId=" + this.taskId + ", serviceName='" + this.serviceName + "', execState='" + this.execState + "', time=" + this.time + ", component='" + this.component + "'}";
    }

    public long getTime() {
        return this.time;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public void setJobId(Long jobId) {
        this.jobId = jobId;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public T getMsg() {
        return this.msg;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public static class TimeoutResult {
        boolean timeout = true;

        public boolean isTimeout() {
            return this.timeout;
        }

        public void setTimeout(boolean timeout) {
            this.timeout = timeout;
        }
    }
}

