/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.trigger.jst;

import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.trigger.jst.PayloadMonitorTarget;
import com.qlangtech.tis.trigger.jst.RegisterMonotorTarget;
import com.qlangtech.tis.trigger.socket.LogType;
import java.io.Serializable;

public class MonotorTarget
implements Serializable {
    public static final String DUMP_COLLECTION = "dummpCollection";
    private static final long serialVersionUID = 1L;
    public final DataXName collection;
    public final LogType logType;
    private Integer taskid;

    private static MonotorTarget create(DataXName collection, LogType logtype) {
        if (logtype == null) {
            throw new IllegalArgumentException("log type can not be null");
        }
        return new MonotorTarget(collection, logtype);
    }

    public Integer getTaskid() {
        return this.taskid;
    }

    public void setTaskid(Integer taskid) {
        this.taskid = taskid;
    }

    public static RegisterMonotorTarget createRegister(MonotorTarget target) {
        return new RegisterMonotorTarget(true, target.collection, target.logType);
    }

    public static RegisterMonotorTarget createRegister(DataXName collection, LogType logtype) {
        MonotorTarget target = MonotorTarget.create(collection, logtype);
        return new RegisterMonotorTarget(true, target.collection, target.logType);
    }

    public static PayloadMonitorTarget createPayloadMonitor(DataXName collection, String payload, LogType logtype) {
        return new PayloadMonitorTarget(true, collection, payload, logtype);
    }

    public static RegisterMonotorTarget createUnregister(DataXName collection, LogType logtype) {
        MonotorTarget target = MonotorTarget.create(collection, logtype);
        return new RegisterMonotorTarget(false, target.collection, target.logType);
    }

    public static RegisterMonotorTarget createUnregister(MonotorTarget target) {
        return new RegisterMonotorTarget(false, target.collection, target.logType);
    }

    public int hashCode() {
        return (this.collection + this.logType.getValue()).hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    MonotorTarget(DataXName collection, LogType logType) {
        this.collection = collection;
        this.logType = logType;
    }

    public DataXName getCollection() {
        return this.collection;
    }

    public String toString() {
        return "monitorTarget[collection:" + this.collection + ",type:" + this.logType + "]";
    }

    public LogType getLogType() {
        return this.logType;
    }

    public boolean testLogType(LogType ... testType) {
        for (LogType type : testType) {
            if (type != this.logType) continue;
            return true;
        }
        return false;
    }
}

