/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.visitor;

import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.sql.parser.visitor.IBlockToString;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BlockScriptBuffer
implements IBlockToString {
    public static final int INDENT_STEP = 4;
    private static final Pattern PATTERN_LAST_RETURN = Pattern.compile("\n\\s*$");
    private final List<Object> format = new ArrayList<Object>();
    private int indent;
    private boolean lastReturnChar = false;

    public BlockScriptBuffer() {
        this(0);
    }

    public BlockScriptBuffer(int indent) {
        this.indent = indent;
    }

    private void addIndent() {
        this.indent += 4;
    }

    private void decreaseIndent() {
        this.indent -= 4;
    }

    public BlockScriptBuffer methodBody(Object method, IFuncFormatCall call) {
        return this.methodBody(true, method, call);
    }

    public BlockScriptBuffer methodBody(boolean returnLine, Object method, IFuncFormatCall call) {
        return this.blockBody(returnLine, new String[]{"{", "}"}, method, call);
    }

    public BlockScriptBuffer block(Object method, IFuncFormatCall call) {
        return this.block(false, method, call);
    }

    public BlockScriptBuffer block(boolean returnLine, Object method, IFuncFormatCall call) {
        return this.blockBody(returnLine, new String[]{"(", ")"}, method, call);
    }

    public void buildRowMapTraverseLiteria(EntityName entity, IFuncFormatCall call) {
        this.methodBody("for ( ( r:RowMap) <- " + entity.entities() + ".asScala)", call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockScriptBuffer blockBody(boolean returnLine, String[] brackets, Object method, IFuncFormatCall call) {
        if (returnLine) {
            this.returnLine();
            this.appendIndent();
        }
        this.append(method).append(brackets[0]).returnLine();
        this.addIndent();
        try {
            call.execute(this);
            this.returnLine();
        }
        finally {
            this.decreaseIndent();
        }
        this.appendIndent().append(brackets[1]);
        if (returnLine) {
            this.returnLine();
        }
        return this;
    }

    public BlockScriptBuffer append(Object val) {
        if (val instanceof String) {
            Matcher matcher = PATTERN_LAST_RETURN.matcher((String)val);
            this.lastReturnChar = matcher.find();
        } else {
            this.lastReturnChar = false;
        }
        this.format.add(val);
        return this;
    }

    public BlockScriptBuffer appendLine(Object val) {
        return this.startLine(val).appendIndent();
    }

    public BlockScriptBuffer appendLine(String val, Object ... params) {
        Object[] p = new String[params.length];
        Object o = null;
        for (int i = 0; i < params.length; ++i) {
            o = params[i];
            p[i] = o instanceof String ? "\"" + o + "\"" : String.valueOf(o);
        }
        return this.startLine(String.format(val, p)).appendIndent();
    }

    public BlockScriptBuffer startLine(Object val) {
        if (!this.lastReturnChar) {
            this.returnLine();
        }
        this.appendIndent();
        return this.append(val);
    }

    private BlockScriptBuffer appendIndent() {
        if (this.indent > 0) {
            for (int i = 0; i < this.indent; ++i) {
                this.format.add(" ");
            }
        }
        return this;
    }

    public BlockScriptBuffer append(long val) {
        this.format.add(val);
        return this;
    }

    public BlockScriptBuffer returnLine() {
        this.append("\n");
        return this;
    }

    @Override
    public String toString() {
        StringBuffer buffer = this.getContent();
        return buffer.toString();
    }

    public StringBuffer getContent() {
        StringBuffer buffer = new StringBuffer();
        for (Object o : this.format) {
            buffer.append(o);
        }
        return buffer;
    }

    public static interface IFuncFormatCall {
        public void execute(BlockScriptBuffer var1);
    }
}

