/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.tuple.creator;

import com.qlangtech.tis.order.center.IParamContext;
import com.qlangtech.tis.realtime.transfer.UnderlineUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;

public interface IStreamIncrGenerateStrategy {
    public static final String TEMPLATE_FLINK_TABLE_HANDLE_SCALA = "flink_table_handle_scala.vm";

    default public boolean isExcludeFacadeDAOSupport() {
        return true;
    }

    default public IStreamTemplateResource getFlinkStreamGenerateTplResource() {
        return IStreamTemplateResource.createClasspathResource("flink_source_handle_scala.vm", true);
    }

    default public IStreamTemplateData decorateMergeData(IStreamTemplateData mergeData) {
        return mergeData;
    }

    public static interface IStreamTemplateData {
        public static final String KEY_STREAM_SOURCE_TABLE_SUFFIX = "_source";

        default public String getCurrentTimestamp() {
            return IParamContext.getCurrentMillisecTimeStamp();
        }

        public String getCollection();

        default public String getJavaName() {
            return UnderlineUtils.getJavaName(this.getCollection());
        }

        public <T> List<T> getDumpTables();
    }

    public static class StringTemplateResource
    implements IStreamTemplateResource {
        private final String tmpContent;

        public StringTemplateResource(String tmpContent) {
            this.tmpContent = tmpContent;
        }

        public Reader getContentReader() {
            return new StringReader(this.tmpContent);
        }
    }

    public static class ClasspathTemplateResource
    implements IStreamTemplateResource {
        private final String tplPath;

        public ClasspathTemplateResource(String tplName) {
            this.tplPath = tplName;
        }

        public String getTplPath() {
            return this.tplPath;
        }
    }

    public static interface IStreamTemplateResource {
        public static IStreamTemplateResource createClasspathResource(String tplName, boolean relativePath) {
            return new ClasspathTemplateResource((String)(relativePath ? "/com/qlangtech/tis/classtpl/" + tplName : tplName));
        }

        public static IStreamTemplateResource createStringContentResource(String content) {
            return new StringTemplateResource(content);
        }
    }
}

