/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.tuple.creator;

import com.qlangtech.tis.fullbuild.indexbuild.IDumpTable;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class EntityName
implements IDumpTable {
    public static final String ROW_MAP_CLASS_NAME = "RowMap";
    private final Optional<String> dbname;
    private final String tabName;
    private boolean dft = false;
    private final boolean physics;
    private final boolean escapeDBName;
    public static final String KeySubTableQuery = "SubTableQuery";

    public static EntityName createSubQueryTable() {
        return new SubTableQueryEntity();
    }

    public static EntityName create(String dbname, String tabName) {
        if (StringUtils.isEmpty((String)dbname)) {
            throw new IllegalArgumentException("param dbName can not be null");
        }
        if (StringUtils.isEmpty((String)tabName)) {
            throw new IllegalArgumentException("param tabName can not be null");
        }
        return EntityName.parse(dbname + "." + tabName);
    }

    public static EntityName parse(String entityName) {
        return EntityName.parse(entityName, false);
    }

    public static EntityName parse(String entityName, boolean physics) {
        return EntityName.parse(entityName, physics, true);
    }

    public static EntityName parse(String entityName, boolean physics, boolean escapeDBName) {
        String[] entitInfo = StringUtils.split((String)entityName, (String)".");
        EntityName entity = null;
        if (entitInfo.length == 1) {
            entity = new EntityName(entitInfo[0], physics);
        } else if (entitInfo.length == 2) {
            entity = new EntityName(Optional.of(entitInfo[0]), entitInfo[1], physics, escapeDBName);
        } else {
            throw new IllegalStateException("line:" + entityName + " is not valid");
        }
        return entity;
    }

    @Override
    public String getDbName() {
        return this.getDbname();
    }

    public String getDbname() {
        if (this.dbname.isPresent()) {
            return this.dbname.get();
        }
        return null;
    }

    @Override
    public String getTableName() {
        return this.getTableName(Optional.empty());
    }

    public String getTableName(Optional<String> escapeChar) {
        return EntityName.getEscapedName(escapeChar, this.tabName);
    }

    public String getFullName(Optional<String> escapeChar) {
        if (this.dbname.isPresent()) {
            return (this.escapeDBName ? EntityName.getEscapedName(escapeChar, this.dbname.get()) : this.dbname.get()) + "." + this.getTableName(escapeChar);
        }
        return this.getTableName(escapeChar);
    }

    private static String getEscapedName(Optional<String> escapeChar, String name) {
        if (escapeChar.isPresent()) {
            String ec = escapeChar.get();
            return ec + name + ec;
        }
        return name;
    }

    @Override
    public String getFullName() {
        return this.getFullName(Optional.empty());
    }

    public String createNewLiteriaToken() {
        StringBuffer buffer = new StringBuffer("EntityName.parse(\"");
        if (this.dft) {
            buffer.append(this.getTabName());
        } else {
            buffer.append(this.toString());
        }
        buffer.append("\")");
        return buffer.toString();
    }

    public static EntityName createFuncEntity(final StringBuffer buffer) {
        EntityName funcEntity = new EntityName("func"){

            @Override
            public String toString() {
                return buffer.toString();
            }
        };
        return funcEntity;
    }

    private EntityName(String tabName) {
        this(tabName, false);
    }

    private EntityName(String tabName, boolean physics) {
        this(Optional.empty(), tabName, physics, false);
        this.dft = true;
    }

    public boolean useDftDbName() {
        return this.dft;
    }

    private EntityName(Optional<String> dbname, String tabName, boolean physics, boolean escapeDBName) {
        this.dbname = dbname;
        this.tabName = tabName;
        this.physics = physics;
        this.escapeDBName = escapeDBName;
    }

    public boolean isPhysics() {
        return this.physics;
    }

    public String facadeDAOInstanceName() {
        return EntityName.facadeDAOInstanceName(this.getDbname());
    }

    public static String facadeDAOInstanceName(String dbName) {
        if ("tis".equals(dbName)) {
            throw new IllegalStateException("dbname:" + dbName + " can not equal with 'tis'");
        }
        return UnderlineUtils.removeUnderline(dbName) + "DAOFacade";
    }

    public static String createColValLiteria(String colTransferName, String colName, String valToken) {
        return EntityName.createColGetterLiteria(colTransferName, colName) + ".getVal(" + valToken + ",true)";
    }

    public String createColValLiteria(String colName, String valToken) {
        return this.createColGetterLiteria(colName) + ".getVal(" + valToken + ",true)";
    }

    public String createColValLiteria(String colName) {
        return this.createColValLiteria(colName, this.getJavaEntityName());
    }

    public String createColGetterLiteria(String colName) {
        return EntityName.createColGetterLiteria(this.getJavaEntityName() + "Meta", colName);
    }

    public static String createColGetterLiteria(String colTransferName, String colName) {
        return colTransferName + ".getColMeta(\"" + colName + "\")";
    }

    public String getJavaEntityName() {
        return UnderlineUtils.removeUnderline(this.tabName).toString();
    }

    public String getTabName() {
        return this.tabName;
    }

    public String entities() {
        return this.getJavaEntityName() + "s";
    }

    public String buildDefineRowMapListLiteria() {
        return "var " + this.entities() + ": List[RowMap]  = null";
    }

    public String buildExecuteQueryDAOLiteria() {
        return this.entities() + " = this." + this.facadeDAOInstanceName() + ".get" + this.capitalizeEntityName() + "DAO().selectColsByExample(" + this.getJavaEntityName() + "Criteria,1,100)";
    }

    public String buildAddSelectorColsLiteria(Set<String> selCols) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getJavaEntityName()).append("Criteria.addSelCol(").append(selCols.stream().map(rr -> this.javaPropTableName() + "ColEnum." + StringUtils.upperCase((String)rr)).collect(Collectors.joining(" ,"))).append(")");
        return buffer.toString();
    }

    public String buildDefineCriteriaEqualLiteria() {
        return "var " + this.getJavaEntityName() + "Criteria :" + this.capitalizeEntityName() + "Criteria = new " + this.capitalizeEntityName() + "Criteria()";
    }

    public String buildCreateCriteriaLiteria() {
        return this.getJavaEntityName() + "Criteria.createCriteria()";
    }

    public final String javaPropTableName() {
        if (this.dft) {
            throw new IllegalStateException("table:" + this.getJavaEntityName() + " shall set dbName");
        }
        return StringUtils.capitalize((String)this.getJavaEntityName());
    }

    public String capitalizeEntityName() {
        return StringUtils.capitalize((String)this.getJavaEntityName());
    }

    public final String javaPropDbName() {
        if (this.dft) {
            throw new IllegalStateException("table:" + this.getJavaEntityName() + " shall set dbName");
        }
        return UnderlineUtils.removeUnderline(this.getDbname()).toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EntityName)) {
            throw new IllegalStateException("obj" + obj + ",[" + obj.getClass() + "] is not type of EntityName");
        }
        return this.hashCode() == ((EntityName)obj).hashCode();
    }

    public String toString() {
        return this.getFullName();
    }

    private static class UnderlineUtils {
        private UnderlineUtils() {
        }

        public static StringBuffer removeUnderline(String value) {
            StringBuffer parsedName = new StringBuffer();
            char[] nameAry = value.toCharArray();
            boolean findUnderChar = false;
            for (int i = 0; i < nameAry.length; ++i) {
                if (nameAry[i] == '_') {
                    findUnderChar = true;
                    continue;
                }
                if (findUnderChar) {
                    parsedName.append(Character.toUpperCase(nameAry[i]));
                    findUnderChar = false;
                    continue;
                }
                parsedName.append(nameAry[i]);
            }
            return parsedName;
        }
    }

    private static class SubTableQueryEntity
    extends EntityName
    implements SubTableQuery {
        public SubTableQueryEntity() {
            super(EntityName.KeySubTableQuery);
        }

        @Override
        public String getTabName() {
            throw new UnsupportedOperationException("SubTableQuery's get TabName is not supported");
        }
    }

    public static interface SubTableQuery {
    }
}

