/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.meta;

import com.qlangtech.tis.sql.parser.meta.NodeType;
import com.qlangtech.tis.sql.parser.meta.Position;
import com.qlangtech.tis.sql.parser.meta.TabExtraMeta;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import org.apache.commons.lang.StringUtils;

public class DependencyNode {
    private String id;
    private String tabid;
    private String dbid;
    private String name;
    private String dbName;
    private String extractSql;
    private String type = NodeType.JOINER_SQL.getType();
    private TabExtraMeta extraMeta;
    private Position position;

    public static DependencyNode create(String id, String name, NodeType type) {
        DependencyNode dnode = new DependencyNode();
        dnode.setId(id);
        dnode.setName(name);
        dnode.setType(type.getType());
        return dnode;
    }

    public TabExtraMeta getExtraMeta() {
        return this.extraMeta;
    }

    public void setExtraMeta(TabExtraMeta extraMeta) {
        this.extraMeta = extraMeta;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public String getTabid() {
        return this.tabid;
    }

    public void setTabid(String tabid) {
        this.tabid = tabid;
    }

    public String getDbid() {
        return this.dbid;
    }

    public void setDbid(String dbid) {
        this.dbid = dbid;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getExtraSql() {
        return this.extractSql;
    }

    public void setExtraSql(String extractSql) {
        this.extractSql = extractSql;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public NodeType parseNodeType() {
        return this.parseNodeType(true);
    }

    public NodeType parseNodeType(boolean validateTabId) {
        try {
            NodeType result = NodeType.parse(this.type);
            if (result == NodeType.DUMP && validateTabId && StringUtils.isBlank((String)this.tabid)) {
                throw new IllegalStateException("tabid can not be null,id:" + this.id);
            }
            return result;
        }
        catch (NodeType.NodeTypeParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EntityName parseEntityName() {
        if (StringUtils.isEmpty((String)this.dbName)) {
            return EntityName.parse(this.name);
        }
        return EntityName.create(this.dbName, this.name);
    }

    public String toString() {
        return this.dbName + "." + this.name;
    }
}

