/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser;

import com.qlangtech.tis.fullbuild.indexbuild.IDumpTable;
import com.qlangtech.tis.fullbuild.indexbuild.ITabPartition;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class TabPartitions {
    private final Map<IDumpTable, ITabPartition> tabPartition;

    public TabPartitions(Map<IDumpTable, ITabPartition> tabPartition) {
        this.tabPartition = tabPartition;
    }

    public int size() {
        return this.tabPartition.size();
    }

    public final Optional<DumpTabPartition> findTablePartition(String dbName, String tableName) {
        return this.findTablePartition(true, dbName, tableName);
    }

    public void putPt(IDumpTable table, ITabPartition pt) {
        this.tabPartition.put(table, pt);
    }

    public Optional<ITabPartition> getMinTablePartition() {
        Optional<ITabPartition> min = this.tabPartition.values().stream().min(Comparator.comparing(r -> Long.parseLong(r.getPt())));
        return min;
    }

    public void visitAll(Consumer<Map.Entry<IDumpTable, ITabPartition>> consumer) {
        this.tabPartition.entrySet().forEach(consumer);
    }

    protected Optional<DumpTabPartition> findTablePartition(boolean dbNameCriteria, String dbName, String tableName) {
        return this.tabPartition.entrySet().stream().filter(r -> (!dbNameCriteria || StringUtils.equals((String)((IDumpTable)r.getKey()).getDbName(), (String)dbName)) && StringUtils.equals((String)((IDumpTable)r.getKey()).getTableName(), (String)tableName)).map(e -> new DumpTabPartition((IDumpTable)e.getKey(), (ITabPartition)e.getValue())).findFirst();
    }

    public final Optional<DumpTabPartition> findTablePartition(String tableName) {
        return this.findTablePartition(false, null, tableName);
    }

    public String joinFullNames() {
        return this.tabPartition.keySet().stream().map(r -> r.getFullName()).collect(Collectors.joining(","));
    }

    public String toString() {
        return this.tabPartition.entrySet().stream().map(ee -> "[" + ee.getKey() + "->" + ((ITabPartition)ee.getValue()).getPt() + "]").collect(Collectors.joining(","));
    }

    public static class DumpTabPartition {
        public final IDumpTable tab;
        public final ITabPartition pt;

        public DumpTabPartition(IDumpTable tab, ITabPartition pt) {
            this.tab = tab;
            this.pt = pt;
        }
    }
}

