/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.pubhook.common;

import com.qlangtech.tis.manage.common.Config;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Callable;

public enum RunEnvironment {
    DAILY("daily", (short)0, "\u65e5\u5e38\u73af\u5883", () -> Config.getConfigRepositoryHost()),
    ONLINE("online", (short)2, "\u7ebf\u4e0a\u73af\u5883", null);

    public static final String KEY_RUNTIME = "runtime";
    private final Short id;
    private final String keyName;
    private final String describe;
    private final Callable<String> innerRepositoryURL;
    private static List<RunEnvironment> environmentList;

    public static boolean isDevelopMode() {
        return RunEnvironment.getSysRuntime() == DAILY;
    }

    public static void setSysRuntime(RunEnvironment runtime) {
        System.setProperty(KEY_RUNTIME, runtime.getKeyName());
    }

    public static boolean isOnlineMode() {
        return RunEnvironment.getSysRuntime() == ONLINE;
    }

    public static RunEnvironment getSysRuntime() {
        return DAILY;
    }

    public static RunEnvironment getSysEnvironment() {
        return RunEnvironment.getSysRuntime();
    }

    private RunEnvironment(String keyName, Short id, String describe, Callable<String> innerRepositoryURL) {
        this.id = id;
        this.keyName = keyName;
        this.describe = describe;
        this.innerRepositoryURL = innerRepositoryURL;
    }

    public String getInnerRepositoryURL() {
        try {
            return this.innerRepositoryURL.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Short getId() {
        return this.id;
    }

    public String getDescribe() {
        return this.describe;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public static RunEnvironment getEnum(String key) {
        EnumSet<RunEnvironment> all = EnumSet.allOf(RunEnvironment.class);
        for (RunEnvironment r : all) {
            if (!r.getKeyName().equals(key)) continue;
            return r;
        }
        throw new IllegalArgumentException("key:" + key + " is invalid");
    }

    public static RunEnvironment getEnum(short key) {
        EnumSet<RunEnvironment> all = EnumSet.allOf(RunEnvironment.class);
        for (RunEnvironment r : all) {
            if (r.getId() != key) continue;
            return r;
        }
        throw new IllegalArgumentException("key:" + key + " is invalid");
    }

    public static List<RunEnvironment> getRunEnvironmentList() {
        return environmentList;
    }

    public static void main(String[] arg) throws Exception {
        List<RunEnvironment> environmentList = RunEnvironment.getRunEnvironmentList();
        for (RunEnvironment envir : environmentList) {
            System.out.println((Object)envir);
        }
    }

    static {
        environmentList = new ArrayList<RunEnvironment>();
        try {
            RunEnvironment[] fields;
            for (RunEnvironment f : fields = RunEnvironment.values()) {
                environmentList.add(f);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

