/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin;

import com.qlangtech.tis.plugin.DftIdentityName;
import com.qlangtech.tis.plugin.ValidatorCommons;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

@FunctionalInterface
public interface IdentityName {
    public static final String MSG_ERROR_NAME_DUPLICATE = "\u540d\u79f0\u91cd\u590d";
    public static final String PLUGIN_IDENTITY_NAME = "identityName";

    public static IdentityName create(String value) {
        return new DftIdentityName(value);
    }

    public static IdentityName create(IdentityName value) {
        return new DftIdentityName(value.identityValue());
    }

    public static <T extends IdentityName> IdentityName createNewPrimaryFieldValue(String idPrefix, List<T> existOpts) {
        if (StringUtils.isEmpty((String)idPrefix) || !ValidatorCommons.pattern_identity.matcher(idPrefix).matches()) {
            throw new IllegalArgumentException("param idPrefix:" + idPrefix + " is not illegal");
        }
        String descName = StringUtils.replace((String)StringUtils.lowerCase((String)idPrefix), (String)"-", (String)"_");
        Pattern pattern = Pattern.compile(descName + "_?(\\d+)");
        Matcher matcher = null;
        int maxSufix = 1;
        for (IdentityName opt : existOpts) {
            int curr;
            matcher = pattern.matcher(StringUtils.lowerCase((String)opt.identityValue()));
            if (!matcher.matches() || (curr = Integer.valueOf(matcher.group(1)).intValue()) < maxSufix) continue;
            maxSufix = curr + 1;
        }
        return IdentityName.create(descName + "_" + maxSufix);
    }

    default public boolean equalWithId(IdentityName identity) {
        return StringUtils.equals((String)this.identityValue(), (String)Objects.requireNonNull(identity, "identity can not be null").identityValue());
    }

    public String identityValue();

    default public Class<?> getDescribleClass() {
        return this.getClass();
    }
}

